/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.HashTestUtils;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.util.concurrent.AtomicLongMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import junit.framework.TestCase;

public class HashingTest
extends TestCase {
    private static final int ITERS = 10000;
    private static final int MAX_SHARDS = 500;
    private static final double MAX_PERCENT_SPREAD = 0.5;
    private static final long RANDOM_SEED = 177L;
    private static final String EMPTY_STRING = "";
    private static final String TQBFJOTLD = "The quick brown fox jumps over the lazy dog";
    private static final String TQBFJOTLDP = "The quick brown fox jumps over the lazy dog.";
    private static final ImmutableTable<HashFunction, String, String> KNOWN_HASHES = ImmutableTable.builder().put((Object)Hashing.adler32(), (Object)"", (Object)"01000000").put((Object)Hashing.adler32(), (Object)"The quick brown fox jumps over the lazy dog", (Object)"da0fdc5b").put((Object)Hashing.adler32(), (Object)"The quick brown fox jumps over the lazy dog.", (Object)"0810e46b").put((Object)Hashing.md5(), (Object)"", (Object)"d41d8cd98f00b204e9800998ecf8427e").put((Object)Hashing.md5(), (Object)"The quick brown fox jumps over the lazy dog", (Object)"9e107d9d372bb6826bd81d3542a419d6").put((Object)Hashing.md5(), (Object)"The quick brown fox jumps over the lazy dog.", (Object)"e4d909c290d0fb1ca068ffaddf22cbd0").put((Object)Hashing.murmur3_128(), (Object)"", (Object)"00000000000000000000000000000000").put((Object)Hashing.murmur3_128(), (Object)"The quick brown fox jumps over the lazy dog", (Object)"6c1b07bc7bbc4be347939ac4a93c437a").put((Object)Hashing.murmur3_128(), (Object)"The quick brown fox jumps over the lazy dog.", (Object)"c902e99e1f4899cde7b68789a3a15d69").put((Object)Hashing.murmur3_32(), (Object)"", (Object)"00000000").put((Object)Hashing.murmur3_32(), (Object)"The quick brown fox jumps over the lazy dog", (Object)"23f74f2e").put((Object)Hashing.murmur3_32(), (Object)"The quick brown fox jumps over the lazy dog.", (Object)"fc8bc4d5").put((Object)Hashing.sha1(), (Object)"", (Object)"da39a3ee5e6b4b0d3255bfef95601890afd80709").put((Object)Hashing.sha1(), (Object)"The quick brown fox jumps over the lazy dog", (Object)"2fd4e1c67a2d28fced849ee1bb76e7391b93eb12").put((Object)Hashing.sha1(), (Object)"The quick brown fox jumps over the lazy dog.", (Object)"408d94384216f890ff7a0c3528e8bed1e0b01621").put((Object)Hashing.sha256(), (Object)"", (Object)"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855").put((Object)Hashing.sha256(), (Object)"The quick brown fox jumps over the lazy dog", (Object)"d7a8fbb307d7809469ca9abcb0082e4f8d5651e46d3cdb762d02d0bf37c9e592").put((Object)Hashing.sha256(), (Object)"The quick brown fox jumps over the lazy dog.", (Object)"ef537f25c895bfa782526529a9b63d97aa631564d5d789c2b765448c8635fb6c").put((Object)Hashing.sha512(), (Object)"", (Object)"cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e").put((Object)Hashing.sha512(), (Object)"The quick brown fox jumps over the lazy dog", (Object)"07e547d9586f6a73f73fbac0435ed76951218fb7d0c8d788a309d785436bbb642e93a252a954f23912547d1e8a3b5ed6e1bfd7097821233fa0538f3db854fee6").put((Object)Hashing.sha512(), (Object)"The quick brown fox jumps over the lazy dog.", (Object)"91ea1245f20d46ae9a037a989f54f1f790f0a47607eeb8a14d12890cea77a1bbc6c7ed9cf205e67b7f2b8fd4c7dfd3a7a8617e45f3c463d481c7e586c39ac1ed").put((Object)Hashing.crc32(), (Object)"", (Object)"00000000").put((Object)Hashing.crc32(), (Object)"The quick brown fox jumps over the lazy dog", (Object)"39a34f41").put((Object)Hashing.crc32(), (Object)"The quick brown fox jumps over the lazy dog.", (Object)"e9259051").put((Object)Hashing.sipHash24(), (Object)"", (Object)"310e0edd47db6f72").put((Object)Hashing.sipHash24(), (Object)"The quick brown fox jumps over the lazy dog", (Object)"e46f1fdc05612752").put((Object)Hashing.sipHash24(), (Object)"The quick brown fox jumps over the lazy dog.", (Object)"9b602581fce4d4f8").build();

    public void testMd5() {
        HashTestUtils.checkAvalanche(Hashing.md5(), 100, 0.4);
        HashTestUtils.checkNo2BitCharacteristics(Hashing.md5());
        HashTestUtils.checkNoFunnels(Hashing.md5());
        HashTestUtils.assertInvariants(Hashing.md5());
        HashingTest.assertEquals((String)"Hashing.md5()", (String)Hashing.md5().toString());
    }

    public void testSha1() {
        HashTestUtils.checkAvalanche(Hashing.sha1(), 100, 0.4);
        HashTestUtils.checkNo2BitCharacteristics(Hashing.sha1());
        HashTestUtils.checkNoFunnels(Hashing.sha1());
        HashTestUtils.assertInvariants(Hashing.sha1());
        HashingTest.assertEquals((String)"Hashing.sha1()", (String)Hashing.sha1().toString());
    }

    public void testSha256() {
        HashTestUtils.checkAvalanche(Hashing.sha256(), 100, 0.4);
        HashTestUtils.checkNo2BitCharacteristics(Hashing.sha256());
        HashTestUtils.checkNoFunnels(Hashing.sha256());
        HashTestUtils.assertInvariants(Hashing.sha256());
        HashingTest.assertEquals((String)"Hashing.sha256()", (String)Hashing.sha256().toString());
    }

    public void testSha512() {
        HashTestUtils.checkAvalanche(Hashing.sha512(), 100, 0.4);
        HashTestUtils.checkNo2BitCharacteristics(Hashing.sha512());
        HashTestUtils.checkNoFunnels(Hashing.sha512());
        HashTestUtils.assertInvariants(Hashing.sha512());
        HashingTest.assertEquals((String)"Hashing.sha512()", (String)Hashing.sha512().toString());
    }

    public void testCrc32() {
        HashTestUtils.assertInvariants(Hashing.crc32());
        HashingTest.assertEquals((String)"Hashing.crc32()", (String)Hashing.crc32().toString());
    }

    public void testAdler32() {
        HashTestUtils.assertInvariants(Hashing.adler32());
        HashingTest.assertEquals((String)"Hashing.adler32()", (String)Hashing.adler32().toString());
    }

    public void testMurmur3_128() {
        HashTestUtils.check2BitAvalanche(Hashing.murmur3_128(), 250, 0.2);
        HashTestUtils.checkAvalanche(Hashing.murmur3_128(), 250, 0.17);
        HashTestUtils.checkNo2BitCharacteristics(Hashing.murmur3_128());
        HashTestUtils.checkNoFunnels(Hashing.murmur3_128());
        HashTestUtils.assertInvariants(Hashing.murmur3_128());
        HashingTest.assertEquals((String)"Hashing.murmur3_128(0)", (String)Hashing.murmur3_128().toString());
    }

    public void testMurmur3_32() {
        HashTestUtils.check2BitAvalanche(Hashing.murmur3_32(), 250, 0.2);
        HashTestUtils.checkAvalanche(Hashing.murmur3_32(), 250, 0.17);
        HashTestUtils.checkNo2BitCharacteristics(Hashing.murmur3_32());
        HashTestUtils.checkNoFunnels(Hashing.murmur3_32());
        HashTestUtils.assertInvariants(Hashing.murmur3_32());
        HashingTest.assertEquals((String)"Hashing.murmur3_32(0)", (String)Hashing.murmur3_32().toString());
    }

    public void testSipHash24() {
        HashTestUtils.check2BitAvalanche(Hashing.sipHash24(), 250, 0.14);
        HashTestUtils.checkAvalanche(Hashing.sipHash24(), 250, 0.1);
        HashTestUtils.checkNo2BitCharacteristics(Hashing.sipHash24());
        HashTestUtils.checkNoFunnels(Hashing.sipHash24());
        HashTestUtils.assertInvariants(Hashing.sipHash24());
        HashingTest.assertEquals((String)"Hashing.sipHash24(506097522914230528, 1084818905618843912)", (String)Hashing.sipHash24().toString());
    }

    public void testGoodFastHash() {
        for (int i = 1; i < 200; i += 17) {
            HashFunction hasher = Hashing.goodFastHash((int)i);
            HashingTest.assertTrue((hasher.bits() >= i ? 1 : 0) != 0);
            HashTestUtils.assertInvariants(hasher);
        }
    }

    public void testGoodFastHash32() {
        HashTestUtils.check2BitAvalanche(Hashing.goodFastHash((int)32), 250, 0.2);
        HashTestUtils.checkAvalanche(Hashing.goodFastHash((int)32), 250, 0.17);
        HashTestUtils.checkNo2BitCharacteristics(Hashing.goodFastHash((int)32));
        HashTestUtils.checkNoFunnels(Hashing.goodFastHash((int)32));
        HashTestUtils.assertInvariants(Hashing.goodFastHash((int)32));
    }

    public void testGoodFastHash128() {
        HashTestUtils.check2BitAvalanche(Hashing.goodFastHash((int)128), 250, 0.2);
        HashTestUtils.checkAvalanche(Hashing.goodFastHash((int)128), 250, 0.17);
        HashTestUtils.checkNo2BitCharacteristics(Hashing.goodFastHash((int)128));
        HashTestUtils.checkNoFunnels(Hashing.goodFastHash((int)128));
        HashTestUtils.assertInvariants(Hashing.goodFastHash((int)128));
    }

    public void testGoodFastHash256() {
        HashTestUtils.check2BitAvalanche(Hashing.goodFastHash((int)256), 250, 0.2);
        HashTestUtils.checkAvalanche(Hashing.goodFastHash((int)256), 250, 0.17);
        HashTestUtils.checkNo2BitCharacteristics(Hashing.goodFastHash((int)256));
        HashTestUtils.checkNoFunnels(Hashing.goodFastHash((int)256));
        HashTestUtils.assertInvariants(Hashing.goodFastHash((int)256));
    }

    public void testConsistentHash_correctness() {
        long[] interestingValues;
        for (long h : interestingValues = new long[]{-1L, 0L, 1L, 2L, Long.MAX_VALUE, Long.MIN_VALUE}) {
            this.checkConsistentHashCorrectness(h);
        }
        Random r = new Random(7L);
        for (int i = 0; i < 20; ++i) {
            this.checkConsistentHashCorrectness(r.nextLong());
        }
    }

    private void checkConsistentHashCorrectness(long hashCode) {
        int last = 0;
        for (int shards = 1; shards <= 100000; ++shards) {
            int b = Hashing.consistentHash((long)hashCode, (int)shards);
            if (b == last) continue;
            HashingTest.assertEquals((int)(shards - 1), (int)b);
            last = b;
        }
    }

    public void testConsistentHash_probabilities() {
        AtomicLongMap map = AtomicLongMap.create();
        Random r = new Random(9L);
        for (int i = 0; i < 10000; ++i) {
            this.countRemaps(r.nextLong(), (AtomicLongMap<Integer>)map);
        }
        for (int shard = 2; shard <= 500; ++shard) {
            HashingTest.assertTrue(((double)map.get((Object)shard) <= 12000.0 / (double)shard + 20.0 ? 1 : 0) != 0);
        }
    }

    private void countRemaps(long h, AtomicLongMap<Integer> map) {
        int last = 0;
        for (int shards = 2; shards <= 500; ++shards) {
            int chosen = Hashing.consistentHash((long)h, (int)shards);
            if (chosen == last) continue;
            map.incrementAndGet((Object)shards);
            last = chosen;
        }
    }

    public void testConsistentHash_outOfRange() {
        try {
            Hashing.consistentHash((long)5L, (int)0);
            HashingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConsistentHash_ofHashCode() {
        this.checkSameResult(HashCode.fromLong((long)1L), 1L);
        this.checkSameResult(HashCode.fromLong((long)-7378697629483820647L), -7378697629483820647L);
        this.checkSameResult(HashCode.fromInt((int)-1717986919), 0x99999999L);
    }

    public void checkSameResult(HashCode hashCode, long equivLong) {
        HashingTest.assertEquals((int)Hashing.consistentHash((long)equivLong, (int)5555), (int)Hashing.consistentHash((HashCode)hashCode, (int)5555));
    }

    public void testConsistentHash_linearCongruentialGeneratorCompatibility() {
        int[] golden100 = new int[]{0, 55, 62, 8, 45, 59, 86, 97, 82, 59, 73, 37, 17, 56, 86, 21, 90, 37, 38, 83};
        for (int i = 0; i < golden100.length; ++i) {
            HashingTest.assertEquals((int)golden100[i], (int)Hashing.consistentHash((long)i, (int)100));
        }
        HashingTest.assertEquals((int)6, (int)Hashing.consistentHash((long)10863919174838991L, (int)11));
        HashingTest.assertEquals((int)3, (int)Hashing.consistentHash((long)2016238256797177309L, (int)11));
        HashingTest.assertEquals((int)5, (int)Hashing.consistentHash((long)1673758223894951030L, (int)11));
        HashingTest.assertEquals((int)80343, (int)Hashing.consistentHash((long)2L, (int)100001));
        HashingTest.assertEquals((int)22152, (int)Hashing.consistentHash((long)2201L, (int)100001));
        HashingTest.assertEquals((int)15018, (int)Hashing.consistentHash((long)2202L, (int)100001));
    }

    public void testCombineOrdered_empty() {
        try {
            Hashing.combineOrdered(Collections.emptySet());
            HashingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCombineOrdered_differentBitLengths() {
        try {
            Hashing.combineOrdered((Iterable)ImmutableList.of((Object)HashCode.fromInt((int)32), (Object)HashCode.fromLong((long)32L)));
            HashingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCombineOrdered() {
        HashCode hash31 = HashCode.fromInt((int)31);
        HashCode hash32 = HashCode.fromInt((int)32);
        HashingTest.assertEquals((Object)hash32, (Object)Hashing.combineOrdered((Iterable)ImmutableList.of((Object)hash32)));
        HashingTest.assertEquals((Object)HashCode.fromBytes((byte[])new byte[]{-128, 0, 0, 0}), (Object)Hashing.combineOrdered((Iterable)ImmutableList.of((Object)hash32, (Object)hash32)));
        HashingTest.assertEquals((Object)HashCode.fromBytes((byte[])new byte[]{-96, 0, 0, 0}), (Object)Hashing.combineOrdered((Iterable)ImmutableList.of((Object)hash32, (Object)hash32, (Object)hash32)));
        HashingTest.assertFalse((boolean)Hashing.combineOrdered((Iterable)ImmutableList.of((Object)hash31, (Object)hash32)).equals((Object)Hashing.combineOrdered((Iterable)ImmutableList.of((Object)hash32, (Object)hash31))));
    }

    public void testCombineOrdered_randomHashCodes() {
        Random random = new Random(7L);
        ArrayList hashCodes = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            hashCodes.add(HashCode.fromLong((long)random.nextLong()));
        }
        HashCode hashCode1 = Hashing.combineOrdered((Iterable)hashCodes);
        Collections.shuffle(hashCodes, random);
        HashCode hashCode2 = Hashing.combineOrdered((Iterable)hashCodes);
        HashingTest.assertFalse((boolean)hashCode1.equals((Object)hashCode2));
    }

    public void testCombineUnordered_empty() {
        try {
            Hashing.combineUnordered(Collections.emptySet());
            HashingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCombineUnordered_differentBitLengths() {
        try {
            Hashing.combineUnordered((Iterable)ImmutableList.of((Object)HashCode.fromInt((int)32), (Object)HashCode.fromLong((long)32L)));
            HashingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCombineUnordered() {
        HashCode hash31 = HashCode.fromInt((int)31);
        HashCode hash32 = HashCode.fromInt((int)32);
        HashingTest.assertEquals((Object)hash32, (Object)Hashing.combineUnordered((Iterable)ImmutableList.of((Object)hash32)));
        HashingTest.assertEquals((Object)HashCode.fromInt((int)64), (Object)Hashing.combineUnordered((Iterable)ImmutableList.of((Object)hash32, (Object)hash32)));
        HashingTest.assertEquals((Object)HashCode.fromInt((int)96), (Object)Hashing.combineUnordered((Iterable)ImmutableList.of((Object)hash32, (Object)hash32, (Object)hash32)));
        HashingTest.assertEquals((Object)Hashing.combineUnordered((Iterable)ImmutableList.of((Object)hash31, (Object)hash32)), (Object)Hashing.combineUnordered((Iterable)ImmutableList.of((Object)hash32, (Object)hash31)));
    }

    public void testCombineUnordered_randomHashCodes() {
        Random random = new Random(177L);
        ArrayList hashCodes = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            hashCodes.add(HashCode.fromLong((long)random.nextLong()));
        }
        HashCode hashCode1 = Hashing.combineUnordered((Iterable)hashCodes);
        Collections.shuffle(hashCodes);
        HashCode hashCode2 = Hashing.combineUnordered((Iterable)hashCodes);
        HashingTest.assertEquals((Object)hashCode1, (Object)hashCode2);
    }

    public void testConcatenatedHashFunction_equals() {
        HashingTest.assertEquals((Object)new Hashing.ConcatenatedHashFunction(new HashFunction[]{Hashing.md5()}), (Object)new Hashing.ConcatenatedHashFunction(new HashFunction[]{Hashing.md5()}));
        HashingTest.assertEquals((Object)new Hashing.ConcatenatedHashFunction(new HashFunction[]{Hashing.md5(), Hashing.murmur3_32()}), (Object)new Hashing.ConcatenatedHashFunction(new HashFunction[]{Hashing.md5(), Hashing.murmur3_32()}));
    }

    public void testConcatenatedHashFunction_bits() {
        HashingTest.assertEquals((int)Hashing.md5().bits(), (int)new Hashing.ConcatenatedHashFunction(new HashFunction[]{Hashing.md5()}).bits());
        HashingTest.assertEquals((int)(Hashing.md5().bits() + Hashing.murmur3_32().bits()), (int)new Hashing.ConcatenatedHashFunction(new HashFunction[]{Hashing.md5(), Hashing.murmur3_32()}).bits());
        HashingTest.assertEquals((int)(Hashing.md5().bits() + Hashing.murmur3_32().bits() + Hashing.murmur3_128().bits()), (int)new Hashing.ConcatenatedHashFunction(new HashFunction[]{Hashing.md5(), Hashing.murmur3_32(), Hashing.murmur3_128()}).bits());
    }

    public void testConcatenatedHashFunction_makeHash() {
        byte[] md5Hash = Hashing.md5().hashLong(42L).asBytes();
        byte[] murmur3Hash = Hashing.murmur3_32().hashLong(42L).asBytes();
        byte[] combined = new byte[md5Hash.length + murmur3Hash.length];
        ByteBuffer buffer = ByteBuffer.wrap(combined);
        buffer.put(md5Hash);
        buffer.put(murmur3Hash);
        HashingTest.assertEquals((Object)HashCode.fromBytes((byte[])combined), (Object)new Hashing.ConcatenatedHashFunction(new HashFunction[]{Hashing.md5(), Hashing.murmur3_32()}).hashLong(42L));
    }

    public void testHashIntReverseBytesVsHashBytesIntsToByteArray() {
        int input = 42;
        HashingTest.assertEquals((Object)Hashing.md5().hashBytes(Ints.toByteArray((int)input)), (Object)Hashing.md5().hashInt(Integer.reverseBytes(input)));
    }

    public void testHashIntVsForLoop() {
        int input = 42;
        HashCode expected = Hashing.md5().hashInt(input);
        Hasher hasher = Hashing.md5().newHasher();
        for (int i = 0; i < 32; i += 8) {
            hasher.putByte((byte)(input >> i));
        }
        HashCode actual = hasher.hash();
        HashingTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testAllHashFunctionsHaveKnownHashes() throws Exception {
        for (Method method : Hashing.class.getDeclaredMethods()) {
            if (!method.getReturnType().equals(HashFunction.class) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            HashFunction hashFunction = (HashFunction)method.invoke(Hashing.class, new Object[0]);
            HashingTest.assertTrue((String)("There should be at least 3 entries in KNOWN_HASHES for " + hashFunction), (KNOWN_HASHES.row((Object)hashFunction).size() >= 3 ? 1 : 0) != 0);
        }
    }

    public void testKnownUtf8Hashing() {
        for (Table.Cell cell : KNOWN_HASHES.cellSet()) {
            HashFunction func = (HashFunction)cell.getRowKey();
            String input = (String)cell.getColumnKey();
            String expected = (String)cell.getValue();
            HashingTest.assertEquals((String)String.format("Known hash for hash(%s, UTF_8) failed", input), (String)expected, (String)func.hashString((CharSequence)input, Charsets.UTF_8).toString());
        }
    }

    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester().setDefault(HashCode.class, (Object)HashCode.fromLong((long)0L));
        tester.testAllPublicStaticMethods(Hashing.class);
    }

    public void testSeedlessHashFunctionEquals() throws Exception {
        HashingTest.assertSeedlessHashFunctionEquals(Hashing.class);
    }

    public void testSeededHashFunctionEquals() throws Exception {
        HashingTest.assertSeededHashFunctionEquals(Hashing.class);
    }

    public void testGoodFastHashEquals() throws Exception {
        HashFunction hashFunction1a = Hashing.goodFastHash((int)1);
        HashFunction hashFunction1b = Hashing.goodFastHash((int)32);
        HashFunction hashFunction2a = Hashing.goodFastHash((int)33);
        HashFunction hashFunction2b = Hashing.goodFastHash((int)128);
        HashFunction hashFunction3a = Hashing.goodFastHash((int)129);
        HashFunction hashFunction3b = Hashing.goodFastHash((int)256);
        HashFunction hashFunction4a = Hashing.goodFastHash((int)257);
        HashFunction hashFunction4b = Hashing.goodFastHash((int)384);
        new EqualsTester().addEqualityGroup(new Object[]{hashFunction1a, hashFunction1b}).addEqualityGroup(new Object[]{hashFunction2a, hashFunction2b}).addEqualityGroup(new Object[]{hashFunction3a, hashFunction3b}).addEqualityGroup(new Object[]{hashFunction4a, hashFunction4b}).testEquals();
        HashingTest.assertEquals((String)hashFunction1a.toString(), (String)hashFunction1b.toString());
        HashingTest.assertEquals((String)hashFunction2a.toString(), (String)hashFunction2b.toString());
        HashingTest.assertEquals((String)hashFunction3a.toString(), (String)hashFunction3b.toString());
        HashingTest.assertEquals((String)hashFunction4a.toString(), (String)hashFunction4b.toString());
    }

    static void assertSeedlessHashFunctionEquals(Class<?> clazz) throws Exception {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getReturnType().equals(HashFunction.class) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            HashFunction hashFunction1a = (HashFunction)method.invoke(clazz, new Object[0]);
            HashFunction hashFunction1b = (HashFunction)method.invoke(clazz, new Object[0]);
            new EqualsTester().addEqualityGroup(new Object[]{hashFunction1a, hashFunction1b}).testEquals();
            HashingTest.assertSame((Object)hashFunction1a, (Object)hashFunction1b);
            HashingTest.assertEquals((String)hashFunction1a.toString(), (String)hashFunction1b.toString());
        }
    }

    static void assertSeededHashFunctionEquals(Class<?> clazz) throws Exception {
        Random random = new Random(177L);
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getReturnType().equals(HashFunction.class) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length == 0 || method.getName().equals("goodFastHash")) continue;
            Object[] params1 = new Object[method.getParameterTypes().length];
            Object[] params2 = new Object[method.getParameterTypes().length];
            for (int i = 0; i < params1.length; ++i) {
                if (method.getParameterTypes()[i] == Integer.TYPE) {
                    params1[i] = random.nextInt();
                    params2[i] = random.nextInt();
                    continue;
                }
                if (method.getParameterTypes()[i] == Long.TYPE) {
                    params1[i] = random.nextLong();
                    params2[i] = random.nextLong();
                    continue;
                }
                HashingTest.fail((String)("Unable to create a random parameter for " + method.getParameterTypes()[i]));
            }
            HashFunction hashFunction1a = (HashFunction)method.invoke(clazz, params1);
            HashFunction hashFunction1b = (HashFunction)method.invoke(clazz, params1);
            HashFunction hashFunction2 = (HashFunction)method.invoke(clazz, params2);
            new EqualsTester().addEqualityGroup(new Object[]{hashFunction1a, hashFunction1b}).addEqualityGroup(new Object[]{hashFunction2}).testEquals();
            HashingTest.assertEquals((String)hashFunction1a.toString(), (String)hashFunction1b.toString());
        }
    }
}

