/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSink;
import com.google.common.io.SourceSinkFactory;
import com.google.common.io.SourceSinkTester;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;

public class CharSinkTester
extends SourceSinkTester<CharSink, String, SourceSinkFactory.CharSinkFactory> {
    private static final ImmutableList<Method> testMethods = CharSinkTester.getTestMethods(CharSinkTester.class);
    private final ImmutableList<String> lines;
    private final ImmutableList<String> expectedLines;
    private CharSink sink;

    static TestSuite tests(String name, SourceSinkFactory.CharSinkFactory factory) {
        TestSuite suite = new TestSuite(name);
        for (Map.Entry entry : TEST_STRINGS.entrySet()) {
            String desc = (String)entry.getKey();
            TestSuite stringSuite = CharSinkTester.suiteForString(name, factory, (String)entry.getValue(), desc);
            suite.addTest((Test)stringSuite);
        }
        return suite;
    }

    static TestSuite suiteForString(String name, SourceSinkFactory.CharSinkFactory factory, String string, String desc) {
        TestSuite stringSuite = new TestSuite(name + " [" + desc + "]");
        for (Method method : testMethods) {
            stringSuite.addTest((Test)new CharSinkTester(factory, string, name, desc, method));
        }
        return stringSuite;
    }

    public CharSinkTester(SourceSinkFactory.CharSinkFactory factory, String string, String suiteName, String caseDesc, Method method) {
        super(factory, string, suiteName, caseDesc, method);
        this.lines = CharSinkTester.getLines(string);
        this.expectedLines = CharSinkTester.getLines((String)this.expected);
    }

    protected void setUp() throws Exception {
        this.sink = (CharSink)((SourceSinkFactory.CharSinkFactory)this.factory).createSink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOpenStream() throws IOException {
        Writer writer = this.sink.openStream();
        try {
            writer.write((String)this.data);
        }
        finally {
            writer.close();
        }
        this.assertContainsExpectedString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOpenBufferedStream() throws IOException {
        Writer writer = this.sink.openBufferedStream();
        try {
            writer.write((String)this.data);
        }
        finally {
            writer.close();
        }
        this.assertContainsExpectedString();
    }

    public void testWrite() throws IOException {
        this.sink.write((CharSequence)this.data);
        this.assertContainsExpectedString();
    }

    public void testWriteLines_systemDefaultSeparator() throws IOException {
        String separator = System.getProperty("line.separator");
        this.sink.writeLines(this.lines);
        this.assertContainsExpectedLines(separator);
    }

    public void testWriteLines_specificSeparator() throws IOException {
        String separator = "\r\n";
        this.sink.writeLines(this.lines, separator);
        this.assertContainsExpectedLines(separator);
    }

    private void assertContainsExpectedString() throws IOException {
        CharSinkTester.assertEquals((String)((String)this.expected), (String)((String)((SourceSinkFactory.CharSinkFactory)this.factory).getSinkContents()));
    }

    private void assertContainsExpectedLines(String separator) throws IOException {
        String expected;
        String string = expected = this.expectedLines.isEmpty() ? "" : Joiner.on((String)separator).join(this.expectedLines);
        if (!this.lines.isEmpty()) {
            expected = expected + separator;
        }
        CharSinkTester.assertEquals((String)expected, (String)((String)((SourceSinkFactory.CharSinkFactory)this.factory).getSinkContents()));
    }
}

