/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import junit.framework.TestCase;

public class FilesSimplifyPathTest
extends TestCase {
    public void testSimplifyEmptyString() {
        FilesSimplifyPathTest.assertEquals((String)".", (String)Files.simplifyPath((String)""));
    }

    public void testSimplifyDot() {
        FilesSimplifyPathTest.assertEquals((String)".", (String)Files.simplifyPath((String)"."));
    }

    public void testSimplifyWhiteSpace() {
        FilesSimplifyPathTest.assertEquals((String)" ", (String)Files.simplifyPath((String)" "));
    }

    public void testSimplify2() {
        FilesSimplifyPathTest.assertEquals((String)"x", (String)Files.simplifyPath((String)"x"));
    }

    public void testSimplify3() {
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/d", (String)Files.simplifyPath((String)"/a/b/c/d"));
    }

    public void testSimplify4() {
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/d", (String)Files.simplifyPath((String)"/a/b/c/d/"));
    }

    public void testSimplify5() {
        FilesSimplifyPathTest.assertEquals((String)"/a/b", (String)Files.simplifyPath((String)"/a//b"));
    }

    public void testSimplify6() {
        FilesSimplifyPathTest.assertEquals((String)"/a/b", (String)Files.simplifyPath((String)"//a//b/"));
    }

    public void testSimplify7() {
        FilesSimplifyPathTest.assertEquals((String)"/", (String)Files.simplifyPath((String)"/.."));
    }

    public void testSimplify8() {
        FilesSimplifyPathTest.assertEquals((String)"/", (String)Files.simplifyPath((String)"/././././"));
    }

    public void testSimplify9() {
        FilesSimplifyPathTest.assertEquals((String)"/a", (String)Files.simplifyPath((String)"/a/b/.."));
    }

    public void testSimplify10() {
        FilesSimplifyPathTest.assertEquals((String)"/", (String)Files.simplifyPath((String)"/a/b/../../.."));
    }

    public void testSimplify11() {
        FilesSimplifyPathTest.assertEquals((String)"/", (String)Files.simplifyPath((String)"//a//b/..////../..//"));
    }

    public void testSimplify12() {
        FilesSimplifyPathTest.assertEquals((String)"/x", (String)Files.simplifyPath((String)"//a//../x//"));
    }

    public void testSimplify13() {
        FilesSimplifyPathTest.assertEquals((String)"../c", (String)Files.simplifyPath((String)"a/b/../../../c"));
    }

    public void testSimplifyDotDot() {
        FilesSimplifyPathTest.assertEquals((String)"..", (String)Files.simplifyPath((String)".."));
    }

    public void testSimplifyDotDotSlash() {
        FilesSimplifyPathTest.assertEquals((String)"..", (String)Files.simplifyPath((String)"../"));
        FilesSimplifyPathTest.assertEquals((String)"..", (String)Files.simplifyPath((String)"a/../.."));
        FilesSimplifyPathTest.assertEquals((String)"..", (String)Files.simplifyPath((String)"a/../../"));
    }

    public void testSimplifyDotDots() {
        FilesSimplifyPathTest.assertEquals((String)"../..", (String)Files.simplifyPath((String)"a/../../.."));
        FilesSimplifyPathTest.assertEquals((String)"../../..", (String)Files.simplifyPath((String)"a/../../../.."));
    }

    public void testSimplifyRootedDotDots() {
        FilesSimplifyPathTest.assertEquals((String)"/", (String)Files.simplifyPath((String)"/../../.."));
        FilesSimplifyPathTest.assertEquals((String)"/", (String)Files.simplifyPath((String)"/../../../"));
    }

    public void testMadbotsBug() {
        FilesSimplifyPathTest.assertEquals((String)"../this", (String)Files.simplifyPath((String)"../this"));
        FilesSimplifyPathTest.assertEquals((String)"../this/is/ok", (String)Files.simplifyPath((String)"../this/is/ok"));
        FilesSimplifyPathTest.assertEquals((String)"../ok", (String)Files.simplifyPath((String)"../this/../ok"));
    }

    public void test705() {
        FilesSimplifyPathTest.assertEquals((String)"../b", (String)Files.simplifyPath((String)"x/../../b"));
        FilesSimplifyPathTest.assertEquals((String)"b", (String)Files.simplifyPath((String)"x/../b"));
    }

    public void test716() {
        FilesSimplifyPathTest.assertEquals((String)"b", (String)Files.simplifyPath((String)"./b"));
        FilesSimplifyPathTest.assertEquals((String)"b", (String)Files.simplifyPath((String)"./b/."));
        FilesSimplifyPathTest.assertEquals((String)"b", (String)Files.simplifyPath((String)"././b/./."));
        FilesSimplifyPathTest.assertEquals((String)"b", (String)Files.simplifyPath((String)"././b"));
        FilesSimplifyPathTest.assertEquals((String)"a/b", (String)Files.simplifyPath((String)"./a/b"));
    }

    public void testHiddenFiles() {
        FilesSimplifyPathTest.assertEquals((String)".b", (String)Files.simplifyPath((String)".b"));
        FilesSimplifyPathTest.assertEquals((String)".b", (String)Files.simplifyPath((String)"./.b"));
        FilesSimplifyPathTest.assertEquals((String)".metadata/b", (String)Files.simplifyPath((String)".metadata/b"));
        FilesSimplifyPathTest.assertEquals((String)".metadata/b", (String)Files.simplifyPath((String)"./.metadata/b"));
    }

    public void testMultipleDotFilenames() {
        FilesSimplifyPathTest.assertEquals((String)"..a", (String)Files.simplifyPath((String)"..a"));
        FilesSimplifyPathTest.assertEquals((String)"/..a", (String)Files.simplifyPath((String)"/..a"));
        FilesSimplifyPathTest.assertEquals((String)"/..a/..b", (String)Files.simplifyPath((String)"/..a/..b"));
        FilesSimplifyPathTest.assertEquals((String)"/.....a/..b", (String)Files.simplifyPath((String)"/.....a/..b"));
        FilesSimplifyPathTest.assertEquals((String)"..../....", (String)Files.simplifyPath((String)"..../...."));
        FilesSimplifyPathTest.assertEquals((String)"..a../..b..", (String)Files.simplifyPath((String)"..a../..b.."));
    }

    public void testSlashDot() {
        FilesSimplifyPathTest.assertEquals((String)"/", (String)Files.simplifyPath((String)"/."));
    }

    public void testInitialSlashDotDot() {
        FilesSimplifyPathTest.assertEquals((String)"/c", (String)Files.simplifyPath((String)"/../c"));
    }

    public void testInitialSlashDot() {
        FilesSimplifyPathTest.assertEquals((String)"/a", (String)Files.simplifyPath((String)"/./a"));
        FilesSimplifyPathTest.assertEquals((String)"/.a", (String)Files.simplifyPath((String)"/.a/a/.."));
    }

    public void testConsecutiveParentsAfterPresent() {
        FilesSimplifyPathTest.assertEquals((String)"../..", (String)Files.simplifyPath((String)"./../../"));
        FilesSimplifyPathTest.assertEquals((String)"../..", (String)Files.simplifyPath((String)"./.././../"));
    }

    public void testRfc2396Normal() {
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g", (String)Files.simplifyPath((String)"/a/b/c/g"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g", (String)Files.simplifyPath((String)"/a/b/c/./g"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g", (String)Files.simplifyPath((String)"/a/b/c/g/"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g?y", (String)Files.simplifyPath((String)"/a/b/c/g?y"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g#s", (String)Files.simplifyPath((String)"/a/b/c/g#s"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g?y#s", (String)Files.simplifyPath((String)"/a/b/c/g?y#s"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/;x", (String)Files.simplifyPath((String)"/a/b/c/;x"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g;x", (String)Files.simplifyPath((String)"/a/b/c/g;x"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g;x?y#s", (String)Files.simplifyPath((String)"/a/b/c/g;x?y#s"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c", (String)Files.simplifyPath((String)"/a/b/c/."));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c", (String)Files.simplifyPath((String)"/a/b/c/./"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b", (String)Files.simplifyPath((String)"/a/b/c/.."));
        FilesSimplifyPathTest.assertEquals((String)"/a/b", (String)Files.simplifyPath((String)"/a/b/c/../"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/g", (String)Files.simplifyPath((String)"/a/b/c/../g"));
        FilesSimplifyPathTest.assertEquals((String)"/a", (String)Files.simplifyPath((String)"/a/b/c/../.."));
        FilesSimplifyPathTest.assertEquals((String)"/a", (String)Files.simplifyPath((String)"/a/b/c/../../"));
        FilesSimplifyPathTest.assertEquals((String)"/a/g", (String)Files.simplifyPath((String)"/a/b/c/../../g"));
    }

    public void testRfc2396Abnormal() {
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g.", (String)Files.simplifyPath((String)"/a/b/c/g."));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/.g", (String)Files.simplifyPath((String)"/a/b/c/.g"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g..", (String)Files.simplifyPath((String)"/a/b/c/g.."));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/..g", (String)Files.simplifyPath((String)"/a/b/c/..g"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/g", (String)Files.simplifyPath((String)"/a/b/c/./../g"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g", (String)Files.simplifyPath((String)"/a/b/c/./g/."));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g/h", (String)Files.simplifyPath((String)"/a/b/c/g/./h"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/h", (String)Files.simplifyPath((String)"/a/b/c/g/../h"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g;x=1/y", (String)Files.simplifyPath((String)"/a/b/c/g;x=1/./y"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/y", (String)Files.simplifyPath((String)"/a/b/c/g;x=1/../y"));
    }

    public void testRfc3986Normal() {
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g", (String)Files.simplifyPath((String)"/a/b/c/g"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g", (String)Files.simplifyPath((String)"/a/b/c/./g"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g", (String)Files.simplifyPath((String)"/a/b/c/g/"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g?y", (String)Files.simplifyPath((String)"/a/b/c/g?y"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g#s", (String)Files.simplifyPath((String)"/a/b/c/g#s"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g?y#s", (String)Files.simplifyPath((String)"/a/b/c/g?y#s"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/;x", (String)Files.simplifyPath((String)"/a/b/c/;x"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g;x", (String)Files.simplifyPath((String)"/a/b/c/g;x"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g;x?y#s", (String)Files.simplifyPath((String)"/a/b/c/g;x?y#s"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c", (String)Files.simplifyPath((String)"/a/b/c/."));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c", (String)Files.simplifyPath((String)"/a/b/c/./"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b", (String)Files.simplifyPath((String)"/a/b/c/.."));
        FilesSimplifyPathTest.assertEquals((String)"/a/b", (String)Files.simplifyPath((String)"/a/b/c/../"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/g", (String)Files.simplifyPath((String)"/a/b/c/../g"));
        FilesSimplifyPathTest.assertEquals((String)"/a", (String)Files.simplifyPath((String)"/a/b/c/../.."));
        FilesSimplifyPathTest.assertEquals((String)"/a", (String)Files.simplifyPath((String)"/a/b/c/../../"));
        FilesSimplifyPathTest.assertEquals((String)"/a/g", (String)Files.simplifyPath((String)"/a/b/c/../../g"));
    }

    public void testRfc3986Abnormal() {
        FilesSimplifyPathTest.assertEquals((String)"/g", (String)Files.simplifyPath((String)"/a/b/c/../../../g"));
        FilesSimplifyPathTest.assertEquals((String)"/g", (String)Files.simplifyPath((String)"/a/b/c/../../../../g"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g.", (String)Files.simplifyPath((String)"/a/b/c/g."));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/.g", (String)Files.simplifyPath((String)"/a/b/c/.g"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g..", (String)Files.simplifyPath((String)"/a/b/c/g.."));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/..g", (String)Files.simplifyPath((String)"/a/b/c/..g"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/g", (String)Files.simplifyPath((String)"/a/b/c/./../g"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g", (String)Files.simplifyPath((String)"/a/b/c/./g/."));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g/h", (String)Files.simplifyPath((String)"/a/b/c/g/./h"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/h", (String)Files.simplifyPath((String)"/a/b/c/g/../h"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/g;x=1/y", (String)Files.simplifyPath((String)"/a/b/c/g;x=1/./y"));
        FilesSimplifyPathTest.assertEquals((String)"/a/b/c/y", (String)Files.simplifyPath((String)"/a/b/c/g;x=1/../y"));
    }

    public void testExtensiveWithAbsolutePrefix() throws IOException {
        this.doExtensiveTest("testdata/simplifypathwithabsoluteprefixtests.txt");
    }

    public void testExtensiveNoPrefix() throws IOException {
        this.doExtensiveTest("testdata/simplifypathnoprefixtests.txt");
    }

    private void doExtensiveTest(String resourceName) throws IOException {
        Splitter splitter = Splitter.on((CharMatcher)CharMatcher.WHITESPACE);
        URL url = ((Object)((Object)this)).getClass().getResource(resourceName);
        for (String line : Resources.readLines((URL)url, (Charset)Charsets.UTF_8)) {
            Iterator iterator = splitter.split((CharSequence)line).iterator();
            String input = (String)iterator.next();
            String expectedOutput = (String)iterator.next();
            FilesSimplifyPathTest.assertFalse((boolean)iterator.hasNext());
            FilesSimplifyPathTest.assertEquals((String)expectedOutput, (String)Files.simplifyPath((String)input));
        }
    }
}

