/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.primitives.Bytes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;

public class LittleEndianDataInputStreamTest
extends TestCase {
    private byte[] data;

    protected void setUp() throws Exception {
        super.setUp();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        this.initializeData(out);
        this.data = baos.toByteArray();
    }

    private void initializeData(DataOutputStream out) throws IOException {
        out.write(new byte[]{-100, 100});
        out.writeBoolean(true);
        out.writeBoolean(false);
        out.writeByte(100);
        out.writeByte(-100);
        out.writeByte(-56);
        out.writeChar(97);
        out.writeShort(-30000);
        out.writeShort(-15536);
        out.writeInt(-889275714);
        out.writeLong(-2401053089206453570L);
        out.writeUTF("Herby Derby");
        out.writeFloat(Float.intBitsToFloat(-889275714));
        out.writeDouble(Double.longBitsToDouble(-2401053089206453570L));
    }

    public void testReadFully() throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(this.data));
        byte[] b = new byte[this.data.length];
        in.readFully(b);
        LittleEndianDataInputStreamTest.assertEquals((Object)Bytes.asList((byte[])this.data), (Object)Bytes.asList((byte[])b));
    }

    public void testReadUnsignedByte_eof() throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(new byte[0]));
        try {
            in.readUnsignedByte();
            LittleEndianDataInputStreamTest.fail();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testReadUnsignedShort_eof() throws IOException {
        byte[] buf = new byte[]{23};
        LittleEndianDataInputStream in = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(buf));
        try {
            in.readUnsignedShort();
            LittleEndianDataInputStreamTest.fail();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testReadLine() throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(this.data));
        try {
            in.readLine();
            LittleEndianDataInputStreamTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            LittleEndianDataInputStreamTest.assertEquals((String)"readLine is not supported", (String)expected.getMessage());
        }
    }

    public void testReadLittleEndian() throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(this.data));
        byte[] b = new byte[2];
        in.readFully(b);
        LittleEndianDataInputStreamTest.assertEquals((int)-100, (int)b[0]);
        LittleEndianDataInputStreamTest.assertEquals((int)100, (int)b[1]);
        LittleEndianDataInputStreamTest.assertEquals((boolean)true, (boolean)in.readBoolean());
        LittleEndianDataInputStreamTest.assertEquals((boolean)false, (boolean)in.readBoolean());
        LittleEndianDataInputStreamTest.assertEquals((int)100, (int)in.readByte());
        LittleEndianDataInputStreamTest.assertEquals((int)-100, (int)in.readByte());
        LittleEndianDataInputStreamTest.assertEquals((int)200, (int)in.readUnsignedByte());
        LittleEndianDataInputStreamTest.assertEquals((char)'\u6100', (char)in.readChar());
        LittleEndianDataInputStreamTest.assertEquals((int)-12150, (int)in.readShort());
        LittleEndianDataInputStreamTest.assertEquals((int)20675, (int)in.readUnsignedShort());
        LittleEndianDataInputStreamTest.assertEquals((int)-1095041334, (int)in.readInt());
        LittleEndianDataInputStreamTest.assertEquals((long)-4703166713275961890L, (long)in.readLong());
        LittleEndianDataInputStreamTest.assertEquals((String)"Herby Derby", (String)in.readUTF());
        LittleEndianDataInputStreamTest.assertEquals((int)-1095041334, (int)Float.floatToIntBits(in.readFloat()));
        LittleEndianDataInputStreamTest.assertEquals((long)-4703166713275961890L, (long)Double.doubleToLongBits(in.readDouble()));
    }

    public void testSkipBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.write(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        this.initializeData(out);
        byte[] data = baos.toByteArray();
        LittleEndianDataInputStream in = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(data));
        for (int bytesSkipped = 0; bytesSkipped < 10; bytesSkipped += in.skipBytes(10 - bytesSkipped)) {
        }
        byte[] b = new byte[2];
        in.readFully(b);
        LittleEndianDataInputStreamTest.assertEquals((int)-100, (int)b[0]);
        LittleEndianDataInputStreamTest.assertEquals((int)100, (int)b[1]);
        LittleEndianDataInputStreamTest.assertTrue((boolean)in.readBoolean());
        LittleEndianDataInputStreamTest.assertFalse((boolean)in.readBoolean());
    }
}

