/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSourceTester;
import com.google.common.io.CharSourceTester;
import com.google.common.io.IoTestCase;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import com.google.common.io.SourceSinkFactories;
import com.google.common.testing.NullPointerTester;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.truth0.Truth;

public class ResourcesTest
extends IoTestCase {
    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)ByteSourceTester.tests("Resources.asByteSource[URL]", SourceSinkFactories.urlByteSourceFactory(), true));
        suite.addTest((Test)CharSourceTester.tests("Resources.asCharSource[URL, Charset]", SourceSinkFactories.urlCharSourceFactory()));
        suite.addTestSuite(ResourcesTest.class);
        return suite;
    }

    public void testToString() throws IOException {
        URL resource = ((Object)((Object)this)).getClass().getResource("testdata/i18n.txt");
        ResourcesTest.assertEquals((String)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (String)Resources.toString((URL)resource, (Charset)Charsets.UTF_8));
        Truth.ASSERT.that(Resources.toString((URL)resource, (Charset)Charsets.US_ASCII)).isNotEqualTo((Object)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1");
    }

    public void testToToByteArray() throws IOException {
        byte[] data = Resources.toByteArray((URL)ResourcesTest.classfile(Resources.class));
        ResourcesTest.assertEquals((int)-889275714, (int)new DataInputStream(new ByteArrayInputStream(data)).readInt());
    }

    public void testReadLines() throws IOException {
        URL resource = ((Object)((Object)this)).getClass().getResource("testdata/i18n.txt");
        ResourcesTest.assertEquals((Object)ImmutableList.of((Object)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1"), (Object)Resources.readLines((URL)resource, (Charset)Charsets.UTF_8));
    }

    public void testReadLines_withLineProcessor() throws IOException {
        URL resource = ((Object)((Object)this)).getClass().getResource("testdata/alice_in_wonderland.txt");
        LineProcessor<List<String>> collectAndLowercaseAndTrim = new LineProcessor<List<String>>(){
            List<String> collector = new ArrayList<String>();

            public boolean processLine(String line) {
                this.collector.add(CharMatcher.WHITESPACE.trimFrom((CharSequence)line));
                return true;
            }

            public List<String> getResult() {
                return this.collector;
            }
        };
        List result = (List)Resources.readLines((URL)resource, (Charset)Charsets.US_ASCII, (LineProcessor)collectAndLowercaseAndTrim);
        ResourcesTest.assertEquals((int)3600, (int)result.size());
        ResourcesTest.assertEquals((String)"ALICE'S ADVENTURES IN WONDERLAND", (String)((String)result.get(0)));
        ResourcesTest.assertEquals((String)"THE END", (String)((String)result.get(result.size() - 1)));
    }

    public void testCopyToOutputStream() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        URL resource = ((Object)((Object)this)).getClass().getResource("testdata/i18n.txt");
        Resources.copy((URL)resource, (OutputStream)out);
        ResourcesTest.assertEquals((String)"\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1", (String)out.toString("UTF-8"));
    }

    public void testGetResource_notFound() {
        try {
            Resources.getResource((String)"no such resource");
            ResourcesTest.fail();
        }
        catch (IllegalArgumentException e) {
            ResourcesTest.assertEquals((String)"resource no such resource not found.", (String)e.getMessage());
        }
    }

    public void testGetResource() {
        ResourcesTest.assertNotNull((Object)Resources.getResource((String)"com/google/common/io/testdata/i18n.txt"));
    }

    public void testGetResource_relativePath_notFound() {
        try {
            Resources.getResource(((Object)((Object)this)).getClass(), (String)"com/google/common/io/testdata/i18n.txt");
            ResourcesTest.fail();
        }
        catch (IllegalArgumentException e) {
            ResourcesTest.assertEquals((String)"resource com/google/common/io/testdata/i18n.txt relative to com.google.common.io.ResourcesTest not found.", (String)e.getMessage());
        }
    }

    public void testGetResource_relativePath() {
        ResourcesTest.assertNotNull((Object)Resources.getResource(((Object)((Object)this)).getClass(), (String)"testdata/i18n.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetResource_contextClassLoader() throws IOException {
        File tempFile = this.createTempFile();
        PrintWriter writer = new PrintWriter(tempFile, "UTF-8");
        writer.println("rud a chur ar an m\u00e9ar fhada");
        writer.close();
        try {
            Resources.getResource((String)tempFile.getName());
            ResourcesTest.fail((String)"Should get IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        URL baseUrl = tempFile.getParentFile().toURI().toURL();
        URLClassLoader loader = new URLClassLoader(new URL[]{baseUrl});
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            URL url = Resources.getResource((String)tempFile.getName());
            String text = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
            ResourcesTest.assertEquals((String)"rud a chur ar an m\u00e9ar fhada\n", (String)text);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetResource_contextClassLoaderNull() {
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            ResourcesTest.assertNotNull((Object)Resources.getResource((String)"com/google/common/io/testdata/i18n.txt"));
            try {
                Resources.getResource((String)"no such resource");
                ResourcesTest.fail((String)"Should get IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextLoader);
        }
    }

    public void testNulls() {
        new NullPointerTester().setDefault(URL.class, (Object)ResourcesTest.classfile(ResourcesTest.class)).testAllPublicStaticMethods(Resources.class);
    }

    private static URL classfile(Class<?> c) {
        return c.getResource(c.getSimpleName() + ".class");
    }
}

