/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.io.Resources;
import com.google.common.reflect.ClassPath;
import com.google.common.reflect.subpackage.ClassInSubPackage;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import junit.framework.TestCase;
import org.junit.Test;
import org.truth0.Truth;

public class ClassPathTest
extends TestCase {
    public void testGetResources() throws Exception {
        HashMap byName = Maps.newHashMap();
        HashMap byToString = Maps.newHashMap();
        ClassPath classpath = ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        for (ClassPath.ResourceInfo resource : classpath.getResources()) {
            Truth.ASSERT.that(resource.getResourceName()).isNotEqualTo((Object)"META-INF/MANIFEST.MF");
            Truth.ASSERT.that(resource.toString()).isNotEqualTo((Object)"META-INF/MANIFEST.MF");
            byName.put(resource.getResourceName(), resource);
            byToString.put(resource.toString(), resource);
            ClassPathTest.assertNotNull((Object)resource.url());
        }
        String testResourceName = "com/google/common/reflect/test.txt";
        Truth.ASSERT.that(byName.keySet()).has().allOf((Object)"com/google/common/reflect/ClassPath.class", (Object)"com/google/common/reflect/ClassPathTest.class", (Object[])new String[]{"com/google/common/reflect/ClassPathTest$Nested.class", testResourceName});
        Truth.ASSERT.that(byToString.keySet()).has().allOf((Object)"com.google.common.reflect.ClassPath", (Object)"com.google.common.reflect.ClassPathTest", (Object[])new String[]{"com.google.common.reflect.ClassPathTest$Nested", testResourceName});
        ClassPathTest.assertEquals((Object)((Object)((Object)this)).getClass().getClassLoader().getResource(testResourceName), (Object)((ClassPath.ResourceInfo)byName.get("com/google/common/reflect/test.txt")).url());
    }

    public void testGetAllClasses() throws Exception {
        HashSet names = Sets.newHashSet();
        HashSet strings = Sets.newHashSet();
        HashSet classes = Sets.newHashSet();
        HashSet packageNames = Sets.newHashSet();
        HashSet simpleNames = Sets.newHashSet();
        ClassPath classpath = ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        for (ClassPath.ClassInfo classInfo : classpath.getAllClasses()) {
            if (!classInfo.getPackageName().equals(ClassPathTest.class.getPackage().getName())) continue;
            names.add(classInfo.getName());
            strings.add(classInfo.toString());
            classes.add(classInfo.load());
            packageNames.add(classInfo.getPackageName());
            simpleNames.add(classInfo.getSimpleName());
        }
        Class<?> anonymousClass = new Object(){}.getClass();
        class LocalClass {
            LocalClass() {
            }
        }
        Truth.ASSERT.that((Collection)names).has().allOf((Object)anonymousClass.getName(), (Object)LocalClass.class.getName(), (Object[])new String[]{ClassPath.class.getName(), ClassPathTest.class.getName()});
        Truth.ASSERT.that((Collection)strings).has().allOf((Object)anonymousClass.getName(), (Object)LocalClass.class.getName(), (Object[])new String[]{ClassPath.class.getName(), ClassPathTest.class.getName()});
        Truth.ASSERT.that((Collection)classes).has().allOf(anonymousClass, LocalClass.class, (Object[])new Class[]{ClassPath.class, ClassPathTest.class});
        Truth.ASSERT.that((Collection)packageNames).has().exactly((Object)ClassPath.class.getPackage().getName());
        Truth.ASSERT.that((Collection)simpleNames).has().allOf((Object)"", (Object)"Local", (Object[])new String[]{"ClassPath", "ClassPathTest"});
    }

    public void testGetTopLevelClasses() throws Exception {
        HashSet names = Sets.newHashSet();
        HashSet strings = Sets.newHashSet();
        HashSet classes = Sets.newHashSet();
        HashSet packageNames = Sets.newHashSet();
        HashSet simpleNames = Sets.newHashSet();
        ClassPath classpath = ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        for (ClassPath.ClassInfo classInfo : classpath.getTopLevelClasses(ClassPathTest.class.getPackage().getName())) {
            names.add(classInfo.getName());
            strings.add(classInfo.toString());
            classes.add(classInfo.load());
            packageNames.add(classInfo.getPackageName());
            simpleNames.add(classInfo.getSimpleName());
        }
        Truth.ASSERT.that((Collection)names).has().allOf((Object)ClassPath.class.getName(), (Object)ClassPathTest.class.getName(), (Object[])new String[0]);
        Truth.ASSERT.that((Collection)strings).has().allOf((Object)ClassPath.class.getName(), (Object)ClassPathTest.class.getName(), (Object[])new String[0]);
        Truth.ASSERT.that((Collection)classes).has().allOf(ClassPath.class, ClassPathTest.class, (Object[])new Class[0]);
        Truth.ASSERT.that((Collection)packageNames).has().item((Object)ClassPath.class.getPackage().getName());
        Truth.ASSERT.that((Collection)simpleNames).has().allOf((Object)"ClassPath", (Object)"ClassPathTest", (Object[])new String[0]);
        ClassPathTest.assertFalse((boolean)classes.contains(ClassInSubPackage.class));
    }

    public void testGetTopLevelClassesRecursive() throws Exception {
        HashSet classes = Sets.newHashSet();
        ClassPath classpath = ClassPath.from((ClassLoader)ClassPathTest.class.getClassLoader());
        for (ClassPath.ClassInfo classInfo : classpath.getTopLevelClassesRecursive(ClassPathTest.class.getPackage().getName())) {
            if (classInfo.getName().contains("ClassPathTest")) {
                System.err.println("");
            }
            classes.add(classInfo.load());
        }
        Truth.ASSERT.that((Collection)classes).has().allOf(ClassPathTest.class, ClassInSubPackage.class, (Object[])new Class[0]);
    }

    public void testGetTopLevelClasses_diamond() throws Exception {
        ClassLoader parent = ClassPathTest.class.getClassLoader();
        ClassLoader sub1 = new ClassLoader(parent){};
        ClassLoader sub2 = new ClassLoader(parent){};
        ClassPathTest.assertEquals((Object)ClassPathTest.findClass((Iterable<ClassPath.ClassInfo>)ClassPath.from((ClassLoader)sub1).getTopLevelClasses(), ClassPathTest.class), (Object)ClassPathTest.findClass((Iterable<ClassPath.ClassInfo>)ClassPath.from((ClassLoader)sub2).getTopLevelClasses(), ClassPathTest.class));
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{ClassPathTest.classInfo(ClassPathTest.class), ClassPathTest.classInfo(ClassPathTest.class)}).addEqualityGroup(new Object[]{ClassPathTest.classInfo(Test.class), ClassPathTest.classInfo(Test.class, ((Object)((Object)this)).getClass().getClassLoader())}).addEqualityGroup(new Object[]{new ClassPath.ResourceInfo("a/b/c.txt", ((Object)((Object)this)).getClass().getClassLoader()), new ClassPath.ResourceInfo("a/b/c.txt", ((Object)((Object)this)).getClass().getClassLoader())}).addEqualityGroup(new Object[]{new ClassPath.ResourceInfo("x.txt", ((Object)((Object)this)).getClass().getClassLoader())}).testEquals();
    }

    public void testClassPathEntries_emptyURLClassLoader_noParent() {
        Truth.ASSERT.that((Collection)ClassPath.getClassPathEntries((ClassLoader)new URLClassLoader(new URL[0], null)).keySet()).isEmpty();
    }

    public void testClassPathEntries_URLClassLoader_noParent() throws Exception {
        URL url1 = new URL("file:/a");
        URL url2 = new URL("file:/b");
        URLClassLoader classloader = new URLClassLoader(new URL[]{url1, url2}, null);
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)url1.toURI(), (Object)classloader, (Object)url2.toURI(), (Object)classloader), (Object)ClassPath.getClassPathEntries((ClassLoader)classloader));
    }

    public void testClassPathEntries_URLClassLoader_withParent() throws Exception {
        URL url1 = new URL("file:/a");
        URL url2 = new URL("file:/b");
        URLClassLoader parent = new URLClassLoader(new URL[]{url1}, null);
        URLClassLoader child = new URLClassLoader(new URL[]{url2}, (ClassLoader)parent){};
        ImmutableMap classPathEntries = ClassPath.getClassPathEntries((ClassLoader)child);
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)url1.toURI(), (Object)parent, (Object)url2.toURI(), (Object)child), (Object)classPathEntries);
        Truth.ASSERT.that((Collection)classPathEntries.keySet()).has().exactly((Object)url1.toURI(), (Object)url2.toURI(), (Object[])new URI[0]).inOrder();
    }

    public void testClassPathEntries_duplicateUri_parentWins() throws Exception {
        URL url = new URL("file:/a");
        URLClassLoader parent = new URLClassLoader(new URL[]{url}, null);
        URLClassLoader child = new URLClassLoader(new URL[]{url}, (ClassLoader)parent){};
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)url.toURI(), (Object)parent), (Object)ClassPath.getClassPathEntries((ClassLoader)child));
    }

    public void testClassPathEntries_notURLClassLoader_noParent() {
        Truth.ASSERT.that((Collection)ClassPath.getClassPathEntries((ClassLoader)new ClassLoader(null){}).keySet()).isEmpty();
    }

    public void testClassPathEntries_notURLClassLoader_withParent() throws Exception {
        URL url = new URL("file:/a");
        URLClassLoader parent = new URLClassLoader(new URL[]{url}, null);
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)url.toURI(), (Object)parent), (Object)ClassPath.getClassPathEntries((ClassLoader)new ClassLoader((ClassLoader)parent){}));
    }

    public void testClassPathEntries_notURLClassLoader_withParentAndGrandParent() throws Exception {
        URL url1 = new URL("file:/a");
        URL url2 = new URL("file:/b");
        URLClassLoader grandParent = new URLClassLoader(new URL[]{url1}, null);
        URLClassLoader parent = new URLClassLoader(new URL[]{url2}, (ClassLoader)grandParent);
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)url1.toURI(), (Object)grandParent, (Object)url2.toURI(), (Object)parent), (Object)ClassPath.getClassPathEntries((ClassLoader)new ClassLoader((ClassLoader)parent){}));
    }

    public void testClassPathEntries_notURLClassLoader_withGrandParent() throws Exception {
        URL url = new URL("file:/a");
        URLClassLoader grandParent = new URLClassLoader(new URL[]{url}, null);
        ClassLoader parent = new ClassLoader((ClassLoader)grandParent){};
        ClassPathTest.assertEquals((Object)ImmutableMap.of((Object)url.toURI(), (Object)grandParent), (Object)ClassPath.getClassPathEntries((ClassLoader)new ClassLoader(parent){}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScan_classPathCycle() throws IOException {
        File jarFile = File.createTempFile("with_circular_class_path", ".jar");
        try {
            ClassPathTest.writeSelfReferencingJarFile(jarFile, "test.txt");
            ClassPath.Scanner scanner = new ClassPath.Scanner();
            scanner.scan(jarFile.toURI(), ClassPathTest.class.getClassLoader());
            ClassPathTest.assertEquals((int)1, (int)scanner.getResources().size());
        }
        finally {
            jarFile.delete();
        }
    }

    public void testScanFromFile_fileNotExists() throws IOException {
        ClassLoader classLoader = ClassPathTest.class.getClassLoader();
        ClassPath.Scanner scanner = new ClassPath.Scanner();
        scanner.scanFrom(new File("no/such/file/anywhere"), classLoader);
        Truth.ASSERT.that((Collection)scanner.getResources()).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScanFromFile_notJarFile() throws IOException {
        ClassLoader classLoader = ClassPathTest.class.getClassLoader();
        File notJar = File.createTempFile("not_a_jar", "txt");
        ClassPath.Scanner scanner = new ClassPath.Scanner();
        try {
            scanner.scanFrom(notJar, classLoader);
        }
        finally {
            notJar.delete();
        }
        Truth.ASSERT.that((Collection)scanner.getResources()).isEmpty();
    }

    public void testGetClassPathEntry() throws URISyntaxException {
        ClassPathTest.assertEquals((Object)URI.create("file:/usr/test/dep.jar"), (Object)ClassPath.Scanner.getClassPathEntry((File)new File("/home/build/outer.jar"), (String)"file:/usr/test/dep.jar"));
        ClassPathTest.assertEquals((Object)URI.create("file:/home/build/a.jar"), (Object)ClassPath.Scanner.getClassPathEntry((File)new File("/home/build/outer.jar"), (String)"a.jar"));
        ClassPathTest.assertEquals((Object)URI.create("file:/home/build/x/y/z"), (Object)ClassPath.Scanner.getClassPathEntry((File)new File("/home/build/outer.jar"), (String)"x/y/z"));
        ClassPathTest.assertEquals((Object)URI.create("file:/home/build/x/y/z.jar"), (Object)ClassPath.Scanner.getClassPathEntry((File)new File("/home/build/outer.jar"), (String)"x/y/z.jar"));
    }

    public void testGetClassPathFromManifest_nullManifest() {
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)new File("some.jar"), null)).isEmpty();
    }

    public void testGetClassPathFromManifest_noClassPath() throws IOException {
        File jarFile = new File("base.jar");
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)ClassPathTest.manifest(""))).isEmpty();
    }

    public void testGetClassPathFromManifest_emptyClassPath() throws IOException {
        File jarFile = new File("base.jar");
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)ClassPathTest.manifestClasspath(""))).isEmpty();
    }

    public void testGetClassPathFromManifest_badClassPath() throws IOException {
        File jarFile = new File("base.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("an_invalid^path");
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).isEmpty();
    }

    public void testGetClassPathFromManifest_relativeDirectory() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("with/relative/dir");
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).has().exactly((Object)new File("base/with/relative/dir").toURI()).inOrder();
    }

    public void testGetClassPathFromManifest_relativeJar() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("with/relative.jar");
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).has().exactly((Object)new File("base/with/relative.jar").toURI()).inOrder();
    }

    public void testGetClassPathFromManifest_jarInCurrentDirectory() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("current.jar");
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).has().exactly((Object)new File("base/current.jar").toURI()).inOrder();
    }

    public void testGetClassPathFromManifest_absoluteDirectory() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("file:/with/absolute/dir");
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).has().exactly((Object)new File("/with/absolute/dir").toURI()).inOrder();
    }

    public void testGetClassPathFromManifest_absoluteJar() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("file:/with/absolute.jar");
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).has().exactly((Object)new File("/with/absolute.jar").toURI()).inOrder();
    }

    public void testGetClassPathFromManifest_multiplePaths() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("file:/with/absolute.jar relative.jar  relative/dir");
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).has().exactly((Object)new File("/with/absolute.jar").toURI(), (Object)new File("base/relative.jar").toURI(), (Object[])new URI[]{new File("base/relative/dir").toURI()}).inOrder();
    }

    public void testGetClassPathFromManifest_leadingBlanks() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath(" relative.jar");
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).has().exactly((Object)new File("base/relative.jar").toURI()).inOrder();
    }

    public void testGetClassPathFromManifest_trailingBlanks() throws IOException {
        File jarFile = new File("base/some.jar");
        Manifest manifest = ClassPathTest.manifestClasspath("relative.jar ");
        Truth.ASSERT.that((Collection)ClassPath.Scanner.getClassPathFromManifest((File)jarFile, (Manifest)manifest)).has().exactly((Object)new File("base/relative.jar").toURI()).inOrder();
    }

    public void testGetClassName() {
        ClassPathTest.assertEquals((String)"abc.d.Abc", (String)ClassPath.getClassName((String)"abc/d/Abc.class"));
    }

    public void testResourceInfo_of() {
        ClassPathTest.assertEquals(ClassPath.ClassInfo.class, ClassPathTest.resourceInfo(ClassPathTest.class).getClass());
        ClassPathTest.assertEquals(ClassPath.ClassInfo.class, ClassPathTest.resourceInfo(ClassPath.class).getClass());
        ClassPathTest.assertEquals(ClassPath.ClassInfo.class, ClassPathTest.resourceInfo(Nested.class).getClass());
    }

    public void testGetSimpleName() {
        ClassPathTest.assertEquals((String)"Foo", (String)new ClassPath.ClassInfo("Foo.class", ((Object)((Object)this)).getClass().getClassLoader()).getSimpleName());
        ClassPathTest.assertEquals((String)"Foo", (String)new ClassPath.ClassInfo("a/b/Foo.class", ((Object)((Object)this)).getClass().getClassLoader()).getSimpleName());
        ClassPathTest.assertEquals((String)"Foo", (String)new ClassPath.ClassInfo("a/b/Bar$Foo.class", ((Object)((Object)this)).getClass().getClassLoader()).getSimpleName());
        ClassPathTest.assertEquals((String)"", (String)new ClassPath.ClassInfo("a/b/Bar$1.class", ((Object)((Object)this)).getClass().getClassLoader()).getSimpleName());
        ClassPathTest.assertEquals((String)"Foo", (String)new ClassPath.ClassInfo("a/b/Bar$Foo.class", ((Object)((Object)this)).getClass().getClassLoader()).getSimpleName());
        ClassPathTest.assertEquals((String)"", (String)new ClassPath.ClassInfo("a/b/Bar$1.class", ((Object)((Object)this)).getClass().getClassLoader()).getSimpleName());
        ClassPathTest.assertEquals((String)"Local", (String)new ClassPath.ClassInfo("a/b/Bar$1Local.class", ((Object)((Object)this)).getClass().getClassLoader()).getSimpleName());
    }

    public void testGetPackageName() {
        ClassPathTest.assertEquals((String)"", (String)new ClassPath.ClassInfo("Foo.class", ((Object)((Object)this)).getClass().getClassLoader()).getPackageName());
        ClassPathTest.assertEquals((String)"a.b", (String)new ClassPath.ClassInfo("a/b/Foo.class", ((Object)((Object)this)).getClass().getClassLoader()).getPackageName());
    }

    public void testNulls() throws IOException {
        new NullPointerTester().testAllPublicStaticMethods(ClassPath.class);
        new NullPointerTester().testAllPublicInstanceMethods((Object)ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
    }

    private static ClassPath.ClassInfo findClass(Iterable<ClassPath.ClassInfo> classes, Class<?> cls) {
        for (ClassPath.ClassInfo classInfo : classes) {
            if (!classInfo.getName().equals(cls.getName())) continue;
            return classInfo;
        }
        throw new AssertionError((Object)("failed to find " + cls));
    }

    private static ClassPath.ResourceInfo resourceInfo(Class<?> cls) {
        return ClassPath.ResourceInfo.of((String)(cls.getName().replace('.', '/') + ".class"), (ClassLoader)cls.getClassLoader());
    }

    private static ClassPath.ClassInfo classInfo(Class<?> cls) {
        return ClassPathTest.classInfo(cls, cls.getClassLoader());
    }

    private static ClassPath.ClassInfo classInfo(Class<?> cls, ClassLoader classLoader) {
        return new ClassPath.ClassInfo(cls.getName().replace('.', '/') + ".class", classLoader);
    }

    private static Manifest manifestClasspath(String classpath) throws IOException {
        return ClassPathTest.manifest("Class-Path: " + classpath + "\n");
    }

    private static void writeSelfReferencingJarFile(File jarFile, String ... entries) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, jarFile.getName());
        Closer closer = Closer.create();
        try {
            FileOutputStream fileOut = (FileOutputStream)closer.register((Closeable)new FileOutputStream(jarFile));
            JarOutputStream jarOut = (JarOutputStream)closer.register((Closeable)new JarOutputStream(fileOut));
            for (String entry : entries) {
                jarOut.putNextEntry(new ZipEntry(entry));
                Resources.copy((URL)ClassPathTest.class.getResource(entry), (OutputStream)jarOut);
                jarOut.closeEntry();
            }
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    private static Manifest manifest(String content) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(Charsets.US_ASCII));
        Manifest manifest = new Manifest();
        manifest.read(in);
        return manifest;
    }

    private static class Nested {
        private Nested() {
        }
    }
}

