/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeToken;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import junit.framework.Assert;
import junit.framework.TestCase;

public class InvokableTest
extends TestCase {
    public void testConstructor_returnType() throws Exception {
        InvokableTest.assertEquals(Prepender.class, (Object)Prepender.constructor(new Class[0]).getReturnType().getType());
    }

    public void testConstructor_returnType_hasTypeParameter() throws Exception {
        Class<WithConstructorAndTypeParameter> type = WithConstructorAndTypeParameter.class;
        Constructor constructor = type.getDeclaredConstructor(new Class[0]);
        Invokable factory = Invokable.from(constructor);
        InvokableTest.assertEquals((int)2, (int)factory.getTypeParameters().length);
        InvokableTest.assertEquals(type.getTypeParameters()[0], (Object)factory.getTypeParameters()[0]);
        InvokableTest.assertEquals(constructor.getTypeParameters()[0], (Object)factory.getTypeParameters()[1]);
        ParameterizedType returnType = (ParameterizedType)factory.getReturnType().getType();
        InvokableTest.assertEquals(type, (Object)returnType.getRawType());
        InvokableTest.assertEquals((Object)ImmutableList.copyOf((Object[])type.getTypeParameters()), (Object)ImmutableList.copyOf((Object[])returnType.getActualTypeArguments()));
    }

    public void testConstructor_exceptionTypes() throws Exception {
        InvokableTest.assertEquals((Object)ImmutableList.of((Object)TypeToken.of(NullPointerException.class)), (Object)Prepender.constructor(String.class, Integer.TYPE).getExceptionTypes());
    }

    public void testConstructor_typeParameters() throws Exception {
        TypeVariable[] variables = Prepender.constructor(new Class[0]).getTypeParameters();
        InvokableTest.assertEquals((int)1, (int)variables.length);
        InvokableTest.assertEquals((String)"A", (String)variables[0].getName());
    }

    public void testConstructor_parameters() throws Exception {
        Invokable<?, Prepender> delegate = Prepender.constructor(String.class, Integer.TYPE);
        ImmutableList parameters = delegate.getParameters();
        InvokableTest.assertEquals((int)2, (int)parameters.size());
        InvokableTest.assertEquals(String.class, (Object)((Parameter)parameters.get(0)).getType().getType());
        InvokableTest.assertTrue((boolean)((Parameter)parameters.get(0)).isAnnotationPresent(NotBlank.class));
        InvokableTest.assertEquals(Integer.TYPE, (Object)((Parameter)parameters.get(1)).getType().getType());
        InvokableTest.assertFalse((boolean)((Parameter)parameters.get(1)).isAnnotationPresent(NotBlank.class));
        new EqualsTester().addEqualityGroup(new Object[]{parameters.get(0)}).addEqualityGroup(new Object[]{parameters.get(1)}).testEquals();
    }

    public void testConstructor_call() throws Exception {
        Invokable<?, Prepender> delegate = Prepender.constructor(String.class, Integer.TYPE);
        Prepender prepender = (Prepender)delegate.invoke(null, new Object[]{"a", 1});
        InvokableTest.assertEquals((String)"a", (String)prepender.prefix);
        InvokableTest.assertEquals((int)1, (int)prepender.times);
    }

    public void testConstructor_returning() throws Exception {
        Invokable delegate = Prepender.constructor(String.class, Integer.TYPE).returning(Prepender.class);
        Prepender prepender = (Prepender)delegate.invoke(null, new Object[]{"a", 1});
        InvokableTest.assertEquals((String)"a", (String)prepender.prefix);
        InvokableTest.assertEquals((int)1, (int)prepender.times);
    }

    public void testConstructor_invalidReturning() throws Exception {
        Invokable<?, Prepender> delegate = Prepender.constructor(String.class, Integer.TYPE);
        try {
            delegate.returning(SubPrepender.class);
            InvokableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStaticMethod_returnType() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", String.class, Iterable.class);
        InvokableTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)delegate.getReturnType());
    }

    public void testStaticMethod_exceptionTypes() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", String.class, Iterable.class);
        InvokableTest.assertEquals((Object)ImmutableList.of(), (Object)delegate.getExceptionTypes());
    }

    public void testStaticMethod_typeParameters() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", String.class, Iterable.class);
        TypeVariable[] variables = delegate.getTypeParameters();
        InvokableTest.assertEquals((int)1, (int)variables.length);
        InvokableTest.assertEquals((String)"T", (String)variables[0].getName());
    }

    public void testStaticMethod_parameters() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", String.class, Iterable.class);
        ImmutableList parameters = delegate.getParameters();
        InvokableTest.assertEquals((int)2, (int)parameters.size());
        InvokableTest.assertEquals(String.class, (Object)((Parameter)parameters.get(0)).getType().getType());
        InvokableTest.assertTrue((boolean)((Parameter)parameters.get(0)).isAnnotationPresent(NotBlank.class));
        InvokableTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)((Parameter)parameters.get(1)).getType());
        InvokableTest.assertFalse((boolean)((Parameter)parameters.get(1)).isAnnotationPresent(NotBlank.class));
        new EqualsTester().addEqualityGroup(new Object[]{parameters.get(0)}).addEqualityGroup(new Object[]{parameters.get(1)}).testEquals();
    }

    public void testStaticMethod_call() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", String.class, Iterable.class);
        Iterable result = (Iterable)delegate.invoke(null, new Object[]{"a", ImmutableList.of((Object)"b", (Object)"c")});
        InvokableTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.copyOf((Iterable)result));
    }

    public void testStaticMethod_returning() throws Exception {
        Invokable delegate = Prepender.method("prepend", String.class, Iterable.class).returning((TypeToken)new TypeToken<Iterable<String>>(){});
        InvokableTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)delegate.getReturnType());
        Iterable result = (Iterable)delegate.invoke(null, new Object[]{"a", ImmutableList.of((Object)"b", (Object)"c")});
        InvokableTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.copyOf((Iterable)result));
    }

    public void testStaticMethod_returningRawType() throws Exception {
        Invokable delegate = Prepender.method("prepend", String.class, Iterable.class).returning(Iterable.class);
        InvokableTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)delegate.getReturnType());
        Iterable result = (Iterable)delegate.invoke(null, new Object[]{"a", ImmutableList.of((Object)"b", (Object)"c")});
        InvokableTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.copyOf((Iterable)result));
    }

    public void testStaticMethod_invalidReturning() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", String.class, Iterable.class);
        try {
            delegate.returning((TypeToken)new TypeToken<Iterable<Integer>>(){});
            InvokableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInstanceMethod_returnType() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", Iterable.class);
        InvokableTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)delegate.getReturnType());
    }

    public void testInstanceMethod_exceptionTypes() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", Iterable.class);
        InvokableTest.assertEquals((Object)ImmutableList.of((Object)TypeToken.of(IllegalArgumentException.class), (Object)TypeToken.of(NullPointerException.class)), (Object)delegate.getExceptionTypes());
    }

    public void testInstanceMethod_typeParameters() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", Iterable.class);
        InvokableTest.assertEquals((int)0, (int)delegate.getTypeParameters().length);
    }

    public void testInstanceMethod_parameters() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", Iterable.class);
        ImmutableList parameters = delegate.getParameters();
        InvokableTest.assertEquals((int)1, (int)parameters.size());
        InvokableTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)((Parameter)parameters.get(0)).getType());
        InvokableTest.assertEquals((int)0, (int)((Parameter)parameters.get(0)).getAnnotations().length);
        new EqualsTester().addEqualityGroup(new Object[]{parameters.get(0)}).testEquals();
    }

    public void testInstanceMethod_call() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", Iterable.class);
        Iterable result = (Iterable)delegate.invoke((Object)new Prepender("a", 2), new Object[]{ImmutableList.of((Object)"b", (Object)"c")});
        InvokableTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.copyOf((Iterable)result));
    }

    public void testInstanceMethod_returning() throws Exception {
        Invokable delegate = Prepender.method("prepend", Iterable.class).returning((TypeToken)new TypeToken<Iterable<String>>(){});
        InvokableTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)delegate.getReturnType());
        Iterable result = (Iterable)delegate.invoke((Object)new Prepender("a", 2), new Object[]{ImmutableList.of((Object)"b", (Object)"c")});
        InvokableTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.copyOf((Iterable)result));
    }

    public void testInstanceMethod_returningRawType() throws Exception {
        Invokable delegate = Prepender.method("prepend", Iterable.class).returning(Iterable.class);
        InvokableTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)delegate.getReturnType());
        Iterable result = (Iterable)delegate.invoke((Object)new Prepender("a", 2), new Object[]{ImmutableList.of((Object)"b", (Object)"c")});
        InvokableTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.copyOf((Iterable)result));
    }

    public void testInstanceMethod_invalidReturning() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("prepend", Iterable.class);
        try {
            delegate.returning((TypeToken)new TypeToken<Iterable<Integer>>(){});
            InvokableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPrivateInstanceMethod_isOverridable() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("privateMethod", new Class[0]);
        InvokableTest.assertTrue((boolean)delegate.isPrivate());
        InvokableTest.assertFalse((boolean)delegate.isOverridable());
        InvokableTest.assertFalse((boolean)delegate.isVarArgs());
    }

    public void testPrivateFinalInstanceMethod_isOverridable() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("privateFinalMethod", new Class[0]);
        InvokableTest.assertTrue((boolean)delegate.isPrivate());
        InvokableTest.assertTrue((boolean)delegate.isFinal());
        InvokableTest.assertFalse((boolean)delegate.isOverridable());
        InvokableTest.assertFalse((boolean)delegate.isVarArgs());
    }

    public void testStaticMethod_isOverridable() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("staticMethod", new Class[0]);
        InvokableTest.assertTrue((boolean)delegate.isStatic());
        InvokableTest.assertFalse((boolean)delegate.isOverridable());
        InvokableTest.assertFalse((boolean)delegate.isVarArgs());
    }

    public void testStaticFinalMethod_isFinal() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("staticFinalMethod", new Class[0]);
        InvokableTest.assertTrue((boolean)delegate.isStatic());
        InvokableTest.assertTrue((boolean)delegate.isFinal());
        InvokableTest.assertFalse((boolean)delegate.isOverridable());
        InvokableTest.assertFalse((boolean)delegate.isVarArgs());
    }

    public void testConstructor_isOverridablel() throws Exception {
        Invokable delegate = Invokable.from(Foo.class.getDeclaredConstructor(new Class[0]));
        InvokableTest.assertFalse((boolean)delegate.isOverridable());
        InvokableTest.assertFalse((boolean)delegate.isVarArgs());
    }

    public void testMethod_isVarArgs() throws Exception {
        Invokable<Prepender, Object> delegate = Prepender.method("privateVarArgsMethod", String[].class);
        InvokableTest.assertTrue((boolean)delegate.isVarArgs());
    }

    public void testConstructor_isVarArgs() throws Exception {
        Invokable<?, Prepender> delegate = Prepender.constructor(String[].class);
        InvokableTest.assertTrue((boolean)delegate.isVarArgs());
    }

    public void testGetOwnerType_constructor() throws Exception {
        Invokable invokable = Invokable.from(String.class.getConstructor(new Class[0]));
        InvokableTest.assertEquals((Object)TypeToken.of(String.class), (Object)invokable.getOwnerType());
    }

    public void testGetOwnerType_method() throws Exception {
        Invokable invokable = Invokable.from((Method)String.class.getMethod("length", new Class[0]));
        InvokableTest.assertEquals((Object)TypeToken.of(String.class), (Object)invokable.getOwnerType());
    }

    public void testNonFinalMethodInFinalClass_isOverridable() throws Exception {
        Invokable delegate = Invokable.from((Method)FinalClass.class.getDeclaredMethod("notFinalMethod", new Class[0]));
        InvokableTest.assertFalse((boolean)delegate.isOverridable());
        InvokableTest.assertFalse((boolean)delegate.isVarArgs());
    }

    public void testInnerClassDefaultConstructor() {
        Constructor<?> constructor = InnerWithDefaultConstructor.class.getDeclaredConstructors()[0];
        InvokableTest.assertEquals((int)0, (int)Invokable.from(constructor).getParameters().size());
    }

    public void testNestedInnerClassDefaultConstructor() {
        Constructor<?> constructor = InnerWithDefaultConstructor.NestedInner.class.getDeclaredConstructors()[0];
        InvokableTest.assertEquals((int)0, (int)Invokable.from(constructor).getParameters().size());
    }

    public void testInnerClassWithOneParameterConstructor() {
        Constructor<?> constructor = InnerWithOneParameterConstructor.class.getDeclaredConstructors()[0];
        Invokable invokable = Invokable.from(constructor);
        InvokableTest.assertEquals((int)1, (int)invokable.getParameters().size());
        InvokableTest.assertEquals((Object)TypeToken.of(String.class), (Object)((Parameter)invokable.getParameters().get(0)).getType());
    }

    public void testInnerClassWithAnnotatedConstructorParameter() {
        Constructor<?> constructor = InnerWithAnnotatedConstructorParameter.class.getDeclaredConstructors()[0];
        Invokable invokable = Invokable.from(constructor);
        InvokableTest.assertEquals((int)1, (int)invokable.getParameters().size());
        InvokableTest.assertEquals((Object)TypeToken.of(String.class), (Object)((Parameter)invokable.getParameters().get(0)).getType());
    }

    public void testInnerClassWithGenericConstructorParameter() {
        Constructor<?> constructor = InnerWithGenericConstructorParameter.class.getDeclaredConstructors()[0];
        Invokable invokable = Invokable.from(constructor);
        InvokableTest.assertEquals((int)2, (int)invokable.getParameters().size());
        InvokableTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)((Parameter)invokable.getParameters().get(0)).getType());
        InvokableTest.assertEquals((Object)TypeToken.of(String.class), (Object)((Parameter)invokable.getParameters().get(1)).getType());
    }

    public void testAnonymousClassDefaultConstructor() {
        boolean i = true;
        String s = "hello world";
        Class<?> anonymous = new Runnable(){

            @Override
            public void run() {
                System.out.println("hello world1");
            }
        }.getClass();
        Constructor<?> constructor = anonymous.getDeclaredConstructors()[0];
        InvokableTest.assertEquals((int)0, (int)Invokable.from(constructor).getParameters().size());
    }

    public void testAnonymousClassWithTwoParametersConstructor() {
        abstract class Base {
            Base(String s, int i) {
            }
        }
        Class<?> anonymous = new Base("test", 0){
            {
                super(x0, x1);
            }
        }.getClass();
        Constructor<?> constructor = anonymous.getDeclaredConstructors()[0];
        InvokableTest.assertEquals((int)2, (int)Invokable.from(constructor).getParameters().size());
    }

    public void testLocalClassDefaultConstructor() {
        boolean i = true;
        String s = "hello world";
        class LocalWithDefaultConstructor
        implements Runnable {
            LocalWithDefaultConstructor() {
            }

            @Override
            public void run() {
                System.out.println("hello world1");
            }
        }
        Constructor<?> constructor = LocalWithDefaultConstructor.class.getDeclaredConstructors()[0];
        InvokableTest.assertEquals((int)0, (int)Invokable.from(constructor).getParameters().size());
    }

    public void testStaticAnonymousClassDefaultConstructor() throws Exception {
        InvokableTest.doTestStaticAnonymousClassDefaultConstructor();
    }

    private static void doTestStaticAnonymousClassDefaultConstructor() {
        boolean i = true;
        String s = "hello world";
        Class<?> anonymous = new Runnable(){

            @Override
            public void run() {
                System.out.println("hello world1");
            }
        }.getClass();
        Constructor<?> constructor = anonymous.getDeclaredConstructors()[0];
        InvokableTest.assertEquals((int)0, (int)Invokable.from(constructor).getParameters().size());
    }

    public void testAnonymousClassInConstructor() {
        new AnonymousClassInConstructor();
    }

    public void testLocalClassInInstanceInitializer() {
        new LocalClassInInstanceInitializer();
    }

    public void testLocalClassInStaticInitializer() {
        new LocalClassInStaticInitializer();
    }

    public void testLocalClassWithSeeminglyHiddenThisInStaticInitializer_BUG() {
        new LocalClassWithSeeminglyHiddenThisInStaticInitializer();
    }

    public void testLocalClassWithOneParameterConstructor() throws Exception {
        boolean i = true;
        String s = "hello world";
        class LocalWithOneParameterConstructor {
            public LocalWithOneParameterConstructor(String x) {
                System.out.println("hello world1");
            }
        }
        Constructor<?> constructor = LocalWithOneParameterConstructor.class.getDeclaredConstructors()[0];
        Invokable invokable = Invokable.from(constructor);
        InvokableTest.assertEquals((int)1, (int)invokable.getParameters().size());
        InvokableTest.assertEquals((Object)TypeToken.of(String.class), (Object)((Parameter)invokable.getParameters().get(0)).getType());
    }

    public void testLocalClassWithAnnotatedConstructorParameter() throws Exception {
        class LocalWithAnnotatedConstructorParameter {
            LocalWithAnnotatedConstructorParameter(String s) {
            }
        }
        Constructor<?> constructor = LocalWithAnnotatedConstructorParameter.class.getDeclaredConstructors()[0];
        Invokable invokable = Invokable.from(constructor);
        InvokableTest.assertEquals((int)1, (int)invokable.getParameters().size());
        InvokableTest.assertEquals((Object)TypeToken.of(String.class), (Object)((Parameter)invokable.getParameters().get(0)).getType());
    }

    public void testLocalClassWithGenericConstructorParameter() throws Exception {
        class LocalWithGenericConstructorParameter {
            LocalWithGenericConstructorParameter(Iterable<String> it, String s) {
            }
        }
        Constructor<?> constructor = LocalWithGenericConstructorParameter.class.getDeclaredConstructors()[0];
        Invokable invokable = Invokable.from(constructor);
        InvokableTest.assertEquals((int)2, (int)invokable.getParameters().size());
        InvokableTest.assertEquals((Object)new TypeToken<Iterable<String>>(){}, (Object)((Parameter)invokable.getParameters().get(0)).getType());
        InvokableTest.assertEquals((Object)TypeToken.of(String.class), (Object)((Parameter)invokable.getParameters().get(1)).getType());
    }

    public void testEquals() throws Exception {
        new EqualsTester().addEqualityGroup(new Object[]{Prepender.constructor(new Class[0]), Prepender.constructor(new Class[0])}).addEqualityGroup(new Object[]{Prepender.constructor(String.class, Integer.TYPE)}).addEqualityGroup(new Object[]{Prepender.method("privateMethod", new Class[0]), Prepender.method("privateMethod", new Class[0])}).addEqualityGroup(new Object[]{Prepender.method("privateFinalMethod", new Class[0])}).testEquals();
    }

    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(Invokable.class);
        new NullPointerTester().testAllPublicInstanceMethods(Prepender.method("staticMethod", new Class[0]));
    }

    private static class SubPrepender
    extends Prepender {
        public SubPrepender() throws NullPointerException {
            throw new AssertionError();
        }
    }

    private static class Prepender {
        private final String prefix;
        private final int times;

        Prepender(@NotBlank String prefix, int times) throws NullPointerException {
            this.prefix = prefix;
            this.times = times;
        }

        Prepender(String ... varargs) {
            this(null, 0);
        }

        private <A> Prepender() {
            this(null, 0);
        }

        static <T> Iterable<String> prepend(@NotBlank String first, Iterable<String> tail) {
            return Iterables.concat((Iterable)ImmutableList.of((Object)first), tail);
        }

        Iterable<String> prepend(Iterable<String> tail) throws IllegalArgumentException, NullPointerException {
            return Iterables.concat(Collections.nCopies(this.times, this.prefix), tail);
        }

        static Invokable<?, Prepender> constructor(Class<?> ... parameterTypes) throws Exception {
            Constructor constructor = Prepender.class.getDeclaredConstructor(parameterTypes);
            return Invokable.from(constructor);
        }

        static Invokable<Prepender, Object> method(String name, Class<?> ... parameterTypes) {
            try {
                Method method = Prepender.class.getDeclaredMethod(name, parameterTypes);
                Invokable invokable = Invokable.from((Method)method);
                return invokable;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
        }

        private void privateMethod() {
        }

        private final void privateFinalMethod() {
        }

        static void staticMethod() {
        }

        static final void staticFinalMethod() {
        }

        private void privateVarArgsMethod(String ... varargs) {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface NotBlank {
    }

    private static class LocalClassWithSeeminglyHiddenThisInStaticInitializer {
        private LocalClassWithSeeminglyHiddenThisInStaticInitializer() {
        }

        static {
            class Local {
                Local(LocalClassWithSeeminglyHiddenThisInStaticInitializer outer) {
                }
            }
            Constructor<?> constructor = Local.class.getDeclaredConstructors()[0];
            int miscalculated = 0;
            Assert.assertEquals((int)miscalculated, (int)Invokable.from(constructor).getParameters().size());
        }
    }

    private static class LocalClassInStaticInitializer {
        private LocalClassInStaticInitializer() {
        }

        static {
            class Local {
                Local() {
                }
            }
            Constructor<?> constructor = Local.class.getDeclaredConstructors()[0];
            Assert.assertEquals((int)0, (int)Invokable.from(constructor).getParameters().size());
        }
    }

    private static class LocalClassInInstanceInitializer {
        private LocalClassInInstanceInitializer() {
            class Local {
                Local() {
                }
            }
            Constructor<?> constructor = Local.class.getDeclaredConstructors()[0];
            Assert.assertEquals((int)0, (int)Invokable.from(constructor).getParameters().size());
        }
    }

    private static class AnonymousClassInConstructor {
        AnonymousClassInConstructor() {
            boolean i = true;
            String s = "hello world";
            Class<?> anonymous = new Runnable(){

                @Override
                public void run() {
                    System.out.println("hello world1");
                }
            }.getClass();
            Constructor<?> constructor = anonymous.getDeclaredConstructors()[0];
            Assert.assertEquals((int)0, (int)Invokable.from(constructor).getParameters().size());
        }
    }

    private class InnerWithGenericConstructorParameter {
        InnerWithGenericConstructorParameter(Iterable<String> it, String s) {
        }
    }

    private class InnerWithAnnotatedConstructorParameter {
        InnerWithAnnotatedConstructorParameter(String s) {
        }
    }

    private class InnerWithOneParameterConstructor {
        public InnerWithOneParameterConstructor(String s) {
        }
    }

    private class InnerWithDefaultConstructor {
        private InnerWithDefaultConstructor() {
        }

        class NestedInner {
            NestedInner() {
            }
        }
    }

    private static final class FinalClass {
        private FinalClass() {
        }

        void notFinalMethod() {
        }
    }

    static class Foo {
        Foo() {
        }
    }

    private static class WithConstructorAndTypeParameter<T> {
        <X> WithConstructorAndTypeParameter() {
        }
    }
}

