/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.MapPutTester;
import com.google.common.reflect.ImmutableTypeToInstanceMapTest;
import com.google.common.reflect.MutableTypeToInstanceMap;
import com.google.common.reflect.TypeToInstanceMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.truth0.Truth;

public class MutableTypeToInstanceMapTest
extends TestCase {
    private TypeToInstanceMap<Object> map;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(MutableTypeToInstanceMapTest.class);
        Method remapTest = null;
        try {
            remapTest = MapPutTester.class.getMethod("testPut_replaceNullValueWithNonNullSupported", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError();
        }
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new ImmutableTypeToInstanceMapTest.TestTypeToInstanceMapGenerator(){

            public Map<TypeToken, Object> create(Object ... elements) {
                MutableTypeToInstanceMap map = new MutableTypeToInstanceMap();
                for (Object object : elements) {
                    Map.Entry entry = (Map.Entry)object;
                    map.putInstance((TypeToken)entry.getKey(), entry.getValue());
                }
                return map;
            }
        }).named("MutableTypeToInstanceMap")).withFeatures(new Feature[]{MapFeature.SUPPORTS_REMOVE, MapFeature.RESTRICTS_KEYS, MapFeature.ALLOWS_NULL_VALUES, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionSize.ANY, MapFeature.ALLOWS_ANY_NULL_QUERIES})).suppressing(new Method[]{remapTest})).createTestSuite());
        return suite;
    }

    protected void setUp() throws Exception {
        this.map = new MutableTypeToInstanceMap();
    }

    public void testPutThrows() {
        try {
            this.map.put((Object)TypeToken.of(Integer.class), (Object)new Integer(5));
            MutableTypeToInstanceMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testPutAllThrows() {
        try {
            this.map.putAll((Map)ImmutableMap.of((Object)TypeToken.of(Integer.class), (Object)new Integer(5)));
            MutableTypeToInstanceMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testEntrySetMutationThrows() {
        this.map.putInstance(String.class, (Object)"test");
        MutableTypeToInstanceMapTest.assertEquals((Object)TypeToken.of(String.class), ((Map.Entry)this.map.entrySet().iterator().next()).getKey());
        MutableTypeToInstanceMapTest.assertEquals((Object)"test", ((Map.Entry)this.map.entrySet().iterator().next()).getValue());
        try {
            ((Map.Entry)this.map.entrySet().iterator().next()).setValue(1);
            MutableTypeToInstanceMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testEntrySetToArrayMutationThrows() {
        this.map.putInstance(String.class, (Object)"test");
        Map.Entry entry = (Map.Entry)this.map.entrySet().toArray()[0];
        MutableTypeToInstanceMapTest.assertEquals((Object)TypeToken.of(String.class), entry.getKey());
        MutableTypeToInstanceMapTest.assertEquals((Object)"test", entry.getValue());
        try {
            entry.setValue(1);
            MutableTypeToInstanceMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testEntrySetToTypedArrayMutationThrows() {
        this.map.putInstance(String.class, (Object)"test");
        Map.Entry entry = this.map.entrySet().toArray(new Map.Entry[0])[0];
        MutableTypeToInstanceMapTest.assertEquals((Object)TypeToken.of(String.class), entry.getKey());
        MutableTypeToInstanceMapTest.assertEquals((Object)"test", entry.getValue());
        try {
            entry.setValue(1);
            MutableTypeToInstanceMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testPutAndGetInstance() {
        MutableTypeToInstanceMapTest.assertNull((Object)this.map.putInstance(Integer.class, (Object)new Integer(5)));
        Integer oldValue = (Integer)this.map.putInstance(Integer.class, (Object)new Integer(7));
        MutableTypeToInstanceMapTest.assertEquals((int)5, (int)oldValue);
        Integer newValue = (Integer)this.map.getInstance(Integer.class);
        MutableTypeToInstanceMapTest.assertEquals((int)7, (int)newValue);
        MutableTypeToInstanceMapTest.assertEquals((int)7, (int)((Integer)this.map.getInstance(TypeToken.of(Integer.class))));
    }

    public void testNull() {
        try {
            this.map.putInstance((TypeToken)null, (Object)new Integer(1));
            MutableTypeToInstanceMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.map.putInstance(Integer.class, null);
        MutableTypeToInstanceMapTest.assertNull((Object)this.map.get(Integer.class));
        MutableTypeToInstanceMapTest.assertNull((Object)this.map.getInstance(Integer.class));
        this.map.putInstance(Long.class, null);
        MutableTypeToInstanceMapTest.assertNull((Object)this.map.get(Long.class));
        MutableTypeToInstanceMapTest.assertNull((Object)this.map.getInstance(Long.class));
    }

    public void testPrimitiveAndWrapper() {
        MutableTypeToInstanceMapTest.assertNull((Object)this.map.getInstance(Integer.TYPE));
        MutableTypeToInstanceMapTest.assertNull((Object)this.map.getInstance(Integer.class));
        MutableTypeToInstanceMapTest.assertNull((Object)this.map.putInstance(Integer.TYPE, (Object)0));
        MutableTypeToInstanceMapTest.assertNull((Object)this.map.putInstance(Integer.class, (Object)1));
        MutableTypeToInstanceMapTest.assertEquals((int)2, (int)this.map.size());
        MutableTypeToInstanceMapTest.assertEquals((int)0, (int)((Integer)this.map.getInstance(Integer.TYPE)));
        MutableTypeToInstanceMapTest.assertEquals((int)1, (int)((Integer)this.map.getInstance(Integer.class)));
        MutableTypeToInstanceMapTest.assertEquals((int)0, (int)((Integer)this.map.putInstance(Integer.TYPE, null)));
        MutableTypeToInstanceMapTest.assertEquals((int)1, (int)((Integer)this.map.putInstance(Integer.class, null)));
        MutableTypeToInstanceMapTest.assertNull((Object)this.map.getInstance(Integer.TYPE));
        MutableTypeToInstanceMapTest.assertNull((Object)this.map.getInstance(Integer.class));
        MutableTypeToInstanceMapTest.assertEquals((int)2, (int)this.map.size());
    }

    public void testParameterizedType() {
        TypeToken<ImmutableList<Integer>> type = new TypeToken<ImmutableList<Integer>>(){};
        this.map.putInstance((TypeToken)type, (Object)ImmutableList.of((Object)1));
        MutableTypeToInstanceMapTest.assertEquals((int)1, (int)this.map.size());
        MutableTypeToInstanceMapTest.assertEquals((Object)ImmutableList.of((Object)1), (Object)this.map.getInstance((TypeToken)type));
    }

    public void testGeneriArrayType() {
        ImmutableList[] array = new ImmutableList[]{ImmutableList.of((Object)1)};
        TypeToken<ImmutableList<Integer>[]> type = new TypeToken<ImmutableList<Integer>[]>(){};
        this.map.putInstance((TypeToken)type, (Object)array);
        MutableTypeToInstanceMapTest.assertEquals((int)1, (int)this.map.size());
        Truth.ASSERT.that((Object[])this.map.getInstance((TypeToken)type)).has().exactly((Object)array[0]).inOrder();
    }

    public void testWildcardType() {
        TypeToken type = new TypeToken<ImmutableList<?>>(){};
        this.map.putInstance(type, (Object)ImmutableList.of((Object)1));
        MutableTypeToInstanceMapTest.assertEquals((int)1, (int)this.map.size());
        MutableTypeToInstanceMapTest.assertEquals((Object)ImmutableList.of((Object)1), (Object)this.map.getInstance(type));
    }

    public void testGetInstance_withTypeVariable() {
        try {
            this.map.getInstance(this.anyIterableType());
            MutableTypeToInstanceMapTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPutInstance_withTypeVariable() {
        try {
            this.map.putInstance(this.anyIterableType(), (Object)ImmutableList.of((Object)1));
            MutableTypeToInstanceMapTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private <T> TypeToken<Iterable<T>> anyIterableType() {
        return new TypeToken<Iterable<T>>(){};
    }
}

