/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.TypeResolver;
import com.google.common.reflect.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class TypeResolverTest
extends TestCase {
    public void testWhere_noMapping() {
        Type t = TypeResolverTest.aTypeVariable();
        TypeResolverTest.assertEquals((Object)t, (Object)new TypeResolver().resolveType(t));
    }

    public void testWhere_typeVariableMapping() {
        Type t = TypeResolverTest.aTypeVariable();
        TypeResolverTest.assertEquals(String.class, (Object)new TypeResolver().where(t, String.class).resolveType(t));
    }

    public <T> void testWhere_indirectMapping() {
        Type t1 = new TypeCapture<T>(){}.capture();
        Type t2 = TypeResolverTest.aTypeVariable();
        TypeResolverTest.assertEquals(String.class, (Object)new TypeResolver().where(t1, t2).where(t2, String.class).resolveType(t1));
    }

    public void testWhere_typeVariableSelfMapping() {
        TypeResolver resolver = new TypeResolver();
        Type t = TypeResolverTest.aTypeVariable();
        TypeResolverTest.assertEquals((Object)t, (Object)resolver.where(t, t).resolveType(t));
    }

    public <T> void testWhere_parameterizedSelfMapping() {
        TypeResolver resolver = new TypeResolver();
        Type t = new TypeCapture<List<T>>(){}.capture();
        TypeResolverTest.assertEquals((Object)t, (Object)resolver.where(t, t).resolveType(t));
    }

    public <T> void testWhere_genericArraySelfMapping() {
        TypeResolver resolver = new TypeResolver();
        Type t = new TypeCapture<T[]>(){}.capture();
        TypeResolverTest.assertEquals((Object)t, (Object)resolver.where(t, t).resolveType(t));
    }

    public <T> void testWhere_rawClassSelfMapping() {
        TypeResolver resolver = new TypeResolver();
        TypeResolverTest.assertEquals(String.class, (Object)resolver.where(String.class, String.class).resolveType(String.class));
    }

    public <T> void testWhere_wildcardSelfMapping() {
        TypeResolver resolver = new TypeResolver();
        Type t = TypeResolverTest.aWildcardType();
        TypeResolverTest.assertEquals((Object)t, (Object)resolver.where(t, t).resolveType(t));
    }

    public <T> void testWhere_duplicateMapping() {
        Type t = TypeResolverTest.aTypeVariable();
        TypeResolver resolver = new TypeResolver().where(t, String.class);
        try {
            resolver.where(t, String.class);
            TypeResolverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public <T1, T2 extends List<T1>> void testWhere_recursiveMapping() {
        Type t1 = new TypeCapture<T1>(){}.capture();
        Type t2 = new TypeCapture<T2>(){}.capture();
        TypeResolverTest.assertEquals((Object)t2, (Object)new TypeResolver().where(t1, t2).resolveType(t1));
    }

    public <T> void testWhere_genericArrayMapping() {
        Type t = new TypeCapture<T>(){}.capture();
        TypeResolverTest.assertEquals(String.class, (Object)new TypeResolver().where(new TypeCapture<T[]>(){}.capture(), String[].class).resolveType(t));
    }

    public <T> void testWhere_primitiveArrayMapping() {
        Type t = new TypeCapture<T>(){}.capture();
        TypeResolverTest.assertEquals(Integer.TYPE, (Object)new TypeResolver().where(new TypeCapture<T[]>(){}.capture(), int[].class).resolveType(t));
    }

    public <T> void testWhere_parameterizedTypeMapping() {
        Type t = new TypeCapture<T>(){}.capture();
        TypeResolverTest.assertEquals(String.class, (Object)new TypeResolver().where(new TypeCapture<List<T>>(){}.capture(), new TypeCapture<List<String>>(){}.capture()).resolveType(t));
        TypeResolverTest.assertEquals((Object)Types.subtypeOf(String.class), (Object)new TypeResolver().where(new TypeCapture<List<T>>(){}.capture(), new TypeCapture<List<? extends String>>(){}.capture()).resolveType(t));
        TypeResolverTest.assertEquals((Object)Types.supertypeOf(String.class), (Object)new TypeResolver().where(new TypeCapture<List<T>>(){}.capture(), new TypeCapture<List<? super String>>(){}.capture()).resolveType(t));
    }

    public <T> void testWhere_wildcardTypeMapping() {
        Type t = new TypeCapture<T>(){}.capture();
        TypeResolverTest.assertEquals(String.class, (Object)new TypeResolver().where(new TypeCapture<List<? extends T>>(){}.capture(), new TypeCapture<List<? extends String>>(){}.capture()).resolveType(t));
        TypeResolverTest.assertEquals(String.class, (Object)new TypeResolver().where(new TypeCapture<List<? super T>>(){}.capture(), new TypeCapture<List<? super String>>(){}.capture()).resolveType(t));
    }

    public <T> void testWhere_incompatibleGenericArrayMapping() {
        try {
            new TypeResolver().where(new TypeCapture<T[]>(){}.capture(), String.class);
            TypeResolverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public <T> void testWhere_incompatibleParameterizedTypeMapping() {
        try {
            new TypeResolver().where(new TypeCapture<Iterable<T>>(){}.capture(), List.class);
            TypeResolverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public <T> void testWhere_impossibleParameterizedTypeMapping() {
        try {
            new TypeResolver().where(new TypeCapture<List<T>>(){}.capture(), new TypeCapture<Map<String, Integer>>(){}.capture());
            TypeResolverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public <T> void testWhere_incompatibleWildcardUpperBound() {
        try {
            new TypeResolver().where(new TypeCapture<List<? extends String>>(){}.capture(), new TypeCapture<List<? extends Integer>>(){}.capture());
            TypeResolverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public <T> void testWhere_incompatibleWildcardLowerBound() {
        try {
            new TypeResolver().where(new TypeCapture<List<? super String>>(){}.capture(), new TypeCapture<List<? super Integer>>(){}.capture());
            TypeResolverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public <T> void testWhere_incompatibleWildcardBounds() {
        try {
            new TypeResolver().where(new TypeCapture<List<? extends T>>(){}.capture(), new TypeCapture<List<? super String>>(){}.capture());
            TypeResolverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public <T> void testWhere_wrongOrder() {
        try {
            new TypeResolver().where(String.class, TypeResolverTest.aTypeVariable());
            TypeResolverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public <T> void testWhere_mapFromConcreteParameterizedType() {
        try {
            new TypeResolver().where(new TypeCapture<List<String>>(){}.capture(), TypeResolverTest.aTypeVariable());
            TypeResolverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public <T> void testWhere_mapFromConcreteGenericArrayType() {
        try {
            new TypeResolver().where(new TypeCapture<List<String>>(){}.capture(), TypeResolverTest.aTypeVariable());
            TypeResolverTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static <T> Type aTypeVariable() {
        return new TypeCapture<T>(){}.capture();
    }

    private static <T> Type aWildcardType() {
        ParameterizedType parameterizedType = (ParameterizedType)new TypeCapture<List<? extends T>>(){}.capture();
        return parameterizedType.getActualTypeArguments()[0];
    }
}

