/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.AbstractFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.truth0.Truth;

public class AbstractFutureTest
extends TestCase {
    public void testSuccess() throws ExecutionException, InterruptedException {
        final Object value = new Object();
        AbstractFutureTest.assertSame((Object)value, (Object)new AbstractFuture<Object>(){
            {
                this.set(value);
            }
        }.get());
    }

    public void testException() throws InterruptedException {
        final Throwable failure = new Throwable();
        AbstractFuture<String> future = new AbstractFuture<String>(){
            {
                this.setException(failure);
            }
        };
        ExecutionException ee1 = this.getExpectingExecutionException(future);
        ExecutionException ee2 = this.getExpectingExecutionException(future);
        AbstractFutureTest.assertNotSame((Object)ee1, (Object)ee2);
        AbstractFutureTest.assertSame((Object)failure, (Object)ee1.getCause());
        AbstractFutureTest.assertSame((Object)failure, (Object)ee2.getCause());
        this.checkStackTrace(ee1);
        this.checkStackTrace(ee2);
    }

    public void testCancel_notDoneNoInterrupt() throws Exception {
        InterruptibleFuture future = new InterruptibleFuture();
        AbstractFutureTest.assertTrue((boolean)future.cancel(false));
        AbstractFutureTest.assertTrue((boolean)future.isCancelled());
        AbstractFutureTest.assertTrue((boolean)future.isDone());
        AbstractFutureTest.assertFalse((boolean)future.wasInterrupted());
        AbstractFutureTest.assertFalse((boolean)future.interruptTaskWasCalled);
        try {
            future.get();
            AbstractFutureTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException e) {
            AbstractFutureTest.assertNotNull((Object)e.getCause());
        }
    }

    public void testCancel_notDoneInterrupt() throws Exception {
        InterruptibleFuture future = new InterruptibleFuture();
        AbstractFutureTest.assertTrue((boolean)future.cancel(true));
        AbstractFutureTest.assertTrue((boolean)future.isCancelled());
        AbstractFutureTest.assertTrue((boolean)future.isDone());
        AbstractFutureTest.assertTrue((boolean)future.wasInterrupted());
        AbstractFutureTest.assertTrue((boolean)future.interruptTaskWasCalled);
        try {
            future.get();
            AbstractFutureTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException e) {
            AbstractFutureTest.assertNotNull((Object)e.getCause());
        }
    }

    public void testCancel_done() throws Exception {
        AbstractFuture<String> future = new AbstractFuture<String>(){
            {
                this.set("foo");
            }
        };
        AbstractFutureTest.assertFalse((boolean)future.cancel(true));
        AbstractFutureTest.assertFalse((boolean)future.isCancelled());
        AbstractFutureTest.assertTrue((boolean)future.isDone());
    }

    public void testCompletionFinishesWithDone() {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 50000; ++i) {
            AbstractFuture<String> future = new AbstractFuture<String>(){};
            AtomicReference errorMessage = new AtomicReference();
            executor.execute(new Runnable((AbstractFuture)future, errorMessage){
                final /* synthetic */ AbstractFuture val$future;
                final /* synthetic */ AtomicReference val$errorMessage;
                {
                    this.val$future = abstractFuture;
                    this.val$errorMessage = atomicReference;
                }

                @Override
                public void run() {
                    this.val$future.set((Object)"success");
                    if (!this.val$future.isDone()) {
                        this.val$errorMessage.set("Set call exited before future was complete.");
                    }
                }
            });
            executor.execute(new Runnable((AbstractFuture)future, errorMessage){
                final /* synthetic */ AbstractFuture val$future;
                final /* synthetic */ AtomicReference val$errorMessage;
                {
                    this.val$future = abstractFuture;
                    this.val$errorMessage = atomicReference;
                }

                @Override
                public void run() {
                    this.val$future.setException((Throwable)new IllegalArgumentException("failure"));
                    if (!this.val$future.isDone()) {
                        this.val$errorMessage.set("SetException call exited before future was complete.");
                    }
                }
            });
            executor.execute(new Runnable((AbstractFuture)future, errorMessage){
                final /* synthetic */ AbstractFuture val$future;
                final /* synthetic */ AtomicReference val$errorMessage;
                {
                    this.val$future = abstractFuture;
                    this.val$errorMessage = atomicReference;
                }

                @Override
                public void run() {
                    this.val$future.cancel(true);
                    if (!this.val$future.isDone()) {
                        this.val$errorMessage.set("Cancel call exited before future was complete.");
                    }
                }
            });
            try {
                future.get();
            }
            catch (Throwable t) {
                // empty catch block
            }
            String error = (String)errorMessage.get();
            AbstractFutureTest.assertNull((String)error, (Object)error);
        }
        executor.shutdown();
    }

    private void checkStackTrace(ExecutionException e) {
        int index = AbstractFutureTest.findStackFrame(e, ((Object)((Object)this)).getClass().getName(), "getExpectingExecutionException");
        Truth.ASSERT.that(Integer.valueOf(index)).isNotEqualTo(Integer.valueOf(0));
        Truth.ASSERT.that(e.getStackTrace()[index - 1].getMethodName()).isEqualTo((Object)"get");
    }

    private static int findStackFrame(ExecutionException e, String clazz, String method) {
        StackTraceElement[] elements = e.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            if (!element.getClassName().equals(clazz) || !element.getMethodName().equals(method)) continue;
            return i;
        }
        AssertionFailedError failure = new AssertionFailedError("Expected element " + clazz + "." + method + " not found in stack trace");
        failure.initCause((Throwable)e);
        throw failure;
    }

    private ExecutionException getExpectingExecutionException(AbstractFuture<String> future) throws InterruptedException {
        try {
            String got = (String)future.get();
            AbstractFutureTest.fail((String)("Expected exception but got " + got));
        }
        catch (ExecutionException e) {
            return e;
        }
        return null;
    }

    private static final class InterruptibleFuture
    extends AbstractFuture<String> {
        boolean interruptTaskWasCalled;

        private InterruptibleFuture() {
        }

        protected void interruptTask() {
            Assert.assertFalse((boolean)this.interruptTaskWasCalled);
            this.interruptTaskWasCalled = true;
        }
    }
}

