/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.truth0.Truth;

public class AbstractIdleServiceTest
extends TestCase {
    public void testStart() {
        TestService service = new TestService();
        AbstractIdleServiceTest.assertEquals((int)0, (int)service.startUpCalled);
        service.startAsync().awaitRunning();
        AbstractIdleServiceTest.assertEquals((int)1, (int)service.startUpCalled);
        AbstractIdleServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        Truth.ASSERT.that(service.transitionStates).has().exactly((Object)Service.State.STARTING).inOrder();
    }

    public void testStart_failed() {
        final Exception exception = new Exception("deliberate");
        TestService service = new TestService(){

            @Override
            protected void startUp() throws Exception {
                super.startUp();
                throw exception;
            }
        };
        AbstractIdleServiceTest.assertEquals((int)0, (int)service.startUpCalled);
        try {
            service.startAsync().awaitRunning();
            AbstractIdleServiceTest.fail();
        }
        catch (RuntimeException e) {
            AbstractIdleServiceTest.assertSame((Object)exception, (Object)e.getCause());
        }
        AbstractIdleServiceTest.assertEquals((int)1, (int)service.startUpCalled);
        AbstractIdleServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
        Truth.ASSERT.that(service.transitionStates).has().exactly((Object)Service.State.STARTING).inOrder();
    }

    public void testStop_withoutStart() {
        TestService service = new TestService();
        service.stopAsync().awaitTerminated();
        AbstractIdleServiceTest.assertEquals((int)0, (int)service.startUpCalled);
        AbstractIdleServiceTest.assertEquals((int)0, (int)service.shutDownCalled);
        AbstractIdleServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        Truth.ASSERT.that(service.transitionStates).isEmpty();
    }

    public void testStop_afterStart() {
        TestService service = new TestService();
        service.startAsync().awaitRunning();
        AbstractIdleServiceTest.assertEquals((int)1, (int)service.startUpCalled);
        AbstractIdleServiceTest.assertEquals((int)0, (int)service.shutDownCalled);
        service.stopAsync().awaitTerminated();
        AbstractIdleServiceTest.assertEquals((int)1, (int)service.startUpCalled);
        AbstractIdleServiceTest.assertEquals((int)1, (int)service.shutDownCalled);
        AbstractIdleServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        Truth.ASSERT.that(service.transitionStates).has().exactly((Object)Service.State.STARTING, (Object)Service.State.STOPPING, (Object[])new Service.State[0]).inOrder();
    }

    public void testStop_failed() {
        final Exception exception = new Exception("deliberate");
        TestService service = new TestService(){

            @Override
            protected void shutDown() throws Exception {
                super.shutDown();
                throw exception;
            }
        };
        service.startAsync().awaitRunning();
        AbstractIdleServiceTest.assertEquals((int)1, (int)service.startUpCalled);
        AbstractIdleServiceTest.assertEquals((int)0, (int)service.shutDownCalled);
        try {
            service.stopAsync().awaitTerminated();
            AbstractIdleServiceTest.fail();
        }
        catch (RuntimeException e) {
            AbstractIdleServiceTest.assertSame((Object)exception, (Object)e.getCause());
        }
        AbstractIdleServiceTest.assertEquals((int)1, (int)service.startUpCalled);
        AbstractIdleServiceTest.assertEquals((int)1, (int)service.shutDownCalled);
        AbstractIdleServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
        Truth.ASSERT.that(service.transitionStates).has().exactly((Object)Service.State.STARTING, (Object)Service.State.STOPPING, (Object[])new Service.State[0]).inOrder();
    }

    public void testServiceToString() {
        TestService service = new TestService();
        AbstractIdleServiceTest.assertEquals((String)"TestService [NEW]", (String)service.toString());
        service.startAsync().awaitRunning();
        AbstractIdleServiceTest.assertEquals((String)"TestService [RUNNING]", (String)service.toString());
        service.stopAsync().awaitTerminated();
        AbstractIdleServiceTest.assertEquals((String)"TestService [TERMINATED]", (String)service.toString());
    }

    public void testTimeout() throws Exception {
        TestService service = new TestService(){

            @Override
            protected Executor executor() {
                return new Executor(){

                    @Override
                    public void execute(Runnable command) {
                    }
                };
            }
        };
        try {
            service.startAsync().awaitRunning(1L, TimeUnit.MILLISECONDS);
            AbstractIdleServiceTest.fail((String)"Expected timeout");
        }
        catch (TimeoutException e) {
            Truth.ASSERT.that(e.getMessage()).contains(Service.State.STARTING.toString());
        }
    }

    private static class TestService
    extends AbstractIdleService {
        int startUpCalled = 0;
        int shutDownCalled = 0;
        final List<Service.State> transitionStates = Lists.newArrayList();

        private TestService() {
        }

        protected void startUp() throws Exception {
            Assert.assertEquals((int)0, (int)this.startUpCalled);
            Assert.assertEquals((int)0, (int)this.shutDownCalled);
            ++this.startUpCalled;
            Assert.assertEquals((Object)Service.State.STARTING, (Object)this.state());
        }

        protected void shutDown() throws Exception {
            Assert.assertEquals((int)1, (int)this.startUpCalled);
            Assert.assertEquals((int)0, (int)this.shutDownCalled);
            ++this.shutDownCalled;
            Assert.assertEquals((Object)Service.State.STOPPING, (Object)this.state());
        }

        protected Executor executor() {
            this.transitionStates.add(this.state());
            return MoreExecutors.sameThreadExecutor();
        }
    }

    public static class FunctionalTest
    extends TestCase {
        public void testServiceStartStop() throws Exception {
            DefaultService service = new DefaultService();
            service.startAsync().awaitRunning();
            FunctionalTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
            service.stopAsync().awaitTerminated();
            FunctionalTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        }

        public void testStart_failed() throws Exception {
            final Exception exception = new Exception("deliberate");
            DefaultService service = new DefaultService(){

                @Override
                protected void startUp() throws Exception {
                    throw exception;
                }
            };
            try {
                service.startAsync().awaitRunning();
                FunctionalTest.fail();
            }
            catch (RuntimeException e) {
                FunctionalTest.assertSame((Object)exception, (Object)e.getCause());
            }
            FunctionalTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
        }

        public void testStop_failed() throws Exception {
            final Exception exception = new Exception("deliberate");
            DefaultService service = new DefaultService(){

                @Override
                protected void shutDown() throws Exception {
                    throw exception;
                }
            };
            service.startAsync().awaitRunning();
            try {
                service.stopAsync().awaitTerminated();
                FunctionalTest.fail();
            }
            catch (RuntimeException e) {
                FunctionalTest.assertSame((Object)exception, (Object)e.getCause());
            }
            FunctionalTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
        }

        private static class DefaultService
        extends AbstractIdleService {
            private DefaultService() {
            }

            protected void startUp() throws Exception {
            }

            protected void shutDown() throws Exception {
            }
        }
    }
}

