/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.testing.NullPointerTester;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;

public class ExecutionListTest
extends TestCase {
    private final ExecutionList list = new ExecutionList();
    private static final Runnable THROWING_RUNNABLE = new Runnable(){

        @Override
        public void run() {
            throw new RuntimeException();
        }
    };

    public void testRunOnPopulatedList() throws Exception {
        ExecutorService exec = Executors.newCachedThreadPool();
        CountDownLatch countDownLatch = new CountDownLatch(3);
        this.list.add((Runnable)new MockRunnable(countDownLatch), (Executor)exec);
        this.list.add((Runnable)new MockRunnable(countDownLatch), (Executor)exec);
        this.list.add((Runnable)new MockRunnable(countDownLatch), (Executor)exec);
        ExecutionListTest.assertEquals((long)countDownLatch.getCount(), (long)3L);
        this.list.execute();
        ExecutionListTest.assertTrue((boolean)countDownLatch.await(1L, TimeUnit.SECONDS));
    }

    public void testExecute_idempotent() {
        final AtomicInteger runCalled = new AtomicInteger();
        this.list.add(new Runnable(){

            @Override
            public void run() {
                runCalled.getAndIncrement();
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        this.list.execute();
        ExecutionListTest.assertEquals((int)1, (int)runCalled.get());
        this.list.execute();
        ExecutionListTest.assertEquals((int)1, (int)runCalled.get());
    }

    public void testExecute_idempotentConcurrently() throws InterruptedException {
        final CountDownLatch okayToRun = new CountDownLatch(1);
        final AtomicInteger runCalled = new AtomicInteger();
        this.list.add(new Runnable(){

            @Override
            public void run() {
                try {
                    okayToRun.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                runCalled.getAndIncrement();
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        Runnable execute = new Runnable(){

            @Override
            public void run() {
                ExecutionListTest.this.list.execute();
            }
        };
        Thread thread1 = new Thread(execute);
        Thread thread2 = new Thread(execute);
        thread1.start();
        thread2.start();
        ExecutionListTest.assertEquals((int)0, (int)runCalled.get());
        okayToRun.countDown();
        thread1.join();
        thread2.join();
        ExecutionListTest.assertEquals((int)1, (int)runCalled.get());
    }

    public void testAddAfterRun() throws Exception {
        this.testRunOnPopulatedList();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.list.add((Runnable)new MockRunnable(countDownLatch), (Executor)Executors.newCachedThreadPool());
        ExecutionListTest.assertTrue((boolean)countDownLatch.await(1L, TimeUnit.SECONDS));
    }

    public void testOrdering() throws Exception {
        final AtomicInteger integer = new AtomicInteger();
        int i = 0;
        while (i < 10) {
            final int expectedCount = i++;
            this.list.add(new Runnable(){

                @Override
                public void run() {
                    integer.compareAndSet(expectedCount, expectedCount + 1);
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
        }
        this.list.execute();
        ExecutionListTest.assertEquals((int)10, (int)integer.get());
    }

    public void testExceptionsCaught() {
        this.list.add(THROWING_RUNNABLE, (Executor)MoreExecutors.sameThreadExecutor());
        this.list.execute();
        this.list.add(THROWING_RUNNABLE, (Executor)MoreExecutors.sameThreadExecutor());
    }

    public void testNulls() {
        new NullPointerTester().testAllPublicInstanceMethods((Object)new ExecutionList());
    }

    private class MockRunnable
    implements Runnable {
        CountDownLatch countDownLatch;

        MockRunnable(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            this.countDownLatch.countDown();
        }
    }
}

