/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class ListenableFutureTaskTest
extends TestCase {
    private ExecutorService exec;
    protected final CountDownLatch runLatch = new CountDownLatch(1);
    protected final CountDownLatch taskLatch = new CountDownLatch(1);
    protected final CountDownLatch listenerLatch = new CountDownLatch(1);
    protected volatile boolean throwException = false;
    protected final ListenableFutureTask<Integer> task = ListenableFutureTask.create((Callable)new Callable<Integer>(){

        @Override
        public Integer call() throws Exception {
            ListenableFutureTaskTest.this.runLatch.countDown();
            ListenableFutureTaskTest.this.taskLatch.await();
            if (ListenableFutureTaskTest.this.throwException) {
                throw new IllegalStateException("Fail");
            }
            return 25;
        }
    });

    protected void setUp() throws Exception {
        super.setUp();
        this.exec = Executors.newCachedThreadPool();
        this.task.addListener(new Runnable(){

            @Override
            public void run() {
                ListenableFutureTaskTest.this.listenerLatch.countDown();
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }

    protected void tearDown() throws Exception {
        if (this.exec != null) {
            this.exec.shutdown();
        }
        super.tearDown();
    }

    public void testListenerDoesNotRunUntilTaskCompletes() throws Exception {
        ListenableFutureTaskTest.assertEquals((long)1L, (long)this.listenerLatch.getCount());
        ListenableFutureTaskTest.assertFalse((boolean)this.task.isDone());
        ListenableFutureTaskTest.assertFalse((boolean)this.task.isCancelled());
        this.exec.execute((Runnable)this.task);
        this.runLatch.await();
        ListenableFutureTaskTest.assertEquals((long)1L, (long)this.listenerLatch.getCount());
        ListenableFutureTaskTest.assertFalse((boolean)this.task.isDone());
        ListenableFutureTaskTest.assertFalse((boolean)this.task.isCancelled());
        this.taskLatch.countDown();
        ListenableFutureTaskTest.assertEquals((int)25, (int)((Integer)this.task.get()));
        ListenableFutureTaskTest.assertTrue((boolean)this.listenerLatch.await(5L, TimeUnit.SECONDS));
        ListenableFutureTaskTest.assertTrue((boolean)this.task.isDone());
        ListenableFutureTaskTest.assertFalse((boolean)this.task.isCancelled());
    }

    public void testListenerCalledOnException() throws Exception {
        this.throwException = true;
        this.exec.execute((Runnable)this.task);
        this.runLatch.await();
        this.taskLatch.countDown();
        try {
            this.task.get(5L, TimeUnit.SECONDS);
            ListenableFutureTaskTest.fail((String)"Should have propagated the failure.");
        }
        catch (ExecutionException e) {
            ListenableFutureTaskTest.assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
        ListenableFutureTaskTest.assertTrue((boolean)this.listenerLatch.await(5L, TimeUnit.SECONDS));
        ListenableFutureTaskTest.assertTrue((boolean)this.task.isDone());
        ListenableFutureTaskTest.assertFalse((boolean)this.task.isCancelled());
    }

    public void testListenerCalledOnCancelFromNotRunning() throws Exception {
        this.task.cancel(false);
        ListenableFutureTaskTest.assertTrue((boolean)this.task.isDone());
        ListenableFutureTaskTest.assertTrue((boolean)this.task.isCancelled());
        ListenableFutureTaskTest.assertEquals((long)1L, (long)this.runLatch.getCount());
        this.listenerLatch.await(5L, TimeUnit.SECONDS);
        ListenableFutureTaskTest.assertTrue((boolean)this.task.isDone());
        ListenableFutureTaskTest.assertTrue((boolean)this.task.isCancelled());
        ListenableFutureTaskTest.assertEquals((long)1L, (long)this.runLatch.getCount());
    }

    public void testListenerCalledOnCancelFromRunning() throws Exception {
        this.exec.execute((Runnable)this.task);
        this.runLatch.await();
        this.task.cancel(true);
        ListenableFutureTaskTest.assertTrue((boolean)this.task.isDone());
        ListenableFutureTaskTest.assertTrue((boolean)this.task.isCancelled());
        ListenableFutureTaskTest.assertEquals((long)1L, (long)this.taskLatch.getCount());
        this.listenerLatch.await(5L, TimeUnit.SECONDS);
        ListenableFutureTaskTest.assertTrue((boolean)this.task.isDone());
        ListenableFutureTaskTest.assertTrue((boolean)this.task.isCancelled());
        ListenableFutureTaskTest.assertEquals((long)1L, (long)this.taskLatch.getCount());
    }
}

