/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.Service;
import junit.framework.TestCase;

public class ServiceTest
extends TestCase {
    public void testStateOrdering() {
        ServiceTest.assertLessThan(Service.State.NEW, Service.State.STARTING);
        ServiceTest.assertLessThan(Service.State.NEW, Service.State.TERMINATED);
        ServiceTest.assertLessThan(Service.State.STARTING, Service.State.RUNNING);
        ServiceTest.assertLessThan(Service.State.STARTING, Service.State.STOPPING);
        ServiceTest.assertLessThan(Service.State.STARTING, Service.State.FAILED);
        ServiceTest.assertLessThan(Service.State.RUNNING, Service.State.STOPPING);
        ServiceTest.assertLessThan(Service.State.RUNNING, Service.State.FAILED);
        ServiceTest.assertLessThan(Service.State.STOPPING, Service.State.FAILED);
        ServiceTest.assertLessThan(Service.State.STOPPING, Service.State.TERMINATED);
    }

    private static <T extends Comparable<? super T>> void assertLessThan(T a, T b) {
        if (a.compareTo(b) >= 0) {
            ServiceTest.fail((String)String.format("Expected %s to be less than %s", a, b));
        }
    }
}

