/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.testing.NullPointerTester;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import junit.framework.TestCase;
import org.truth0.Truth;

public class ThreadFactoryBuilderTest
extends TestCase {
    private final Runnable monitoredRunnable = new Runnable(){

        @Override
        public void run() {
            ThreadFactoryBuilderTest.this.completed = true;
        }
    };
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
        }
    };
    private ThreadFactoryBuilder builder;
    private volatile boolean completed = false;

    public void setUp() {
        this.builder = new ThreadFactoryBuilder();
    }

    public void testThreadFactoryBuilder_defaults() throws InterruptedException {
        ThreadFactory threadFactory = this.builder.build();
        Thread thread = threadFactory.newThread(this.monitoredRunnable);
        ThreadFactoryBuilderTest.checkThreadPoolName(thread, 1);
        Thread defaultThread = Executors.defaultThreadFactory().newThread(this.monitoredRunnable);
        ThreadFactoryBuilderTest.assertEquals((boolean)defaultThread.isDaemon(), (boolean)thread.isDaemon());
        ThreadFactoryBuilderTest.assertEquals((int)defaultThread.getPriority(), (int)thread.getPriority());
        ThreadFactoryBuilderTest.assertSame((Object)defaultThread.getThreadGroup(), (Object)thread.getThreadGroup());
        ThreadFactoryBuilderTest.assertSame((Object)defaultThread.getUncaughtExceptionHandler(), (Object)thread.getUncaughtExceptionHandler());
        ThreadFactoryBuilderTest.assertFalse((boolean)this.completed);
        thread.start();
        thread.join();
        ThreadFactoryBuilderTest.assertTrue((boolean)this.completed);
        Thread thread2 = threadFactory.newThread(this.monitoredRunnable);
        ThreadFactoryBuilderTest.checkThreadPoolName(thread2, 2);
        ThreadFactoryBuilderTest.assertEquals((String)thread.getName().substring(0, thread.getName().lastIndexOf(45)), (String)thread2.getName().substring(0, thread.getName().lastIndexOf(45)));
        ThreadFactory threadFactory2 = this.builder.build();
        Thread thread3 = threadFactory2.newThread(this.monitoredRunnable);
        ThreadFactoryBuilderTest.checkThreadPoolName(thread3, 1);
        Truth.ASSERT.that(thread2.getName().substring(0, thread.getName().lastIndexOf(45))).isNotEqualTo((Object)thread3.getName().substring(0, thread.getName().lastIndexOf(45)));
    }

    private static void checkThreadPoolName(Thread thread, int threadId) {
        ThreadFactoryBuilderTest.assertTrue((boolean)thread.getName().matches("^pool-\\d+-thread-" + threadId + "$"));
    }

    public void testNameFormatWithPercentS_custom() {
        String format = "super-duper-thread-%s";
        ThreadFactory factory = this.builder.setNameFormat(format).build();
        for (int i = 0; i < 11; ++i) {
            ThreadFactoryBuilderTest.assertEquals((String)String.format(format, i), (String)factory.newThread(this.monitoredRunnable).getName());
        }
    }

    public void testNameFormatWithPercentD_custom() {
        String format = "super-duper-thread-%d";
        ThreadFactory factory = this.builder.setNameFormat(format).build();
        for (int i = 0; i < 11; ++i) {
            ThreadFactoryBuilderTest.assertEquals((String)String.format(format, i), (String)factory.newThread(this.monitoredRunnable).getName());
        }
    }

    public void testDaemon_false() {
        ThreadFactory factory = this.builder.setDaemon(false).build();
        Thread thread = factory.newThread(this.monitoredRunnable);
        ThreadFactoryBuilderTest.assertFalse((boolean)thread.isDaemon());
    }

    public void testDaemon_true() {
        ThreadFactory factory = this.builder.setDaemon(true).build();
        Thread thread = factory.newThread(this.monitoredRunnable);
        ThreadFactoryBuilderTest.assertTrue((boolean)thread.isDaemon());
    }

    public void testPriority_custom() {
        for (int i = 1; i <= 10; ++i) {
            ThreadFactory factory = this.builder.setPriority(i).build();
            Thread thread = factory.newThread(this.monitoredRunnable);
            ThreadFactoryBuilderTest.assertEquals((int)i, (int)thread.getPriority());
        }
    }

    public void testPriority_tooLow() {
        try {
            this.builder.setPriority(0);
            ThreadFactoryBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPriority_tooHigh() {
        try {
            this.builder.setPriority(11);
            ThreadFactoryBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUncaughtExceptionHandler_custom() {
        ThreadFactoryBuilderTest.assertEquals((Object)UNCAUGHT_EXCEPTION_HANDLER, (Object)this.builder.setUncaughtExceptionHandler(UNCAUGHT_EXCEPTION_HANDLER).build().newThread(this.monitoredRunnable).getUncaughtExceptionHandler());
    }

    public void testBuildMutateBuild() {
        ThreadFactory factory1 = this.builder.setPriority(1).build();
        ThreadFactoryBuilderTest.assertEquals((int)1, (int)factory1.newThread(this.monitoredRunnable).getPriority());
        ThreadFactory factory2 = this.builder.setPriority(2).build();
        ThreadFactoryBuilderTest.assertEquals((int)1, (int)factory1.newThread(this.monitoredRunnable).getPriority());
        ThreadFactoryBuilderTest.assertEquals((int)2, (int)factory2.newThread(this.monitoredRunnable).getPriority());
    }

    public void testBuildTwice() {
        this.builder.build();
        this.builder.build();
    }

    public void testBuildMutate() {
        ThreadFactory factory1 = this.builder.setPriority(1).build();
        ThreadFactoryBuilderTest.assertEquals((int)1, (int)factory1.newThread(this.monitoredRunnable).getPriority());
        this.builder.setPriority(2);
        ThreadFactoryBuilderTest.assertEquals((int)1, (int)factory1.newThread(this.monitoredRunnable).getPriority());
    }

    public void testThreadFactory() throws InterruptedException {
        String THREAD_NAME = "ludicrous speed";
        boolean THREAD_PRIORITY = true;
        boolean THREAD_DAEMON = false;
        ThreadFactory backingThreadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("ludicrous speed");
                thread.setPriority(1);
                thread.setDaemon(false);
                thread.setUncaughtExceptionHandler(UNCAUGHT_EXCEPTION_HANDLER);
                return thread;
            }
        };
        Thread thread = this.builder.setThreadFactory(backingThreadFactory).build().newThread(this.monitoredRunnable);
        ThreadFactoryBuilderTest.assertEquals((String)"ludicrous speed", (String)thread.getName());
        ThreadFactoryBuilderTest.assertEquals((int)1, (int)thread.getPriority());
        ThreadFactoryBuilderTest.assertEquals((boolean)false, (boolean)thread.isDaemon());
        ThreadFactoryBuilderTest.assertSame((Object)UNCAUGHT_EXCEPTION_HANDLER, (Object)thread.getUncaughtExceptionHandler());
        ThreadFactoryBuilderTest.assertSame((Object)((Object)Thread.State.NEW), (Object)((Object)thread.getState()));
        ThreadFactoryBuilderTest.assertFalse((boolean)this.completed);
        thread.start();
        thread.join();
        ThreadFactoryBuilderTest.assertTrue((boolean)this.completed);
    }

    public void testNulls() {
        NullPointerTester npTester = new NullPointerTester();
        npTester.testAllPublicConstructors(ThreadFactoryBuilder.class);
        npTester.testAllPublicStaticMethods(ThreadFactoryBuilder.class);
        npTester.testAllPublicInstanceMethods((Object)this.builder);
    }
}

