/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.WrappingExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class WrappingExecutorServiceTest
extends TestCase {
    private static final String RESULT_VALUE = "ran";
    private static final Runnable DO_NOTHING = new Runnable(){

        @Override
        public void run() {
        }
    };

    public void testDelegations() throws InterruptedException {
        MockExecutor mock = new MockExecutor();
        TestExecutor testExecutor = new TestExecutor(mock);
        WrappingExecutorServiceTest.assertFalse((boolean)testExecutor.awaitTermination(10L, TimeUnit.MILLISECONDS));
        mock.assertLastMethodCalled("awaitTermination");
        WrappingExecutorServiceTest.assertFalse((boolean)testExecutor.isTerminated());
        mock.assertLastMethodCalled("isTerminated");
        WrappingExecutorServiceTest.assertFalse((boolean)testExecutor.isShutdown());
        mock.assertLastMethodCalled("isShutdown");
        testExecutor.shutdown();
        mock.assertLastMethodCalled("shutdown");
        List list = testExecutor.shutdownNow();
        mock.assertLastMethodCalled("shutdownNow");
        WrappingExecutorServiceTest.assertEquals((Object)ImmutableList.of(), (Object)list);
    }

    public void testExecute() {
        MockExecutor mock = new MockExecutor();
        TestExecutor testExecutor = new TestExecutor(mock);
        testExecutor.execute(DO_NOTHING);
        mock.assertLastMethodCalled("execute");
    }

    public void testSubmit() throws InterruptedException, ExecutionException {
        MockExecutor mock = new MockExecutor();
        TestExecutor testExecutor = new TestExecutor(mock);
        Future f = testExecutor.submit(DO_NOTHING);
        mock.assertLastMethodCalled("submit");
        f.get();
        mock = new MockExecutor();
        testExecutor = new TestExecutor(mock);
        f = testExecutor.submit(DO_NOTHING, RESULT_VALUE);
        mock.assertLastMethodCalled("submit");
        WrappingExecutorServiceTest.assertEquals((String)RESULT_VALUE, (String)((String)f.get()));
        mock = new MockExecutor();
        testExecutor = new TestExecutor(mock);
        Callable task = Callables.returning((Object)RESULT_VALUE);
        Future f2 = testExecutor.submit(task);
        mock.assertLastMethodCalled("submit");
        WrappingExecutorServiceTest.assertEquals((String)RESULT_VALUE, (String)((String)f2.get()));
    }

    public void testInvokeAll() throws InterruptedException, ExecutionException {
        List<Callable<String>> tasks = WrappingExecutorServiceTest.createTasks(3);
        MockExecutor mock = new MockExecutor();
        TestExecutor testExecutor = new TestExecutor(mock);
        List futures = testExecutor.invokeAll(tasks);
        mock.assertLastMethodCalled("invokeAll");
        WrappingExecutorServiceTest.checkResults(futures);
        mock = new MockExecutor();
        TimeUnit unit = TimeUnit.SECONDS;
        long timeout = 5L;
        TestExecutor testExecutor2 = new TestExecutor(mock);
        List futures2 = testExecutor2.invokeAll(tasks, timeout, unit);
        mock.assertMethodWithTimeout("invokeAll", timeout, unit);
        WrappingExecutorServiceTest.checkResults(futures2);
    }

    public void testInvokeAny() throws InterruptedException, ExecutionException, TimeoutException {
        List<Callable<String>> tasks = WrappingExecutorServiceTest.createTasks(3);
        MockExecutor mock = new MockExecutor();
        TestExecutor testExecutor = new TestExecutor(mock);
        String s = (String)testExecutor.invokeAny(tasks);
        WrappingExecutorServiceTest.assertEquals((String)"ran0", (String)s);
        mock.assertLastMethodCalled("invokeAny");
        mock = new MockExecutor();
        TimeUnit unit = TimeUnit.SECONDS;
        long timeout = 5L;
        TestExecutor testExecutor2 = new TestExecutor(mock);
        String s2 = (String)testExecutor2.invokeAny(tasks, timeout, unit);
        WrappingExecutorServiceTest.assertEquals((String)"ran0", (String)s2);
        mock.assertMethodWithTimeout("invokeAny", timeout, unit);
    }

    private static void checkResults(List<Future<String>> futures) throws InterruptedException, ExecutionException {
        for (int i = 0; i < futures.size(); ++i) {
            WrappingExecutorServiceTest.assertEquals((String)(RESULT_VALUE + i), (String)futures.get(i).get());
        }
    }

    private static List<Callable<String>> createTasks(int n) {
        ArrayList callables = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            callables.add(Callables.returning((Object)(RESULT_VALUE + i)));
        }
        return callables;
    }

    private static final class MockExecutor
    implements ExecutorService {
        private String lastMethodCalled = "";
        private long lastTimeoutInMillis = -1L;
        private ExecutorService inline = MoreExecutors.sameThreadExecutor();

        private MockExecutor() {
        }

        public void assertLastMethodCalled(String method) {
            Assert.assertEquals((String)method, (String)this.lastMethodCalled);
        }

        public void assertMethodWithTimeout(String method, long timeout, TimeUnit unit) {
            this.assertLastMethodCalled(method + "Timeout");
            Assert.assertEquals((long)unit.toMillis(timeout), (long)this.lastTimeoutInMillis);
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            this.lastMethodCalled = "awaitTermination";
            return false;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            this.lastMethodCalled = "invokeAll";
            MockExecutor.assertTaskWrapped(tasks);
            return this.inline.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            MockExecutor.assertTaskWrapped(tasks);
            this.lastMethodCalled = "invokeAllTimeout";
            this.lastTimeoutInMillis = unit.toMillis(timeout);
            return this.inline.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
            MockExecutor.assertTaskWrapped(tasks);
            this.lastMethodCalled = "invokeAny";
            return this.inline.submit((Callable)Iterables.get(tasks, (int)0)).get();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            MockExecutor.assertTaskWrapped(tasks);
            this.lastMethodCalled = "invokeAnyTimeout";
            this.lastTimeoutInMillis = unit.toMillis(timeout);
            return this.inline.submit((Callable)Iterables.get(tasks, (int)0)).get(timeout, unit);
        }

        @Override
        public boolean isShutdown() {
            this.lastMethodCalled = "isShutdown";
            return false;
        }

        @Override
        public boolean isTerminated() {
            this.lastMethodCalled = "isTerminated";
            return false;
        }

        @Override
        public void shutdown() {
            this.lastMethodCalled = "shutdown";
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.lastMethodCalled = "shutdownNow";
            return ImmutableList.of();
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            this.lastMethodCalled = "submit";
            Assert.assertTrue((boolean)(task instanceof WrappedCallable));
            return this.inline.submit(task);
        }

        @Override
        public Future<?> submit(Runnable task) {
            this.lastMethodCalled = "submit";
            Assert.assertTrue((boolean)(task instanceof WrappedRunnable));
            return this.inline.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            this.lastMethodCalled = "submit";
            Assert.assertTrue((boolean)(task instanceof WrappedRunnable));
            return this.inline.submit(task, result);
        }

        @Override
        public void execute(Runnable command) {
            this.lastMethodCalled = "execute";
            Assert.assertTrue((boolean)(command instanceof WrappedRunnable));
            this.inline.execute(command);
        }

        private static <T> void assertTaskWrapped(Collection<? extends Callable<T>> tasks) {
            Predicate p = Predicates.instanceOf(WrappedCallable.class);
            Assert.assertTrue((boolean)Iterables.all(tasks, (Predicate)p));
        }
    }

    private static final class TestExecutor
    extends WrappingExecutorService {
        public TestExecutor(MockExecutor mock) {
            super((ExecutorService)mock);
        }

        protected <T> Callable<T> wrapTask(Callable<T> callable) {
            return new WrappedCallable<T>(callable);
        }

        protected Runnable wrapTask(Runnable command) {
            return new WrappedRunnable(command);
        }
    }

    private static final class WrappedRunnable
    implements Runnable {
        private final Runnable delegate;

        public WrappedRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            this.delegate.run();
        }
    }

    private static final class WrappedCallable<T>
    implements Callable<T> {
        private final Callable<T> delegate;

        public WrappedCallable(Callable<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T call() throws Exception {
            return this.delegate.call();
        }
    }
}

