/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CaseFormat;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class CaseFormatTest
extends TestCase {
    public void testIdentity() {
        for (CaseFormat from : CaseFormat.values()) {
            String string = String.valueOf(String.valueOf(from));
            String string2 = String.valueOf(String.valueOf(from));
            CaseFormatTest.assertSame((String)new StringBuilder(4 + string.length() + string2.length()).append(string).append(" to ").append(string2).toString(), (Object)"foo", (Object)from.to(from, "foo"));
            for (CaseFormat to : CaseFormat.values()) {
                String string3 = String.valueOf(String.valueOf(from));
                String string4 = String.valueOf(String.valueOf(to));
                CaseFormatTest.assertEquals((String)new StringBuilder(4 + string3.length() + string4.length()).append(string3).append(" to ").append(string4).toString(), (String)"", (String)from.to(to, ""));
                String string5 = String.valueOf(String.valueOf(from));
                String string6 = String.valueOf(String.valueOf(to));
                CaseFormatTest.assertEquals((String)new StringBuilder(4 + string5.length() + string6.length()).append(string5).append(" to ").append(string6).toString(), (String)" ", (String)from.to(to, " "));
            }
        }
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullArguments() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(CaseFormat.class);
        for (CaseFormat format : CaseFormat.values()) {
            tester.testAllPublicInstanceMethods((Object)format);
        }
    }

    public void testLowerHyphenToLowerHyphen() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_HYPHEN, "foo"));
        CaseFormatTest.assertEquals((String)"foo-bar", (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_HYPHEN, "foo-bar"));
    }

    public void testLowerHyphenToLowerUnderscore() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_UNDERSCORE, "foo"));
        CaseFormatTest.assertEquals((String)"foo_bar", (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_UNDERSCORE, "foo-bar"));
    }

    public void testLowerHyphenToLowerCamel() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, "foo"));
        CaseFormatTest.assertEquals((String)"fooBar", (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, "foo-bar"));
    }

    public void testLowerHyphenToUpperCamel() {
        CaseFormatTest.assertEquals((String)"Foo", (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, "foo"));
        CaseFormatTest.assertEquals((String)"FooBar", (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, "foo-bar"));
    }

    public void testLowerHyphenToUpperUnderscore() {
        CaseFormatTest.assertEquals((String)"FOO", (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, "foo"));
        CaseFormatTest.assertEquals((String)"FOO_BAR", (String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, "foo-bar"));
    }

    public void testLowerUnderscoreToLowerHyphen() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, "foo"));
        CaseFormatTest.assertEquals((String)"foo-bar", (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, "foo_bar"));
    }

    public void testLowerUnderscoreToLowerUnderscore() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, "foo"));
        CaseFormatTest.assertEquals((String)"foo_bar", (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, "foo_bar"));
    }

    public void testLowerUnderscoreToLowerCamel() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "foo"));
        CaseFormatTest.assertEquals((String)"fooBar", (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "foo_bar"));
    }

    public void testLowerUnderscoreToUpperCamel() {
        CaseFormatTest.assertEquals((String)"Foo", (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, "foo"));
        CaseFormatTest.assertEquals((String)"FooBar", (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, "foo_bar"));
    }

    public void testLowerUnderscoreToUpperUnderscore() {
        CaseFormatTest.assertEquals((String)"FOO", (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_UNDERSCORE, "foo"));
        CaseFormatTest.assertEquals((String)"FOO_BAR", (String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_UNDERSCORE, "foo_bar"));
    }

    public void testLowerCamelToLowerHyphen() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, "foo"));
        CaseFormatTest.assertEquals((String)"foo-bar", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, "fooBar"));
        CaseFormatTest.assertEquals((String)"h-t-t-p", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, "HTTP"));
    }

    public void testLowerCamelToLowerUnderscore() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, "foo"));
        CaseFormatTest.assertEquals((String)"foo_bar", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, "fooBar"));
        CaseFormatTest.assertEquals((String)"h_t_t_p", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, "hTTP"));
    }

    public void testLowerCamelToLowerCamel() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_CAMEL, "foo"));
        CaseFormatTest.assertEquals((String)"fooBar", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_CAMEL, "fooBar"));
    }

    public void testLowerCamelToUpperCamel() {
        CaseFormatTest.assertEquals((String)"Foo", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, "foo"));
        CaseFormatTest.assertEquals((String)"FooBar", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, "fooBar"));
        CaseFormatTest.assertEquals((String)"HTTP", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, "hTTP"));
    }

    public void testLowerCamelToUpperUnderscore() {
        CaseFormatTest.assertEquals((String)"FOO", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, "foo"));
        CaseFormatTest.assertEquals((String)"FOO_BAR", (String)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, "fooBar"));
    }

    public void testUpperCamelToLowerHyphen() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, "Foo"));
        CaseFormatTest.assertEquals((String)"foo-bar", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, "FooBar"));
    }

    public void testUpperCamelToLowerUnderscore() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, "Foo"));
        CaseFormatTest.assertEquals((String)"foo_bar", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, "FooBar"));
    }

    public void testUpperCamelToLowerCamel() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, "Foo"));
        CaseFormatTest.assertEquals((String)"fooBar", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, "FooBar"));
        CaseFormatTest.assertEquals((String)"hTTP", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, "HTTP"));
    }

    public void testUpperCamelToUpperCamel() {
        CaseFormatTest.assertEquals((String)"Foo", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_CAMEL, "Foo"));
        CaseFormatTest.assertEquals((String)"FooBar", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_CAMEL, "FooBar"));
    }

    public void testUpperCamelToUpperUnderscore() {
        CaseFormatTest.assertEquals((String)"FOO", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, "Foo"));
        CaseFormatTest.assertEquals((String)"FOO_BAR", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, "FooBar"));
        CaseFormatTest.assertEquals((String)"H_T_T_P", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, "HTTP"));
        CaseFormatTest.assertEquals((String)"H__T__T__P", (String)CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, "H_T_T_P"));
    }

    public void testUpperUnderscoreToLowerHyphen() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, "FOO"));
        CaseFormatTest.assertEquals((String)"foo-bar", (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, "FOO_BAR"));
    }

    public void testUpperUnderscoreToLowerUnderscore() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, "FOO"));
        CaseFormatTest.assertEquals((String)"foo_bar", (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, "FOO_BAR"));
    }

    public void testUpperUnderscoreToLowerCamel() {
        CaseFormatTest.assertEquals((String)"foo", (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "FOO"));
        CaseFormatTest.assertEquals((String)"fooBar", (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "FOO_BAR"));
    }

    public void testUpperUnderscoreToUpperCamel() {
        CaseFormatTest.assertEquals((String)"Foo", (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, "FOO"));
        CaseFormatTest.assertEquals((String)"FooBar", (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, "FOO_BAR"));
        CaseFormatTest.assertEquals((String)"HTTP", (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, "H_T_T_P"));
    }

    public void testUpperUnderscoreToUpperUnderscore() {
        CaseFormatTest.assertEquals((String)"FOO", (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_UNDERSCORE, "FOO"));
        CaseFormatTest.assertEquals((String)"FOO_BAR", (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_UNDERSCORE, "FOO_BAR"));
    }

    public void testConverterToForward() {
        CaseFormatTest.assertEquals((String)"FooBar", (String)((String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.UPPER_CAMEL).convert((Object)"FOO_BAR")));
        CaseFormatTest.assertEquals((String)"fooBar", (String)((String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL).convert((Object)"FOO_BAR")));
        CaseFormatTest.assertEquals((String)"FOO_BAR", (String)((String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE).convert((Object)"FooBar")));
        CaseFormatTest.assertEquals((String)"FOO_BAR", (String)((String)CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE).convert((Object)"fooBar")));
    }

    public void testConverterToBackward() {
        CaseFormatTest.assertEquals((String)"FOO_BAR", (String)((String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.UPPER_CAMEL).reverse().convert((Object)"FooBar")));
        CaseFormatTest.assertEquals((String)"FOO_BAR", (String)((String)CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL).reverse().convert((Object)"fooBar")));
        CaseFormatTest.assertEquals((String)"FooBar", (String)((String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE).reverse().convert((Object)"FOO_BAR")));
        CaseFormatTest.assertEquals((String)"fooBar", (String)((String)CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE).reverse().convert((Object)"FOO_BAR")));
    }

    public void testConverter_nullConversions() {
        for (CaseFormat outer : CaseFormat.values()) {
            for (CaseFormat inner : CaseFormat.values()) {
                CaseFormatTest.assertNull((Object)outer.converterTo(inner).convert(null));
                CaseFormatTest.assertNull((Object)outer.converterTo(inner).reverse().convert(null));
            }
        }
    }

    public void testConverter_toString() {
        CaseFormatTest.assertEquals((String)"LOWER_HYPHEN.converterTo(UPPER_CAMEL)", (String)CaseFormat.LOWER_HYPHEN.converterTo(CaseFormat.UPPER_CAMEL).toString());
    }

    public void testConverter_serialization() {
        for (CaseFormat outer : CaseFormat.values()) {
            for (CaseFormat inner : CaseFormat.values()) {
                SerializableTester.reserializeAndAssert((Object)outer.converterTo(inner));
            }
        }
    }
}

