/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.EquivalenceTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class EquivalenceTest
extends TestCase {
    private static final Equivalence<String> LENGTH_EQUIVALENCE = Equivalence.equals().onResultOf((Function)LengthFunction.INSTANCE);

    public void testPairwiseEquivalent() {
        EquivalenceTester.of((Equivalence)Equivalence.equals().pairwise()).addEquivalenceGroup((Object)ImmutableList.of(), (Object[])new Iterable[0]).addEquivalenceGroup((Object)ImmutableList.of((Object)"a"), (Object[])new Iterable[0]).addEquivalenceGroup((Object)ImmutableList.of((Object)"b"), (Object[])new Iterable[0]).addEquivalenceGroup((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object[])new Iterable[]{ImmutableList.of((Object)"a", (Object)"b")}).test();
    }

    public void testPairwiseEquivalent_equals() {
        new EqualsTester().addEqualityGroup(new Object[]{Equivalence.equals().pairwise(), Equivalence.equals().pairwise()}).addEqualityGroup(new Object[]{Equivalence.identity().pairwise()}).testEquals();
    }

    public void testWrap() {
        new EqualsTester().addEqualityGroup(new Object[]{LENGTH_EQUIVALENCE.wrap((Object)"hello"), LENGTH_EQUIVALENCE.wrap((Object)"hello"), LENGTH_EQUIVALENCE.wrap((Object)"world")}).addEqualityGroup(new Object[]{LENGTH_EQUIVALENCE.wrap((Object)"hi"), LENGTH_EQUIVALENCE.wrap((Object)"yo")}).addEqualityGroup(new Object[]{LENGTH_EQUIVALENCE.wrap(null), LENGTH_EQUIVALENCE.wrap(null)}).addEqualityGroup(new Object[]{Equivalence.equals().wrap((Object)"hello")}).addEqualityGroup(new Object[]{Equivalence.equals().wrap(null)}).testEquals();
    }

    public void testWrap_get() {
        String test = "test";
        Equivalence.Wrapper wrapper = LENGTH_EQUIVALENCE.wrap((Object)test);
        EquivalenceTest.assertSame((Object)test, (Object)wrapper.get());
    }

    @GwtIncompatible(value="SerializableTester")
    public void testSerialization() {
        SerializableTester.reserializeAndAssert((Object)LENGTH_EQUIVALENCE.wrap((Object)"hello"));
        SerializableTester.reserializeAndAssert((Object)Equivalence.equals());
        SerializableTester.reserializeAndAssert((Object)Equivalence.identity());
    }

    public void testOnResultOf() {
        EquivalenceTester.of((Equivalence)Equivalence.equals().onResultOf(Functions.toStringFunction())).addEquivalenceGroup((Object)new IntValue(1), new Object[]{new IntValue(1)}).addEquivalenceGroup((Object)new IntValue(2), new Object[0]).test();
    }

    public void testOnResultOf_equals() {
        new EqualsTester().addEqualityGroup(new Object[]{Equivalence.identity().onResultOf(Functions.toStringFunction()), Equivalence.identity().onResultOf(Functions.toStringFunction())}).addEqualityGroup(new Object[]{Equivalence.equals().onResultOf(Functions.toStringFunction())}).addEqualityGroup(new Object[]{Equivalence.identity().onResultOf(Functions.identity())}).testEquals();
    }

    public void testEquivalentTo() {
        Predicate equalTo1 = Equivalence.equals().equivalentTo((Object)"1");
        EquivalenceTest.assertTrue((boolean)equalTo1.apply((Object)"1"));
        EquivalenceTest.assertFalse((boolean)equalTo1.apply((Object)"2"));
        EquivalenceTest.assertFalse((boolean)equalTo1.apply(null));
        Predicate isNull = Equivalence.equals().equivalentTo(null);
        EquivalenceTest.assertFalse((boolean)isNull.apply((Object)"1"));
        EquivalenceTest.assertFalse((boolean)isNull.apply((Object)"2"));
        EquivalenceTest.assertTrue((boolean)isNull.apply(null));
        new EqualsTester().addEqualityGroup(new Object[]{equalTo1, Equivalence.equals().equivalentTo((Object)"1")}).addEqualityGroup(new Object[]{isNull}).addEqualityGroup(new Object[]{Equivalence.identity().equivalentTo((Object)"1")}).testEquals();
    }

    public void testEqualsEquivalent() {
        EquivalenceTester.of((Equivalence)Equivalence.equals()).addEquivalenceGroup((Object)new Integer(42), new Object[]{42}).addEquivalenceGroup((Object)"a", new Object[0]).test();
    }

    public void testIdentityEquivalent() {
        EquivalenceTester.of((Equivalence)Equivalence.identity()).addEquivalenceGroup((Object)new Integer(42), new Object[0]).addEquivalenceGroup((Object)new Integer(42), new Object[0]).addEquivalenceGroup((Object)"a", new Object[0]).test();
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{Equivalence.equals(), Equivalence.equals()}).addEqualityGroup(new Object[]{Equivalence.identity(), Equivalence.identity()}).testEquals();
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(Equivalence.class);
        new NullPointerTester().testAllPublicInstanceMethods((Object)Equivalence.equals());
        new NullPointerTester().testAllPublicInstanceMethods((Object)Equivalence.identity());
    }

    private static class IntValue {
        private final int value;

        IntValue(int value) {
            this.value = value;
        }

        public String toString() {
            int n = this.value;
            return new StringBuilder(19).append("value = ").append(n).toString();
        }
    }

    private static enum LengthFunction implements Function<String, Integer>
    {
        INSTANCE;


        public Integer apply(String input) {
            return input.length();
        }
    }
}

