/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.testing.NullPointerTester;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class PreconditionsTest
extends TestCase {
    private static final String NON_NULL_STRING = "foo";
    private static final Object IGNORE_ME = new Object(){

        public String toString() {
            throw new AssertionFailedError();
        }
    };
    private static final String FORMAT = "I ate %s pies.";

    public void testCheckArgument_simple_success() {
        Preconditions.checkArgument((boolean)true);
    }

    public void testCheckArgument_simple_failure() {
        try {
            Preconditions.checkArgument((boolean)false);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckArgument_simpleMessage_success() {
        Preconditions.checkArgument((boolean)true, (Object)IGNORE_ME);
    }

    public void testCheckArgument_simpleMessage_failure() {
        try {
            Preconditions.checkArgument((boolean)false, (Object)new Message());
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalArgumentException expected) {
            PreconditionsTest.verifySimpleMessage(expected);
        }
    }

    public void testCheckArgument_nullMessage_failure() {
        try {
            Preconditions.checkArgument((boolean)false, null);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalArgumentException expected) {
            PreconditionsTest.assertEquals((String)"null", (String)expected.getMessage());
        }
    }

    public void testCheckArgument_complexMessage_success() {
        Preconditions.checkArgument((boolean)true, (String)"%s", (Object[])new Object[]{IGNORE_ME});
    }

    public void testCheckArgument_complexMessage_failure() {
        try {
            Preconditions.checkArgument((boolean)false, (String)FORMAT, (Object[])new Object[]{5});
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalArgumentException expected) {
            PreconditionsTest.verifyComplexMessage(expected);
        }
    }

    public void testCheckState_simple_success() {
        Preconditions.checkState((boolean)true);
    }

    public void testCheckState_simple_failure() {
        try {
            Preconditions.checkState((boolean)false);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCheckState_simpleMessage_success() {
        Preconditions.checkState((boolean)true, (Object)IGNORE_ME);
    }

    public void testCheckState_simpleMessage_failure() {
        try {
            Preconditions.checkState((boolean)false, (Object)new Message());
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalStateException expected) {
            PreconditionsTest.verifySimpleMessage(expected);
        }
    }

    public void testCheckState_nullMessage_failure() {
        try {
            Preconditions.checkState((boolean)false, null);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalStateException expected) {
            PreconditionsTest.assertEquals((String)"null", (String)expected.getMessage());
        }
    }

    public void testCheckState_complexMessage_success() {
        Preconditions.checkState((boolean)true, (String)"%s", (Object[])new Object[]{IGNORE_ME});
    }

    public void testCheckState_complexMessage_failure() {
        try {
            Preconditions.checkState((boolean)false, (String)FORMAT, (Object[])new Object[]{5});
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalStateException expected) {
            PreconditionsTest.verifyComplexMessage(expected);
        }
    }

    public void testCheckNotNull_simple_success() {
        String result = (String)Preconditions.checkNotNull((Object)NON_NULL_STRING);
        PreconditionsTest.assertSame((Object)NON_NULL_STRING, (Object)result);
    }

    public void testCheckNotNull_simple_failure() {
        try {
            Preconditions.checkNotNull(null);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCheckNotNull_simpleMessage_success() {
        String result = (String)Preconditions.checkNotNull((Object)NON_NULL_STRING, (Object)IGNORE_ME);
        PreconditionsTest.assertSame((Object)NON_NULL_STRING, (Object)result);
    }

    public void testCheckNotNull_simpleMessage_failure() {
        try {
            Preconditions.checkNotNull(null, (Object)new Message());
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (NullPointerException expected) {
            PreconditionsTest.verifySimpleMessage(expected);
        }
    }

    public void testCheckNotNull_complexMessage_success() {
        String result = (String)Preconditions.checkNotNull((Object)NON_NULL_STRING, (String)"%s", (Object[])new Object[]{IGNORE_ME});
        PreconditionsTest.assertSame((Object)NON_NULL_STRING, (Object)result);
    }

    public void testCheckNotNull_complexMessage_failure() {
        try {
            Preconditions.checkNotNull(null, (String)FORMAT, (Object[])new Object[]{5});
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (NullPointerException expected) {
            PreconditionsTest.verifyComplexMessage(expected);
        }
    }

    public void testCheckElementIndex_ok() {
        PreconditionsTest.assertEquals((int)0, (int)Preconditions.checkElementIndex((int)0, (int)1));
        PreconditionsTest.assertEquals((int)0, (int)Preconditions.checkElementIndex((int)0, (int)2));
        PreconditionsTest.assertEquals((int)1, (int)Preconditions.checkElementIndex((int)1, (int)2));
    }

    public void testCheckElementIndex_badSize() {
        try {
            Preconditions.checkElementIndex((int)1, (int)-1);
            PreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckElementIndex_negative() {
        try {
            Preconditions.checkElementIndex((int)-1, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            PreconditionsTest.assertEquals((String)"index (-1) must not be negative", (String)expected.getMessage());
        }
    }

    public void testCheckElementIndex_tooHigh() {
        try {
            Preconditions.checkElementIndex((int)1, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            PreconditionsTest.assertEquals((String)"index (1) must be less than size (1)", (String)expected.getMessage());
        }
    }

    public void testCheckElementIndex_withDesc_negative() {
        try {
            Preconditions.checkElementIndex((int)-1, (int)1, (String)NON_NULL_STRING);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            PreconditionsTest.assertEquals((String)"foo (-1) must not be negative", (String)expected.getMessage());
        }
    }

    public void testCheckElementIndex_withDesc_tooHigh() {
        try {
            Preconditions.checkElementIndex((int)1, (int)1, (String)NON_NULL_STRING);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            PreconditionsTest.assertEquals((String)"foo (1) must be less than size (1)", (String)expected.getMessage());
        }
    }

    public void testCheckPositionIndex_ok() {
        PreconditionsTest.assertEquals((int)0, (int)Preconditions.checkPositionIndex((int)0, (int)0));
        PreconditionsTest.assertEquals((int)0, (int)Preconditions.checkPositionIndex((int)0, (int)1));
        PreconditionsTest.assertEquals((int)1, (int)Preconditions.checkPositionIndex((int)1, (int)1));
    }

    public void testCheckPositionIndex_badSize() {
        try {
            Preconditions.checkPositionIndex((int)1, (int)-1);
            PreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckPositionIndex_negative() {
        try {
            Preconditions.checkPositionIndex((int)-1, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            PreconditionsTest.assertEquals((String)"index (-1) must not be negative", (String)expected.getMessage());
        }
    }

    public void testCheckPositionIndex_tooHigh() {
        try {
            Preconditions.checkPositionIndex((int)2, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            PreconditionsTest.assertEquals((String)"index (2) must not be greater than size (1)", (String)expected.getMessage());
        }
    }

    public void testCheckPositionIndex_withDesc_negative() {
        try {
            Preconditions.checkPositionIndex((int)-1, (int)1, (String)NON_NULL_STRING);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            PreconditionsTest.assertEquals((String)"foo (-1) must not be negative", (String)expected.getMessage());
        }
    }

    public void testCheckPositionIndex_withDesc_tooHigh() {
        try {
            Preconditions.checkPositionIndex((int)2, (int)1, (String)NON_NULL_STRING);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            PreconditionsTest.assertEquals((String)"foo (2) must not be greater than size (1)", (String)expected.getMessage());
        }
    }

    public void testCheckPositionIndexes_ok() {
        Preconditions.checkPositionIndexes((int)0, (int)0, (int)0);
        Preconditions.checkPositionIndexes((int)0, (int)0, (int)1);
        Preconditions.checkPositionIndexes((int)0, (int)1, (int)1);
        Preconditions.checkPositionIndexes((int)1, (int)1, (int)1);
    }

    public void testCheckPositionIndexes_badSize() {
        try {
            Preconditions.checkPositionIndexes((int)1, (int)1, (int)-1);
            PreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckPositionIndex_startNegative() {
        try {
            Preconditions.checkPositionIndexes((int)-1, (int)1, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            PreconditionsTest.assertEquals((String)"start index (-1) must not be negative", (String)expected.getMessage());
        }
    }

    public void testCheckPositionIndexes_endTooHigh() {
        try {
            Preconditions.checkPositionIndexes((int)0, (int)2, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            PreconditionsTest.assertEquals((String)"end index (2) must not be greater than size (1)", (String)expected.getMessage());
        }
    }

    public void testCheckPositionIndexes_reversed() {
        try {
            Preconditions.checkPositionIndexes((int)1, (int)0, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            PreconditionsTest.assertEquals((String)"end index (0) must not be less than start index (1)", (String)expected.getMessage());
        }
    }

    public void testFormat() {
        PreconditionsTest.assertEquals((String)"%s", (String)Preconditions.format((String)"%s", (Object[])new Object[0]));
        PreconditionsTest.assertEquals((String)"5", (String)Preconditions.format((String)"%s", (Object[])new Object[]{5}));
        PreconditionsTest.assertEquals((String)"foo [5]", (String)Preconditions.format((String)NON_NULL_STRING, (Object[])new Object[]{5}));
        PreconditionsTest.assertEquals((String)"foo [5, 6, 7]", (String)Preconditions.format((String)NON_NULL_STRING, (Object[])new Object[]{5, 6, 7}));
        PreconditionsTest.assertEquals((String)"%s 1 2", (String)Preconditions.format((String)"%s %s %s", (Object[])new Object[]{"%s", 1, 2}));
        PreconditionsTest.assertEquals((String)" [5, 6]", (String)Preconditions.format((String)"", (Object[])new Object[]{5, 6}));
        PreconditionsTest.assertEquals((String)"123", (String)Preconditions.format((String)"%s%s%s", (Object[])new Object[]{1, 2, 3}));
        PreconditionsTest.assertEquals((String)"1%s%s", (String)Preconditions.format((String)"%s%s%s", (Object[])new Object[]{1}));
        PreconditionsTest.assertEquals((String)"5 + 6 = 11", (String)Preconditions.format((String)"%s + 6 = 11", (Object[])new Object[]{5}));
        PreconditionsTest.assertEquals((String)"5 + 6 = 11", (String)Preconditions.format((String)"5 + %s = 11", (Object[])new Object[]{6}));
        PreconditionsTest.assertEquals((String)"5 + 6 = 11", (String)Preconditions.format((String)"5 + 6 = %s", (Object[])new Object[]{11}));
        PreconditionsTest.assertEquals((String)"5 + 6 = 11", (String)Preconditions.format((String)"%s + %s = %s", (Object[])new Object[]{5, 6, 11}));
        PreconditionsTest.assertEquals((String)"null [null, null]", (String)Preconditions.format((String)"%s", (Object[])new Object[]{null, null, null}));
        PreconditionsTest.assertEquals((String)"null [5, 6]", (String)Preconditions.format(null, (Object[])new Object[]{5, 6}));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Preconditions.class);
    }

    private static void verifySimpleMessage(Exception e) {
        PreconditionsTest.assertEquals((String)"A message", (String)e.getMessage());
    }

    private static void verifyComplexMessage(Exception e) {
        PreconditionsTest.assertEquals((String)"I ate 5 pies.", (String)e.getMessage());
    }

    private static class Message {
        boolean invoked;

        private Message() {
        }

        public String toString() {
            Assert.assertFalse((boolean)this.invoked);
            this.invoked = true;
            return "A message";
        }
    }
}

