/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Ascii;
import com.google.common.base.StandardSystemProperty;
import junit.framework.TestCase;

public class StandardSystemPropertyTest
extends TestCase {
    public void testGetKeyMatchesString() {
        for (StandardSystemProperty property : StandardSystemProperty.values()) {
            String fieldName = property.name();
            String expected = Ascii.toLowerCase((String)fieldName).replaceAll("_", ".");
            StandardSystemPropertyTest.assertEquals((String)expected, (String)property.key());
        }
    }

    public void testGetValue() {
        for (StandardSystemProperty property : StandardSystemProperty.values()) {
            StandardSystemPropertyTest.assertEquals((String)System.getProperty(property.key()), (String)property.value());
        }
    }

    public void testToString() {
        for (StandardSystemProperty property : StandardSystemProperty.values()) {
            String string = String.valueOf(String.valueOf(property.key()));
            String string2 = String.valueOf(String.valueOf(property.value()));
            StandardSystemPropertyTest.assertEquals((String)new StringBuilder(1 + string.length() + string2.length()).append(string).append("=").append(string2).toString(), (String)property.toString());
        }
    }

    public void testNoNullValues() {
        for (StandardSystemProperty property : StandardSystemProperty.values()) {
            if (property == StandardSystemProperty.JAVA_COMPILER) continue;
            StandardSystemPropertyTest.assertNotNull((Object)property.value());
        }
    }
}

