/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.testing.FakeTicker;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class StopwatchTest
extends TestCase {
    private final FakeTicker ticker = new FakeTicker();
    private final Stopwatch stopwatch = new Stopwatch((Ticker)this.ticker);

    public void testCreateStarted() {
        Stopwatch startedStopwatch = Stopwatch.createStarted();
        StopwatchTest.assertTrue((boolean)startedStopwatch.isRunning());
    }

    public void testCreateUnstarted() {
        Stopwatch unstartedStopwatch = Stopwatch.createUnstarted();
        StopwatchTest.assertFalse((boolean)unstartedStopwatch.isRunning());
        StopwatchTest.assertEquals((long)0L, (long)unstartedStopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    public void testInitialState() {
        StopwatchTest.assertFalse((boolean)this.stopwatch.isRunning());
        StopwatchTest.assertEquals((long)0L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    public void testStart() {
        StopwatchTest.assertSame((Object)this.stopwatch, (Object)this.stopwatch.start());
        StopwatchTest.assertTrue((boolean)this.stopwatch.isRunning());
    }

    public void testStart_whileRunning() {
        this.stopwatch.start();
        try {
            this.stopwatch.start();
            StopwatchTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        StopwatchTest.assertTrue((boolean)this.stopwatch.isRunning());
    }

    public void testStop() {
        this.stopwatch.start();
        StopwatchTest.assertSame((Object)this.stopwatch, (Object)this.stopwatch.stop());
        StopwatchTest.assertFalse((boolean)this.stopwatch.isRunning());
    }

    public void testStop_new() {
        try {
            this.stopwatch.stop();
            StopwatchTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        StopwatchTest.assertFalse((boolean)this.stopwatch.isRunning());
    }

    public void testStop_alreadyStopped() {
        this.stopwatch.start();
        this.stopwatch.stop();
        try {
            this.stopwatch.stop();
            StopwatchTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        StopwatchTest.assertFalse((boolean)this.stopwatch.isRunning());
    }

    public void testReset_new() {
        this.ticker.advance(1L);
        this.stopwatch.reset();
        StopwatchTest.assertFalse((boolean)this.stopwatch.isRunning());
        this.ticker.advance(2L);
        StopwatchTest.assertEquals((long)0L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.stopwatch.start();
        this.ticker.advance(3L);
        StopwatchTest.assertEquals((long)3L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    public void testReset_whileRunning() {
        this.ticker.advance(1L);
        this.stopwatch.start();
        StopwatchTest.assertEquals((long)0L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.ticker.advance(2L);
        StopwatchTest.assertEquals((long)2L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.stopwatch.reset();
        StopwatchTest.assertFalse((boolean)this.stopwatch.isRunning());
        this.ticker.advance(3L);
        StopwatchTest.assertEquals((long)0L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    public void testElapsed_whileRunning() {
        this.ticker.advance(78L);
        this.stopwatch.start();
        StopwatchTest.assertEquals((long)0L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.ticker.advance(345L);
        StopwatchTest.assertEquals((long)345L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    public void testElapsed_notRunning() {
        this.ticker.advance(1L);
        this.stopwatch.start();
        this.ticker.advance(4L);
        this.stopwatch.stop();
        this.ticker.advance(9L);
        StopwatchTest.assertEquals((long)4L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    public void testElapsed_multipleSegments() {
        this.stopwatch.start();
        this.ticker.advance(9L);
        this.stopwatch.stop();
        this.ticker.advance(16L);
        this.stopwatch.start();
        StopwatchTest.assertEquals((long)9L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.ticker.advance(25L);
        StopwatchTest.assertEquals((long)34L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.stopwatch.stop();
        this.ticker.advance(36L);
        StopwatchTest.assertEquals((long)34L, (long)this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    public void testElapsed_micros() {
        this.stopwatch.start();
        this.ticker.advance(999L);
        StopwatchTest.assertEquals((long)0L, (long)this.stopwatch.elapsed(TimeUnit.MICROSECONDS));
        this.ticker.advance(1L);
        StopwatchTest.assertEquals((long)1L, (long)this.stopwatch.elapsed(TimeUnit.MICROSECONDS));
    }

    public void testElapsed_millis() {
        this.stopwatch.start();
        this.ticker.advance(999999L);
        StopwatchTest.assertEquals((long)0L, (long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.ticker.advance(1L);
        StopwatchTest.assertEquals((long)1L, (long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public void testElapsedMillis() {
        this.stopwatch.start();
        this.ticker.advance(999999L);
        StopwatchTest.assertEquals((long)0L, (long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.ticker.advance(1L);
        StopwatchTest.assertEquals((long)1L, (long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public void testElapsedMillis_whileRunning() {
        this.ticker.advance(78000000L);
        this.stopwatch.start();
        StopwatchTest.assertEquals((long)0L, (long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.ticker.advance(345000000L);
        StopwatchTest.assertEquals((long)345L, (long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public void testElapsedMillis_notRunning() {
        this.ticker.advance(1000000L);
        this.stopwatch.start();
        this.ticker.advance(4000000L);
        this.stopwatch.stop();
        this.ticker.advance(9000000L);
        StopwatchTest.assertEquals((long)4L, (long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public void testElapsedMillis_multipleSegments() {
        this.stopwatch.start();
        this.ticker.advance(9000000L);
        this.stopwatch.stop();
        this.ticker.advance(16000000L);
        this.stopwatch.start();
        StopwatchTest.assertEquals((long)9L, (long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.ticker.advance(25000000L);
        StopwatchTest.assertEquals((long)34L, (long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.stopwatch.stop();
        this.ticker.advance(36000000L);
        StopwatchTest.assertEquals((long)34L, (long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @GwtIncompatible(value="String.format()")
    public void testToString() {
        this.stopwatch.start();
        StopwatchTest.assertEquals((String)"0.000 ns", (String)this.stopwatch.toString());
        this.ticker.advance(1L);
        StopwatchTest.assertEquals((String)"1.000 ns", (String)this.stopwatch.toString());
        this.ticker.advance(998L);
        StopwatchTest.assertEquals((String)"999.0 ns", (String)this.stopwatch.toString());
        this.ticker.advance(1L);
        StopwatchTest.assertEquals((String)"1.000 \u03bcs", (String)this.stopwatch.toString());
        this.ticker.advance(1L);
        StopwatchTest.assertEquals((String)"1.001 \u03bcs", (String)this.stopwatch.toString());
        this.ticker.advance(8998L);
        StopwatchTest.assertEquals((String)"9.999 \u03bcs", (String)this.stopwatch.toString());
        this.stopwatch.reset();
        this.stopwatch.start();
        this.ticker.advance(1234567L);
        StopwatchTest.assertEquals((String)"1.235 ms", (String)this.stopwatch.toString());
        this.stopwatch.reset();
        this.stopwatch.start();
        this.ticker.advance(5000000000L);
        StopwatchTest.assertEquals((String)"5.000 s", (String)this.stopwatch.toString());
        this.stopwatch.reset();
        this.stopwatch.start();
        this.ticker.advance(90000000000L);
        StopwatchTest.assertEquals((String)"1.500 min", (String)this.stopwatch.toString());
        this.stopwatch.reset();
        this.stopwatch.start();
        this.ticker.advance(9000000000000L);
        StopwatchTest.assertEquals((String)"2.500 h", (String)this.stopwatch.toString());
        this.stopwatch.reset();
        this.stopwatch.start();
        this.ticker.advance(626400000000000L);
        StopwatchTest.assertEquals((String)"7.250 d", (String)this.stopwatch.toString());
    }
}

