/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.testing.ClassSanityTester;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.Assert;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class SuppliersTest
extends TestCase {
    public void testCompose() {
        Supplier<Integer> fiveSupplier = new Supplier<Integer>(){

            public Integer get() {
                return 5;
            }
        };
        Function<Number, Integer> intValueFunction = new Function<Number, Integer>(){

            public Integer apply(Number x) {
                return x.intValue();
            }
        };
        Supplier squareSupplier = Suppliers.compose((Function)intValueFunction, (Supplier)fiveSupplier);
        SuppliersTest.assertEquals((Object)5, (Object)squareSupplier.get());
    }

    public void testComposeWithLists() {
        Supplier<ArrayList<Integer>> listSupplier = new Supplier<ArrayList<Integer>>(){

            public ArrayList<Integer> get() {
                return Lists.newArrayList((Object[])new Integer[]{0});
            }
        };
        Function<List<Integer>, List<Integer>> addElementFunction = new Function<List<Integer>, List<Integer>>(){

            public List<Integer> apply(List<Integer> list) {
                ArrayList result = Lists.newArrayList(list);
                result.add(1);
                return result;
            }
        };
        Supplier addSupplier = Suppliers.compose((Function)addElementFunction, (Supplier)listSupplier);
        List result = (List)addSupplier.get();
        SuppliersTest.assertEquals((Object)0, result.get(0));
        SuppliersTest.assertEquals((Object)1, result.get(1));
    }

    public void testMemoize() {
        CountingSupplier countingSupplier = new CountingSupplier();
        Supplier memoizedSupplier = Suppliers.memoize((Supplier)countingSupplier);
        this.checkMemoize(countingSupplier, (Supplier<Integer>)memoizedSupplier);
    }

    public void testMemoize_redudantly() {
        CountingSupplier countingSupplier = new CountingSupplier();
        Supplier memoizedSupplier = Suppliers.memoize((Supplier)countingSupplier);
        SuppliersTest.assertSame((Object)memoizedSupplier, (Object)Suppliers.memoize((Supplier)memoizedSupplier));
    }

    @GwtIncompatible(value="SerializableTester")
    public void testMemoizeSerialized() {
        CountingSupplier countingSupplier = new CountingSupplier();
        Supplier memoizedSupplier = Suppliers.memoize((Supplier)countingSupplier);
        this.checkMemoize(countingSupplier, (Supplier<Integer>)memoizedSupplier);
        memoizedSupplier.get();
        Supplier copy = (Supplier)SerializableTester.reserialize((Object)memoizedSupplier);
        memoizedSupplier.get();
        CountingSupplier countingCopy = (CountingSupplier)((Suppliers.MemoizingSupplier)copy).delegate;
        this.checkMemoize(countingCopy, (Supplier<Integer>)copy);
    }

    private void checkMemoize(CountingSupplier countingSupplier, Supplier<Integer> memoizedSupplier) {
        SuppliersTest.assertEquals((int)0, (int)countingSupplier.calls);
        SuppliersTest.assertEquals((int)10, (int)((Integer)memoizedSupplier.get()));
        SuppliersTest.assertEquals((int)1, (int)countingSupplier.calls);
        SuppliersTest.assertEquals((int)10, (int)((Integer)memoizedSupplier.get()));
        SuppliersTest.assertEquals((int)1, (int)countingSupplier.calls);
    }

    public void testMemoizeExceptionThrown() {
        Supplier<Integer> exceptingSupplier = new Supplier<Integer>(){

            public Integer get() {
                throw new NullPointerException();
            }
        };
        Supplier memoizedSupplier = Suppliers.memoize((Supplier)exceptingSupplier);
        for (int i = 0; i < 2; ++i) {
            try {
                memoizedSupplier.get();
                SuppliersTest.fail((String)"failed to throw NullPointerException");
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    @GwtIncompatible(value="Thread.sleep")
    public void testMemoizeWithExpiration() throws InterruptedException {
        CountingSupplier countingSupplier = new CountingSupplier();
        Supplier memoizedSupplier = Suppliers.memoizeWithExpiration((Supplier)countingSupplier, (long)75L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.checkExpiration(countingSupplier, (Supplier<Integer>)memoizedSupplier);
    }

    @GwtIncompatible(value="Thread.sleep, SerializationTester")
    public void testMemoizeWithExpirationSerialized() throws InterruptedException {
        CountingSupplier countingSupplier = new CountingSupplier();
        Supplier memoizedSupplier = Suppliers.memoizeWithExpiration((Supplier)countingSupplier, (long)75L, (TimeUnit)TimeUnit.MILLISECONDS);
        memoizedSupplier.get();
        Supplier copy = (Supplier)SerializableTester.reserialize((Object)memoizedSupplier);
        memoizedSupplier.get();
        CountingSupplier countingCopy = (CountingSupplier)((Suppliers.ExpiringMemoizingSupplier)copy).delegate;
        this.checkExpiration(countingCopy, (Supplier<Integer>)copy);
    }

    @GwtIncompatible(value="Thread.sleep")
    private void checkExpiration(CountingSupplier countingSupplier, Supplier<Integer> memoizedSupplier) throws InterruptedException {
        SuppliersTest.assertEquals((int)0, (int)countingSupplier.calls);
        SuppliersTest.assertEquals((int)10, (int)((Integer)memoizedSupplier.get()));
        SuppliersTest.assertEquals((int)1, (int)countingSupplier.calls);
        SuppliersTest.assertEquals((int)10, (int)((Integer)memoizedSupplier.get()));
        SuppliersTest.assertEquals((int)1, (int)countingSupplier.calls);
        Thread.sleep(150L);
        SuppliersTest.assertEquals((int)20, (int)((Integer)memoizedSupplier.get()));
        SuppliersTest.assertEquals((int)2, (int)countingSupplier.calls);
        SuppliersTest.assertEquals((int)20, (int)((Integer)memoizedSupplier.get()));
        SuppliersTest.assertEquals((int)2, (int)countingSupplier.calls);
    }

    public void testOfInstanceSuppliesSameInstance() {
        Object toBeSupplied = new Object();
        Supplier objectSupplier = Suppliers.ofInstance((Object)toBeSupplied);
        SuppliersTest.assertSame((Object)toBeSupplied, (Object)objectSupplier.get());
        SuppliersTest.assertSame((Object)toBeSupplied, (Object)objectSupplier.get());
    }

    public void testOfInstanceSuppliesNull() {
        Supplier nullSupplier = Suppliers.ofInstance(null);
        SuppliersTest.assertNull((Object)nullSupplier.get());
    }

    @GwtIncompatible(value="Thread")
    public void testExpiringMemoizedSupplierThreadSafe() throws Throwable {
        Function<Supplier<Boolean>, Supplier<Boolean>> memoizer = new Function<Supplier<Boolean>, Supplier<Boolean>>(){

            public Supplier<Boolean> apply(Supplier<Boolean> supplier) {
                return Suppliers.memoizeWithExpiration(supplier, (long)Long.MAX_VALUE, (TimeUnit)TimeUnit.NANOSECONDS);
            }
        };
        this.testSupplierThreadSafe(memoizer);
    }

    @GwtIncompatible(value="Thread")
    public void testMemoizedSupplierThreadSafe() throws Throwable {
        Function<Supplier<Boolean>, Supplier<Boolean>> memoizer = new Function<Supplier<Boolean>, Supplier<Boolean>>(){

            public Supplier<Boolean> apply(Supplier<Boolean> supplier) {
                return Suppliers.memoize(supplier);
            }
        };
        this.testSupplierThreadSafe(memoizer);
    }

    @GwtIncompatible(value="Thread")
    public void testSupplierThreadSafe(Function<Supplier<Boolean>, Supplier<Boolean>> memoizer) throws Throwable {
        final AtomicInteger count = new AtomicInteger(0);
        final AtomicReference<Object> thrown = new AtomicReference<Object>(null);
        int numThreads = 3;
        final Thread[] threads = new Thread[3];
        final long timeout = TimeUnit.SECONDS.toNanos(60L);
        Supplier<Boolean> supplier = new Supplier<Boolean>(){

            boolean isWaiting(Thread thread) {
                switch (thread.getState()) {
                    case BLOCKED: 
                    case WAITING: 
                    case TIMED_WAITING: {
                        return true;
                    }
                }
                return false;
            }

            int waitingThreads() {
                int waitingThreads = 0;
                for (Thread thread : threads) {
                    if (!this.isWaiting(thread)) continue;
                    ++waitingThreads;
                }
                return waitingThreads;
            }

            public Boolean get() {
                long t0 = System.nanoTime();
                while (this.waitingThreads() != 2) {
                    if (System.nanoTime() - t0 > timeout) {
                        thrown.set(new TimeoutException("timed out waiting for other threads to block synchronizing on supplier"));
                        break;
                    }
                    Thread.yield();
                }
                count.getAndIncrement();
                return Boolean.TRUE;
            }
        };
        final Supplier memoizedSupplier = (Supplier)memoizer.apply((Object)supplier);
        for (int i = 0; i < 3; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    Assert.assertSame((Object)Boolean.TRUE, (Object)memoizedSupplier.get());
                }
            };
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        if (thrown.get() != null) {
            throw (Throwable)thrown.get();
        }
        SuppliersTest.assertEquals((int)1, (int)count.get());
    }

    @GwtIncompatible(value="Thread")
    public void testSynchronizedSupplierThreadSafe() throws InterruptedException {
        Supplier<Integer> nonThreadSafe = new Supplier<Integer>(){
            int counter = 0;

            public Integer get() {
                int nextValue = this.counter + 1;
                Thread.yield();
                this.counter = nextValue;
                return this.counter;
            }
        };
        int numThreads = 10;
        int iterations = 1000;
        Thread[] threads = new Thread[10];
        for (int i = 0; i < 10; ++i) {
            threads[i] = new Thread((Supplier)nonThreadSafe){
                final /* synthetic */ Supplier val$nonThreadSafe;
                {
                    this.val$nonThreadSafe = supplier;
                }

                @Override
                public void run() {
                    for (int j = 0; j < 1000; ++j) {
                        Suppliers.synchronizedSupplier((Supplier)this.val$nonThreadSafe).get();
                    }
                }
            };
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        SuppliersTest.assertEquals((int)10001, (int)((Integer)nonThreadSafe.get()));
    }

    public void testSupplierFunction() {
        Supplier supplier = Suppliers.ofInstance((Object)14);
        Function supplierFunction = Suppliers.supplierFunction();
        SuppliersTest.assertEquals((int)14, (int)((Integer)supplierFunction.apply((Object)supplier)));
    }

    @GwtIncompatible(value="SerializationTester")
    public void testSerialization() {
        SuppliersTest.assertEquals((Object)5, (Object)((Supplier)SerializableTester.reserialize((Object)Suppliers.ofInstance((Object)5))).get());
        SuppliersTest.assertEquals((Object)5, (Object)((Supplier)SerializableTester.reserialize((Object)Suppliers.compose((Function)Functions.identity(), (Supplier)Suppliers.ofInstance((Object)5)))).get());
        SuppliersTest.assertEquals((Object)5, (Object)((Supplier)SerializableTester.reserialize((Object)Suppliers.memoize((Supplier)Suppliers.ofInstance((Object)5)))).get());
        SuppliersTest.assertEquals((Object)5, (Object)((Supplier)SerializableTester.reserialize((Object)Suppliers.memoizeWithExpiration((Supplier)Suppliers.ofInstance((Object)5), (long)30L, (TimeUnit)TimeUnit.SECONDS))).get());
        SuppliersTest.assertEquals((Object)5, (Object)((Supplier)SerializableTester.reserialize((Object)Suppliers.synchronizedSupplier((Supplier)Suppliers.ofInstance((Object)5)))).get());
    }

    @GwtIncompatible(value="reflection")
    public void testSuppliersNullChecks() throws Exception {
        new ClassSanityTester().forAllPublicStaticMethods(Suppliers.class).testNulls();
    }

    @GwtIncompatible(value="reflection")
    public void testSuppliersSerializable() throws Exception {
        new ClassSanityTester().forAllPublicStaticMethods(Suppliers.class).testSerializable();
    }

    public void testOfInstance_equals() {
        new EqualsTester().addEqualityGroup(new Object[]{Suppliers.ofInstance((Object)"foo"), Suppliers.ofInstance((Object)"foo")}).addEqualityGroup(new Object[]{Suppliers.ofInstance((Object)"bar")}).testEquals();
    }

    public void testCompose_equals() {
        new EqualsTester().addEqualityGroup(new Object[]{Suppliers.compose((Function)Functions.constant((Object)1), (Supplier)Suppliers.ofInstance((Object)"foo")), Suppliers.compose((Function)Functions.constant((Object)1), (Supplier)Suppliers.ofInstance((Object)"foo"))}).addEqualityGroup(new Object[]{Suppliers.compose((Function)Functions.constant((Object)2), (Supplier)Suppliers.ofInstance((Object)"foo"))}).addEqualityGroup(new Object[]{Suppliers.compose((Function)Functions.constant((Object)1), (Supplier)Suppliers.ofInstance((Object)"bar"))}).testEquals();
    }

    static class CountingSupplier
    implements Supplier<Integer>,
    Serializable {
        private static final long serialVersionUID = 0L;
        transient int calls = 0;

        CountingSupplier() {
        }

        public Integer get() {
            ++this.calls;
            return this.calls * 10;
        }
    }
}

