/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.testing.NullPointerTester;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class ThrowablesTest
extends TestCase {
    public void testPropagateIfPossible_NoneDeclared_NoneThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t);
                    throw new SomeChainingException(t);
                }
            }
        };
        sample.noneDeclared();
    }

    public void testPropagateIfPossible_NoneDeclared_UncheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_NoneDeclared_UndeclaredThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsUndeclaredChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeChainingException someChainingException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_OneDeclared_NoneThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        sample.oneDeclared();
    }

    public void testPropagateIfPossible_OneDeclared_UncheckedThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_OneDeclared_CheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_OneDeclared_UndeclaredThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUndeclaredChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeChainingException someChainingException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_TwoDeclared_NoneThrown() throws SomeCheckedException, SomeOtherCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        sample.twoDeclared();
    }

    public void testPropagateIfPossible_TwoDeclared_UncheckedThrown() throws SomeCheckedException, SomeOtherCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.twoDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_TwoDeclared_CheckedThrown() throws SomeOtherCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.twoDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_TwoDeclared_OtherCheckedThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsOtherChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.twoDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeOtherCheckedException someOtherCheckedException) {
            // empty catch block
        }
    }

    public void testPropageIfPossible_null() throws SomeCheckedException {
        Throwables.propagateIfPossible(null);
        Throwables.propagateIfPossible(null, SomeCheckedException.class);
        Throwables.propagateIfPossible(null, SomeCheckedException.class, SomeUncheckedException.class);
    }

    public void testPropagate_NoneDeclared_NoneThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        sample.noneDeclared();
    }

    public void testPropagate_NoneDeclared_UncheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testPropagate_NoneDeclared_ErrorThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsError();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeError someError) {
            // empty catch block
        }
    }

    public void testPropagate_NoneDeclared_CheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (RuntimeException expected) {
            ThrowablesTest.assertTrue((boolean)(expected.getCause() instanceof SomeCheckedException));
        }
    }

    public void testPropagateIfInstanceOf_NoneThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        sample.oneDeclared();
    }

    public void testPropagateIfInstanceOf_DeclaredThrown() {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfInstanceOf_UncheckedThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfInstanceOf_UndeclaredThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsOtherChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (RuntimeException e) {
            ThrowablesTest.assertTrue((boolean)(e.getCause() instanceof SomeOtherCheckedException));
        }
    }

    public void testPropageIfInstanceOf_null() throws SomeCheckedException {
        Throwables.propagateIfInstanceOf(null, SomeCheckedException.class);
    }

    public void testGetRootCause_NoCause() {
        SomeCheckedException exception = new SomeCheckedException();
        ThrowablesTest.assertSame((Object)exception, (Object)Throwables.getRootCause((Throwable)exception));
    }

    public void testGetRootCause_SingleWrapped() {
        SomeCheckedException cause = new SomeCheckedException();
        SomeChainingException exception = new SomeChainingException(cause);
        ThrowablesTest.assertSame((Object)cause, (Object)Throwables.getRootCause((Throwable)exception));
    }

    public void testGetRootCause_DoubleWrapped() {
        SomeCheckedException cause = new SomeCheckedException();
        SomeChainingException exception = new SomeChainingException(new SomeChainingException(cause));
        ThrowablesTest.assertSame((Object)cause, (Object)Throwables.getRootCause((Throwable)exception));
    }

    static void methodThatDoesntThrowAnything() {
    }

    static void methodThatThrowsError() {
        throw new SomeError();
    }

    static void methodThatThrowsUnchecked() {
        throw new SomeUncheckedException();
    }

    static void methodThatThrowsChecked() throws SomeCheckedException {
        throw new SomeCheckedException();
    }

    static void methodThatThrowsOtherChecked() throws SomeOtherCheckedException {
        throw new SomeOtherCheckedException();
    }

    static void methodThatThrowsUndeclaredChecked() throws SomeUndeclaredCheckedException {
        throw new SomeUndeclaredCheckedException();
    }

    public void testGetStackTraceAsString() {
        class StackTraceException
        extends Exception {
            StackTraceException(String message) {
                super(message);
            }
        }
        StackTraceException e = new StackTraceException("my message");
        String string = String.valueOf(String.valueOf(e.getClass().getName()));
        String string2 = String.valueOf(String.valueOf(e.getMessage()));
        String firstLine = Pattern.quote(new StringBuilder(2 + string.length() + string2.length()).append(string).append(": ").append(string2).toString());
        String string3 = String.valueOf(String.valueOf(ThrowablesTest.class.getName()));
        String secondLine = new StringBuilder(10 + string3.length()).append("\\s*at ").append(string3).append("\\..*").toString();
        String moreLines = "(?:.*\n?)*";
        String string4 = String.valueOf(String.valueOf(firstLine));
        String string5 = String.valueOf(String.valueOf(secondLine));
        String string6 = String.valueOf(String.valueOf(moreLines));
        String expected = new StringBuilder(2 + string4.length() + string5.length() + string6.length()).append(string4).append("\n").append(string5).append("\n").append(string6).toString();
        ThrowablesTest.assertTrue((boolean)Throwables.getStackTraceAsString((Throwable)e).matches(expected));
    }

    public void testGetCausalChain() {
        FileNotFoundException fnfe = new FileNotFoundException();
        IllegalArgumentException iae = new IllegalArgumentException(fnfe);
        RuntimeException re = new RuntimeException(iae);
        IllegalStateException ex = new IllegalStateException(re);
        ThrowablesTest.assertEquals(Arrays.asList(ex, re, iae, fnfe), (Object)Throwables.getCausalChain((Throwable)ex));
        ThrowablesTest.assertSame((Object)fnfe, (Object)Iterables.getOnlyElement((Iterable)Throwables.getCausalChain((Throwable)fnfe)));
        try {
            Throwables.getCausalChain(null);
            ThrowablesTest.fail((String)"Should have throw NPE");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        List causes = Throwables.getCausalChain((Throwable)ex);
        try {
            causes.add(new RuntimeException());
            ThrowablesTest.fail((String)"List should be unmodifiable");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
    }

    public void testNullPointers() {
        new NullPointerTester().testAllPublicStaticMethods(Throwables.class);
    }

    static class Sample {
        Sample() {
        }

        void noneDeclared() {
        }

        void oneDeclared() throws SomeCheckedException {
        }

        void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
        }
    }

    private static class SomeChainingException
    extends RuntimeException {
        public SomeChainingException(Throwable cause) {
            super(cause);
        }
    }

    private static class SomeUndeclaredCheckedException
    extends Exception {
        private SomeUndeclaredCheckedException() {
        }
    }

    private static class SomeUncheckedException
    extends RuntimeException {
        private SomeUncheckedException() {
        }
    }

    private static class SomeOtherCheckedException
    extends Exception {
        private SomeOtherCheckedException() {
        }
    }

    private static class SomeCheckedException
    extends Exception {
        private SomeCheckedException() {
        }
    }

    private static class SomeError
    extends Error {
        private SomeError() {
        }
    }
}

