/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.AbstractCache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class AbstractCacheTest
extends TestCase {
    public void testGetIfPresent() {
        final AtomicReference<Object> valueRef = new AtomicReference<Object>();
        AbstractCache<Object, Object> cache = new AbstractCache<Object, Object>(){

            public Object getIfPresent(Object key) {
                return valueRef.get();
            }
        };
        AbstractCacheTest.assertNull((Object)cache.getIfPresent(new Object()));
        Object newValue = new Object();
        valueRef.set(newValue);
        AbstractCacheTest.assertSame((Object)newValue, (Object)cache.getIfPresent(new Object()));
    }

    public void testGetAllPresent_empty() {
        AbstractCache<Object, Object> cache = new AbstractCache<Object, Object>(){

            public Object getIfPresent(Object key) {
                return null;
            }
        };
        AbstractCacheTest.assertEquals((Object)ImmutableMap.of(), (Object)cache.getAllPresent((Iterable)ImmutableList.of((Object)new Object())));
    }

    public void testGetAllPresent_cached() {
        final Object cachedKey = new Object();
        final Object cachedValue = new Object();
        AbstractCache<Object, Object> cache = new AbstractCache<Object, Object>(){

            public Object getIfPresent(Object key) {
                return cachedKey.equals(key) ? cachedValue : null;
            }
        };
        AbstractCacheTest.assertEquals((Object)ImmutableMap.of((Object)cachedKey, (Object)cachedValue), (Object)cache.getAllPresent((Iterable)ImmutableList.of((Object)cachedKey, (Object)new Object())));
    }

    public void testInvalidateAll() {
        final ArrayList invalidated = Lists.newArrayList();
        AbstractCache<Integer, Integer> cache = new AbstractCache<Integer, Integer>(){

            public Integer getIfPresent(Object key) {
                throw new UnsupportedOperationException();
            }

            public void invalidate(Object key) {
                invalidated.add(key);
            }
        };
        ImmutableList toInvalidate = ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4);
        cache.invalidateAll((Iterable)toInvalidate);
        AbstractCacheTest.assertEquals((Object)toInvalidate, (Object)invalidated);
    }

    public void testEmptySimpleStats() {
        AbstractCache.SimpleStatsCounter counter = new AbstractCache.SimpleStatsCounter();
        CacheStats stats = counter.snapshot();
        AbstractCacheTest.assertEquals((long)0L, (long)stats.requestCount());
        AbstractCacheTest.assertEquals((long)0L, (long)stats.hitCount());
        AbstractCacheTest.assertEquals((Object)1.0, (Object)stats.hitRate());
        AbstractCacheTest.assertEquals((long)0L, (long)stats.missCount());
        AbstractCacheTest.assertEquals((Object)0.0, (Object)stats.missRate());
        AbstractCacheTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        AbstractCacheTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        AbstractCacheTest.assertEquals((long)0L, (long)stats.loadCount());
        AbstractCacheTest.assertEquals((long)0L, (long)stats.totalLoadTime());
        AbstractCacheTest.assertEquals((Object)0.0, (Object)stats.averageLoadPenalty());
        AbstractCacheTest.assertEquals((long)0L, (long)stats.evictionCount());
    }

    public void testSingleSimpleStats() {
        int i;
        AbstractCache.SimpleStatsCounter counter = new AbstractCache.SimpleStatsCounter();
        for (i = 0; i < 11; ++i) {
            counter.recordHits(1);
        }
        for (i = 0; i < 13; ++i) {
            counter.recordLoadSuccess((long)i);
        }
        for (i = 0; i < 17; ++i) {
            counter.recordLoadException((long)i);
        }
        for (i = 0; i < 23; ++i) {
            counter.recordMisses(1);
        }
        for (i = 0; i < 27; ++i) {
            counter.recordEviction();
        }
        CacheStats stats = counter.snapshot();
        int requestCount = 34;
        AbstractCacheTest.assertEquals((long)requestCount, (long)stats.requestCount());
        AbstractCacheTest.assertEquals((long)11L, (long)stats.hitCount());
        AbstractCacheTest.assertEquals((Object)(11.0 / (double)requestCount), (Object)stats.hitRate());
        int missCount = 23;
        AbstractCacheTest.assertEquals((long)missCount, (long)stats.missCount());
        AbstractCacheTest.assertEquals((Object)((double)missCount / (double)requestCount), (Object)stats.missRate());
        AbstractCacheTest.assertEquals((long)13L, (long)stats.loadSuccessCount());
        AbstractCacheTest.assertEquals((long)17L, (long)stats.loadExceptionCount());
        AbstractCacheTest.assertEquals((long)30L, (long)stats.loadCount());
        AbstractCacheTest.assertEquals((long)214L, (long)stats.totalLoadTime());
        AbstractCacheTest.assertEquals((Object)7.133333333333334, (Object)stats.averageLoadPenalty());
        AbstractCacheTest.assertEquals((long)27L, (long)stats.evictionCount());
    }

    public void testSimpleStatsIncrementBy() {
        int i;
        int i2;
        long totalLoadTime = 0L;
        AbstractCache.SimpleStatsCounter counter1 = new AbstractCache.SimpleStatsCounter();
        for (i2 = 0; i2 < 11; ++i2) {
            counter1.recordHits(1);
        }
        for (i2 = 0; i2 < 13; ++i2) {
            counter1.recordLoadSuccess((long)i2);
            totalLoadTime += (long)i2;
        }
        for (i2 = 0; i2 < 17; ++i2) {
            counter1.recordLoadException((long)i2);
            totalLoadTime += (long)i2;
        }
        for (i2 = 0; i2 < 19; ++i2) {
            counter1.recordMisses(1);
        }
        for (i2 = 0; i2 < 23; ++i2) {
            counter1.recordEviction();
        }
        AbstractCache.SimpleStatsCounter counter2 = new AbstractCache.SimpleStatsCounter();
        for (i = 0; i < 27; ++i) {
            counter2.recordHits(1);
        }
        for (i = 0; i < 31; ++i) {
            counter2.recordLoadSuccess((long)i);
            totalLoadTime += (long)i;
        }
        for (i = 0; i < 37; ++i) {
            counter2.recordLoadException((long)i);
            totalLoadTime += (long)i;
        }
        for (i = 0; i < 41; ++i) {
            counter2.recordMisses(1);
        }
        for (i = 0; i < 43; ++i) {
            counter2.recordEviction();
        }
        counter1.incrementBy((AbstractCache.StatsCounter)counter2);
        AbstractCacheTest.assertEquals((Object)new CacheStats(38L, 60L, 44L, 54L, totalLoadTime, 66L), (Object)counter1.snapshot());
    }
}

