/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.CacheTesting;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.LocalCache;
import com.google.common.cache.TestingCacheLoaders;
import com.google.common.cache.TestingRemovalListeners;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.testing.FakeTicker;
import com.google.common.testing.TestLogHandler;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import junit.framework.TestCase;

public class CacheLoadingTest
extends TestCase {
    TestLogHandler logHandler;

    public void setUp() throws Exception {
        super.setUp();
        this.logHandler = new TestLogHandler();
        LocalCache.logger.addHandler((Handler)this.logHandler);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        Thread.currentThread();
        Thread.interrupted();
        LocalCache.logger.removeHandler((Handler)this.logHandler);
    }

    private Throwable popLoggedThrowable() {
        List logRecords = this.logHandler.getStoredLogRecords();
        CacheLoadingTest.assertEquals((int)1, (int)logRecords.size());
        LogRecord logRecord = (LogRecord)logRecords.get(0);
        this.logHandler.clear();
        return logRecord.getThrown();
    }

    private void checkNothingLogged() {
        CacheLoadingTest.assertTrue((boolean)this.logHandler.getStoredLogRecords().isEmpty());
    }

    private void checkLoggedCause(Throwable t) {
        CacheLoadingTest.assertSame((Object)t, (Object)this.popLoggedThrowable().getCause());
    }

    private void checkLoggedInvalidLoad() {
        CacheLoadingTest.assertTrue((boolean)(this.popLoggedThrowable() instanceof CacheLoader.InvalidCacheLoadException));
    }

    public void testLoad() throws ExecutionException {
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(TestingCacheLoaders.identityLoader());
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        Object key = new Object();
        CacheLoadingTest.assertSame((Object)key, (Object)cache.get(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        key = new Object();
        CacheLoadingTest.assertSame((Object)key, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        key = new Object();
        cache.refresh(key);
        this.checkNothingLogged();
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)key, (Object)cache.get(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
        Object value = new Object();
        CacheLoadingTest.assertSame((Object)key, (Object)cache.get(key, CacheLoadingTest.throwing(new Exception())));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.hitCount());
        key = new Object();
        CacheLoadingTest.assertSame((Object)value, (Object)cache.get(key, Callables.returning((Object)value)));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)3L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)4L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.hitCount());
    }

    public void testReload() throws ExecutionException {
        final Object one = new Object();
        final Object two = new Object();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return Futures.immediateFuture((Object)two);
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(key);
        this.checkNothingLogged();
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)two, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
    }

    public void testRefresh() {
        final Object one = new Object();
        final Object two = new Object();
        FakeTicker ticker = new FakeTicker();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return Futures.immediateFuture((Object)two);
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().ticker((Ticker)ticker).refreshAfterWrite(1L, TimeUnit.MILLISECONDS).build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)two, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)two, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.hitCount());
    }

    public void testRefresh_getIfPresent() {
        final Object one = new Object();
        final Object two = new Object();
        FakeTicker ticker = new FakeTicker();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return Futures.immediateFuture((Object)two);
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().ticker((Ticker)ticker).refreshAfterWrite(1L, TimeUnit.MILLISECONDS).build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getIfPresent(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)two, (Object)cache.getIfPresent(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)two, (Object)cache.getIfPresent(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.hitCount());
    }

    public void testBulkLoad_default() throws ExecutionException {
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(TestingCacheLoaders.identityLoader());
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertEquals((Object)ImmutableMap.of(), (Object)cache.getAll((Iterable)ImmutableList.of()));
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)1), (Object)cache.getAll(Arrays.asList(1)));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3, (Object)4, (Object)4), (Object)cache.getAll(Arrays.asList(1, 2, 3, 4)));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)4L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)4L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
        CacheLoadingTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)2, (Object)3, (Object)3), (Object)cache.getAll(Arrays.asList(2, 3)));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)4L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)4L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.hitCount());
        CacheLoadingTest.assertEquals((Object)ImmutableMap.of((Object)4, (Object)4, (Object)5, (Object)5), (Object)cache.getAll(Arrays.asList(4, 5)));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)5L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)5L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)4L, (long)stats.hitCount());
    }

    public void testBulkLoad_loadAll() throws ExecutionException {
        TestingCacheLoaders.IdentityLoader backingLoader = TestingCacheLoaders.identityLoader();
        CacheLoader loader = TestingCacheLoaders.bulkLoader(backingLoader);
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(loader);
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertEquals((Object)ImmutableMap.of(), (Object)cache.getAll((Iterable)ImmutableList.of()));
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)1), (Object)cache.getAll(Arrays.asList(1)));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)1, (Object)2, (Object)2, (Object)3, (Object)3, (Object)4, (Object)4), (Object)cache.getAll(Arrays.asList(1, 2, 3, 4)));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)4L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
        CacheLoadingTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)2, (Object)3, (Object)3), (Object)cache.getAll(Arrays.asList(2, 3)));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)4L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.hitCount());
        CacheLoadingTest.assertEquals((Object)ImmutableMap.of((Object)4, (Object)4, (Object)5, (Object)5), (Object)cache.getAll(Arrays.asList(4, 5)));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)5L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)4L, (long)stats.hitCount());
    }

    public void testBulkLoad_extra() throws ExecutionException {
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) throws Exception {
                return new Object();
            }

            public Map<Object, Object> loadAll(Iterable<? extends Object> keys) throws Exception {
                HashMap result = Maps.newHashMap();
                for (Object object : keys) {
                    Object value = new Object();
                    result.put(object, value);
                    result.put(value, object);
                }
                return result;
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)loader);
        Object[] lookupKeys = new Object[]{new Object(), new Object(), new Object()};
        ImmutableMap result = cache.getAll(Arrays.asList(lookupKeys));
        Truth.assertThat(result.keySet()).has().exactlyAs(Arrays.asList(lookupKeys));
        for (Map.Entry entry : result.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            CacheLoadingTest.assertSame(value, result.get(key));
            CacheLoadingTest.assertNull(result.get(value));
            CacheLoadingTest.assertSame(value, cache.asMap().get(key));
            CacheLoadingTest.assertSame(key, cache.asMap().get(value));
        }
    }

    public void testBulkLoad_clobber() throws ExecutionException {
        final Object extraKey = new Object();
        final Object extraValue = new Object();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) throws Exception {
                throw new AssertionError();
            }

            public Map<Object, Object> loadAll(Iterable<? extends Object> keys) throws Exception {
                HashMap result = Maps.newHashMap();
                for (Object object : keys) {
                    Object value = new Object();
                    result.put(object, value);
                }
                result.put(extraKey, extraValue);
                return result;
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)loader);
        cache.asMap().put(extraKey, extraKey);
        CacheLoadingTest.assertSame((Object)extraKey, cache.asMap().get(extraKey));
        Object[] lookupKeys = new Object[]{new Object(), new Object(), new Object()};
        ImmutableMap result = cache.getAll(Arrays.asList(lookupKeys));
        Truth.assertThat(result.keySet()).has().exactlyAs(Arrays.asList(lookupKeys));
        for (Map.Entry entry : result.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            CacheLoadingTest.assertSame(value, result.get(key));
            CacheLoadingTest.assertSame(value, cache.asMap().get(key));
        }
        CacheLoadingTest.assertNull(result.get(extraKey));
        CacheLoadingTest.assertSame((Object)extraValue, cache.asMap().get(extraKey));
    }

    public void testBulkLoad_clobberNullValue() throws ExecutionException {
        final Object extraKey = new Object();
        final Object extraValue = new Object();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) throws Exception {
                throw new AssertionError();
            }

            public Map<Object, Object> loadAll(Iterable<? extends Object> keys) throws Exception {
                HashMap result = Maps.newHashMap();
                for (Object object : keys) {
                    Object value = new Object();
                    result.put(object, value);
                }
                result.put(extraKey, extraValue);
                result.put(extraValue, null);
                return result;
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)loader);
        cache.asMap().put(extraKey, extraKey);
        CacheLoadingTest.assertSame((Object)extraKey, cache.asMap().get(extraKey));
        Object[] lookupKeys = new Object[]{new Object(), new Object(), new Object()};
        try {
            cache.getAll(Arrays.asList(lookupKeys));
            CacheLoadingTest.fail();
        }
        catch (CacheLoader.InvalidCacheLoadException expected) {
            // empty catch block
        }
        for (Object key : lookupKeys) {
            CacheLoadingTest.assertTrue((boolean)cache.asMap().containsKey(key));
        }
        CacheLoadingTest.assertSame((Object)extraValue, cache.asMap().get(extraKey));
        CacheLoadingTest.assertFalse((boolean)cache.asMap().containsKey(extraValue));
    }

    public void testBulkLoad_clobberNullKey() throws ExecutionException {
        final Object extraKey = new Object();
        final Object extraValue = new Object();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) throws Exception {
                throw new AssertionError();
            }

            public Map<Object, Object> loadAll(Iterable<? extends Object> keys) throws Exception {
                HashMap result = Maps.newHashMap();
                for (Object object : keys) {
                    Object value = new Object();
                    result.put(object, value);
                }
                result.put(extraKey, extraValue);
                result.put(null, extraKey);
                return result;
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)loader);
        cache.asMap().put(extraKey, extraKey);
        CacheLoadingTest.assertSame((Object)extraKey, cache.asMap().get(extraKey));
        Object[] lookupKeys = new Object[]{new Object(), new Object(), new Object()};
        try {
            cache.getAll(Arrays.asList(lookupKeys));
            CacheLoadingTest.fail();
        }
        catch (CacheLoader.InvalidCacheLoadException expected) {
            // empty catch block
        }
        for (Object key : lookupKeys) {
            CacheLoadingTest.assertTrue((boolean)cache.asMap().containsKey(key));
        }
        CacheLoadingTest.assertSame((Object)extraValue, cache.asMap().get(extraKey));
        CacheLoadingTest.assertFalse((boolean)cache.asMap().containsValue(extraKey));
    }

    public void testBulkLoad_partial() throws ExecutionException {
        final Object extraKey = new Object();
        final Object extraValue = new Object();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) throws Exception {
                throw new AssertionError();
            }

            public Map<Object, Object> loadAll(Iterable<? extends Object> keys) throws Exception {
                HashMap result = Maps.newHashMap();
                result.put(extraKey, extraValue);
                return result;
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)loader);
        Object[] lookupKeys = new Object[]{new Object(), new Object(), new Object()};
        try {
            cache.getAll(Arrays.asList(lookupKeys));
            CacheLoadingTest.fail();
        }
        catch (CacheLoader.InvalidCacheLoadException expected) {
            // empty catch block
        }
        CacheLoadingTest.assertSame((Object)extraValue, cache.asMap().get(extraKey));
    }

    public void testLoadNull() throws ExecutionException {
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(TestingCacheLoaders.constantLoader(null));
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.get(new Object());
            CacheLoadingTest.fail();
        }
        catch (CacheLoader.InvalidCacheLoadException expected) {
            // empty catch block
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getUnchecked(new Object());
            CacheLoadingTest.fail();
        }
        catch (CacheLoader.InvalidCacheLoadException expected) {
            // empty catch block
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(new Object());
        this.checkLoggedInvalidLoad();
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.get(new Object(), Callables.returning(null));
            CacheLoadingTest.fail();
        }
        catch (CacheLoader.InvalidCacheLoadException expected) {
            // empty catch block
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)3L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)4L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (CacheLoader.InvalidCacheLoadException invalidCacheLoadException) {
            // empty catch block
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)4L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)5L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
    }

    public void testReloadNull() throws ExecutionException {
        final Object one = new Object();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return null;
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(key);
        this.checkLoggedInvalidLoad();
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
    }

    public void testReloadNullFuture() throws ExecutionException {
        final Object one = new Object();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return Futures.immediateFuture(null);
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(key);
        this.checkLoggedInvalidLoad();
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
    }

    public void testRefreshNull() {
        final Object one = new Object();
        FakeTicker ticker = new FakeTicker();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return Futures.immediateFuture(null);
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().ticker((Ticker)ticker).refreshAfterWrite(1L, TimeUnit.MILLISECONDS).build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.hitCount());
    }

    public void testBulkLoadNull() throws ExecutionException {
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(TestingCacheLoaders.bulkLoader(TestingCacheLoaders.constantLoader(null)));
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (CacheLoader.InvalidCacheLoadException invalidCacheLoadException) {
            // empty catch block
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
    }

    public void testBulkLoadNullMap() throws ExecutionException {
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                throw new AssertionError();
            }

            public Map<Object, Object> loadAll(Iterable<? extends Object> keys) {
                return null;
            }
        });
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (CacheLoader.InvalidCacheLoadException invalidCacheLoadException) {
            // empty catch block
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
    }

    public void testLoadError() throws ExecutionException {
        Error e = new Error();
        CacheLoader loader = TestingCacheLoaders.errorLoader(e);
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(loader);
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.get(new Object());
            CacheLoadingTest.fail();
        }
        catch (ExecutionError expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getUnchecked(new Object());
            CacheLoadingTest.fail();
        }
        catch (ExecutionError expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(new Object());
        this.checkLoggedCause(e);
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        final Error callableError = new Error();
        try {
            cache.get(new Object(), (Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    throw callableError;
                }
            });
            CacheLoadingTest.fail();
        }
        catch (ExecutionError expected) {
            CacheLoadingTest.assertSame((Object)callableError, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)3L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)4L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (ExecutionError expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)4L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)5L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
    }

    public void testReloadError() throws ExecutionException {
        final Object one = new Object();
        final Error e = new Error();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                throw e;
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(key);
        this.checkLoggedCause(e);
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
    }

    public void testReloadFutureError() throws ExecutionException {
        final Object one = new Object();
        final Error e = new Error();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(key);
        this.checkLoggedCause(e);
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
    }

    public void testRefreshError() {
        final Object one = new Object();
        final Error e = new Error();
        FakeTicker ticker = new FakeTicker();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().ticker((Ticker)ticker).refreshAfterWrite(1L, TimeUnit.MILLISECONDS).build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.hitCount());
    }

    public void testBulkLoadError() throws ExecutionException {
        Error e = new Error();
        CacheLoader loader = TestingCacheLoaders.errorLoader(e);
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(TestingCacheLoaders.bulkLoader(loader));
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (ExecutionError expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
    }

    public void testLoadCheckedException() {
        Exception e = new Exception();
        CacheLoader loader = TestingCacheLoaders.exceptionLoader(e);
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(loader);
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.get(new Object());
            CacheLoadingTest.fail();
        }
        catch (ExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getUnchecked(new Object());
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(new Object());
        this.checkLoggedCause(e);
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        Exception callableException = new Exception();
        try {
            cache.get(new Object(), CacheLoadingTest.throwing(callableException));
            CacheLoadingTest.fail();
        }
        catch (ExecutionException expected) {
            CacheLoadingTest.assertSame((Object)callableException, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)3L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)4L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (ExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)4L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)5L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
    }

    public void testLoadInterruptedException() {
        InterruptedException e = new InterruptedException();
        CacheLoader loader = TestingCacheLoaders.exceptionLoader(e);
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(loader);
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        Thread.currentThread();
        CacheLoadingTest.assertFalse((boolean)Thread.interrupted());
        try {
            cache.get(new Object());
            CacheLoadingTest.fail();
        }
        catch (ExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        Thread.currentThread();
        CacheLoadingTest.assertTrue((boolean)Thread.interrupted());
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getUnchecked(new Object());
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        Thread.currentThread();
        CacheLoadingTest.assertTrue((boolean)Thread.interrupted());
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(new Object());
        Thread.currentThread();
        CacheLoadingTest.assertTrue((boolean)Thread.interrupted());
        this.checkLoggedCause(e);
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        InterruptedException callableException = new InterruptedException();
        try {
            cache.get(new Object(), CacheLoadingTest.throwing(callableException));
            CacheLoadingTest.fail();
        }
        catch (ExecutionException expected) {
            CacheLoadingTest.assertSame((Object)callableException, (Object)expected.getCause());
        }
        Thread.currentThread();
        CacheLoadingTest.assertTrue((boolean)Thread.interrupted());
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)3L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)4L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (ExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        Thread.currentThread();
        CacheLoadingTest.assertTrue((boolean)Thread.interrupted());
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)4L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)5L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
    }

    public void testReloadCheckedException() {
        final Object one = new Object();
        final Exception e = new Exception();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) throws Exception {
                throw e;
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(key);
        this.checkLoggedCause(e);
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
    }

    public void testReloadFutureCheckedException() {
        final Object one = new Object();
        final Exception e = new Exception();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(key);
        this.checkLoggedCause(e);
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
    }

    public void testRefreshCheckedException() {
        final Object one = new Object();
        final Exception e = new Exception();
        FakeTicker ticker = new FakeTicker();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().ticker((Ticker)ticker).refreshAfterWrite(1L, TimeUnit.MILLISECONDS).build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.hitCount());
    }

    public void testBulkLoadCheckedException() {
        Exception e = new Exception();
        CacheLoader loader = TestingCacheLoaders.exceptionLoader(e);
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(TestingCacheLoaders.bulkLoader(loader));
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (ExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
    }

    public void testBulkLoadInterruptedException() {
        InterruptedException e = new InterruptedException();
        CacheLoader loader = TestingCacheLoaders.exceptionLoader(e);
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(TestingCacheLoaders.bulkLoader(loader));
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (ExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        Thread.currentThread();
        CacheLoadingTest.assertTrue((boolean)Thread.interrupted());
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
    }

    public void testLoadUncheckedException() throws ExecutionException {
        RuntimeException e = new RuntimeException();
        CacheLoader loader = TestingCacheLoaders.exceptionLoader(e);
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(loader);
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.get(new Object());
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getUnchecked(new Object());
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(new Object());
        this.checkLoggedCause(e);
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)2L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        RuntimeException callableException = new RuntimeException();
        try {
            cache.get(new Object(), CacheLoadingTest.throwing(callableException));
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            CacheLoadingTest.assertSame((Object)callableException, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)3L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)4L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)4L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)5L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
    }

    public void testReloadUncheckedException() throws ExecutionException {
        final Object one = new Object();
        final RuntimeException e = new RuntimeException();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) throws Exception {
                throw e;
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(key);
        this.checkLoggedCause(e);
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
    }

    public void testReloadFutureUncheckedException() throws ExecutionException {
        final Object one = new Object();
        final RuntimeException e = new RuntimeException();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        cache.refresh(key);
        this.checkLoggedCause(e);
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
    }

    public void testRefreshUncheckedException() {
        final Object one = new Object();
        final RuntimeException e = new RuntimeException();
        FakeTicker ticker = new FakeTicker();
        CacheLoader<Object, Object> loader = new CacheLoader<Object, Object>(){

            public Object load(Object key) {
                return one;
            }

            public ListenableFuture<Object> reload(Object key, Object oldValue) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().ticker((Ticker)ticker).refreshAfterWrite(1L, TimeUnit.MILLISECONDS).build((CacheLoader)loader);
        Object key = new Object();
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.hitCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheLoadingTest.assertSame((Object)one, (Object)cache.getUnchecked(key));
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)2L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)3L, (long)stats.hitCount());
    }

    public void testBulkLoadUncheckedException() throws ExecutionException {
        RuntimeException e = new RuntimeException();
        CacheLoader loader = TestingCacheLoaders.exceptionLoader(e);
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(TestingCacheLoaders.bulkLoader(loader));
        CacheStats stats = cache.stats();
        CacheLoadingTest.assertEquals((long)0L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
        try {
            cache.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            CacheLoadingTest.assertSame((Object)e, (Object)expected.getCause());
        }
        stats = cache.stats();
        CacheLoadingTest.assertEquals((long)1L, (long)stats.missCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.loadSuccessCount());
        CacheLoadingTest.assertEquals((long)1L, (long)stats.loadExceptionCount());
        CacheLoadingTest.assertEquals((long)0L, (long)stats.hitCount());
    }

    public void testReloadAfterFailure() throws ExecutionException {
        final AtomicInteger count = new AtomicInteger();
        final IllegalStateException e = new IllegalStateException("exception to trigger failure on first load()");
        CacheLoader<Integer, String> failOnceFunction = new CacheLoader<Integer, String>(){

            public String load(Integer key) throws Exception {
                if (count.getAndIncrement() == 0) {
                    throw e;
                }
                return key.toString();
            }
        };
        TestingRemovalListeners.CountingRemovalListener removalListener = TestingRemovalListeners.countingRemovalListener();
        LoadingCache cache = CacheBuilder.newBuilder().removalListener(removalListener).build((CacheLoader)failOnceFunction);
        try {
            cache.getUnchecked((Object)1);
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException ue) {
            CacheLoadingTest.assertSame((Object)e, (Object)ue.getCause());
        }
        CacheLoadingTest.assertEquals((String)"1", (String)((String)cache.getUnchecked((Object)1)));
        CacheLoadingTest.assertEquals((int)0, (int)removalListener.getCount());
        count.set(0);
        cache.refresh((Object)2);
        this.checkLoggedCause(e);
        CacheLoadingTest.assertEquals((String)"2", (String)((String)cache.getUnchecked((Object)2)));
        CacheLoadingTest.assertEquals((int)0, (int)removalListener.getCount());
    }

    public void testReloadAfterValueReclamation() throws InterruptedException, ExecutionException {
        Object oldValue;
        int i;
        TestingCacheLoaders.CountingLoader countingLoader = new TestingCacheLoaders.CountingLoader();
        LoadingCache cache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)countingLoader);
        ConcurrentMap map = cache.asMap();
        int iterations = 10;
        WeakReference<Object> ref = new WeakReference<Object>(null);
        int expectedComputations = 0;
        for (i = 0; i < iterations; ++i) {
            oldValue = ref.get();
            if (oldValue == null) {
                ++expectedComputations;
            }
            ref = new WeakReference<Object>(cache.getUnchecked((Object)1));
            oldValue = null;
            Thread.sleep(i);
            System.gc();
        }
        CacheLoadingTest.assertEquals((int)expectedComputations, (int)countingLoader.getCount());
        for (i = 0; i < iterations; ++i) {
            oldValue = ref.get();
            if (oldValue == null) {
                ++expectedComputations;
            }
            cache.refresh((Object)1);
            this.checkNothingLogged();
            ref = new WeakReference(map.get(1));
            oldValue = null;
            Thread.sleep(i);
            System.gc();
        }
        CacheLoadingTest.assertEquals((int)expectedComputations, (int)countingLoader.getCount());
    }

    public void testReloadAfterSimulatedValueReclamation() throws ExecutionException {
        TestingCacheLoaders.CountingLoader countingLoader = new TestingCacheLoaders.CountingLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).weakValues().build((CacheLoader)countingLoader);
        Object key = new Object();
        CacheLoadingTest.assertNotNull((Object)cache.getUnchecked(key));
        CacheTesting.simulateValueReclamation(cache, key);
        CacheLoadingTest.assertNotNull((Object)cache.getUnchecked(key));
        CacheLoadingTest.assertEquals((long)1L, (long)cache.size());
        CacheLoadingTest.assertEquals((int)2, (int)countingLoader.getCount());
        CacheTesting.simulateValueReclamation(cache, key);
        cache.refresh(key);
        this.checkNothingLogged();
        CacheLoadingTest.assertEquals((long)1L, (long)cache.size());
        CacheLoadingTest.assertEquals((int)3, (int)countingLoader.getCount());
    }

    public void testReloadAfterSimulatedKeyReclamation() throws ExecutionException {
        TestingCacheLoaders.CountingLoader countingLoader = new TestingCacheLoaders.CountingLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).weakKeys().build((CacheLoader)countingLoader);
        Object key = new Object();
        CacheLoadingTest.assertNotNull((Object)cache.getUnchecked(key));
        CacheLoadingTest.assertEquals((long)1L, (long)cache.size());
        CacheTesting.simulateKeyReclamation(cache, key);
        CacheLoadingTest.assertNotNull((Object)cache.getUnchecked(key));
        CacheLoadingTest.assertEquals((int)2, (int)countingLoader.getCount());
        CacheTesting.simulateKeyReclamation(cache, key);
        cache.refresh(key);
        this.checkNothingLogged();
        CacheLoadingTest.assertEquals((int)3, (int)countingLoader.getCount());
    }

    public void testLoadingExceptionWithCause() {
        Exception cause = new Exception();
        UncheckedExecutionException uee = new UncheckedExecutionException((Throwable)cause);
        ExecutionException ee = new ExecutionException(cause);
        LoadingCache cacheUnchecked = CacheBuilder.newBuilder().build(TestingCacheLoaders.exceptionLoader((Exception)((Object)uee)));
        LoadingCache cacheChecked = CacheBuilder.newBuilder().build(TestingCacheLoaders.exceptionLoader(ee));
        try {
            cacheUnchecked.get(new Object());
            CacheLoadingTest.fail();
        }
        catch (ExecutionException e) {
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException caughtEe) {
            CacheLoadingTest.assertSame((Object)((Object)uee), (Object)caughtEe.getCause());
        }
        try {
            cacheUnchecked.getUnchecked(new Object());
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException caughtUee) {
            CacheLoadingTest.assertSame((Object)((Object)uee), (Object)caughtUee.getCause());
        }
        cacheUnchecked.refresh(new Object());
        this.checkLoggedCause(uee);
        try {
            cacheUnchecked.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (ExecutionException e) {
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException caughtEe) {
            CacheLoadingTest.assertSame((Object)((Object)uee), (Object)caughtEe.getCause());
        }
        try {
            cacheChecked.get(new Object());
            CacheLoadingTest.fail();
        }
        catch (ExecutionException caughtEe) {
            CacheLoadingTest.assertSame((Object)ee, (Object)caughtEe.getCause());
        }
        try {
            cacheChecked.getUnchecked(new Object());
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException caughtUee) {
            CacheLoadingTest.assertSame((Object)ee, (Object)caughtUee.getCause());
        }
        cacheChecked.refresh(new Object());
        this.checkLoggedCause(ee);
        try {
            cacheChecked.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (ExecutionException caughtEe) {
            CacheLoadingTest.assertSame((Object)ee, (Object)caughtEe.getCause());
        }
    }

    public void testBulkLoadingExceptionWithCause() {
        Exception cause = new Exception();
        UncheckedExecutionException uee = new UncheckedExecutionException((Throwable)cause);
        ExecutionException ee = new ExecutionException(cause);
        LoadingCache cacheUnchecked = CacheBuilder.newBuilder().build(TestingCacheLoaders.bulkLoader(TestingCacheLoaders.exceptionLoader((Exception)((Object)uee))));
        LoadingCache cacheChecked = CacheBuilder.newBuilder().build(TestingCacheLoaders.bulkLoader(TestingCacheLoaders.exceptionLoader(ee)));
        try {
            cacheUnchecked.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (ExecutionException e) {
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException caughtEe) {
            CacheLoadingTest.assertSame((Object)((Object)uee), (Object)caughtEe.getCause());
        }
        try {
            cacheChecked.getAll(Arrays.asList(new Object()));
            CacheLoadingTest.fail();
        }
        catch (ExecutionException caughtEe) {
            CacheLoadingTest.assertSame((Object)ee, (Object)caughtEe.getCause());
        }
    }

    public void testConcurrentLoading() throws InterruptedException {
        CacheLoadingTest.testConcurrentLoading((CacheBuilder<Object, Object>)CacheBuilder.newBuilder());
    }

    public void testConcurrentExpirationLoading() throws InterruptedException {
        CacheLoadingTest.testConcurrentLoading((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS));
    }

    private static void testConcurrentLoading(CacheBuilder<Object, Object> builder) throws InterruptedException {
        CacheLoadingTest.testConcurrentLoadingDefault(builder);
        CacheLoadingTest.testConcurrentLoadingNull(builder);
        CacheLoadingTest.testConcurrentLoadingUncheckedException(builder);
        CacheLoadingTest.testConcurrentLoadingCheckedException(builder);
    }

    private static void testConcurrentLoadingDefault(CacheBuilder<Object, Object> builder) throws InterruptedException {
        int count = 10;
        final AtomicInteger callCount = new AtomicInteger();
        final CountDownLatch startSignal = new CountDownLatch(count + 1);
        final Object result = new Object();
        LoadingCache cache = builder.build((CacheLoader)new CacheLoader<String, Object>(){

            public Object load(String key) throws InterruptedException {
                callCount.incrementAndGet();
                startSignal.await();
                return result;
            }
        });
        List<Object> resultArray = CacheLoadingTest.doConcurrentGet(cache, "bar", count, startSignal);
        CacheLoadingTest.assertEquals((int)1, (int)callCount.get());
        for (int i = 0; i < count; ++i) {
            int n = i;
            CacheLoadingTest.assertSame((String)new StringBuilder(41).append("result(").append(n).append(") didn't match expected").toString(), (Object)result, (Object)resultArray.get(i));
        }
    }

    private static void testConcurrentLoadingNull(CacheBuilder<Object, Object> builder) throws InterruptedException {
        int count = 10;
        final AtomicInteger callCount = new AtomicInteger();
        final CountDownLatch startSignal = new CountDownLatch(count + 1);
        LoadingCache cache = builder.build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws InterruptedException {
                callCount.incrementAndGet();
                startSignal.await();
                return null;
            }
        });
        List<Object> result = CacheLoadingTest.doConcurrentGet(cache, "bar", count, startSignal);
        CacheLoadingTest.assertEquals((int)1, (int)callCount.get());
        for (int i = 0; i < count; ++i) {
            CacheLoadingTest.assertTrue((boolean)(result.get(i) instanceof CacheLoader.InvalidCacheLoadException));
        }
        try {
            cache.getUnchecked((Object)"bar");
            CacheLoadingTest.fail();
        }
        catch (CacheLoader.InvalidCacheLoadException expected) {
            // empty catch block
        }
        CacheLoadingTest.assertEquals((int)2, (int)callCount.get());
    }

    private static void testConcurrentLoadingUncheckedException(CacheBuilder<Object, Object> builder) throws InterruptedException {
        int count = 10;
        final AtomicInteger callCount = new AtomicInteger();
        final CountDownLatch startSignal = new CountDownLatch(count + 1);
        final RuntimeException e = new RuntimeException();
        LoadingCache cache = builder.build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws InterruptedException {
                callCount.incrementAndGet();
                startSignal.await();
                throw e;
            }
        });
        List<Object> result = CacheLoadingTest.doConcurrentGet(cache, "bar", count, startSignal);
        CacheLoadingTest.assertEquals((int)1, (int)callCount.get());
        for (int i = 0; i < count; ++i) {
            CacheLoadingTest.assertTrue((boolean)(result.get(i) instanceof UncheckedExecutionException));
            CacheLoadingTest.assertSame((Object)e, (Object)((UncheckedExecutionException)((Object)result.get(i))).getCause());
        }
        try {
            cache.getUnchecked((Object)"bar");
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            // empty catch block
        }
        CacheLoadingTest.assertEquals((int)2, (int)callCount.get());
    }

    private static void testConcurrentLoadingCheckedException(CacheBuilder<Object, Object> builder) throws InterruptedException {
        int count = 10;
        final AtomicInteger callCount = new AtomicInteger();
        final CountDownLatch startSignal = new CountDownLatch(count + 1);
        final IOException e = new IOException();
        LoadingCache cache = builder.build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws IOException, InterruptedException {
                callCount.incrementAndGet();
                startSignal.await();
                throw e;
            }
        });
        List<Object> result = CacheLoadingTest.doConcurrentGet(cache, "bar", count, startSignal);
        CacheLoadingTest.assertEquals((int)1, (int)callCount.get());
        for (int i = 0; i < count; ++i) {
            int mod = i % 3;
            if (mod == 0 || mod == 2) {
                CacheLoadingTest.assertTrue((boolean)(result.get(i) instanceof ExecutionException));
                CacheLoadingTest.assertSame((Object)e, (Object)((ExecutionException)result.get(i)).getCause());
                continue;
            }
            CacheLoadingTest.assertTrue((boolean)(result.get(i) instanceof UncheckedExecutionException));
            CacheLoadingTest.assertSame((Object)e, (Object)((UncheckedExecutionException)((Object)result.get(i))).getCause());
        }
        try {
            cache.getUnchecked((Object)"bar");
            CacheLoadingTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            // empty catch block
        }
        CacheLoadingTest.assertEquals((int)2, (int)callCount.get());
    }

    private static <K> List<Object> doConcurrentGet(final LoadingCache<K, ?> cache, final K key, int nThreads, final CountDownLatch gettersStartedSignal) throws InterruptedException {
        final AtomicReferenceArray result = new AtomicReferenceArray(nThreads);
        final CountDownLatch gettersComplete = new CountDownLatch(nThreads);
        for (int i = 0; i < nThreads; ++i) {
            final int index = i;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    gettersStartedSignal.countDown();
                    Object value = null;
                    try {
                        int mod = index % 3;
                        if (mod == 0) {
                            value = cache.get(key);
                        } else if (mod == 1) {
                            value = cache.getUnchecked(key);
                        } else {
                            cache.refresh(key);
                            value = cache.get(key);
                        }
                        result.set(index, value);
                    }
                    catch (Throwable t) {
                        result.set(index, t);
                    }
                    gettersComplete.countDown();
                }
            });
            thread.start();
            while (thread.isAlive() && thread.getState() != Thread.State.WAITING) {
                Thread.yield();
            }
        }
        gettersStartedSignal.countDown();
        gettersComplete.await();
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)nThreads);
        for (int i = 0; i < nThreads; ++i) {
            resultList.add(result.get(i));
        }
        return resultList;
    }

    public void testAsMapDuringLoading() throws InterruptedException, ExecutionException {
        final CountDownLatch getStartedSignal = new CountDownLatch(2);
        final CountDownLatch letGetFinishSignal = new CountDownLatch(1);
        final CountDownLatch getFinishedSignal = new CountDownLatch(2);
        String getKey = "get";
        String refreshKey = "refresh";
        String suffix = "Suffix";
        CacheLoader<String, String> computeFunction = new CacheLoader<String, String>(){

            public String load(String key) throws InterruptedException {
                getStartedSignal.countDown();
                letGetFinishSignal.await();
                return String.valueOf(key).concat("Suffix");
            }
        };
        final LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)computeFunction);
        ConcurrentMap map = cache.asMap();
        map.put("refresh", "refresh");
        CacheLoadingTest.assertEquals((int)1, (int)map.size());
        CacheLoadingTest.assertFalse((boolean)map.containsKey("get"));
        CacheLoadingTest.assertSame((Object)"refresh", map.get("refresh"));
        new Thread(){

            @Override
            public void run() {
                cache.getUnchecked((Object)"get");
                getFinishedSignal.countDown();
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                cache.refresh((Object)"refresh");
                getFinishedSignal.countDown();
            }
        }.start();
        getStartedSignal.await();
        CacheLoadingTest.assertEquals((int)1, (int)map.size());
        CacheLoadingTest.assertFalse((boolean)map.containsKey("get"));
        CacheLoadingTest.assertSame((Object)"refresh", map.get("refresh"));
        letGetFinishSignal.countDown();
        getFinishedSignal.await();
        this.checkNothingLogged();
        CacheLoadingTest.assertEquals((long)2L, (long)cache.size());
        CacheLoadingTest.assertEquals((String)"getSuffix", (String)((String)map.get("get")));
        CacheLoadingTest.assertEquals((String)"refreshSuffix", (String)((String)map.get("refresh")));
    }

    public void testInvalidateDuringLoading() throws InterruptedException, ExecutionException {
        final CountDownLatch computationStarted = new CountDownLatch(2);
        final CountDownLatch letGetFinishSignal = new CountDownLatch(1);
        final CountDownLatch getFinishedSignal = new CountDownLatch(2);
        String getKey = "get";
        String refreshKey = "refresh";
        String suffix = "Suffix";
        CacheLoader<String, String> computeFunction = new CacheLoader<String, String>(){

            public String load(String key) throws InterruptedException {
                computationStarted.countDown();
                letGetFinishSignal.await();
                return String.valueOf(key).concat("Suffix");
            }
        };
        final LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)computeFunction);
        ConcurrentMap map = cache.asMap();
        map.put("refresh", "refresh");
        new Thread(){

            @Override
            public void run() {
                cache.getUnchecked((Object)"get");
                getFinishedSignal.countDown();
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                cache.refresh((Object)"refresh");
                getFinishedSignal.countDown();
            }
        }.start();
        computationStarted.await();
        cache.invalidate((Object)"get");
        cache.invalidate((Object)"refresh");
        CacheLoadingTest.assertFalse((boolean)map.containsKey("get"));
        CacheLoadingTest.assertFalse((boolean)map.containsKey("refresh"));
        letGetFinishSignal.countDown();
        getFinishedSignal.await();
        this.checkNothingLogged();
        CacheLoadingTest.assertEquals((long)2L, (long)cache.size());
        CacheLoadingTest.assertEquals((String)"getSuffix", (String)((String)map.get("get")));
        CacheLoadingTest.assertEquals((String)"refreshSuffix", (String)((String)map.get("refresh")));
        CacheLoadingTest.assertEquals((long)2L, (long)cache.size());
    }

    public void testInvalidateAndReloadDuringLoading() throws InterruptedException, ExecutionException {
        final CountDownLatch computationStarted = new CountDownLatch(2);
        final CountDownLatch letGetFinishSignal = new CountDownLatch(1);
        final CountDownLatch getFinishedSignal = new CountDownLatch(4);
        String getKey = "get";
        String refreshKey = "refresh";
        String suffix = "Suffix";
        CacheLoader<String, String> computeFunction = new CacheLoader<String, String>(){

            public String load(String key) throws InterruptedException {
                computationStarted.countDown();
                letGetFinishSignal.await();
                return String.valueOf(key).concat("Suffix");
            }
        };
        final LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)computeFunction);
        ConcurrentMap map = cache.asMap();
        map.put("refresh", "refresh");
        new Thread(){

            @Override
            public void run() {
                cache.getUnchecked((Object)"get");
                getFinishedSignal.countDown();
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                cache.refresh((Object)"refresh");
                getFinishedSignal.countDown();
            }
        }.start();
        computationStarted.await();
        cache.invalidate((Object)"get");
        cache.invalidate((Object)"refresh");
        CacheLoadingTest.assertFalse((boolean)map.containsKey("get"));
        CacheLoadingTest.assertFalse((boolean)map.containsKey("refresh"));
        new Thread(){

            @Override
            public void run() {
                cache.getUnchecked((Object)"get");
                getFinishedSignal.countDown();
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                cache.refresh((Object)"refresh");
                getFinishedSignal.countDown();
            }
        }.start();
        letGetFinishSignal.countDown();
        getFinishedSignal.await();
        this.checkNothingLogged();
        CacheLoadingTest.assertEquals((long)2L, (long)cache.size());
        CacheLoadingTest.assertEquals((String)"getSuffix", (String)((String)map.get("get")));
        CacheLoadingTest.assertEquals((String)"refreshSuffix", (String)((String)map.get("refresh")));
    }

    public void testExpandDuringLoading() throws InterruptedException {
        int count = 3;
        final AtomicInteger callCount = new AtomicInteger();
        final CountDownLatch computeSignal = new CountDownLatch(1);
        final CountDownLatch secondSignal = new CountDownLatch(1);
        final CountDownLatch thirdSignal = new CountDownLatch(1);
        final CountDownLatch fourthSignal = new CountDownLatch(1);
        final CountDownLatch doneSignal = new CountDownLatch(3);
        CacheLoader<String, String> computeFunction = new CacheLoader<String, String>(){

            public String load(String key) throws InterruptedException {
                callCount.incrementAndGet();
                secondSignal.countDown();
                computeSignal.await();
                return String.valueOf(key).concat("foo");
            }
        };
        final LoadingCache cache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)computeFunction);
        final AtomicReferenceArray result = new AtomicReferenceArray(3);
        String key = "bar";
        new Thread(){

            @Override
            public void run() {
                result.set(0, cache.getUnchecked((Object)"bar"));
                doneSignal.countDown();
            }
        }.start();
        secondSignal.await();
        new Thread(){

            @Override
            public void run() {
                thirdSignal.countDown();
                result.set(1, cache.getUnchecked((Object)"bar"));
                doneSignal.countDown();
            }
        }.start();
        thirdSignal.await();
        Thread.yield();
        CacheTesting.forceExpandSegment(cache, "bar");
        new Thread(){

            @Override
            public void run() {
                fourthSignal.countDown();
                result.set(2, cache.getUnchecked((Object)"bar"));
                doneSignal.countDown();
            }
        }.start();
        fourthSignal.await();
        Thread.yield();
        computeSignal.countDown();
        doneSignal.await();
        CacheLoadingTest.assertTrue((callCount.get() == 1 ? 1 : 0) != 0);
        CacheLoadingTest.assertEquals((String)"barfoo", (String)((String)result.get(0)));
        CacheLoadingTest.assertEquals((String)"barfoo", (String)((String)result.get(1)));
        CacheLoadingTest.assertEquals((String)"barfoo", (String)((String)result.get(2)));
        CacheLoadingTest.assertEquals((String)"barfoo", (String)((String)cache.getUnchecked((Object)"bar")));
    }

    public void testExpandDuringRefresh() throws InterruptedException, ExecutionException {
        final AtomicInteger callCount = new AtomicInteger();
        final CountDownLatch computeSignal = new CountDownLatch(1);
        final CountDownLatch secondSignal = new CountDownLatch(1);
        final CountDownLatch thirdSignal = new CountDownLatch(1);
        final CountDownLatch fourthSignal = new CountDownLatch(1);
        final CountDownLatch doneSignal = new CountDownLatch(3);
        String suffix = "Suffix";
        CacheLoader<String, String> computeFunction = new CacheLoader<String, String>(){

            public String load(String key) throws InterruptedException {
                callCount.incrementAndGet();
                secondSignal.countDown();
                computeSignal.await();
                return String.valueOf(key).concat("Suffix");
            }
        };
        final AtomicReferenceArray result = new AtomicReferenceArray(2);
        final LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)computeFunction);
        String key = "bar";
        cache.asMap().put("bar", "bar");
        new Thread(){

            @Override
            public void run() {
                cache.refresh((Object)"bar");
                doneSignal.countDown();
            }
        }.start();
        secondSignal.await();
        this.checkNothingLogged();
        new Thread(){

            @Override
            public void run() {
                thirdSignal.countDown();
                result.set(0, cache.getUnchecked((Object)"bar"));
                doneSignal.countDown();
            }
        }.start();
        thirdSignal.await();
        Thread.yield();
        CacheTesting.forceExpandSegment(cache, "bar");
        new Thread(){

            @Override
            public void run() {
                fourthSignal.countDown();
                result.set(1, cache.getUnchecked((Object)"bar"));
                doneSignal.countDown();
            }
        }.start();
        fourthSignal.await();
        Thread.yield();
        computeSignal.countDown();
        doneSignal.await();
        CacheLoadingTest.assertTrue((callCount.get() == 1 ? 1 : 0) != 0);
        CacheLoadingTest.assertEquals((String)"bar", (String)((String)result.get(0)));
        CacheLoadingTest.assertEquals((String)"bar", (String)((String)result.get(1)));
        CacheLoadingTest.assertEquals((String)"barSuffix", (String)((String)cache.getUnchecked((Object)"bar")));
    }

    static <T> Callable<T> throwing(final Exception exception) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                throw exception;
            }
        };
    }
}

