/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.ForwardingLoadingCache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import org.easymock.EasyMock;

public class ForwardingLoadingCacheTest
extends TestCase {
    private LoadingCache<String, Boolean> forward;
    private LoadingCache<String, Boolean> mock;

    public void setUp() throws Exception {
        super.setUp();
        this.mock = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        this.forward = new ForwardingLoadingCache<String, Boolean>(){

            protected LoadingCache<String, Boolean> delegate() {
                return ForwardingLoadingCacheTest.this.mock;
            }
        };
    }

    public void testGet() throws ExecutionException {
        EasyMock.expect((Object)this.mock.get((Object)"key")).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{this.mock});
        ForwardingLoadingCacheTest.assertSame((Object)Boolean.TRUE, (Object)this.forward.get((Object)"key"));
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testGetUnchecked() {
        EasyMock.expect((Object)this.mock.getUnchecked((Object)"key")).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{this.mock});
        ForwardingLoadingCacheTest.assertSame((Object)Boolean.TRUE, (Object)this.forward.getUnchecked((Object)"key"));
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testGetAll() throws ExecutionException {
        EasyMock.expect((Object)this.mock.getAll((Iterable)ImmutableList.of((Object)"key"))).andReturn((Object)ImmutableMap.of((Object)"key", (Object)Boolean.TRUE));
        EasyMock.replay((Object[])new Object[]{this.mock});
        ForwardingLoadingCacheTest.assertEquals((Object)ImmutableMap.of((Object)"key", (Object)Boolean.TRUE), (Object)this.forward.getAll((Iterable)ImmutableList.of((Object)"key")));
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testApply() {
        EasyMock.expect((Object)this.mock.apply((Object)"key")).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{this.mock});
        ForwardingLoadingCacheTest.assertSame((Object)Boolean.TRUE, (Object)this.forward.apply((Object)"key"));
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testInvalidate() {
        this.mock.invalidate((Object)"key");
        EasyMock.replay((Object[])new Object[]{this.mock});
        this.forward.invalidate((Object)"key");
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testRefresh() throws ExecutionException {
        this.mock.refresh((Object)"key");
        EasyMock.replay((Object[])new Object[]{this.mock});
        this.forward.refresh((Object)"key");
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testInvalidateAll() {
        this.mock.invalidateAll();
        EasyMock.replay((Object[])new Object[]{this.mock});
        this.forward.invalidateAll();
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testSize() {
        EasyMock.expect((Object)this.mock.size()).andReturn((Object)0L);
        EasyMock.replay((Object[])new Object[]{this.mock});
        this.forward.size();
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testStats() {
        EasyMock.expect((Object)this.mock.stats()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.mock});
        ForwardingLoadingCacheTest.assertNull((Object)this.forward.stats());
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testAsMap() {
        EasyMock.expect((Object)this.mock.asMap()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.mock});
        ForwardingLoadingCacheTest.assertNull((Object)this.forward.asMap());
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    public void testCleanUp() {
        this.mock.cleanUp();
        EasyMock.replay((Object[])new Object[]{this.mock});
        this.forward.cleanUp();
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    private static class OnlyGet<K, V>
    extends ForwardingLoadingCache<K, V> {
        private OnlyGet() {
        }

        protected LoadingCache<K, V> delegate() {
            return null;
        }
    }
}

