/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractMapEntry;
import java.util.Collections;
import java.util.Map;
import junit.framework.TestCase;

@GwtCompatible
public class AbstractMapEntryTest
extends TestCase {
    private static final String NK = null;
    private static final Integer NV = null;

    private static <K, V> Map.Entry<K, V> entry(final K key, final V value) {
        return new AbstractMapEntry<K, V>(){

            public K getKey() {
                return key;
            }

            public V getValue() {
                return value;
            }
        };
    }

    private static <K, V> Map.Entry<K, V> control(K key, V value) {
        return Collections.singletonMap(key, value).entrySet().iterator().next();
    }

    public void testToString() {
        AbstractMapEntryTest.assertEquals((String)"foo=1", (String)AbstractMapEntryTest.entry("foo", 1).toString());
    }

    public void testToStringNull() {
        AbstractMapEntryTest.assertEquals((String)"null=1", (String)AbstractMapEntryTest.entry(NK, 1).toString());
        AbstractMapEntryTest.assertEquals((String)"foo=null", (String)AbstractMapEntryTest.entry("foo", NV).toString());
        AbstractMapEntryTest.assertEquals((String)"null=null", (String)AbstractMapEntryTest.entry(NK, NV).toString());
    }

    public void testEquals() {
        Map.Entry<String, Integer> foo1 = AbstractMapEntryTest.entry("foo", 1);
        AbstractMapEntryTest.assertEquals(foo1, foo1);
        AbstractMapEntryTest.assertEquals(AbstractMapEntryTest.control("foo", 1), foo1);
        AbstractMapEntryTest.assertEquals(AbstractMapEntryTest.control("bar", 2), AbstractMapEntryTest.entry("bar", 2));
        AbstractMapEntryTest.assertFalse((boolean)AbstractMapEntryTest.control("foo", 1).equals(AbstractMapEntryTest.entry("foo", 2)));
        AbstractMapEntryTest.assertFalse((boolean)foo1.equals(AbstractMapEntryTest.control("bar", 1)));
        AbstractMapEntryTest.assertFalse((boolean)foo1.equals(new Object()));
        AbstractMapEntryTest.assertFalse((boolean)foo1.equals(null));
    }

    public void testEqualsNull() {
        AbstractMapEntryTest.assertEquals(AbstractMapEntryTest.control(NK, 1), AbstractMapEntryTest.entry(NK, 1));
        AbstractMapEntryTest.assertEquals(AbstractMapEntryTest.control("bar", NV), AbstractMapEntryTest.entry("bar", NV));
        AbstractMapEntryTest.assertFalse((boolean)AbstractMapEntryTest.control(NK, 1).equals(AbstractMapEntryTest.entry(NK, 2)));
        AbstractMapEntryTest.assertFalse((boolean)AbstractMapEntryTest.entry(NK, 1).equals(AbstractMapEntryTest.control("bar", 1)));
        AbstractMapEntryTest.assertFalse((boolean)AbstractMapEntryTest.entry(NK, 1).equals(new Object()));
        AbstractMapEntryTest.assertFalse((boolean)AbstractMapEntryTest.entry(NK, 1).equals(null));
    }

    public void testHashCode() {
        AbstractMapEntryTest.assertEquals((int)AbstractMapEntryTest.control("foo", 1).hashCode(), (int)AbstractMapEntryTest.entry("foo", 1).hashCode());
        AbstractMapEntryTest.assertEquals((int)AbstractMapEntryTest.control("bar", 2).hashCode(), (int)AbstractMapEntryTest.entry("bar", 2).hashCode());
    }

    public void testHashCodeNull() {
        AbstractMapEntryTest.assertEquals((int)AbstractMapEntryTest.control(NK, 1).hashCode(), (int)AbstractMapEntryTest.entry(NK, 1).hashCode());
        AbstractMapEntryTest.assertEquals((int)AbstractMapEntryTest.control("bar", NV).hashCode(), (int)AbstractMapEntryTest.entry("bar", NV).hashCode());
        AbstractMapEntryTest.assertEquals((int)AbstractMapEntryTest.control(NK, NV).hashCode(), (int)AbstractMapEntryTest.entry(NK, NV).hashCode());
    }
}

