/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.collect.AbstractTableTest;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@GwtCompatible(emulated=true)
public class ArrayTableTest
extends AbstractTableTest {
    protected ArrayTable<String, Integer, Character> create(Object ... data) {
        ArrayTable table = ArrayTable.create(Arrays.asList("foo", "bar", "cat"), Arrays.asList(1, 2, 3));
        this.populate((Table<String, Integer, Character>)table, data);
        return table;
    }

    @Override
    protected void assertSize(int expectedSize) {
        ArrayTableTest.assertEquals((int)9, (int)this.table.size());
    }

    @Override
    protected boolean supportsRemove() {
        return false;
    }

    @Override
    protected boolean supportsNullValues() {
        return true;
    }

    @Override
    public void testContains() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertTrue((boolean)this.table.contains((Object)"foo", (Object)1));
        ArrayTableTest.assertTrue((boolean)this.table.contains((Object)"bar", (Object)1));
        ArrayTableTest.assertTrue((boolean)this.table.contains((Object)"foo", (Object)3));
        ArrayTableTest.assertTrue((boolean)this.table.contains((Object)"foo", (Object)2));
        ArrayTableTest.assertTrue((boolean)this.table.contains((Object)"bar", (Object)3));
        ArrayTableTest.assertTrue((boolean)this.table.contains((Object)"cat", (Object)1));
        ArrayTableTest.assertFalse((boolean)this.table.contains((Object)"foo", (Object)-1));
        ArrayTableTest.assertFalse((boolean)this.table.contains((Object)"bad", (Object)1));
        ArrayTableTest.assertFalse((boolean)this.table.contains((Object)"bad", (Object)-1));
        ArrayTableTest.assertFalse((boolean)this.table.contains((Object)"foo", null));
        ArrayTableTest.assertFalse((boolean)this.table.contains(null, (Object)1));
        ArrayTableTest.assertFalse((boolean)this.table.contains(null, null));
    }

    @Override
    public void testContainsRow() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertTrue((boolean)this.table.containsRow((Object)"foo"));
        ArrayTableTest.assertTrue((boolean)this.table.containsRow((Object)"bar"));
        ArrayTableTest.assertTrue((boolean)this.table.containsRow((Object)"cat"));
        ArrayTableTest.assertFalse((boolean)this.table.containsRow((Object)"bad"));
        ArrayTableTest.assertFalse((boolean)this.table.containsRow(null));
    }

    @Override
    public void testContainsColumn() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertTrue((boolean)this.table.containsColumn((Object)1));
        ArrayTableTest.assertTrue((boolean)this.table.containsColumn((Object)3));
        ArrayTableTest.assertTrue((boolean)this.table.containsColumn((Object)2));
        ArrayTableTest.assertFalse((boolean)this.table.containsColumn((Object)-1));
        ArrayTableTest.assertFalse((boolean)this.table.containsColumn(null));
    }

    @Override
    public void testContainsValue() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertTrue((boolean)this.table.containsValue((Object)Character.valueOf('a')));
        ArrayTableTest.assertTrue((boolean)this.table.containsValue((Object)Character.valueOf('b')));
        ArrayTableTest.assertTrue((boolean)this.table.containsValue((Object)Character.valueOf('c')));
        ArrayTableTest.assertFalse((boolean)this.table.containsValue((Object)Character.valueOf('x')));
        ArrayTableTest.assertTrue((boolean)this.table.containsValue(null));
    }

    @Override
    public void testIsEmpty() {
        ArrayTableTest.assertFalse((boolean)this.table.isEmpty());
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertFalse((boolean)this.table.isEmpty());
    }

    @Override
    public void testEquals() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        HashBasedTable hashCopy = HashBasedTable.create();
        hashCopy.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        hashCopy.put((Object)"bar", (Object)1, (Object)Character.valueOf('b'));
        hashCopy.put((Object)"foo", (Object)3, (Object)Character.valueOf('c'));
        ArrayTable<String, Integer, Character> reordered = this.create("foo", 3, Character.valueOf('c'), "foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'));
        ArrayTable<String, Integer, Character> smaller = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'));
        ArrayTable<String, Integer, Character> swapOuter = this.create("bar", 1, Character.valueOf('a'), "foo", 1, Character.valueOf('b'), "bar", 3, Character.valueOf('c'));
        ArrayTable<String, Integer, Character> swapValues = this.create("foo", 1, Character.valueOf('c'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('a'));
        new EqualsTester().addEqualityGroup(new Object[]{this.table, reordered}).addEqualityGroup(new Object[]{hashCopy}).addEqualityGroup(new Object[]{smaller}).addEqualityGroup(new Object[]{swapOuter}).addEqualityGroup(new Object[]{swapValues}).testEquals();
    }

    @Override
    public void testHashCode() {
        this.table = ArrayTable.create(Arrays.asList("foo", "bar"), Arrays.asList(1, 3));
        this.table.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        this.table.put((Object)"bar", (Object)1, (Object)Character.valueOf('b'));
        this.table.put((Object)"foo", (Object)3, (Object)Character.valueOf('c'));
        int expected = Objects.hashCode((Object[])new Object[]{"foo", 1, Character.valueOf('a')}) + Objects.hashCode((Object[])new Object[]{"bar", 1, Character.valueOf('b')}) + Objects.hashCode((Object[])new Object[]{"foo", 3, Character.valueOf('c')}) + Objects.hashCode((Object[])new Object[]{"bar", 3, 0});
        ArrayTableTest.assertEquals((int)expected, (int)this.table.hashCode());
    }

    @Override
    public void testRow() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        HashMap expected = Maps.newHashMap();
        expected.put(1, Character.valueOf('a'));
        expected.put(3, Character.valueOf('c'));
        expected.put(2, null);
        ArrayTableTest.assertEquals((Object)expected, (Object)this.table.row((Object)"foo"));
    }

    @Override
    public void testColumn() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        HashMap expected = Maps.newHashMap();
        expected.put("foo", Character.valueOf('a'));
        expected.put("bar", Character.valueOf('b'));
        expected.put("cat", null);
        ArrayTableTest.assertEquals((Object)expected, (Object)this.table.column((Object)1));
    }

    @Override
    public void testToStringSize1() {
        this.table = ArrayTable.create((Iterable)ImmutableList.of((Object)"foo"), (Iterable)ImmutableList.of((Object)1));
        this.table.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        ArrayTableTest.assertEquals((String)"{foo={1=a}}", (String)this.table.toString());
    }

    public void testCreateDuplicateRows() {
        try {
            ArrayTable.create(Arrays.asList("foo", "bar", "foo"), Arrays.asList(1, 2, 3));
            ArrayTableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateDuplicateColumns() {
        try {
            ArrayTable.create(Arrays.asList("foo", "bar"), Arrays.asList(1, 2, 3, 2));
            ArrayTableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateEmptyRows() {
        try {
            ArrayTable.create(Arrays.asList(new String[0]), Arrays.asList(1, 2, 3));
            ArrayTableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateEmptyColumns() {
        try {
            ArrayTable.create(Arrays.asList("foo", "bar"), Arrays.asList(new Integer[0]));
            ArrayTableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateCopyArrayTable() {
        ArrayTable<String, Integer, Character> original = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTable copy = ArrayTable.create(original);
        ArrayTableTest.assertEquals(original, (Object)copy);
        original.put((Object)"foo", (Object)1, (Object)Character.valueOf('d'));
        ArrayTableTest.assertEquals((Object)Character.valueOf('d'), (Object)original.get((Object)"foo", (Object)1));
        ArrayTableTest.assertEquals((Object)Character.valueOf('a'), (Object)copy.get((Object)"foo", (Object)1));
        ArrayTableTest.assertEquals((Object)copy.rowKeySet(), (Object)original.rowKeySet());
        ArrayTableTest.assertEquals((Object)copy.columnKeySet(), (Object)original.columnKeySet());
    }

    public void testCreateCopyHashBasedTable() {
        HashBasedTable original = HashBasedTable.create();
        original.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        original.put((Object)"bar", (Object)1, (Object)Character.valueOf('b'));
        original.put((Object)"foo", (Object)3, (Object)Character.valueOf('c'));
        ArrayTable copy = ArrayTable.create((Table)original);
        ArrayTableTest.assertEquals((int)4, (int)copy.size());
        ArrayTableTest.assertEquals((Object)Character.valueOf('a'), (Object)copy.get((Object)"foo", (Object)1));
        ArrayTableTest.assertEquals((Object)Character.valueOf('b'), (Object)copy.get((Object)"bar", (Object)1));
        ArrayTableTest.assertEquals((Object)Character.valueOf('c'), (Object)copy.get((Object)"foo", (Object)3));
        ArrayTableTest.assertNull((Object)copy.get((Object)"bar", (Object)3));
        original.put((Object)"foo", (Object)1, (Object)Character.valueOf('d'));
        ArrayTableTest.assertEquals((Object)Character.valueOf('d'), (Object)original.get((Object)"foo", (Object)1));
        ArrayTableTest.assertEquals((Object)Character.valueOf('a'), (Object)copy.get((Object)"foo", (Object)1));
        ArrayTableTest.assertEquals((Object)copy.rowKeySet(), (Object)ImmutableSet.of((Object)"foo", (Object)"bar"));
        ArrayTableTest.assertEquals((Object)copy.columnKeySet(), (Object)ImmutableSet.of((Object)1, (Object)3));
    }

    public void testCreateCopyEmptyTable() {
        HashBasedTable original = HashBasedTable.create();
        try {
            ArrayTable.create((Table)original);
            ArrayTableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSerialization() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        SerializableTester.reserializeAndAssert((Object)this.table);
    }

    @GwtIncompatible(value="reflection")
    public void testNullPointerStatic() {
        new NullPointerTester().testAllPublicStaticMethods(ArrayTable.class);
    }

    public void testToString_ordered() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertEquals((String)"{foo={1=a, 2=null, 3=c}, bar={1=b, 2=null, 3=null}, cat={1=null, 2=null, 3=null}}", (String)this.table.toString());
        ArrayTableTest.assertEquals((String)"{foo={1=a, 2=null, 3=c}, bar={1=b, 2=null, 3=null}, cat={1=null, 2=null, 3=null}}", (String)this.table.rowMap().toString());
    }

    public void testCellSetToString_ordered() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertEquals((String)"[(foo,1)=a, (foo,2)=null, (foo,3)=c, (bar,1)=b, (bar,2)=null, (bar,3)=null, (cat,1)=null, (cat,2)=null, (cat,3)=null]", (String)this.table.cellSet().toString());
    }

    public void testRowKeySetToString_ordered() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertEquals((String)"[foo, bar, cat]", (String)this.table.rowKeySet().toString());
    }

    public void testColumnKeySetToString_ordered() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertEquals((String)"[1, 2, 3]", (String)this.table.columnKeySet().toString());
    }

    public void testValuesToString_ordered() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertEquals((String)"[a, null, c, b, null, null, null, null, null]", (String)this.table.values().toString());
    }

    public void testRowKeyList() {
        ArrayTable<String, Integer, Character> table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        Truth.assertThat((List)table.rowKeyList()).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{"cat"}).inOrder();
    }

    public void testColumnKeyList() {
        ArrayTable<String, Integer, Character> table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        Truth.assertThat((List)table.columnKeyList()).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
    }

    public void testGetMissingKeys() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertNull((Object)this.table.get((Object)"dog", (Object)1));
        ArrayTableTest.assertNull((Object)this.table.get((Object)"foo", (Object)4));
    }

    public void testAt() {
        ArrayTable<String, Integer, Character> table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertEquals((Object)Character.valueOf('b'), (Object)table.at(1, 0));
        ArrayTableTest.assertEquals((Object)Character.valueOf('c'), (Object)table.at(0, 2));
        ArrayTableTest.assertNull((Object)table.at(1, 2));
        try {
            table.at(1, 3);
            ArrayTableTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            table.at(1, -1);
            ArrayTableTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            table.at(3, 2);
            ArrayTableTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            table.at(-1, 2);
            ArrayTableTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSet() {
        ArrayTable<String, Integer, Character> table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertEquals((Object)Character.valueOf('b'), (Object)table.set(1, 0, (Object)Character.valueOf('d')));
        ArrayTableTest.assertEquals((Object)Character.valueOf('d'), (Object)table.get((Object)"bar", (Object)1));
        ArrayTableTest.assertNull((Object)table.set(2, 0, (Object)Character.valueOf('e')));
        ArrayTableTest.assertEquals((Object)Character.valueOf('e'), (Object)table.get((Object)"cat", (Object)1));
        ArrayTableTest.assertEquals((Object)Character.valueOf('a'), (Object)table.set(0, 0, null));
        ArrayTableTest.assertNull((Object)table.get((Object)"foo", (Object)1));
        try {
            table.set(1, 3, (Object)Character.valueOf('z'));
            ArrayTableTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            table.set(1, -1, (Object)Character.valueOf('z'));
            ArrayTableTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            table.set(3, 2, (Object)Character.valueOf('z'));
            ArrayTableTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            table.set(-1, 2, (Object)Character.valueOf('z'));
            ArrayTableTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        ArrayTableTest.assertFalse((boolean)table.containsValue((Object)Character.valueOf('z')));
    }

    public void testEraseAll() {
        ArrayTable<String, Integer, Character> table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        table.eraseAll();
        ArrayTableTest.assertEquals((int)9, (int)table.size());
        ArrayTableTest.assertNull((Object)table.get((Object)"bar", (Object)1));
        ArrayTableTest.assertTrue((boolean)table.containsRow((Object)"foo"));
        ArrayTableTest.assertFalse((boolean)table.containsValue((Object)Character.valueOf('a')));
    }

    public void testPutIllegal() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        try {
            this.table.put((Object)"dog", (Object)1, (Object)Character.valueOf('d'));
            ArrayTableTest.fail();
        }
        catch (IllegalArgumentException expected) {
            ArrayTableTest.assertEquals((String)"Row dog not in [foo, bar, cat]", (String)expected.getMessage());
        }
        try {
            this.table.put((Object)"foo", (Object)4, (Object)Character.valueOf('d'));
            ArrayTableTest.fail();
        }
        catch (IllegalArgumentException expected) {
            ArrayTableTest.assertEquals((String)"Column 4 not in [1, 2, 3]", (String)expected.getMessage());
        }
        ArrayTableTest.assertFalse((boolean)this.table.containsValue((Object)Character.valueOf('d')));
    }

    public void testErase() {
        ArrayTable<String, Integer, Character> table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        ArrayTableTest.assertEquals((Object)Character.valueOf('b'), (Object)table.erase((Object)"bar", (Object)1));
        ArrayTableTest.assertNull((Object)table.get((Object)"bar", (Object)1));
        ArrayTableTest.assertEquals((int)9, (int)table.size());
        ArrayTableTest.assertNull((Object)table.erase((Object)"bar", (Object)1));
        ArrayTableTest.assertNull((Object)table.erase((Object)"foo", (Object)2));
        ArrayTableTest.assertNull((Object)table.erase((Object)"dog", (Object)1));
        ArrayTableTest.assertNull((Object)table.erase((Object)"bar", (Object)5));
        ArrayTableTest.assertNull((Object)table.erase(null, (Object)1));
        ArrayTableTest.assertNull((Object)table.erase((Object)"bar", null));
    }

    @GwtIncompatible(value="ArrayTable.toArray(Class)")
    public void testToArray() {
        ArrayTable<String, Integer, Character> table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        Character[][] array = (Character[][])table.toArray(Character.class);
        ArrayTableTest.assertEquals((int)3, (int)array.length);
        Truth.assertThat((Object[])array[0]).asList().has().exactly((Object)Character.valueOf('a'), null, (Object[])new Character[]{Character.valueOf('c')}).inOrder();
        Truth.assertThat((Object[])array[1]).asList().has().exactly((Object)Character.valueOf('b'), null, null).inOrder();
        Truth.assertThat((Object[])array[2]).asList().has().exactly(null, null, null).inOrder();
        table.set(0, 2, (Object)Character.valueOf('d'));
        ArrayTableTest.assertEquals((Object)Character.valueOf('c'), (Object)array[0][2]);
        array[0][2] = Character.valueOf('e');
        ArrayTableTest.assertEquals((Object)Character.valueOf('d'), (Object)table.at(0, 2));
    }

    public void testCellReflectsChanges() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        Table.Cell cell = (Table.Cell)this.table.cellSet().iterator().next();
        ArrayTableTest.assertEquals((Object)Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('a')), (Object)cell);
        ArrayTableTest.assertEquals((Object)Character.valueOf('a'), (Object)this.table.put((Object)"foo", (Object)1, (Object)Character.valueOf('d')));
        ArrayTableTest.assertEquals((Object)Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('d')), (Object)cell);
    }

    public void testRowMissing() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        Map row = this.table.row((Object)"dog");
        ArrayTableTest.assertTrue((boolean)row.isEmpty());
        try {
            row.put(1, Character.valueOf('d'));
            ArrayTableTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testColumnMissing() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        Map column = this.table.column((Object)4);
        ArrayTableTest.assertTrue((boolean)column.isEmpty());
        try {
            column.put("foo", Character.valueOf('d'));
            ArrayTableTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRowPutIllegal() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        Map map = this.table.row((Object)"foo");
        try {
            map.put(4, Character.valueOf('d'));
            ArrayTableTest.fail();
        }
        catch (IllegalArgumentException expected) {
            ArrayTableTest.assertEquals((String)"Column 4 not in [1, 2, 3]", (String)expected.getMessage());
        }
    }

    public void testColumnPutIllegal() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        Map map = this.table.column((Object)3);
        try {
            map.put("dog", Character.valueOf('d'));
            ArrayTableTest.fail();
        }
        catch (IllegalArgumentException expected) {
            ArrayTableTest.assertEquals((String)"Row dog not in [foo, bar, cat]", (String)expected.getMessage());
        }
    }

    @GwtIncompatible(value="reflection")
    public void testNulls() {
        new NullPointerTester().testAllPublicInstanceMethods(this.create(new Object[0]));
    }

    @GwtIncompatible(value="serialize")
    public void testSerializable() {
        SerializableTester.reserializeAndAssert(this.create(new Object[0]));
    }
}

