/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Constraint;
import com.google.common.collect.Constraints;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.Assert;
import junit.framework.TestCase;

@GwtCompatible
public class ConstraintsTest
extends TestCase {
    private static final String TEST_ELEMENT = "test";
    private static final Constraint<String> TEST_CONSTRAINT = new Constraint<String>(){

        public String checkElement(String element) {
            if (ConstraintsTest.TEST_ELEMENT.equals(element)) {
                throw new TestElementException();
            }
            return element;
        }
    };

    public void testConstrainedCollectionLegal() {
        ArrayList collection = Lists.newArrayList((Object[])new String[]{"foo", "bar"});
        Collection constrained = Constraints.constrainedCollection((Collection)collection, TEST_CONSTRAINT);
        collection.add(TEST_ELEMENT);
        constrained.add("qux");
        constrained.addAll(Arrays.asList("cat", "dog"));
        Truth.assertThat((Collection)collection).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{TEST_ELEMENT, "qux", "cat", "dog"}).inOrder();
        Truth.assertThat((Collection)constrained).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{TEST_ELEMENT, "qux", "cat", "dog"}).inOrder();
    }

    public void testConstrainedCollectionIllegal() {
        ArrayList collection = Lists.newArrayList((Object[])new String[]{"foo", "bar"});
        Collection constrained = Constraints.constrainedCollection((Collection)collection, TEST_CONSTRAINT);
        try {
            constrained.add(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.addAll(Arrays.asList("baz", TEST_ELEMENT));
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException testElementException) {
            // empty catch block
        }
        Truth.assertThat((Collection)constrained).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[0]).inOrder();
        Truth.assertThat((Collection)collection).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[0]).inOrder();
    }

    public void testConstrainedSetLegal() {
        LinkedHashSet set = Sets.newLinkedHashSet(Arrays.asList("foo", "bar"));
        Set constrained = Constraints.constrainedSet((Set)set, TEST_CONSTRAINT);
        set.add(TEST_ELEMENT);
        constrained.add("qux");
        constrained.addAll(Arrays.asList("cat", "dog"));
        ConstraintsTest.assertTrue((boolean)set.equals(constrained));
        ConstraintsTest.assertTrue((boolean)constrained.equals(set));
        ConstraintsTest.assertEquals((String)((Object)set).toString(), (String)constrained.toString());
        ConstraintsTest.assertEquals((int)set.hashCode(), (int)constrained.hashCode());
        Truth.assertThat((Collection)set).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{TEST_ELEMENT, "qux", "cat", "dog"}).inOrder();
        Truth.assertThat((Collection)constrained).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{TEST_ELEMENT, "qux", "cat", "dog"}).inOrder();
    }

    public void testConstrainedSetIllegal() {
        LinkedHashSet set = Sets.newLinkedHashSet(Arrays.asList("foo", "bar"));
        Set constrained = Constraints.constrainedSet((Set)set, TEST_CONSTRAINT);
        try {
            constrained.add(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.addAll(Arrays.asList("baz", TEST_ELEMENT));
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException testElementException) {
            // empty catch block
        }
        Truth.assertThat((Collection)constrained).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[0]).inOrder();
        Truth.assertThat((Collection)set).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[0]).inOrder();
    }

    public void testConstrainedSortedSetLegal() {
        TreeSet sortedSet = Sets.newTreeSet(Arrays.asList("foo", "bar"));
        SortedSet constrained = Constraints.constrainedSortedSet((SortedSet)sortedSet, TEST_CONSTRAINT);
        sortedSet.add(TEST_ELEMENT);
        constrained.add("qux");
        constrained.addAll(Arrays.asList("cat", "dog"));
        ConstraintsTest.assertTrue((boolean)((Object)sortedSet).equals(constrained));
        ConstraintsTest.assertTrue((boolean)constrained.equals(sortedSet));
        ConstraintsTest.assertEquals((String)((Object)sortedSet).toString(), (String)constrained.toString());
        ConstraintsTest.assertEquals((int)((Object)sortedSet).hashCode(), (int)constrained.hashCode());
        Truth.assertThat((Collection)sortedSet).has().exactly((Object)"bar", (Object)"cat", (Object[])new String[]{"dog", "foo", "qux", TEST_ELEMENT}).inOrder();
        Truth.assertThat((Collection)constrained).has().exactly((Object)"bar", (Object)"cat", (Object[])new String[]{"dog", "foo", "qux", TEST_ELEMENT}).inOrder();
        ConstraintsTest.assertNull(constrained.comparator());
        ConstraintsTest.assertEquals((String)"bar", (String)((String)constrained.first()));
        ConstraintsTest.assertEquals((String)TEST_ELEMENT, (String)((String)constrained.last()));
    }

    public void testConstrainedSortedSetIllegal() {
        TreeSet sortedSet = Sets.newTreeSet(Arrays.asList("foo", "bar"));
        SortedSet constrained = Constraints.constrainedSortedSet((SortedSet)sortedSet, TEST_CONSTRAINT);
        try {
            constrained.add(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.subSet("bar", "foo").add(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.headSet("bar").add(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.tailSet("foo").add(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.addAll(Arrays.asList("baz", TEST_ELEMENT));
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException testElementException) {
            // empty catch block
        }
        Truth.assertThat((Collection)constrained).has().exactly((Object)"bar", (Object)"foo", (Object[])new String[0]).inOrder();
        Truth.assertThat((Collection)sortedSet).has().exactly((Object)"bar", (Object)"foo", (Object[])new String[0]).inOrder();
    }

    public void testConstrainedListLegal() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"foo", "bar"});
        List constrained = Constraints.constrainedList((List)list, TEST_CONSTRAINT);
        list.add(TEST_ELEMENT);
        constrained.add("qux");
        constrained.addAll(Arrays.asList("cat", "dog"));
        constrained.add(1, "cow");
        constrained.addAll(4, Arrays.asList("box", "fan"));
        constrained.set(2, "baz");
        ConstraintsTest.assertTrue((boolean)list.equals(constrained));
        ConstraintsTest.assertTrue((boolean)constrained.equals(list));
        ConstraintsTest.assertEquals((String)((Object)list).toString(), (String)constrained.toString());
        ConstraintsTest.assertEquals((int)list.hashCode(), (int)constrained.hashCode());
        Truth.assertThat((List)list).has().exactly((Object)"foo", (Object)"cow", (Object[])new String[]{"baz", TEST_ELEMENT, "box", "fan", "qux", "cat", "dog"}).inOrder();
        Truth.assertThat((List)constrained).has().exactly((Object)"foo", (Object)"cow", (Object[])new String[]{"baz", TEST_ELEMENT, "box", "fan", "qux", "cat", "dog"}).inOrder();
        ListIterator<String> iterator = constrained.listIterator();
        iterator.next();
        iterator.set("sun");
        constrained.listIterator(2).add("sky");
        Truth.assertThat((List)list).has().exactly((Object)"sun", (Object)"cow", (Object[])new String[]{"sky", "baz", TEST_ELEMENT, "box", "fan", "qux", "cat", "dog"}).inOrder();
        Truth.assertThat((List)constrained).has().exactly((Object)"sun", (Object)"cow", (Object[])new String[]{"sky", "baz", TEST_ELEMENT, "box", "fan", "qux", "cat", "dog"}).inOrder();
        ConstraintsTest.assertTrue((boolean)(constrained instanceof RandomAccess));
    }

    public void testConstrainedListRandomAccessFalse() {
        LinkedList list = Lists.newLinkedList(Arrays.asList("foo", "bar"));
        List constrained = Constraints.constrainedList((List)list, TEST_CONSTRAINT);
        list.add(TEST_ELEMENT);
        constrained.add("qux");
        ConstraintsTest.assertFalse((boolean)(constrained instanceof RandomAccess));
    }

    public void testConstrainedListIllegal() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"foo", "bar"});
        List constrained = Constraints.constrainedList((List)list, TEST_CONSTRAINT);
        try {
            constrained.add(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.listIterator().add(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.listIterator(1).add(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.listIterator().set(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.listIterator(1).set(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.subList(0, 1).add(TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.add(1, TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.set(1, TEST_ELEMENT);
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.addAll(Arrays.asList("baz", TEST_ELEMENT));
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException expected) {
            // empty catch block
        }
        try {
            constrained.addAll(1, Arrays.asList("baz", TEST_ELEMENT));
            ConstraintsTest.fail((String)"TestElementException expected");
        }
        catch (TestElementException testElementException) {
            // empty catch block
        }
        Truth.assertThat((List)constrained).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[0]).inOrder();
        Truth.assertThat((List)list).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[0]).inOrder();
    }

    public void testNefariousAddAll() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"foo", "bar"});
        List constrained = Constraints.constrainedList((List)list, TEST_CONSTRAINT);
        Collection<String> onceIterable = ConstraintsTest.onceIterableCollection("baz");
        constrained.addAll(onceIterable);
        Truth.assertThat((List)constrained).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{"baz"}).inOrder();
        Truth.assertThat((List)list).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{"baz"}).inOrder();
    }

    static <E> Collection<E> onceIterableCollection(final E element) {
        return new AbstractCollection<E>(){
            boolean iteratorCalled;

            @Override
            public int size() {
                return 1;
            }

            @Override
            public Iterator<E> iterator() {
                Assert.assertFalse((String)"Expected only one call to iterator()", (boolean)this.iteratorCalled);
                this.iteratorCalled = true;
                return Collections.singleton(element).iterator();
            }
        };
    }

    private static final class TestElementException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;

        private TestElementException() {
        }
    }
}

