/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class FauxveridesTest
extends TestCase {
    private static final Function<Type, String> SIMPLE_NAME_GETTER = new Function<Type, String>(){

        public String apply(Type from) {
            if (from instanceof Class) {
                return ((Class)from).getSimpleName();
            }
            return from.toString();
        }
    };

    public void testImmutableBiMap() {
        this.doHasAllFauxveridesTest(ImmutableBiMap.class, ImmutableMap.class);
    }

    public void testImmutableListMultimap() {
        this.doHasAllFauxveridesTest(ImmutableListMultimap.class, ImmutableMultimap.class);
    }

    public void testImmutableSetMultimap() {
        this.doHasAllFauxveridesTest(ImmutableSetMultimap.class, ImmutableMultimap.class);
    }

    public void testImmutableSortedMap() {
        this.doHasAllFauxveridesTest(ImmutableSortedMap.class, ImmutableMap.class);
    }

    public void testImmutableSortedSet() {
        this.doHasAllFauxveridesTest(ImmutableSortedSet.class, ImmutableSet.class);
    }

    public void testImmutableSortedMultiset() {
        this.doHasAllFauxveridesTest(ImmutableSortedMultiset.class, ImmutableMultiset.class);
    }

    public void testImmutableSortedMapCopyOfMap() {
        ImmutableMap original = ImmutableMap.of((Object)new Object(), (Object)new Object(), (Object)new Object(), (Object)new Object());
        try {
            ImmutableSortedMap.copyOf((Map)original);
            FauxveridesTest.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testImmutableSortedSetCopyOfIterable() {
        ImmutableSet original = ImmutableSet.of((Object)new Object(), (Object)new Object());
        try {
            ImmutableSortedSet.copyOf((Collection)original);
            FauxveridesTest.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testImmutableSortedSetCopyOfIterator() {
        ImmutableSet original = ImmutableSet.of((Object)new Object(), (Object)new Object());
        try {
            ImmutableSortedSet.copyOf(original.iterator());
            FauxveridesTest.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void doHasAllFauxveridesTest(Class<?> descendant, Class<?> ancestor) {
        Set<MethodSignature> required = FauxveridesTest.getAllRequiredToFauxveride(ancestor);
        Set<MethodSignature> found = FauxveridesTest.getAllFauxveridden(descendant, ancestor);
        required.removeAll(found);
        FauxveridesTest.assertEquals((String)"Must hide public static methods from ancestor classes", Collections.emptySet(), (Object)Sets.newTreeSet(required));
    }

    private static Set<MethodSignature> getAllRequiredToFauxveride(Class<?> ancestor) {
        return FauxveridesTest.getPublicStaticMethodsBetween(ancestor, Object.class);
    }

    private static Set<MethodSignature> getAllFauxveridden(Class<?> descendant, Class<?> ancestor) {
        return FauxveridesTest.getPublicStaticMethodsBetween(descendant, ancestor);
    }

    private static Set<MethodSignature> getPublicStaticMethodsBetween(Class<?> descendant, Class<?> ancestor) {
        HashSet methods = Sets.newHashSet();
        for (Class<?> clazz : FauxveridesTest.getClassesBetween(descendant, ancestor)) {
            methods.addAll(FauxveridesTest.getPublicStaticMethods(clazz));
        }
        return methods;
    }

    private static Set<MethodSignature> getPublicStaticMethods(Class<?> clazz) {
        HashSet publicStaticMethods = Sets.newHashSet();
        for (Method method : clazz.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            publicStaticMethods.add(new MethodSignature(method));
        }
        return publicStaticMethods;
    }

    private static Set<Class<?>> getClassesBetween(Class<?> descendant, Class<?> ancestor) {
        HashSet classes = Sets.newHashSet();
        while (!descendant.equals(ancestor)) {
            classes.add(descendant);
            descendant = descendant.getSuperclass();
        }
        return classes;
    }

    private static String getTypesString(List<? extends Type> types) {
        List names = Lists.transform(types, SIMPLE_NAME_GETTER);
        return Joiner.on((String)", ").join((Iterable)names);
    }

    private static final class TypeParameterSignature {
        final String name;
        final List<Type> bounds;

        TypeParameterSignature(TypeVariable<?> typeParameter) {
            this.name = typeParameter.getName();
            this.bounds = Arrays.asList(typeParameter.getBounds());
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeParameterSignature) {
                TypeParameterSignature other = (TypeParameterSignature)obj;
                return this.bounds.equals(other.bounds);
            }
            return false;
        }

        public int hashCode() {
            return this.bounds.hashCode();
        }

        public String toString() {
            String string;
            if (this.bounds.equals(ImmutableList.of(Object.class))) {
                string = this.name;
            } else {
                String string2 = String.valueOf(String.valueOf(this.name));
                String string3 = String.valueOf(String.valueOf(FauxveridesTest.getTypesString(this.bounds)));
                string = new StringBuilder(9 + string2.length() + string3.length()).append(string2).append(" extends ").append(string3).toString();
            }
            return string;
        }
    }

    private static final class TypeSignature {
        final List<TypeParameterSignature> parameterSignatures;

        TypeSignature(TypeVariable<Method>[] parameters) {
            this.parameterSignatures = Lists.transform(Arrays.asList(parameters), (Function)new Function<TypeVariable<?>, TypeParameterSignature>(){

                public TypeParameterSignature apply(TypeVariable<?> from) {
                    return new TypeParameterSignature(from);
                }
            });
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeSignature) {
                TypeSignature other = (TypeSignature)obj;
                return this.parameterSignatures.equals(other.parameterSignatures);
            }
            return false;
        }

        public int hashCode() {
            return this.parameterSignatures.hashCode();
        }

        public String toString() {
            String string;
            if (this.parameterSignatures.isEmpty()) {
                string = "";
            } else {
                String string2 = String.valueOf(String.valueOf(Joiner.on((String)", ").join(this.parameterSignatures)));
                string = new StringBuilder(3 + string2.length()).append("<").append(string2).append("> ").toString();
            }
            return string;
        }
    }

    private static final class MethodSignature
    implements Comparable<MethodSignature> {
        final String name;
        final List<Class<?>> parameterTypes;
        final TypeSignature typeSignature;

        MethodSignature(Method method) {
            this.name = method.getName();
            this.parameterTypes = Arrays.asList(method.getParameterTypes());
            this.typeSignature = new TypeSignature(method.getTypeParameters());
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodSignature) {
                MethodSignature other = (MethodSignature)obj;
                return this.name.equals(other.name) && this.parameterTypes.equals(other.parameterTypes) && this.typeSignature.equals(other.typeSignature);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.parameterTypes, this.typeSignature});
        }

        public String toString() {
            return String.format("%s%s(%s)", this.typeSignature, this.name, FauxveridesTest.getTypesString(this.parameterTypes));
        }

        @Override
        public int compareTo(MethodSignature o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

