/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingBlockingDeque;
import com.google.common.collect.ForwardingTestCase;
import com.google.common.collect.Lists;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;

public class ForwardingBlockingDequeTest
extends ForwardingTestCase {
    private BlockingDeque<String> forward;

    protected void setUp() throws Exception {
        super.setUp();
        final BlockingDeque deque = this.createProxyInstance(BlockingDeque.class);
        this.forward = new ForwardingBlockingDeque<String>(){

            protected BlockingDeque<String> delegate() {
                return deque;
            }
        };
    }

    public void testRemainingCapacity() {
        this.forward.remainingCapacity();
        ForwardingBlockingDequeTest.assertEquals((String)"[remainingCapacity]", (String)this.getCalls());
    }

    public void testPutFirst_T() throws InterruptedException {
        this.forward.putFirst("asf");
        ForwardingBlockingDequeTest.assertEquals((String)"[putFirst(Object)]", (String)this.getCalls());
    }

    public void testPutLast_T() throws InterruptedException {
        this.forward.putFirst("asf");
        ForwardingBlockingDequeTest.assertEquals((String)"[putFirst(Object)]", (String)this.getCalls());
    }

    public void testOfferFirst_T() throws InterruptedException {
        this.forward.offerFirst("asf", 2L, TimeUnit.SECONDS);
        ForwardingBlockingDequeTest.assertEquals((String)"[offerFirst(Object,long,TimeUnit)]", (String)this.getCalls());
    }

    public void testOfferLast_T() throws InterruptedException {
        this.forward.offerLast("asf", 2L, TimeUnit.SECONDS);
        ForwardingBlockingDequeTest.assertEquals((String)"[offerLast(Object,long,TimeUnit)]", (String)this.getCalls());
    }

    public void testTakeFirst() throws InterruptedException {
        this.forward.takeFirst();
        ForwardingBlockingDequeTest.assertEquals((String)"[takeFirst]", (String)this.getCalls());
    }

    public void testTakeLast() throws InterruptedException {
        this.forward.takeLast();
        ForwardingBlockingDequeTest.assertEquals((String)"[takeLast]", (String)this.getCalls());
    }

    public void testPollFirst() throws InterruptedException {
        this.forward.pollFirst(2L, TimeUnit.SECONDS);
        ForwardingBlockingDequeTest.assertEquals((String)"[pollFirst(long,TimeUnit)]", (String)this.getCalls());
    }

    public void testPollLast() throws InterruptedException {
        this.forward.pollLast(2L, TimeUnit.SECONDS);
        ForwardingBlockingDequeTest.assertEquals((String)"[pollLast(long,TimeUnit)]", (String)this.getCalls());
    }

    public void testPut_T() throws InterruptedException {
        this.forward.put("asf");
        ForwardingBlockingDequeTest.assertEquals((String)"[put(Object)]", (String)this.getCalls());
    }

    public void testOffer_T() throws InterruptedException {
        this.forward.offer("asf", 2L, TimeUnit.SECONDS);
        ForwardingBlockingDequeTest.assertEquals((String)"[offer(Object,long,TimeUnit)]", (String)this.getCalls());
    }

    public void testTake() throws InterruptedException {
        this.forward.take();
        ForwardingBlockingDequeTest.assertEquals((String)"[take]", (String)this.getCalls());
    }

    public void testPoll() throws InterruptedException {
        this.forward.poll(2L, TimeUnit.SECONDS);
        ForwardingBlockingDequeTest.assertEquals((String)"[poll(long,TimeUnit)]", (String)this.getCalls());
    }

    public void testDrainTo_T() {
        this.forward.drainTo(Lists.newArrayList());
        ForwardingBlockingDequeTest.assertEquals((String)"[drainTo(Collection)]", (String)this.getCalls());
    }

    public void testDrainTo_T_maxElements() {
        this.forward.drainTo(Lists.newArrayList(), 3);
        ForwardingBlockingDequeTest.assertEquals((String)"[drainTo(Collection,int)]", (String)this.getCalls());
    }
}

