/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ForwardingTestCase;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ForwardingMultisetTest
extends ForwardingTestCase {
    private static final Collection<String> EMPTY_COLLECTION = Collections.emptyList();
    protected Multiset<String> forward;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingMultisetTest.class);
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return new StandardImplForwardingMultiset(LinkedHashMultiset.create(Arrays.asList(elements)));
            }
        }).named("ForwardingMultiset[LinkedHashMultiset] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return new StandardImplForwardingMultiset(ImmutableMultiset.copyOf((Object[])elements));
            }
        }).named("ForwardingMultiset[ImmutableMultiset] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                LinkedHashMultiset inner = LinkedHashMultiset.create(Arrays.asList(elements));
                return new ForwardingMultiset<String>((Multiset)inner){
                    final /* synthetic */ Multiset val$inner;
                    {
                        this.val$inner = multiset;
                    }

                    protected Multiset<String> delegate() {
                        return this.val$inner;
                    }

                    public Set<String> elementSet() {
                        return new ForwardingMultiset.StandardElementSet((ForwardingMultiset)this);
                    }

                    public int add(String element, int occurrences) {
                        throw new UnsupportedOperationException();
                    }

                    public Set<Multiset.Entry<String>> entrySet() {
                        final Set backingSet = super.entrySet();
                        return new ForwardingSet<Multiset.Entry<String>>(){

                            protected Set<Multiset.Entry<String>> delegate() {
                                return backingSet;
                            }

                            public boolean add(Multiset.Entry<String> element) {
                                throw new UnsupportedOperationException();
                            }

                            public boolean addAll(Collection<? extends Multiset.Entry<String>> collection) {
                                throw new UnsupportedOperationException();
                            }

                            public void clear() {
                                throw new UnsupportedOperationException();
                            }

                            public boolean contains(Object object) {
                                throw new UnsupportedOperationException();
                            }

                            public boolean containsAll(Collection<?> collection) {
                                throw new UnsupportedOperationException();
                            }

                            public boolean isEmpty() {
                                throw new UnsupportedOperationException();
                            }

                            public boolean remove(Object object) {
                                throw new UnsupportedOperationException();
                            }

                            public boolean removeAll(Collection<?> collection) {
                                throw new UnsupportedOperationException();
                            }

                            public boolean retainAll(Collection<?> collection) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    public boolean equals(Object object) {
                        throw new UnsupportedOperationException();
                    }

                    public boolean remove(Object element) {
                        throw new UnsupportedOperationException();
                    }

                    public boolean setCount(String element, int oldCount, int newCount) {
                        throw new UnsupportedOperationException();
                    }

                    public int setCount(String element, int count) {
                        throw new UnsupportedOperationException();
                    }

                    public boolean add(String element) {
                        throw new UnsupportedOperationException();
                    }

                    public boolean addAll(Collection<? extends String> collection) {
                        throw new UnsupportedOperationException();
                    }

                    public Iterator<String> iterator() {
                        throw new UnsupportedOperationException();
                    }

                    public boolean removeAll(Collection<?> collection) {
                        throw new UnsupportedOperationException();
                    }

                    public boolean retainAll(Collection<?> collection) {
                        throw new UnsupportedOperationException();
                    }

                    public int size() {
                        throw new UnsupportedOperationException();
                    }
                }.elementSet();
            }
        }).named("standardElementSet tripwire")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.REMOVE_OPERATIONS})).createTestSuite());
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        final Multiset multiset = this.createProxyInstance(Multiset.class);
        this.forward = new ForwardingMultiset<String>(){

            protected Multiset<String> delegate() {
                return multiset;
            }
        };
    }

    public void testAdd_T() {
        this.forward().add((Object)"asdf");
        ForwardingMultisetTest.assertEquals((String)"[add(Object)]", (String)this.getCalls());
    }

    public void testAddAll_Collection() {
        this.forward().addAll(EMPTY_COLLECTION);
        ForwardingMultisetTest.assertEquals((String)"[addAll(Collection)]", (String)this.getCalls());
    }

    public void testClear() {
        this.forward().clear();
        ForwardingMultisetTest.assertEquals((String)"[clear]", (String)this.getCalls());
    }

    public void testContains_Object() {
        this.forward().contains(null);
        ForwardingMultisetTest.assertEquals((String)"[contains(Object)]", (String)this.getCalls());
    }

    public void testContainsAll_Collection() {
        this.forward().containsAll(EMPTY_COLLECTION);
        ForwardingMultisetTest.assertEquals((String)"[containsAll(Collection)]", (String)this.getCalls());
    }

    public void testIsEmpty() {
        this.forward().isEmpty();
        ForwardingMultisetTest.assertEquals((String)"[isEmpty]", (String)this.getCalls());
    }

    public void testIterator() {
        this.forward().iterator();
        ForwardingMultisetTest.assertEquals((String)"[iterator]", (String)this.getCalls());
    }

    public void testRemove_Object() {
        this.forward().remove(null);
        ForwardingMultisetTest.assertEquals((String)"[remove(Object)]", (String)this.getCalls());
    }

    public void testRemoveAll_Collection() {
        this.forward().removeAll(EMPTY_COLLECTION);
        ForwardingMultisetTest.assertEquals((String)"[removeAll(Collection)]", (String)this.getCalls());
    }

    public void testRetainAll_Collection() {
        this.forward().retainAll(EMPTY_COLLECTION);
        ForwardingMultisetTest.assertEquals((String)"[retainAll(Collection)]", (String)this.getCalls());
    }

    public void testSize() {
        this.forward().size();
        ForwardingMultisetTest.assertEquals((String)"[size]", (String)this.getCalls());
    }

    public void testToArray() {
        this.forward().toArray();
        ForwardingMultisetTest.assertEquals((String)"[toArray]", (String)this.getCalls());
    }

    public void testToArray_TArray() {
        this.forward().toArray((Object[])new String[0]);
        ForwardingMultisetTest.assertEquals((String)"[toArray(Object[])]", (String)this.getCalls());
    }

    public void testToString() {
        this.forward().toString();
        ForwardingMultisetTest.assertEquals((String)"[toString]", (String)this.getCalls());
    }

    public void testEquals_Object() {
        this.forward().equals((Object)"asdf");
        ForwardingMultisetTest.assertEquals((String)"[equals(Object)]", (String)this.getCalls());
    }

    public void testHashCode() {
        this.forward().hashCode();
        ForwardingMultisetTest.assertEquals((String)"[hashCode]", (String)this.getCalls());
    }

    public void testCount_Object() {
        this.forward().count(null);
        ForwardingMultisetTest.assertEquals((String)"[count(Object)]", (String)this.getCalls());
    }

    public void testAdd_Object_int() {
        this.forward().add((Object)"asd", 23);
        ForwardingMultisetTest.assertEquals((String)"[add(Object,int)]", (String)this.getCalls());
    }

    public void testRemove_Object_int() {
        this.forward().remove((Object)"asd", 23);
        ForwardingMultisetTest.assertEquals((String)"[remove(Object,int)]", (String)this.getCalls());
    }

    public void testSetCount_Object_int() {
        this.forward().setCount((Object)"asdf", 233);
        ForwardingMultisetTest.assertEquals((String)"[setCount(Object,int)]", (String)this.getCalls());
    }

    public void testSetCount_Object_oldCount_newCount() {
        this.forward().setCount((Object)"asdf", 4552, 1233);
        ForwardingMultisetTest.assertEquals((String)"[setCount(Object,int,int)]", (String)this.getCalls());
    }

    public void testElementSet() {
        this.forward().elementSet();
        ForwardingMultisetTest.assertEquals((String)"[elementSet]", (String)this.getCalls());
    }

    public void testEntrySet() {
        this.forward().entrySet();
        ForwardingMultisetTest.assertEquals((String)"[entrySet]", (String)this.getCalls());
    }

    protected Multiset<String> forward() {
        return this.forward;
    }

    static final class StandardImplForwardingMultiset<T>
    extends ForwardingMultiset<T> {
        private final Multiset<T> backingCollection;

        StandardImplForwardingMultiset(Multiset<T> backingMultiset) {
            this.backingCollection = backingMultiset;
        }

        protected Multiset<T> delegate() {
            return this.backingCollection;
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public boolean add(T element) {
            return this.standardAdd(element);
        }

        public void clear() {
            this.standardClear();
        }

        public int count(Object element) {
            return this.standardCount(element);
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public boolean setCount(T element, int oldCount, int newCount) {
            return this.standardSetCount(element, oldCount, newCount);
        }

        public int setCount(T element, int count) {
            return this.standardSetCount(element, count);
        }

        public Set<T> elementSet() {
            return new ForwardingMultiset.StandardElementSet((ForwardingMultiset)this);
        }

        public Iterator<T> iterator() {
            return this.standardIterator();
        }

        public boolean isEmpty() {
            return this.standardIsEmpty();
        }

        public int size() {
            return this.standardSize();
        }
    }
}

