/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.BoundType;
import com.google.common.collect.ForwardingMultisetTest;
import com.google.common.collect.ForwardingSortedMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.SortedMultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import javax.annotation.Nullable;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ForwardingSortedMultisetTest
extends ForwardingMultisetTest {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingSortedMultisetTest.class);
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)SortedMultisetTestSuiteBuilder.using((TestMultisetGenerator)new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return new StandardImplForwardingSortedMultiset(TreeMultiset.create(Arrays.asList(elements)));
            }

            public List<String> order(List<String> insertionOrder) {
                return Ordering.natural().sortedCopy(insertionOrder);
            }
        }).named("ForwardingSortedMultiset with standard impls")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        final SortedMultiset sortedMultiset = this.createProxyInstance(SortedMultiset.class);
        this.forward = new ForwardingSortedMultiset<String>(){

            protected SortedMultiset<String> delegate() {
                return sortedMultiset;
            }
        };
    }

    public void testComparator() {
        this.forward().comparator();
        ForwardingSortedMultisetTest.assertEquals((String)"[comparator]", (String)this.getCalls());
    }

    public void testFirstEntry() {
        this.forward().firstEntry();
        ForwardingSortedMultisetTest.assertEquals((String)"[firstEntry]", (String)this.getCalls());
    }

    public void testLastEntry() {
        this.forward().lastEntry();
        ForwardingSortedMultisetTest.assertEquals((String)"[lastEntry]", (String)this.getCalls());
    }

    public void testPollFirstEntry() {
        this.forward().pollFirstEntry();
        ForwardingSortedMultisetTest.assertEquals((String)"[pollFirstEntry]", (String)this.getCalls());
    }

    public void testPollLastEntry() {
        this.forward().pollLastEntry();
        ForwardingSortedMultisetTest.assertEquals((String)"[pollLastEntry]", (String)this.getCalls());
    }

    public void testDescendingMultiset() {
        this.forward().descendingMultiset();
        ForwardingSortedMultisetTest.assertEquals((String)"[descendingMultiset]", (String)this.getCalls());
    }

    public void testHeadMultiset() {
        this.forward().headMultiset((Object)"abcd", BoundType.CLOSED);
        ForwardingSortedMultisetTest.assertEquals((String)"[headMultiset(Object,BoundType)]", (String)this.getCalls());
    }

    public void testSubMultiset() {
        this.forward().subMultiset((Object)"abcd", BoundType.CLOSED, (Object)"dcba", BoundType.OPEN);
        ForwardingSortedMultisetTest.assertEquals((String)"[subMultiset(Object,BoundType,Object,BoundType)]", (String)this.getCalls());
    }

    public void testTailMultiset() {
        this.forward().tailMultiset((Object)"last", BoundType.OPEN);
        ForwardingSortedMultisetTest.assertEquals((String)"[tailMultiset(Object,BoundType)]", (String)this.getCalls());
    }

    protected SortedMultiset<String> forward() {
        return (SortedMultiset)super.forward();
    }

    static class StandardImplForwardingSortedMultiset<E>
    extends ForwardingSortedMultiset<E> {
        private final SortedMultiset<E> backingMultiset;

        StandardImplForwardingSortedMultiset(SortedMultiset<E> backingMultiset) {
            this.backingMultiset = backingMultiset;
        }

        protected SortedMultiset<E> delegate() {
            return this.backingMultiset;
        }

        public SortedMultiset<E> descendingMultiset() {
            return new ForwardingSortedMultiset.StandardDescendingMultiset(){

                Iterator<Multiset.Entry<E>> entryIterator() {
                    return StandardImplForwardingSortedMultiset.this.backingMultiset.descendingMultiset().entrySet().iterator();
                }
            };
        }

        public NavigableSet<E> elementSet() {
            return new ForwardingSortedMultiset.StandardElementSet((ForwardingSortedMultiset)this);
        }

        public Multiset.Entry<E> firstEntry() {
            return this.standardFirstEntry();
        }

        public Multiset.Entry<E> lastEntry() {
            return this.standardLastEntry();
        }

        public Multiset.Entry<E> pollFirstEntry() {
            return this.standardPollFirstEntry();
        }

        public Multiset.Entry<E> pollLastEntry() {
            return this.standardPollLastEntry();
        }

        public SortedMultiset<E> subMultiset(E lowerBound, BoundType lowerBoundType, E upperBound, BoundType upperBoundType) {
            return this.standardSubMultiset(lowerBound, lowerBoundType, upperBound, upperBoundType);
        }

        public int count(@Nullable Object element) {
            return this.standardCount(element);
        }

        public boolean equals(@Nullable Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public boolean add(E element) {
            return this.standardAdd(element);
        }

        public boolean addAll(Collection<? extends E> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(@Nullable Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean isEmpty() {
            return this.standardIsEmpty();
        }

        public Iterator<E> iterator() {
            return this.standardIterator();
        }

        public boolean remove(@Nullable Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public int size() {
            return this.standardSize();
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }
    }
}

