/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingTable;
import com.google.common.collect.ForwardingTestCase;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;

public class ForwardingTableTest
extends ForwardingTestCase {
    private Table<String, Integer, Boolean> forward;

    public void setUp() throws Exception {
        super.setUp();
        final Table table = this.createProxyInstance(Table.class);
        this.forward = new ForwardingTable<String, Integer, Boolean>(){

            protected Table<String, Integer, Boolean> delegate() {
                return table;
            }
        };
    }

    public void testHashCode() {
        this.forward.hashCode();
        ForwardingTableTest.assertEquals((String)"[hashCode]", (String)this.getCalls());
    }

    public void testCellSet() {
        this.forward.cellSet();
        ForwardingTableTest.assertEquals((String)"[cellSet]", (String)this.getCalls());
    }

    public void testClear() {
        this.forward.clear();
        ForwardingTableTest.assertEquals((String)"[clear]", (String)this.getCalls());
    }

    public void testColumn() {
        this.forward.column((Object)1);
        ForwardingTableTest.assertEquals((String)"[column(Object)]", (String)this.getCalls());
    }

    public void testColumnKeySet() {
        this.forward.columnKeySet();
        ForwardingTableTest.assertEquals((String)"[columnKeySet]", (String)this.getCalls());
    }

    public void testColumnMap() {
        this.forward.columnMap();
        ForwardingTableTest.assertEquals((String)"[columnMap]", (String)this.getCalls());
    }

    public void testContains() {
        this.forward.contains((Object)"blah", (Object)1);
        ForwardingTableTest.assertEquals((String)"[contains(Object,Object)]", (String)this.getCalls());
    }

    public void testContainsColumn() {
        this.forward.containsColumn((Object)1);
        ForwardingTableTest.assertEquals((String)"[containsColumn(Object)]", (String)this.getCalls());
    }

    public void testContainsRow() {
        this.forward.containsRow((Object)"blah");
        ForwardingTableTest.assertEquals((String)"[containsRow(Object)]", (String)this.getCalls());
    }

    public void testContainsValue() {
        this.forward.containsValue((Object)false);
        ForwardingTableTest.assertEquals((String)"[containsValue(Object)]", (String)this.getCalls());
    }

    public void testGet() {
        this.forward.get((Object)"blah", (Object)1);
        ForwardingTableTest.assertEquals((String)"[get(Object,Object)]", (String)this.getCalls());
    }

    public void testIsEmpty() {
        this.forward.isEmpty();
        ForwardingTableTest.assertEquals((String)"[isEmpty]", (String)this.getCalls());
    }

    public void testPut() {
        this.forward.put((Object)"blah", (Object)1, (Object)false);
        ForwardingTableTest.assertEquals((String)"[put(Object,Object,Object)]", (String)this.getCalls());
    }

    public void testPutAll() {
        this.forward.putAll((Table)HashBasedTable.create());
        ForwardingTableTest.assertEquals((String)"[putAll(Table)]", (String)this.getCalls());
    }

    public void testRemove() {
        this.forward.remove((Object)"blah", (Object)1);
        ForwardingTableTest.assertEquals((String)"[remove(Object,Object)]", (String)this.getCalls());
    }

    public void testRow() {
        this.forward.row((Object)"String");
        ForwardingTableTest.assertEquals((String)"[row(Object)]", (String)this.getCalls());
    }

    public void testRowKeySet() {
        this.forward.rowKeySet();
        ForwardingTableTest.assertEquals((String)"[rowKeySet]", (String)this.getCalls());
    }

    public void testRowMap() {
        this.forward.rowMap();
        ForwardingTableTest.assertEquals((String)"[rowMap]", (String)this.getCalls());
    }

    public void testSize() {
        this.forward.size();
        ForwardingTableTest.assertEquals((String)"[size]", (String)this.getCalls());
    }

    public void testValues() {
        this.forward.values();
        ForwardingTableTest.assertEquals((String)"[values]", (String)this.getCalls());
    }

    public void testEqualsObject() {
        this.forward.equals(null);
        ForwardingTableTest.assertEquals((String)"[equals(Object)]", (String)this.getCalls());
    }
}

