/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public abstract class ForwardingTestCase
extends TestCase {
    private final List<String> calls = new ArrayList<String>();
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");

    private void called(String id) {
        this.calls.add(id);
    }

    protected String getCalls() {
        return this.calls.toString();
    }

    protected boolean isCalled() {
        return !this.calls.isEmpty();
    }

    protected <T> T createProxyInstance(Class<T> c) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ForwardingTestCase.this.called(ForwardingTestCase.this.asString(method));
                return ForwardingTestCase.getDefaultValue(method.getReturnType());
            }
        };
        return (T)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, handler);
    }

    private String asString(Method method) {
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return methodName;
        }
        Iterable parameterNames = Iterables.transform(Arrays.asList(parameterTypes), (Function)new Function<Class<?>, String>(){

            public String apply(Class<?> from) {
                return from.getSimpleName();
            }
        });
        String string = String.valueOf(String.valueOf(methodName));
        String string2 = String.valueOf(String.valueOf(COMMA_JOINER.join(parameterNames)));
        return new StringBuilder(2 + string.length() + string2.length()).append(string).append("(").append(string2).append(")").toString();
    }

    private static Object getDefaultValue(Class<?> returnType) {
        if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            return Boolean.FALSE;
        }
        if (returnType == Integer.TYPE || returnType == Integer.class) {
            return 0;
        }
        if (returnType == Set.class || returnType == Collection.class) {
            return Collections.emptySet();
        }
        if (returnType == Iterator.class) {
            return Iterators.emptyModifiableIterator();
        }
        if (returnType.isArray()) {
            return Array.newInstance(returnType.getComponentType(), 0);
        }
        if ("java.util.function.Predicate".equals(returnType.getCanonicalName()) || "java.util.function.Consumer".equals(returnType.getCanonicalName())) {
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    if ("test".equals(method.getName()) || "accept".equals(method.getName())) {
                        return ForwardingTestCase.getDefaultValue(method.getReturnType());
                    }
                    String string = String.valueOf(String.valueOf(method));
                    String string2 = String.valueOf(String.valueOf(proxy));
                    throw new IllegalStateException(new StringBuilder(23 + string.length() + string2.length()).append("Unexpected ").append(string).append(" invoked on ").append(string2).toString());
                }
            };
            return Proxy.newProxyInstance(returnType.getClassLoader(), new Class[]{returnType}, handler);
        }
        return null;
    }

    protected static <T> void callAllPublicMethods(Class<T> theClass, T object) throws InvocationTargetException {
        for (Method method : theClass.getMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] parameters = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameters[i] = ForwardingTestCase.getDefaultValue(parameterTypes[i]);
            }
            try {
                try {
                    method.invoke(object, parameters);
                }
                catch (InvocationTargetException ex) {
                    try {
                        throw ex.getCause();
                    }
                    catch (UnsupportedOperationException unsupported) {}
                }
            }
            catch (Throwable cause) {
                String string = String.valueOf(String.valueOf(method));
                String string2 = String.valueOf(String.valueOf(Arrays.toString(parameters)));
                throw new InvocationTargetException(cause, new StringBuilder(12 + string.length() + string2.length()).append(string).append(" with args: ").append(string2).toString());
            }
        }
    }
}

