/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.BiMapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestBiMapGenerator;
import com.google.common.collect.testing.google.TestStringBiMapGenerator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class HashBiMapTest
extends TestCase {
    private static final int N = 1000;

    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new HashBiMapGenerator()).named("HashBiMap")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTestSuite(HashBiMapTest.class);
        return suite;
    }

    public void testMapConstructor() {
        ImmutableMap map = ImmutableMap.of((Object)"canada", (Object)"dollar", (Object)"chile", (Object)"peso", (Object)"switzerland", (Object)"franc");
        HashBiMap bimap = HashBiMap.create((Map)map);
        HashBiMapTest.assertEquals((String)"dollar", (String)((String)bimap.get((Object)"canada")));
        HashBiMapTest.assertEquals((String)"canada", (String)((String)bimap.inverse().get((Object)"dollar")));
    }

    public void testBashIt() throws Exception {
        int i;
        HashBiMap bimap = HashBiMap.create((int)1000);
        BiMap inverse = bimap.inverse();
        for (i = 0; i < 1000; ++i) {
            HashBiMapTest.assertNull((Object)bimap.put((Object)(2 * i), (Object)(2 * i + 1)));
        }
        for (i = 0; i < 1000; ++i) {
            HashBiMapTest.assertEquals((int)(2 * i + 1), (int)((Integer)bimap.get((Object)(2 * i))));
        }
        for (i = 0; i < 1000; ++i) {
            HashBiMapTest.assertEquals((int)(2 * i), (int)((Integer)inverse.get((Object)(2 * i + 1))));
        }
        for (i = 0; i < 1000; ++i) {
            int oldValue = (Integer)bimap.get((Object)(2 * i));
            HashBiMapTest.assertEquals((int)(2 * i + 1), (int)((Integer)bimap.put((Object)(2 * i), (Object)(oldValue - 2))));
        }
        for (i = 0; i < 1000; ++i) {
            HashBiMapTest.assertEquals((int)(2 * i - 1), (int)((Integer)bimap.get((Object)(2 * i))));
        }
        for (i = 0; i < 1000; ++i) {
            HashBiMapTest.assertEquals((int)(2 * i), (int)((Integer)inverse.get((Object)(2 * i - 1))));
        }
        Set entries = bimap.entrySet();
        for (Map.Entry entry : entries) {
            entry.setValue((Integer)entry.getValue() + 2000);
        }
        for (int i2 = 0; i2 < 1000; ++i2) {
            HashBiMapTest.assertEquals((int)(2000 + 2 * i2 - 1), (int)((Integer)bimap.get((Object)(2 * i2))));
        }
    }

    public void testBiMapEntrySetIteratorRemove() {
        HashBiMap map = HashBiMap.create();
        map.put((Object)1, (Object)"one");
        Set entries = map.entrySet();
        Iterator iterator = entries.iterator();
        Map.Entry entry = (Map.Entry)iterator.next();
        entry.setValue("two");
        HashBiMapTest.assertEquals((String)"two", (String)((String)map.get((Object)1)));
        HashBiMapTest.assertEquals((Object)1, (Object)map.inverse().get((Object)"two"));
        iterator.remove();
        HashBiMapTest.assertTrue((boolean)map.isEmpty());
    }

    public static final class HashBiMapGenerator
    extends TestStringBiMapGenerator {
        protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
            HashBiMap result = HashBiMap.create();
            for (Map.Entry<String, String> entry : entries) {
                result.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return result;
        }
    }
}

