/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.SortedMultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import com.google.common.collect.testing.google.UnmodifiableCollectionTests;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class ImmutableSortedMultisetTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ImmutableSortedMultisetTest.class);
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)SortedMultisetTestSuiteBuilder.using((TestMultisetGenerator)new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return ImmutableSortedMultiset.copyOf((Comparable[])elements);
            }

            public List<String> order(List<String> insertionOrder) {
                return Ordering.natural().sortedCopy(insertionOrder);
            }
        }).named("ImmutableSortedMultiset")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                return ImmutableSortedMultiset.copyOf((Comparable[])elements).asList();
            }

            public List<String> order(List<String> insertionOrder) {
                return Ordering.natural().sortedCopy(insertionOrder);
            }
        }).named("ImmutableSortedMultiset.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                HashSet set = Sets.newHashSet();
                ImmutableSortedMultiset.Builder builder = ImmutableSortedMultiset.naturalOrder();
                for (String s : elements) {
                    Preconditions.checkArgument((boolean)set.add(s));
                    builder.addCopies((Object)s, 2);
                }
                return builder.build().elementSet().asList();
            }

            public List<String> order(List<String> insertionOrder) {
                return Ordering.natural().sortedCopy(insertionOrder);
            }
        }).named("ImmutableSortedMultiset.elementSet.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public void testCreation_noArgs() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.of();
        ImmutableSortedMultisetTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testCreation_oneElement() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.of((Comparable)((Object)"a"));
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a")), (Object)multiset);
    }

    public void testCreation_twoElements() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"));
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b")), (Object)multiset);
    }

    public void testCreation_threeElements() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"c"));
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c")), (Object)multiset);
    }

    public void testCreation_fourElements() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"c"), (Comparable)((Object)"d"));
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c", "d")), (Object)multiset);
    }

    public void testCreation_fiveElements() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"c"), (Comparable)((Object)"d"), (Comparable)((Object)"e"));
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c", "d", "e")), (Object)multiset);
    }

    public void testCreation_sixElements() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"c"), (Comparable)((Object)"d"), (Comparable)((Object)"e"), (Comparable)((Object)"f"), (Comparable[])new String[0]);
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c", "d", "e", "f")), (Object)multiset);
    }

    public void testCreation_sevenElements() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"c"), (Comparable)((Object)"d"), (Comparable)((Object)"e"), (Comparable)((Object)"f"), (Comparable[])new String[]{"g"});
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c", "d", "e", "f", "g")), (Object)multiset);
    }

    public void testCreation_emptyArray() {
        String[] array = new String[]{};
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Comparable[])array);
        ImmutableSortedMultisetTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testCreation_arrayOfOneElement() {
        String[] array = new String[]{"a"};
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Comparable[])array);
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a")), (Object)multiset);
    }

    public void testCreation_arrayOfArray() {
        Ordering comparator = Ordering.natural().lexicographical().onResultOf((Function)new Function<String[], Iterable<Comparable>>(){

            public Iterable<Comparable> apply(String[] input) {
                return Arrays.asList(input);
            }
        });
        String[] array = new String[]{"a"};
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.orderedBy((Comparator)comparator).add((Object)array).build();
        HashMultiset expected = HashMultiset.create();
        expected.add((Object)array);
        ImmutableSortedMultisetTest.assertEquals((Object)expected, (Object)multiset);
    }

    public void testCreation_arrayContainingOnlyNull() {
        String[] array = new String[]{null};
        try {
            ImmutableSortedMultiset.copyOf((Comparable[])array);
            ImmutableSortedMultisetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_collection_empty() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[0]);
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Iterable)c);
        ImmutableSortedMultisetTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testCopyOf_collection_oneElement() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a"});
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Iterable)c);
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a")), (Object)multiset);
    }

    public void testCopyOf_collection_general() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a", "b", "a"});
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Iterable)c);
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a")), (Object)multiset);
    }

    public void testCopyOf_collectionContainingNull() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a", null, "b"});
        try {
            ImmutableSortedMultiset.copyOf((Iterable)c);
            ImmutableSortedMultisetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_multiset_empty() {
        HashMultiset c = HashMultiset.create();
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Iterable)c);
        ImmutableSortedMultisetTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testCopyOf_multiset_oneElement() {
        HashMultiset c = HashMultiset.create(Arrays.asList("a"));
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Iterable)c);
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a")), (Object)multiset);
    }

    public void testCopyOf_multiset_general() {
        HashMultiset c = HashMultiset.create(Arrays.asList("a", "b", "a"));
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Iterable)c);
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a")), (Object)multiset);
    }

    public void testCopyOf_multisetContainingNull() {
        HashMultiset c = HashMultiset.create(Arrays.asList("a", null, "b"));
        try {
            ImmutableSortedMultiset.copyOf((Iterable)c);
            ImmutableSortedMultisetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_iterator_empty() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Iterator)iterator);
        ImmutableSortedMultisetTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testCopyOf_iterator_oneElement() {
        UnmodifiableIterator iterator = Iterators.singletonIterator((Object)"a");
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Iterator)iterator);
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a")), (Object)multiset);
    }

    public void testCopyOf_iterator_general() {
        Iterator<String> iterator = Arrays.asList("a", "b", "a").iterator();
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf(iterator);
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a")), (Object)multiset);
    }

    public void testCopyOf_iteratorContainingNull() {
        Iterator<String> iterator = Arrays.asList("a", null, "b").iterator();
        try {
            ImmutableSortedMultiset.copyOf(iterator);
            ImmutableSortedMultisetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_plainIterable() {
        CountingIterable iterable = new CountingIterable();
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Iterable)iterable);
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a")), (Object)multiset);
        ImmutableSortedMultisetTest.assertEquals((int)1, (int)iterable.count);
    }

    public void testCopyOf_shortcut_empty() {
        ImmutableSortedMultiset c = ImmutableSortedMultiset.of();
        ImmutableSortedMultisetTest.assertSame((Object)c, (Object)ImmutableSortedMultiset.copyOf((Iterable)c));
    }

    public void testCopyOf_shortcut_singleton() {
        ImmutableSortedMultiset c = ImmutableSortedMultiset.of((Comparable)((Object)"a"));
        ImmutableSortedMultisetTest.assertSame((Object)c, (Object)ImmutableSortedMultiset.copyOf((Iterable)c));
    }

    public void testCopyOf_shortcut_immutableMultiset() {
        ImmutableSortedMultiset c = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"c"));
        ImmutableSortedMultisetTest.assertSame((Object)c, (Object)ImmutableSortedMultiset.copyOf((Iterable)c));
    }

    public void testBuilderAdd() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.naturalOrder().add((Object)"a").add((Object)"b").add((Object)"a").add((Object)"c").build();
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a", "c")), (Object)multiset);
    }

    public void testBuilderAddAll() {
        List<String> a = Arrays.asList("a", "b");
        List<String> b = Arrays.asList("c", "d");
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.naturalOrder().addAll(a).addAll(b).build();
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "c", "d")), (Object)multiset);
    }

    public void testBuilderAddAllMultiset() {
        HashMultiset a = HashMultiset.create(Arrays.asList("a", "b", "b"));
        HashMultiset b = HashMultiset.create(Arrays.asList("c", "b"));
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.naturalOrder().addAll((Iterable)a).addAll((Iterable)b).build();
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "b", "b", "c")), (Object)multiset);
    }

    public void testBuilderAddAllIterator() {
        Iterator<String> iterator = Arrays.asList("a", "b", "a", "c").iterator();
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.naturalOrder().addAll(iterator).build();
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "b", "a", "c")), (Object)multiset);
    }

    public void testBuilderAddCopies() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.naturalOrder().addCopies((Object)"a", 2).addCopies((Object)"b", 3).addCopies((Object)"c", 0).build();
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "a", "b", "b", "b")), (Object)multiset);
    }

    public void testBuilderSetCount() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.naturalOrder().add((Object)"a").setCount((Object)"a", 2).setCount((Object)"b", 3).build();
        ImmutableSortedMultisetTest.assertEquals((Object)HashMultiset.create(Arrays.asList("a", "a", "b", "b", "b")), (Object)multiset);
    }

    public void testBuilderAddHandlesNullsCorrectly() {
        ImmutableSortedMultiset.Builder builder = ImmutableSortedMultiset.naturalOrder();
        try {
            builder.add((Object)null);
            ImmutableSortedMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilderAddAllHandlesNullsCorrectly() {
        ImmutableSortedMultiset.Builder builder = ImmutableSortedMultiset.naturalOrder();
        try {
            builder.addAll((Iterable)null);
            ImmutableSortedMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        builder = ImmutableSortedMultiset.naturalOrder();
        List<String> listWithNulls = Arrays.asList("a", null, "b");
        try {
            builder.addAll(listWithNulls);
            ImmutableSortedMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        builder = ImmutableSortedMultiset.naturalOrder();
        LinkedHashMultiset multisetWithNull = LinkedHashMultiset.create(Arrays.asList("a", null, "b"));
        try {
            builder.addAll((Iterable)multisetWithNull);
            ImmutableSortedMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
    }

    public void testBuilderAddCopiesHandlesNullsCorrectly() {
        ImmutableSortedMultiset.Builder builder = ImmutableSortedMultiset.naturalOrder();
        try {
            builder.addCopies(null, 2);
            ImmutableSortedMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilderAddCopiesIllegal() {
        ImmutableSortedMultiset.Builder builder = ImmutableSortedMultiset.naturalOrder();
        try {
            builder.addCopies((Object)"a", -2);
            ImmutableSortedMultisetTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBuilderSetCountHandlesNullsCorrectly() {
        ImmutableSortedMultiset.Builder builder = new ImmutableSortedMultiset.Builder((Comparator)Ordering.natural().nullsFirst());
        try {
            builder.setCount(null, 2);
            ImmutableSortedMultisetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilderSetCountIllegal() {
        ImmutableSortedMultiset.Builder builder = ImmutableSortedMultiset.naturalOrder();
        try {
            builder.setCount((Object)"a", -2);
            ImmutableSortedMultisetTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullPointers() {
        new NullPointerTester().testAllPublicStaticMethods(ImmutableSortedMultiset.class);
    }

    public void testSerialization_empty() {
        ImmutableSortedMultiset c = ImmutableSortedMultiset.of();
        ImmutableSortedMultisetTest.assertSame((Object)c, (Object)SerializableTester.reserialize((Object)c));
    }

    public void testSerialization_multiple() {
        ImmutableSortedMultiset c = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"a"));
        Collection copy = (Collection)SerializableTester.reserializeAndAssert((Object)c);
        Truth.assertThat((Collection)copy).has().exactly((Object)"a", (Object)"a", (Object[])new String[]{"b"}).inOrder();
    }

    public void testSerialization_elementSet() {
        ImmutableSortedMultiset c = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"a"));
        Collection copy = (Collection)SerializableTester.reserializeAndAssert((Object)c.elementSet());
        Truth.assertThat((Collection)copy).has().exactly((Object)"a", (Object)"b", (Object[])new String[0]).inOrder();
    }

    public void testSerialization_entrySet() {
        ImmutableSortedMultiset c = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"c"));
        SerializableTester.reserializeAndAssert((Object)c.entrySet());
    }

    public void testEquals_immutableMultiset() {
        ImmutableSortedMultiset c = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"a"));
        ImmutableSortedMultisetTest.assertEquals((Object)c, (Object)ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"a")));
        ImmutableSortedMultisetTest.assertEquals((Object)c, (Object)ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"a"), (Comparable)((Object)"b")));
        Truth.assertThat((Collection)c).isNotEqualTo((Object)ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b")));
        Truth.assertThat((Collection)c).isNotEqualTo((Object)ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"c"), (Comparable)((Object)"d")));
    }

    public void testIterationOrder() {
        ImmutableSortedMultiset c = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"a"));
        Truth.assertThat((Collection)c).has().exactly((Object)"a", (Object)"a", (Object[])new String[]{"b"}).inOrder();
    }

    public void testMultisetWrites() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"a"));
        UnmodifiableCollectionTests.assertMultisetIsUnmodifiable((Multiset)multiset, (Object)"test");
    }

    public void testAsList() {
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.of((Comparable)((Object)"a"), (Comparable)((Object)"a"), (Comparable)((Object)"b"), (Comparable)((Object)"b"), (Comparable)((Object)"b"));
        ImmutableList list = multiset.asList();
        ImmutableSortedMultisetTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"a", (Object)"b", (Object)"b", (Object)"b"), (Object)list);
        ImmutableSortedMultisetTest.assertTrue((boolean)(list instanceof ImmutableAsList));
        ImmutableList copy = (ImmutableList)SerializableTester.reserializeAndAssert((Object)list);
        ImmutableSortedMultisetTest.assertTrue((boolean)(copy instanceof ImmutableAsList));
        ImmutableSortedMultisetTest.assertEquals((int)2, (int)list.indexOf((Object)"b"));
        ImmutableSortedMultisetTest.assertEquals((int)4, (int)list.lastIndexOf((Object)"b"));
    }

    public void testCopyOfDefensiveCopy() {
        class TestArrayList<E>
        extends ArrayList<E> {
            boolean toArrayCalled = false;

            TestArrayList() {
            }

            @Override
            public Object[] toArray() {
                this.toArrayCalled = true;
                return super.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                this.toArrayCalled = true;
                return super.toArray(a);
            }
        }
        TestArrayList toCopy = new TestArrayList();
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOf((Comparator)Ordering.natural(), toCopy);
        ImmutableSortedMultisetTest.assertTrue((boolean)toCopy.toArrayCalled);
    }

    public void testCopyOfSortedDefensiveCopy() {
        SortedMultiset toCopy = (SortedMultiset)EasyMock.createMock(SortedMultiset.class);
        class TestHashSet<E>
        extends HashSet<E> {
            boolean toArrayCalled = false;

            TestHashSet() {
            }

            @Override
            public Object[] toArray() {
                this.toArrayCalled = true;
                return super.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                this.toArrayCalled = true;
                return super.toArray(a);
            }
        }
        TestHashSet entrySet = new TestHashSet();
        EasyMock.expect((Object)toCopy.comparator()).andReturn((Object)Ordering.natural());
        EasyMock.expect((Object)toCopy.entrySet()).andReturn(entrySet);
        EasyMock.replay((Object[])new Object[]{toCopy});
        ImmutableSortedMultiset multiset = ImmutableSortedMultiset.copyOfSorted((SortedMultiset)toCopy);
        EasyMock.verify((Object[])new Object[]{toCopy});
        ImmutableSortedMultisetTest.assertTrue((boolean)entrySet.toArrayCalled);
    }

    public void testCopyOfDuplicateInconsistentWithEquals() {
        IntegerDiv10 three = new IntegerDiv10(3);
        IntegerDiv10 eleven = new IntegerDiv10(11);
        IntegerDiv10 twelve = new IntegerDiv10(12);
        IntegerDiv10 twenty = new IntegerDiv10(20);
        ImmutableList original = ImmutableList.of((Object)three, (Object)eleven, (Object)twelve, (Object)twenty);
        ImmutableSortedMultiset copy = ImmutableSortedMultiset.copyOf((Iterable)original);
        ImmutableSortedMultisetTest.assertTrue((boolean)copy.contains((Object)eleven));
        ImmutableSortedMultisetTest.assertTrue((boolean)copy.contains((Object)twelve));
    }

    private static class IntegerDiv10
    implements Comparable<IntegerDiv10> {
        final int value;

        IntegerDiv10(int value) {
            this.value = value;
        }

        @Override
        public int compareTo(IntegerDiv10 o) {
            return this.value / 10 - o.value / 10;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    private static class CountingIterable
    implements Iterable<String> {
        int count = 0;

        private CountingIterable() {
        }

        @Override
        public Iterator<String> iterator() {
            ++this.count;
            return Arrays.asList("a", "b", "a").iterator();
        }
    }
}

