/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.testing.SerializableTester;
import java.util.Set;
import junit.framework.Assert;

@GwtCompatible(emulated=true)
final class LenientSerializableTester {
    @GwtIncompatible(value="SerializableTester")
    static <E> Set<E> reserializeAndAssertLenient(Set<E> original) {
        Set copy = (Set)SerializableTester.reserialize(original);
        Assert.assertEquals(original, (Object)copy);
        Assert.assertTrue((boolean)(copy instanceof ImmutableSet));
        return copy;
    }

    @GwtIncompatible(value="SerializableTester")
    static <E> Multiset<E> reserializeAndAssertLenient(Multiset<E> original) {
        Multiset copy = (Multiset)SerializableTester.reserialize(original);
        Assert.assertEquals(original, (Object)copy);
        Assert.assertTrue((boolean)(copy instanceof ImmutableMultiset));
        return copy;
    }

    private LenientSerializableTester() {
    }
}

