/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetFeature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class LinkedHashMultisetTest
extends TestCase {
    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)LinkedHashMultisetTest.linkedHashMultisetGenerator()).named("LinkedHashMultiset")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.SERIALIZABLE, CollectionFeature.GENERAL_PURPOSE, MultisetFeature.ENTRIES_ARE_VIEWS})).createTestSuite());
        suite.addTestSuite(LinkedHashMultisetTest.class);
        return suite;
    }

    private static TestStringMultisetGenerator linkedHashMultisetGenerator() {
        return new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return LinkedHashMultiset.create(Arrays.asList(elements));
            }

            public List<String> order(List<String> insertionOrder) {
                ArrayList order = Lists.newArrayList();
                for (String s : insertionOrder) {
                    int index = order.indexOf(s);
                    if (index == -1) {
                        order.add(s);
                        continue;
                    }
                    order.add(index, s);
                }
                return order;
            }
        };
    }

    public void testCreate() {
        LinkedHashMultiset multiset = LinkedHashMultiset.create();
        multiset.add((Object)"foo", 2);
        multiset.add((Object)"bar");
        LinkedHashMultisetTest.assertEquals((int)3, (int)multiset.size());
        LinkedHashMultisetTest.assertEquals((int)2, (int)multiset.count((Object)"foo"));
        LinkedHashMultisetTest.assertEquals((String)"[foo x 2, bar]", (String)multiset.toString());
    }

    public void testCreateWithSize() {
        LinkedHashMultiset multiset = LinkedHashMultiset.create((int)50);
        multiset.add((Object)"foo", 2);
        multiset.add((Object)"bar");
        LinkedHashMultisetTest.assertEquals((int)3, (int)multiset.size());
        LinkedHashMultisetTest.assertEquals((int)2, (int)multiset.count((Object)"foo"));
        LinkedHashMultisetTest.assertEquals((String)"[foo x 2, bar]", (String)multiset.toString());
    }

    public void testCreateFromIterable() {
        LinkedHashMultiset multiset = LinkedHashMultiset.create(Arrays.asList("foo", "bar", "foo"));
        LinkedHashMultisetTest.assertEquals((int)3, (int)multiset.size());
        LinkedHashMultisetTest.assertEquals((int)2, (int)multiset.count((Object)"foo"));
        LinkedHashMultisetTest.assertEquals((String)"[foo x 2, bar]", (String)multiset.toString());
    }

    public void testToString() {
        LinkedHashMultiset ms = LinkedHashMultiset.create();
        ms.add((Object)"a", 3);
        ms.add((Object)"c", 1);
        ms.add((Object)"b", 2);
        LinkedHashMultisetTest.assertEquals((String)"[a x 3, c, b x 2]", (String)ms.toString());
    }

    public void testLosesPlaceInLine() throws Exception {
        LinkedHashMultiset ms = LinkedHashMultiset.create();
        ms.add((Object)"a");
        ms.add((Object)"b", 2);
        ms.add((Object)"c");
        Truth.assertThat((Collection)ms.elementSet()).has().exactly((Object)"a", (Object)"b", (Object[])new String[]{"c"}).inOrder();
        ms.remove((Object)"b");
        Truth.assertThat((Collection)ms.elementSet()).has().exactly((Object)"a", (Object)"b", (Object[])new String[]{"c"}).inOrder();
        ms.add((Object)"b");
        Truth.assertThat((Collection)ms.elementSet()).has().exactly((Object)"a", (Object)"b", (Object[])new String[]{"c"}).inOrder();
        ms.remove((Object)"b", 2);
        ms.add((Object)"b");
        Truth.assertThat((Collection)ms.elementSet()).has().exactly((Object)"a", (Object)"c", (Object[])new String[]{"b"}).inOrder();
    }
}

