/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMapTest;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.MapPutTester;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class MutableClassToInstanceMapTest
extends TestCase {
    private ClassToInstanceMap<Number> map;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(MutableClassToInstanceMapTest.class);
        Method remapTest = null;
        try {
            remapTest = MapPutTester.class.getMethod("testPut_replaceNullValueWithNonNullSupported", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError();
        }
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new ImmutableClassToInstanceMapTest.TestClassToInstanceMapGenerator(){

            public Map<Class, Number> create(Object ... elements) {
                MutableClassToInstanceMap map = MutableClassToInstanceMap.create();
                for (Object object : elements) {
                    Map.Entry entry = (Map.Entry)object;
                    map.putInstance((Class)entry.getKey(), entry.getValue());
                }
                return map;
            }
        }).named("MutableClassToInstanceMap")).withFeatures(new Feature[]{MapFeature.GENERAL_PURPOSE, MapFeature.RESTRICTS_KEYS, MapFeature.ALLOWS_NULL_VALUES, CollectionSize.ANY, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_ANY_NULL_QUERIES})).suppressing(new Method[]{remapTest})).createTestSuite());
        return suite;
    }

    protected void setUp() throws Exception {
        this.map = MutableClassToInstanceMap.create();
    }

    public void testConstraint() {
        this.map.put(Integer.class, (Object)new Integer(5));
        try {
            this.map.put(Double.class, (Object)new Long(42L));
            MutableClassToInstanceMapTest.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testPutAndGetInstance() {
        MutableClassToInstanceMapTest.assertNull((Object)this.map.putInstance(Integer.class, (Object)new Integer(5)));
        Integer oldValue = (Integer)this.map.putInstance(Integer.class, (Object)new Integer(7));
        MutableClassToInstanceMapTest.assertEquals((int)5, (int)oldValue);
        Integer newValue = (Integer)this.map.getInstance(Integer.class);
        MutableClassToInstanceMapTest.assertEquals((int)7, (int)newValue);
    }

    public void testNull() {
        try {
            this.map.put(null, (Object)new Integer(1));
            MutableClassToInstanceMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.map.putInstance(Integer.class, null);
        MutableClassToInstanceMapTest.assertNull((Object)this.map.get(Integer.class));
        MutableClassToInstanceMapTest.assertNull((Object)this.map.getInstance(Integer.class));
        this.map.put(Long.class, null);
        MutableClassToInstanceMapTest.assertNull((Object)this.map.get(Long.class));
        MutableClassToInstanceMapTest.assertNull((Object)this.map.getInstance(Long.class));
    }

    public void testPrimitiveAndWrapper() {
        MutableClassToInstanceMapTest.assertNull((Object)this.map.getInstance(Integer.TYPE));
        MutableClassToInstanceMapTest.assertNull((Object)this.map.getInstance(Integer.class));
        MutableClassToInstanceMapTest.assertNull((Object)this.map.putInstance(Integer.TYPE, (Object)0));
        MutableClassToInstanceMapTest.assertNull((Object)this.map.putInstance(Integer.class, (Object)1));
        MutableClassToInstanceMapTest.assertEquals((int)2, (int)this.map.size());
        MutableClassToInstanceMapTest.assertEquals((int)0, (int)((Integer)this.map.getInstance(Integer.TYPE)));
        MutableClassToInstanceMapTest.assertEquals((int)1, (int)((Integer)this.map.getInstance(Integer.class)));
        MutableClassToInstanceMapTest.assertEquals((int)0, (int)((Integer)this.map.putInstance(Integer.TYPE, null)));
        MutableClassToInstanceMapTest.assertEquals((int)1, (int)((Integer)this.map.putInstance(Integer.class, null)));
        MutableClassToInstanceMapTest.assertNull((Object)this.map.getInstance(Integer.TYPE));
        MutableClassToInstanceMapTest.assertNull((Object)this.map.getInstance(Integer.class));
        MutableClassToInstanceMapTest.assertEquals((int)2, (int)this.map.size());
    }
}

