/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.Cut;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LegacyComparable;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.testing.Helpers;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

@GwtCompatible
public class RangeTest
extends TestCase {
    static final DiscreteDomain<Integer> UNBOUNDED_DOMAIN = new DiscreteDomain<Integer>(){

        public Integer next(Integer value) {
            return (Integer)1.integers().next((Comparable)value);
        }

        public Integer previous(Integer value) {
            return (Integer)1.integers().previous((Comparable)value);
        }

        public long distance(Integer start, Integer end) {
            return 1.integers().distance((Comparable)start, (Comparable)end);
        }
    };

    public void testOpen() {
        Range range = Range.open((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(8));
        RangeTest.checkContains((Range<Integer>)range);
        RangeTest.assertTrue((boolean)range.hasLowerBound());
        RangeTest.assertEquals((int)4, (int)((Integer)range.lowerEndpoint()));
        RangeTest.assertEquals((Object)BoundType.OPEN, (Object)range.lowerBoundType());
        RangeTest.assertTrue((boolean)range.hasUpperBound());
        RangeTest.assertEquals((int)8, (int)((Integer)range.upperEndpoint()));
        RangeTest.assertEquals((Object)BoundType.OPEN, (Object)range.upperBoundType());
        RangeTest.assertFalse((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"(4\u20258)", (String)range.toString());
        SerializableTester.reserializeAndAssert((Object)range);
    }

    public void testOpen_invalid() {
        try {
            Range.open((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(3));
            RangeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(3));
            RangeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testClosed() {
        Range range = Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7));
        RangeTest.checkContains((Range<Integer>)range);
        RangeTest.assertTrue((boolean)range.hasLowerBound());
        RangeTest.assertEquals((int)5, (int)((Integer)range.lowerEndpoint()));
        RangeTest.assertEquals((Object)BoundType.CLOSED, (Object)range.lowerBoundType());
        RangeTest.assertTrue((boolean)range.hasUpperBound());
        RangeTest.assertEquals((int)7, (int)((Integer)range.upperEndpoint()));
        RangeTest.assertEquals((Object)BoundType.CLOSED, (Object)range.upperBoundType());
        RangeTest.assertFalse((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"[5\u20257]", (String)range.toString());
        SerializableTester.reserializeAndAssert((Object)range);
    }

    public void testClosed_invalid() {
        try {
            Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(3));
            RangeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testOpenClosed() {
        Range range = Range.openClosed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(7));
        RangeTest.checkContains((Range<Integer>)range);
        RangeTest.assertTrue((boolean)range.hasLowerBound());
        RangeTest.assertEquals((int)4, (int)((Integer)range.lowerEndpoint()));
        RangeTest.assertEquals((Object)BoundType.OPEN, (Object)range.lowerBoundType());
        RangeTest.assertTrue((boolean)range.hasUpperBound());
        RangeTest.assertEquals((int)7, (int)((Integer)range.upperEndpoint()));
        RangeTest.assertEquals((Object)BoundType.CLOSED, (Object)range.upperBoundType());
        RangeTest.assertFalse((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"(4\u20257]", (String)range.toString());
        SerializableTester.reserializeAndAssert((Object)range);
    }

    public void testClosedOpen() {
        Range range = Range.closedOpen((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(8));
        RangeTest.checkContains((Range<Integer>)range);
        RangeTest.assertTrue((boolean)range.hasLowerBound());
        RangeTest.assertEquals((int)5, (int)((Integer)range.lowerEndpoint()));
        RangeTest.assertEquals((Object)BoundType.CLOSED, (Object)range.lowerBoundType());
        RangeTest.assertTrue((boolean)range.hasUpperBound());
        RangeTest.assertEquals((int)8, (int)((Integer)range.upperEndpoint()));
        RangeTest.assertEquals((Object)BoundType.OPEN, (Object)range.upperBoundType());
        RangeTest.assertFalse((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"[5\u20258)", (String)range.toString());
        SerializableTester.reserializeAndAssert((Object)range);
    }

    public void testIsConnected() {
        RangeTest.assertTrue((boolean)Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)).isConnected(Range.open((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(6))));
        RangeTest.assertTrue((boolean)Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)).isConnected(Range.openClosed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(5))));
        RangeTest.assertTrue((boolean)Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)).isConnected(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(6))));
        RangeTest.assertTrue((boolean)Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)).isConnected(Range.open((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8))));
        RangeTest.assertTrue((boolean)Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)).isConnected(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(6))));
        RangeTest.assertFalse((boolean)Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)).isConnected(Range.closed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(8))));
        RangeTest.assertFalse((boolean)Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)).isConnected(Range.closedOpen((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(7))));
    }

    private static void checkContains(Range<Integer> range) {
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(4)));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(5)));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(7)));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(8)));
    }

    public void testSingleton() {
        Range range = Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(4));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(3)));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(4)));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(5)));
        RangeTest.assertTrue((boolean)range.hasLowerBound());
        RangeTest.assertEquals((int)4, (int)((Integer)range.lowerEndpoint()));
        RangeTest.assertEquals((Object)BoundType.CLOSED, (Object)range.lowerBoundType());
        RangeTest.assertTrue((boolean)range.hasUpperBound());
        RangeTest.assertEquals((int)4, (int)((Integer)range.upperEndpoint()));
        RangeTest.assertEquals((Object)BoundType.CLOSED, (Object)range.upperBoundType());
        RangeTest.assertFalse((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"[4\u20254]", (String)range.toString());
        SerializableTester.reserializeAndAssert((Object)range);
    }

    public void testEmpty1() {
        Range range = Range.closedOpen((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(4));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(3)));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(4)));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(5)));
        RangeTest.assertTrue((boolean)range.hasLowerBound());
        RangeTest.assertEquals((int)4, (int)((Integer)range.lowerEndpoint()));
        RangeTest.assertEquals((Object)BoundType.CLOSED, (Object)range.lowerBoundType());
        RangeTest.assertTrue((boolean)range.hasUpperBound());
        RangeTest.assertEquals((int)4, (int)((Integer)range.upperEndpoint()));
        RangeTest.assertEquals((Object)BoundType.OPEN, (Object)range.upperBoundType());
        RangeTest.assertTrue((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"[4\u20254)", (String)range.toString());
        SerializableTester.reserializeAndAssert((Object)range);
    }

    public void testEmpty2() {
        Range range = Range.openClosed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(4));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(3)));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(4)));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(5)));
        RangeTest.assertTrue((boolean)range.hasLowerBound());
        RangeTest.assertEquals((int)4, (int)((Integer)range.lowerEndpoint()));
        RangeTest.assertEquals((Object)BoundType.OPEN, (Object)range.lowerBoundType());
        RangeTest.assertTrue((boolean)range.hasUpperBound());
        RangeTest.assertEquals((int)4, (int)((Integer)range.upperEndpoint()));
        RangeTest.assertEquals((Object)BoundType.CLOSED, (Object)range.upperBoundType());
        RangeTest.assertTrue((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"(4\u20254]", (String)range.toString());
        SerializableTester.reserializeAndAssert((Object)range);
    }

    public void testLessThan() {
        Range range = Range.lessThan((Comparable)Integer.valueOf(5));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(Integer.MIN_VALUE)));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(4)));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(5)));
        RangeTest.assertUnboundedBelow((Range<Integer>)range);
        RangeTest.assertTrue((boolean)range.hasUpperBound());
        RangeTest.assertEquals((int)5, (int)((Integer)range.upperEndpoint()));
        RangeTest.assertEquals((Object)BoundType.OPEN, (Object)range.upperBoundType());
        RangeTest.assertFalse((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"(-\u221e\u20255)", (String)range.toString());
        SerializableTester.reserializeAndAssert((Object)range);
    }

    public void testGreaterThan() {
        Range range = Range.greaterThan((Comparable)Integer.valueOf(5));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(5)));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(6)));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        RangeTest.assertTrue((boolean)range.hasLowerBound());
        RangeTest.assertEquals((int)5, (int)((Integer)range.lowerEndpoint()));
        RangeTest.assertEquals((Object)BoundType.OPEN, (Object)range.lowerBoundType());
        RangeTest.assertUnboundedAbove((Range<Integer>)range);
        RangeTest.assertFalse((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"(5\u2025+\u221e)", (String)range.toString());
        SerializableTester.reserializeAndAssert((Object)range);
    }

    public void testAtLeast() {
        Range range = Range.atLeast((Comparable)Integer.valueOf(6));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(5)));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(6)));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        RangeTest.assertTrue((boolean)range.hasLowerBound());
        RangeTest.assertEquals((int)6, (int)((Integer)range.lowerEndpoint()));
        RangeTest.assertEquals((Object)BoundType.CLOSED, (Object)range.lowerBoundType());
        RangeTest.assertUnboundedAbove((Range<Integer>)range);
        RangeTest.assertFalse((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"[6\u2025+\u221e)", (String)range.toString());
        SerializableTester.reserializeAndAssert((Object)range);
    }

    public void testAtMost() {
        Range range = Range.atMost((Comparable)Integer.valueOf(4));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(Integer.MIN_VALUE)));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(4)));
        RangeTest.assertFalse((boolean)range.contains((Comparable)Integer.valueOf(5)));
        RangeTest.assertUnboundedBelow((Range<Integer>)range);
        RangeTest.assertTrue((boolean)range.hasUpperBound());
        RangeTest.assertEquals((int)4, (int)((Integer)range.upperEndpoint()));
        RangeTest.assertEquals((Object)BoundType.CLOSED, (Object)range.upperBoundType());
        RangeTest.assertFalse((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"(-\u221e\u20254]", (String)range.toString());
        SerializableTester.reserializeAndAssert((Object)range);
    }

    public void testAll() {
        Range range = Range.all();
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(Integer.MIN_VALUE)));
        RangeTest.assertTrue((boolean)range.contains((Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        RangeTest.assertUnboundedBelow((Range<Integer>)range);
        RangeTest.assertUnboundedAbove((Range<Integer>)range);
        RangeTest.assertFalse((boolean)range.isEmpty());
        RangeTest.assertEquals((String)"(-\u221e\u2025+\u221e)", (String)range.toString());
        RangeTest.assertSame((Object)range, (Object)SerializableTester.reserializeAndAssert((Object)range));
        RangeTest.assertSame((Object)range, (Object)Range.all());
    }

    private static void assertUnboundedBelow(Range<Integer> range) {
        RangeTest.assertFalse((boolean)range.hasLowerBound());
        try {
            range.lowerEndpoint();
            RangeTest.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            range.lowerBoundType();
            RangeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void assertUnboundedAbove(Range<Integer> range) {
        RangeTest.assertFalse((boolean)range.hasUpperBound());
        try {
            range.upperEndpoint();
            RangeTest.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            range.upperBoundType();
            RangeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testOrderingCuts() {
        Cut a = Range.lessThan((Comparable)Integer.valueOf((int)0)).lowerBound;
        Cut b = Range.atLeast((Comparable)Integer.valueOf((int)0)).lowerBound;
        Cut c = Range.greaterThan((Comparable)Integer.valueOf((int)0)).lowerBound;
        Cut d = Range.atLeast((Comparable)Integer.valueOf((int)1)).lowerBound;
        Cut e = Range.greaterThan((Comparable)Integer.valueOf((int)1)).lowerBound;
        Cut f = Range.greaterThan((Comparable)Integer.valueOf((int)1)).upperBound;
        Helpers.testCompareToAndEquals((List)ImmutableList.of((Object)a, (Object)b, (Object)c, (Object)d, (Object)e, (Object)f));
    }

    public void testContainsAll() {
        Range range = Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5));
        RangeTest.assertTrue((boolean)range.containsAll(Arrays.asList(3, 3, 4, 5)));
        RangeTest.assertFalse((boolean)range.containsAll(Arrays.asList(3, 3, 4, 5, 6)));
        RangeTest.assertTrue((boolean)range.containsAll((Iterable)ImmutableSortedSet.of((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(5))));
        RangeTest.assertTrue((boolean)range.containsAll((Iterable)ImmutableSortedSet.of((Comparable)Integer.valueOf(3))));
        RangeTest.assertTrue((boolean)range.containsAll((Iterable)ImmutableSortedSet.of()));
        RangeTest.assertFalse((boolean)range.containsAll((Iterable)ImmutableSortedSet.of((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(6))));
        RangeTest.assertTrue((boolean)Range.openClosed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(3)).containsAll(Collections.emptySet()));
    }

    public void testEncloses_open() {
        Range range = Range.open((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5));
        RangeTest.assertTrue((boolean)range.encloses(range));
        RangeTest.assertTrue((boolean)range.encloses(Range.open((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4))));
        RangeTest.assertTrue((boolean)range.encloses(Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5))));
        RangeTest.assertTrue((boolean)range.encloses(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4))));
        RangeTest.assertFalse((boolean)range.encloses(Range.openClosed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5))));
        RangeTest.assertFalse((boolean)range.encloses(Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5))));
        RangeTest.assertFalse((boolean)range.encloses(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4))));
        RangeTest.assertFalse((boolean)range.encloses(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(6))));
        RangeTest.assertFalse((boolean)range.encloses(Range.greaterThan((Comparable)Integer.valueOf(3))));
        RangeTest.assertFalse((boolean)range.encloses(Range.lessThan((Comparable)Integer.valueOf(3))));
        RangeTest.assertFalse((boolean)range.encloses(Range.atLeast((Comparable)Integer.valueOf(3))));
        RangeTest.assertFalse((boolean)range.encloses(Range.atMost((Comparable)Integer.valueOf(3))));
        RangeTest.assertFalse((boolean)range.encloses(Range.all()));
    }

    public void testEncloses_closed() {
        Range range = Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5));
        RangeTest.assertTrue((boolean)range.encloses(range));
        RangeTest.assertTrue((boolean)range.encloses(Range.open((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5))));
        RangeTest.assertTrue((boolean)range.encloses(Range.openClosed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5))));
        RangeTest.assertTrue((boolean)range.encloses(Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5))));
        RangeTest.assertTrue((boolean)range.encloses(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5))));
        RangeTest.assertTrue((boolean)range.encloses(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4))));
        RangeTest.assertFalse((boolean)range.encloses(Range.open((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(6))));
        RangeTest.assertFalse((boolean)range.encloses(Range.greaterThan((Comparable)Integer.valueOf(3))));
        RangeTest.assertFalse((boolean)range.encloses(Range.lessThan((Comparable)Integer.valueOf(3))));
        RangeTest.assertFalse((boolean)range.encloses(Range.atLeast((Comparable)Integer.valueOf(3))));
        RangeTest.assertFalse((boolean)range.encloses(Range.atMost((Comparable)Integer.valueOf(3))));
        RangeTest.assertFalse((boolean)range.encloses(Range.all()));
    }

    public void testIntersection_empty() {
        Range range = Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(3));
        RangeTest.assertEquals((Object)range, (Object)range.intersection(range));
        try {
            range.intersection(Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)));
            RangeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            range.intersection(Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2)));
            RangeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIntersection_deFactoEmpty() {
        Range range = Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4));
        RangeTest.assertEquals((Object)range, (Object)range.intersection(range));
        RangeTest.assertEquals((Object)Range.openClosed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(3)), (Object)range.intersection(Range.atMost((Comparable)Integer.valueOf(3))));
        RangeTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(4)), (Object)range.intersection(Range.atLeast((Comparable)Integer.valueOf(4))));
        try {
            range.intersection(Range.lessThan((Comparable)Integer.valueOf(3)));
            RangeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            range.intersection(Range.greaterThan((Comparable)Integer.valueOf(4)));
            RangeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        range = Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(4));
        RangeTest.assertEquals((Object)Range.openClosed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(4)), (Object)range.intersection(Range.greaterThan((Comparable)Integer.valueOf(4))));
    }

    public void testIntersection_singleton() {
        Range range = Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(3));
        RangeTest.assertEquals((Object)range, (Object)range.intersection(range));
        RangeTest.assertEquals((Object)range, (Object)range.intersection(Range.atMost((Comparable)Integer.valueOf(4))));
        RangeTest.assertEquals((Object)range, (Object)range.intersection(Range.atMost((Comparable)Integer.valueOf(3))));
        RangeTest.assertEquals((Object)range, (Object)range.intersection(Range.atLeast((Comparable)Integer.valueOf(3))));
        RangeTest.assertEquals((Object)range, (Object)range.intersection(Range.atLeast((Comparable)Integer.valueOf(2))));
        RangeTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(3)), (Object)range.intersection(Range.lessThan((Comparable)Integer.valueOf(3))));
        RangeTest.assertEquals((Object)Range.openClosed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(3)), (Object)range.intersection(Range.greaterThan((Comparable)Integer.valueOf(3))));
        try {
            range.intersection(Range.atLeast((Comparable)Integer.valueOf(4)));
            RangeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            range.intersection(Range.atMost((Comparable)Integer.valueOf(2)));
            RangeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIntersection_general() {
        Range range = Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(8));
        try {
            range.intersection(Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2)));
            RangeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        RangeTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(4)), (Object)range.intersection(Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4))));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(6)), (Object)range.intersection(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(6))));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(6)), (Object)range.intersection(Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(6))));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)), (Object)range.intersection(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7))));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8)), (Object)range.intersection(Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8))));
        RangeTest.assertEquals((Object)range, (Object)range.intersection(range));
        RangeTest.assertEquals((Object)range, (Object)range.intersection(Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10))));
        RangeTest.assertEquals((Object)range, (Object)range.intersection(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))));
        RangeTest.assertEquals((Object)range, (Object)range.intersection(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(10))));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8)), (Object)range.intersection(Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(10))));
        RangeTest.assertEquals((Object)Range.openClosed((Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(8)), (Object)range.intersection(Range.openClosed((Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(10))));
        try {
            range.intersection(Range.closed((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(12)));
            RangeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSpan_general() {
        Range range = Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(8));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(8)), (Object)range.span(Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2))));
        RangeTest.assertEquals((Object)Range.atMost((Comparable)Integer.valueOf(8)), (Object)range.span(Range.atMost((Comparable)Integer.valueOf(2))));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8)), (Object)range.span(Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4))));
        RangeTest.assertEquals((Object)Range.atMost((Comparable)Integer.valueOf(8)), (Object)range.span(Range.lessThan((Comparable)Integer.valueOf(4))));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8)), (Object)range.span(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(6))));
        RangeTest.assertEquals((Object)Range.atMost((Comparable)Integer.valueOf(8)), (Object)range.span(Range.atMost((Comparable)Integer.valueOf(6))));
        RangeTest.assertEquals((Object)range, (Object)range.span(Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(6))));
        RangeTest.assertEquals((Object)range, (Object)range.span(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7))));
        RangeTest.assertEquals((Object)range, (Object)range.span(Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8))));
        RangeTest.assertEquals((Object)range, (Object)range.span(range));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)), (Object)range.span(Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10))));
        RangeTest.assertEquals((Object)Range.atLeast((Comparable)Integer.valueOf(4)), (Object)range.span(Range.atLeast((Comparable)Integer.valueOf(4))));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8)), (Object)range.span(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(8))));
        RangeTest.assertEquals((Object)Range.atMost((Comparable)Integer.valueOf(8)), (Object)range.span(Range.atMost((Comparable)Integer.valueOf(8))));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(10)), (Object)range.span(Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(10))));
        RangeTest.assertEquals((Object)Range.all(), (Object)range.span(Range.all()));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)), (Object)range.span(Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(10))));
        RangeTest.assertEquals((Object)Range.atLeast((Comparable)Integer.valueOf(4)), (Object)range.span(Range.atLeast((Comparable)Integer.valueOf(6))));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)), (Object)range.span(Range.openClosed((Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(10))));
        RangeTest.assertEquals((Object)Range.atLeast((Comparable)Integer.valueOf(4)), (Object)range.span(Range.greaterThan((Comparable)Integer.valueOf(8))));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(12)), (Object)range.span(Range.closed((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(12))));
        RangeTest.assertEquals((Object)Range.atLeast((Comparable)Integer.valueOf(4)), (Object)range.span(Range.atLeast((Comparable)Integer.valueOf(10))));
    }

    public void testApply() {
        Range predicate = Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3));
        RangeTest.assertFalse((boolean)predicate.apply((Object)1));
        RangeTest.assertTrue((boolean)predicate.apply((Object)2));
        RangeTest.assertTrue((boolean)predicate.apply((Object)3));
        RangeTest.assertFalse((boolean)predicate.apply((Object)4));
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{Range.open((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)), Range.range((Comparable)Integer.valueOf(1), (BoundType)BoundType.OPEN, (Comparable)Integer.valueOf(5), (BoundType)BoundType.OPEN)}).addEqualityGroup(new Object[]{Range.greaterThan((Comparable)Integer.valueOf(2)), Range.greaterThan((Comparable)Integer.valueOf(2))}).addEqualityGroup(new Object[]{Range.all(), Range.all()}).addEqualityGroup(new Object[]{"Phil"}).testEquals();
    }

    public void testLegacyComparable() {
        Range range = Range.closed((Comparable)LegacyComparable.X, (Comparable)LegacyComparable.Y);
    }

    public void testCanonical() {
        RangeTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)), (Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)).canonical(DiscreteDomain.integers()));
        RangeTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)), (Object)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(5)).canonical(DiscreteDomain.integers()));
        RangeTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)), (Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).canonical(DiscreteDomain.integers()));
        RangeTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)), (Object)Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)).canonical(DiscreteDomain.integers()));
        RangeTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(0)), (Object)Range.closedOpen((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(0)).canonical(DiscreteDomain.integers()));
        RangeTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(0)), (Object)Range.lessThan((Comparable)Integer.valueOf(0)).canonical(DiscreteDomain.integers()));
        RangeTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(1)), (Object)Range.atMost((Comparable)Integer.valueOf(0)).canonical(DiscreteDomain.integers()));
        RangeTest.assertEquals((Object)Range.atLeast((Comparable)Integer.valueOf(0)), (Object)Range.atLeast((Comparable)Integer.valueOf(0)).canonical(DiscreteDomain.integers()));
        RangeTest.assertEquals((Object)Range.atLeast((Comparable)Integer.valueOf(1)), (Object)Range.greaterThan((Comparable)Integer.valueOf(0)).canonical(DiscreteDomain.integers()));
        RangeTest.assertEquals((Object)Range.atLeast((Comparable)Integer.valueOf(Integer.MIN_VALUE)), (Object)Range.all().canonical(DiscreteDomain.integers()));
    }

    public void testCanonical_unboundedDomain() {
        RangeTest.assertEquals((Object)Range.lessThan((Comparable)Integer.valueOf(0)), (Object)Range.lessThan((Comparable)Integer.valueOf(0)).canonical(UNBOUNDED_DOMAIN));
        RangeTest.assertEquals((Object)Range.lessThan((Comparable)Integer.valueOf(1)), (Object)Range.atMost((Comparable)Integer.valueOf(0)).canonical(UNBOUNDED_DOMAIN));
        RangeTest.assertEquals((Object)Range.atLeast((Comparable)Integer.valueOf(0)), (Object)Range.atLeast((Comparable)Integer.valueOf(0)).canonical(UNBOUNDED_DOMAIN));
        RangeTest.assertEquals((Object)Range.atLeast((Comparable)Integer.valueOf(1)), (Object)Range.greaterThan((Comparable)Integer.valueOf(0)).canonical(UNBOUNDED_DOMAIN));
        RangeTest.assertEquals((Object)Range.all(), (Object)Range.all().canonical(UNBOUNDED_DOMAIN));
    }

    public void testEncloseAll() {
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0)), (Object)Range.encloseAll(Arrays.asList(0)));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(-3), (Comparable)Integer.valueOf(5)), (Object)Range.encloseAll(Arrays.asList(5, -3)));
        RangeTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(-3), (Comparable)Integer.valueOf(5)), (Object)Range.encloseAll(Arrays.asList(1, 2, 2, 2, 5, -3, 0, -1)));
    }

    public void testEncloseAll_empty() {
        try {
            Range.encloseAll((Iterable)ImmutableSet.of());
            RangeTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testEncloseAll_nullValue() {
        ArrayList nullFirst = Lists.newArrayList((Object[])new Integer[]{null, 0});
        try {
            Range.encloseAll((Iterable)nullFirst);
            RangeTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        ArrayList nullNotFirst = Lists.newArrayList((Object[])new Integer[]{0, null});
        try {
            Range.encloseAll((Iterable)nullNotFirst);
            RangeTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEquivalentFactories() {
        new EqualsTester().addEqualityGroup(new Object[]{Range.all()}).addEqualityGroup(new Object[]{Range.atLeast((Comparable)Integer.valueOf(1)), Range.downTo((Comparable)Integer.valueOf(1), (BoundType)BoundType.CLOSED)}).addEqualityGroup(new Object[]{Range.greaterThan((Comparable)Integer.valueOf(1)), Range.downTo((Comparable)Integer.valueOf(1), (BoundType)BoundType.OPEN)}).addEqualityGroup(new Object[]{Range.atMost((Comparable)Integer.valueOf(7)), Range.upTo((Comparable)Integer.valueOf(7), (BoundType)BoundType.CLOSED)}).addEqualityGroup(new Object[]{Range.lessThan((Comparable)Integer.valueOf(7)), Range.upTo((Comparable)Integer.valueOf(7), (BoundType)BoundType.OPEN)}).addEqualityGroup(new Object[]{Range.open((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(7)), Range.range((Comparable)Integer.valueOf(1), (BoundType)BoundType.OPEN, (Comparable)Integer.valueOf(7), (BoundType)BoundType.OPEN)}).addEqualityGroup(new Object[]{Range.openClosed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(7)), Range.range((Comparable)Integer.valueOf(1), (BoundType)BoundType.OPEN, (Comparable)Integer.valueOf(7), (BoundType)BoundType.CLOSED)}).addEqualityGroup(new Object[]{Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(7)), Range.range((Comparable)Integer.valueOf(1), (BoundType)BoundType.CLOSED, (Comparable)Integer.valueOf(7), (BoundType)BoundType.CLOSED)}).addEqualityGroup(new Object[]{Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(7)), Range.range((Comparable)Integer.valueOf(1), (BoundType)BoundType.CLOSED, (Comparable)Integer.valueOf(7), (BoundType)BoundType.OPEN)}).testEquals();
    }
}

