/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.collect.AbstractImmutableTableTest;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SingletonImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.Collection;

@GwtCompatible(emulated=true)
public class SingletonImmutableTableTest
extends AbstractImmutableTableTest {
    private final ImmutableTable<Character, Integer, String> testTable = new SingletonImmutableTable((Object)Character.valueOf('a'), (Object)1, (Object)"blah");

    public void testHashCode() {
        SingletonImmutableTableTest.assertEquals((int)Objects.hashCode((Object[])new Object[]{Character.valueOf('a'), 1, "blah"}), (int)this.testTable.hashCode());
    }

    public void testCellSet() {
        SingletonImmutableTableTest.assertEquals((Object)ImmutableSet.of((Object)Tables.immutableCell((Object)Character.valueOf('a'), (Object)1, (Object)"blah")), (Object)this.testTable.cellSet());
    }

    public void testColumn() {
        SingletonImmutableTableTest.assertEquals((Object)ImmutableMap.of(), (Object)this.testTable.column((Object)0));
        SingletonImmutableTableTest.assertEquals((Object)ImmutableMap.of((Object)Character.valueOf('a'), (Object)"blah"), (Object)this.testTable.column((Object)1));
    }

    public void testColumnKeySet() {
        SingletonImmutableTableTest.assertEquals((Object)ImmutableSet.of((Object)1), (Object)this.testTable.columnKeySet());
    }

    public void testColumnMap() {
        SingletonImmutableTableTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)ImmutableMap.of((Object)Character.valueOf('a'), (Object)"blah")), (Object)this.testTable.columnMap());
    }

    public void testRow() {
        SingletonImmutableTableTest.assertEquals((Object)ImmutableMap.of(), (Object)this.testTable.row((Object)Character.valueOf('A')));
        SingletonImmutableTableTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)"blah"), (Object)this.testTable.row((Object)Character.valueOf('a')));
    }

    public void testRowKeySet() {
        SingletonImmutableTableTest.assertEquals((Object)ImmutableSet.of((Object)Character.valueOf('a')), (Object)this.testTable.rowKeySet());
    }

    public void testRowMap() {
        SingletonImmutableTableTest.assertEquals((Object)ImmutableMap.of((Object)Character.valueOf('a'), (Object)ImmutableMap.of((Object)1, (Object)"blah")), (Object)this.testTable.rowMap());
    }

    public void testEqualsObject() {
        new EqualsTester().addEqualityGroup(new Object[]{this.testTable, HashBasedTable.create(this.testTable)}).addEqualityGroup(new Object[]{ImmutableTable.of(), HashBasedTable.create()}).addEqualityGroup(new Object[]{HashBasedTable.create((Table)ImmutableTable.of((Object)Character.valueOf('A'), (Object)2, (Object)""))}).testEquals();
    }

    @GwtIncompatible(value="ArrayTable")
    public void testEqualsObjectNullValues() {
        new EqualsTester().addEqualityGroup(new Object[]{this.testTable}).addEqualityGroup(new Object[]{ArrayTable.create((Iterable)ImmutableSet.of((Object)Character.valueOf('A')), (Iterable)ImmutableSet.of((Object)1))}).testEquals();
    }

    public void testToString() {
        SingletonImmutableTableTest.assertEquals((String)"{a={1=blah}}", (String)this.testTable.toString());
    }

    public void testContains() {
        SingletonImmutableTableTest.assertTrue((boolean)this.testTable.contains((Object)Character.valueOf('a'), (Object)1));
        SingletonImmutableTableTest.assertFalse((boolean)this.testTable.contains((Object)Character.valueOf('a'), (Object)2));
        SingletonImmutableTableTest.assertFalse((boolean)this.testTable.contains((Object)Character.valueOf('A'), (Object)1));
        SingletonImmutableTableTest.assertFalse((boolean)this.testTable.contains((Object)Character.valueOf('A'), (Object)2));
    }

    public void testContainsColumn() {
        SingletonImmutableTableTest.assertTrue((boolean)this.testTable.containsColumn((Object)1));
        SingletonImmutableTableTest.assertFalse((boolean)this.testTable.containsColumn((Object)2));
    }

    public void testContainsRow() {
        SingletonImmutableTableTest.assertTrue((boolean)this.testTable.containsRow((Object)Character.valueOf('a')));
        SingletonImmutableTableTest.assertFalse((boolean)this.testTable.containsRow((Object)Character.valueOf('A')));
    }

    public void testContainsValue() {
        SingletonImmutableTableTest.assertTrue((boolean)this.testTable.containsValue((Object)"blah"));
        SingletonImmutableTableTest.assertFalse((boolean)this.testTable.containsValue((Object)""));
    }

    public void testGet() {
        SingletonImmutableTableTest.assertEquals((String)"blah", (String)((String)this.testTable.get((Object)Character.valueOf('a'), (Object)1)));
        SingletonImmutableTableTest.assertNull((Object)this.testTable.get((Object)Character.valueOf('a'), (Object)2));
        SingletonImmutableTableTest.assertNull((Object)this.testTable.get((Object)Character.valueOf('A'), (Object)1));
        SingletonImmutableTableTest.assertNull((Object)this.testTable.get((Object)Character.valueOf('A'), (Object)2));
    }

    public void testIsEmpty() {
        SingletonImmutableTableTest.assertFalse((boolean)this.testTable.isEmpty());
    }

    public void testSize() {
        SingletonImmutableTableTest.assertEquals((int)1, (int)this.testTable.size());
    }

    public void testValues() {
        Truth.assertThat((Collection)this.testTable.values()).has().item((Object)"blah");
    }

    @Override
    Iterable<ImmutableTable<Character, Integer, String>> getTestInstances() {
        return ImmutableSet.of(this.testTable);
    }
}

