/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.collect.BinaryTreeTraverser;
import com.google.common.collect.TreeTraverser;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class TreeTraverserTest
extends TestCase {
    private static final TreeTraverser<Tree> ADAPTER = new TreeTraverser<Tree>(){

        public Iterable<Tree> children(Tree node) {
            return node.children;
        }
    };
    private static final BinaryTreeTraverser<BinaryTree> BIN_ADAPTER = new BinaryTreeTraverser<BinaryTree>(){

        public Optional<BinaryTree> leftChild(BinaryTree node) {
            return Optional.fromNullable((Object)node.left);
        }

        public Optional<BinaryTree> rightChild(BinaryTree node) {
            return Optional.fromNullable((Object)node.right);
        }
    };
    static final Tree a = new Tree('a', new Tree[0]);
    static final Tree b = new Tree('b', new Tree[0]);
    static final Tree c = new Tree('c', new Tree[0]);
    static final Tree d = new Tree('d', a, b, c);
    static final Tree e = new Tree('e', new Tree[0]);
    static final Tree f = new Tree('f', new Tree[0]);
    static final Tree g = new Tree('g', f);
    static final Tree h = new Tree('h', d, e, g);
    static final BinaryTree ba = new BinaryTree('a', null, null);
    static final BinaryTree bc = new BinaryTree('c', null, null);
    static final BinaryTree bb = new BinaryTree('b', ba, bc);
    static final BinaryTree bg = new BinaryTree('g', null, null);
    static final BinaryTree bf = new BinaryTree('f', bg, null);
    static final BinaryTree be = new BinaryTree('e', null, bf);
    static final BinaryTree bd = new BinaryTree('d', bb, be);

    static String iterationOrder(Iterable<Tree> iterable) {
        StringBuilder builder = new StringBuilder();
        for (Tree t : iterable) {
            builder.append(t.value);
        }
        return builder.toString();
    }

    static String binaryIterationOrder(Iterable<BinaryTree> iterable) {
        StringBuilder builder = new StringBuilder();
        for (BinaryTree t : iterable) {
            builder.append(t.value);
        }
        return builder.toString();
    }

    public void testPreOrder() {
        Truth.assertThat((String)TreeTraverserTest.iterationOrder((Iterable<Tree>)ADAPTER.preOrderTraversal((Object)h))).isEqualTo((Object)"hdabcegf");
        Truth.assertThat((String)TreeTraverserTest.binaryIterationOrder((Iterable<BinaryTree>)BIN_ADAPTER.preOrderTraversal((Object)bd))).isEqualTo((Object)"dbacefg");
    }

    public void testPostOrder() {
        Truth.assertThat((String)TreeTraverserTest.iterationOrder((Iterable<Tree>)ADAPTER.postOrderTraversal((Object)h))).isEqualTo((Object)"abcdefgh");
        Truth.assertThat((String)TreeTraverserTest.binaryIterationOrder((Iterable<BinaryTree>)BIN_ADAPTER.postOrderTraversal((Object)bd))).isEqualTo((Object)"acbgfed");
    }

    public void testBreadthOrder() {
        Truth.assertThat((String)TreeTraverserTest.iterationOrder((Iterable<Tree>)ADAPTER.breadthFirstTraversal((Object)h))).isEqualTo((Object)"hdegabcf");
        Truth.assertThat((String)TreeTraverserTest.binaryIterationOrder((Iterable<BinaryTree>)BIN_ADAPTER.breadthFirstTraversal((Object)bd))).isEqualTo((Object)"dbeacfg");
    }

    public void testInOrder() {
        Truth.assertThat((String)TreeTraverserTest.binaryIterationOrder((Iterable<BinaryTree>)BIN_ADAPTER.inOrderTraversal((Object)bd))).isEqualTo((Object)"abcdegf");
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNulls() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods(ADAPTER);
        tester.testAllPublicInstanceMethods(BIN_ADAPTER);
    }

    private static final class BinaryTree {
        final char value;
        @Nullable
        final BinaryTree left;
        @Nullable
        final BinaryTree right;

        private BinaryTree(char value, BinaryTree left, BinaryTree right) {
            this.value = value;
            this.left = left;
            this.right = right;
        }
    }

    private static final class Tree {
        final char value;
        final List<Tree> children;

        public Tree(char value, Tree ... children) {
            this.value = value;
            this.children = Arrays.asList(children);
        }
    }
}

