/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.UnmodifiableListIterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

@GwtCompatible
public class UnmodifiableListIteratorTest
extends TestCase {
    public void testRemove() {
        UnmodifiableListIterator<String> iterator = this.create();
        UnmodifiableListIteratorTest.assertTrue((boolean)iterator.hasNext());
        UnmodifiableListIteratorTest.assertEquals((String)"a", (String)((String)iterator.next()));
        try {
            iterator.remove();
            UnmodifiableListIteratorTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAdd() {
        UnmodifiableListIterator<String> iterator = this.create();
        UnmodifiableListIteratorTest.assertTrue((boolean)iterator.hasNext());
        UnmodifiableListIteratorTest.assertEquals((String)"a", (String)((String)iterator.next()));
        UnmodifiableListIteratorTest.assertEquals((String)"b", (String)((String)iterator.next()));
        UnmodifiableListIteratorTest.assertEquals((String)"b", (String)((String)iterator.previous()));
        try {
            iterator.add("c");
            UnmodifiableListIteratorTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testSet() {
        UnmodifiableListIterator<String> iterator = this.create();
        UnmodifiableListIteratorTest.assertTrue((boolean)iterator.hasNext());
        UnmodifiableListIteratorTest.assertEquals((String)"a", (String)((String)iterator.next()));
        UnmodifiableListIteratorTest.assertEquals((String)"b", (String)((String)iterator.next()));
        UnmodifiableListIteratorTest.assertEquals((String)"b", (String)((String)iterator.previous()));
        try {
            iterator.set("c");
            UnmodifiableListIteratorTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    UnmodifiableListIterator<String> create() {
        final String[] array = new String[]{"a", "b", "c"};
        return new UnmodifiableListIterator<String>(){
            int i;

            public boolean hasNext() {
                return this.i < array.length;
            }

            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return array[this.i++];
            }

            public boolean hasPrevious() {
                return this.i > 0;
            }

            public int nextIndex() {
                return this.i;
            }

            public String previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return array[--this.i];
            }

            public int previousIndex() {
                return this.i - 1;
            }
        };
    }
}

