/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableMap;
import com.google.common.escape.ArrayBasedCharEscaper;
import com.google.common.escape.Escaper;
import com.google.common.escape.testing.EscaperAsserts;
import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;

@GwtCompatible
public class ArrayBasedCharEscaperTest
extends TestCase {
    private static final Map<Character, String> NO_REPLACEMENTS = ImmutableMap.of();
    private static final Map<Character, String> SIMPLE_REPLACEMENTS = ImmutableMap.of((Object)Character.valueOf('\n'), (Object)"<newline>", (Object)Character.valueOf('\t'), (Object)"<tab>", (Object)Character.valueOf('&'), (Object)"<and>");

    public void testSafeRange() throws IOException {
        ArrayBasedCharEscaper wrappingEscaper = new ArrayBasedCharEscaper(NO_REPLACEMENTS, 'A', 'Z'){

            protected char[] escapeUnsafe(char c) {
                char c2 = c;
                return new StringBuilder(3).append("{").append(c2).append("}").toString().toCharArray();
            }
        };
        EscaperAsserts.assertBasic((Escaper)wrappingEscaper);
        ArrayBasedCharEscaperTest.assertEquals((String)"{[}FOO{@}BAR{]}", (String)wrappingEscaper.escape("[FOO@BAR]"));
    }

    public void testSafeRange_maxLessThanMin() throws IOException {
        ArrayBasedCharEscaper wrappingEscaper = new ArrayBasedCharEscaper(NO_REPLACEMENTS, 'Z', 'A'){

            protected char[] escapeUnsafe(char c) {
                char c2 = c;
                return new StringBuilder(3).append("{").append(c2).append("}").toString().toCharArray();
            }
        };
        EscaperAsserts.assertBasic((Escaper)wrappingEscaper);
        ArrayBasedCharEscaperTest.assertEquals((String)"{[}{F}{O}{O}{]}", (String)wrappingEscaper.escape("[FOO]"));
    }

    public void testDeleteUnsafeChars() throws IOException {
        ArrayBasedCharEscaper deletingEscaper = new ArrayBasedCharEscaper(NO_REPLACEMENTS, ' ', '~'){
            private final char[] noChars;
            {
                this.noChars = new char[0];
            }

            protected char[] escapeUnsafe(char c) {
                return this.noChars;
            }
        };
        EscaperAsserts.assertBasic((Escaper)deletingEscaper);
        ArrayBasedCharEscaperTest.assertEquals((String)"Everything outside the printable ASCII range is deleted.", (String)deletingEscaper.escape("\tEverything\u0000 outside the\ud800\udc00 printable ASCII \uffffrange is \u007fdeleted.\n"));
    }

    public void testReplacementPriority() throws IOException {
        ArrayBasedCharEscaper replacingEscaper = new ArrayBasedCharEscaper(SIMPLE_REPLACEMENTS, ' ', '~'){
            private final char[] unknown;
            {
                this.unknown = new char[]{'?'};
            }

            protected char[] escapeUnsafe(char c) {
                return this.unknown;
            }
        };
        EscaperAsserts.assertBasic((Escaper)replacingEscaper);
        ArrayBasedCharEscaperTest.assertEquals((String)"<tab>Fish <and>? Chips?<newline>", (String)replacingEscaper.escape("\tFish &\u0000 Chips\r\n"));
    }
}

