/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableMap;
import com.google.common.escape.ArrayBasedUnicodeEscaper;
import com.google.common.escape.Escaper;
import com.google.common.escape.testing.EscaperAsserts;
import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;

@GwtCompatible
public class ArrayBasedUnicodeEscaperTest
extends TestCase {
    private static final Map<Character, String> NO_REPLACEMENTS = ImmutableMap.of();
    private static final Map<Character, String> SIMPLE_REPLACEMENTS = ImmutableMap.of((Object)Character.valueOf('\n'), (Object)"<newline>", (Object)Character.valueOf('\t'), (Object)"<tab>", (Object)Character.valueOf('&'), (Object)"<and>");
    private static final char[] NO_CHARS = new char[0];

    public void testReplacements() throws IOException {
        ArrayBasedUnicodeEscaper escaper = new ArrayBasedUnicodeEscaper(SIMPLE_REPLACEMENTS, 0, 0x10FFFF, null){

            protected char[] escapeUnsafe(int c) {
                return NO_CHARS;
            }
        };
        EscaperAsserts.assertBasic((Escaper)escaper);
        ArrayBasedUnicodeEscaperTest.assertEquals((String)"<tab>Fish <and> Chips<newline>", (String)escaper.escape("\tFish & Chips\n"));
        String safeChars = "\u0000\u0100\ud800\udc00\uffff";
        ArrayBasedUnicodeEscaperTest.assertEquals((String)safeChars, (String)escaper.escape(safeChars));
        String badUnicode = "\udc00\ud800";
        try {
            escaper.escape(badUnicode);
            ArrayBasedUnicodeEscaperTest.fail((String)"should fail for bad Unicode");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testSafeRange() throws IOException {
        ArrayBasedUnicodeEscaper wrappingEscaper = new ArrayBasedUnicodeEscaper(NO_REPLACEMENTS, 65, 90, null){

            protected char[] escapeUnsafe(int c) {
                char c2 = (char)c;
                return new StringBuilder(3).append("{").append(c2).append("}").toString().toCharArray();
            }
        };
        EscaperAsserts.assertBasic((Escaper)wrappingEscaper);
        ArrayBasedUnicodeEscaperTest.assertEquals((String)"{[}FOO{@}BAR{]}", (String)wrappingEscaper.escape("[FOO@BAR]"));
    }

    public void testDeleteUnsafeChars() throws IOException {
        ArrayBasedUnicodeEscaper deletingEscaper = new ArrayBasedUnicodeEscaper(NO_REPLACEMENTS, 32, 126, null){

            protected char[] escapeUnsafe(int c) {
                return NO_CHARS;
            }
        };
        EscaperAsserts.assertBasic((Escaper)deletingEscaper);
        ArrayBasedUnicodeEscaperTest.assertEquals((String)"Everything outside the printable ASCII range is deleted.", (String)deletingEscaper.escape("\tEverything\u0000 outside the\ud800\udc00 printable ASCII \uffffrange is \u007fdeleted.\n"));
    }

    public void testReplacementPriority() throws IOException {
        ArrayBasedUnicodeEscaper replacingEscaper = new ArrayBasedUnicodeEscaper(SIMPLE_REPLACEMENTS, 32, 126, null){
            private final char[] unknown;
            {
                this.unknown = new char[]{'?'};
            }

            protected char[] escapeUnsafe(int c) {
                return this.unknown;
            }
        };
        EscaperAsserts.assertBasic((Escaper)replacingEscaper);
        ArrayBasedUnicodeEscaperTest.assertEquals((String)"<tab>Fish <and>? Chips?<newline>", (String)replacingEscaper.escape("\tFish &\u0000 Chips\r\n"));
    }

    public void testCodePointsFromSurrogatePairs() throws IOException {
        ArrayBasedUnicodeEscaper surrogateEscaper = new ArrayBasedUnicodeEscaper(NO_REPLACEMENTS, 0, 131072, null){
            private final char[] escaped;
            {
                this.escaped = new char[]{'X'};
            }

            protected char[] escapeUnsafe(int c) {
                return this.escaped;
            }
        };
        EscaperAsserts.assertBasic((Escaper)surrogateEscaper);
        String safeInput = "\ud800\udc00";
        ArrayBasedUnicodeEscaperTest.assertEquals((String)safeInput, (String)surrogateEscaper.escape(safeInput));
        String unsafeInput = "\udbff\udfff";
        ArrayBasedUnicodeEscaperTest.assertEquals((String)"X", (String)surrogateEscaper.escape(unsafeInput));
    }
}

