/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.eventbus.DeadEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.StringCatcher;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;

public class EventBusTest
extends TestCase {
    private static final String EVENT = "Hello";
    private static final String BUS_IDENTIFIER = "test-bus";
    private EventBus bus;

    protected void setUp() throws Exception {
        super.setUp();
        this.bus = new EventBus(BUS_IDENTIFIER);
    }

    public void testBasicCatcherDistribution() {
        StringCatcher catcher = new StringCatcher();
        this.bus.register((Object)catcher);
        this.bus.post((Object)EVENT);
        List<String> events = catcher.getEvents();
        EventBusTest.assertEquals((String)"Only one event should be delivered.", (int)1, (int)events.size());
        EventBusTest.assertEquals((String)"Correct string should be delivered.", (String)EVENT, (String)events.get(0));
    }

    public void testPolymorphicDistribution() {
        StringCatcher stringCatcher = new StringCatcher();
        final ArrayList objectEvents = Lists.newArrayList();
        Object objCatcher = new Object(){

            @Subscribe
            public void eat(Object food) {
                objectEvents.add(food);
            }
        };
        final ArrayList compEvents = Lists.newArrayList();
        Object compCatcher = new Object(){

            @Subscribe
            public void eat(Comparable<?> food) {
                compEvents.add(food);
            }
        };
        this.bus.register((Object)stringCatcher);
        this.bus.register(objCatcher);
        this.bus.register(compCatcher);
        Object OBJ_EVENT = new Object();
        Integer COMP_EVENT = new Integer(6);
        this.bus.post((Object)EVENT);
        this.bus.post(OBJ_EVENT);
        this.bus.post((Object)COMP_EVENT);
        List<String> stringEvents = stringCatcher.getEvents();
        EventBusTest.assertEquals((String)"Only one String should be delivered.", (int)1, (int)stringEvents.size());
        EventBusTest.assertEquals((String)"Correct string should be delivered.", (String)EVENT, (String)stringEvents.get(0));
        EventBusTest.assertEquals((String)"Three Objects should be delivered.", (int)3, (int)objectEvents.size());
        EventBusTest.assertEquals((String)"String fixture must be first object delivered.", (Object)EVENT, objectEvents.get(0));
        EventBusTest.assertEquals((String)"Object fixture must be second object delivered.", (Object)OBJ_EVENT, objectEvents.get(1));
        EventBusTest.assertEquals((String)"Comparable fixture must be thirdobject delivered.", (Object)COMP_EVENT, objectEvents.get(2));
        EventBusTest.assertEquals((String)"Two Comparable<?>s should be delivered.", (int)2, (int)compEvents.size());
        EventBusTest.assertEquals((String)"String fixture must be first comparable delivered.", (Object)EVENT, compEvents.get(0));
        EventBusTest.assertEquals((String)"Comparable fixture must be second comparable delivered.", (Object)COMP_EVENT, compEvents.get(1));
    }

    public void testSubscriberThrowsException() throws Exception {
        RecordingSubscriberExceptionHandler handler = new RecordingSubscriberExceptionHandler();
        EventBus eventBus = new EventBus((SubscriberExceptionHandler)handler);
        final RuntimeException exception = new RuntimeException("but culottes have a tendancy to ride up!");
        Object subscriber = new Object(){

            @Subscribe
            public void throwExceptionOn(String message) {
                throw exception;
            }
        };
        eventBus.register(subscriber);
        eventBus.post((Object)EVENT);
        EventBusTest.assertEquals((String)"Cause should be available.", (Object)exception, (Object)handler.exception);
        EventBusTest.assertEquals((String)"EventBus should be available.", (Object)eventBus, (Object)handler.context.getEventBus());
        EventBusTest.assertEquals((String)"Event should be available.", (Object)EVENT, (Object)handler.context.getEvent());
        EventBusTest.assertEquals((String)"Subscriber should be available.", (Object)subscriber, (Object)handler.context.getSubscriber());
        EventBusTest.assertEquals((String)"Method should be available.", (Object)subscriber.getClass().getMethod("throwExceptionOn", String.class), (Object)handler.context.getSubscriberMethod());
    }

    public void testSubscriberThrowsExceptionHandlerThrowsException() throws Exception {
        EventBus eventBus = new EventBus(new SubscriberExceptionHandler(){

            public void handleException(Throwable exception, SubscriberExceptionContext context) {
                throw new RuntimeException();
            }
        });
        Object subscriber = new Object(){

            @Subscribe
            public void throwExceptionOn(String message) {
                throw new RuntimeException();
            }
        };
        eventBus.register(subscriber);
        try {
            eventBus.post((Object)EVENT);
        }
        catch (RuntimeException e) {
            EventBusTest.fail((String)"Exception should not be thrown.");
        }
    }

    public void testDeadEventForwarding() {
        GhostCatcher catcher = new GhostCatcher();
        this.bus.register((Object)catcher);
        this.bus.post((Object)EVENT);
        List<DeadEvent> events = catcher.getEvents();
        EventBusTest.assertEquals((String)"One dead event should be delivered.", (int)1, (int)events.size());
        EventBusTest.assertEquals((String)"The dead event should wrap the original event.", (Object)EVENT, (Object)events.get(0).getEvent());
    }

    public void testDeadEventPosting() {
        GhostCatcher catcher = new GhostCatcher();
        this.bus.register((Object)catcher);
        this.bus.post((Object)new DeadEvent((Object)this, (Object)EVENT));
        List<DeadEvent> events = catcher.getEvents();
        EventBusTest.assertEquals((String)"The explicit DeadEvent should be delivered.", (int)1, (int)events.size());
        EventBusTest.assertEquals((String)"The dead event must not be re-wrapped.", (Object)EVENT, (Object)events.get(0).getEvent());
    }

    public void testFlattenHierarchy() {
        HierarchyFixture fixture = new HierarchyFixture();
        Set hierarchy = this.bus.flattenHierarchy(fixture.getClass());
        EventBusTest.assertEquals((int)5, (int)hierarchy.size());
        this.assertContains(Object.class, hierarchy);
        this.assertContains(HierarchyFixtureInterface.class, hierarchy);
        this.assertContains(HierarchyFixtureSubinterface.class, hierarchy);
        this.assertContains(HierarchyFixtureParent.class, hierarchy);
        this.assertContains(HierarchyFixture.class, hierarchy);
    }

    public void testMissingSubscribe() {
        this.bus.register(new Object());
    }

    public void testUnregister() {
        StringCatcher catcher1 = new StringCatcher();
        StringCatcher catcher2 = new StringCatcher();
        try {
            this.bus.unregister((Object)catcher1);
            EventBusTest.fail((String)"Attempting to unregister an unregistered object succeeded");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.bus.register((Object)catcher1);
        this.bus.post((Object)EVENT);
        this.bus.register((Object)catcher2);
        this.bus.post((Object)EVENT);
        ArrayList expectedEvents = Lists.newArrayList();
        expectedEvents.add(EVENT);
        expectedEvents.add(EVENT);
        EventBusTest.assertEquals((String)"Two correct events should be delivered.", (Object)expectedEvents, catcher1.getEvents());
        EventBusTest.assertEquals((String)"One correct event should be delivered.", (Object)Lists.newArrayList((Object[])new String[]{EVENT}), catcher2.getEvents());
        this.bus.unregister((Object)catcher1);
        this.bus.post((Object)EVENT);
        EventBusTest.assertEquals((String)"Shouldn't catch any more events when unregistered.", (Object)expectedEvents, catcher1.getEvents());
        EventBusTest.assertEquals((String)"Two correct events should be delivered.", (Object)expectedEvents, catcher2.getEvents());
        try {
            this.bus.unregister((Object)catcher1);
            EventBusTest.fail((String)"Attempting to unregister an unregistered object succeeded");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.bus.unregister((Object)catcher2);
        this.bus.post((Object)EVENT);
        EventBusTest.assertEquals((String)"Shouldn't catch any more events when unregistered.", (Object)expectedEvents, catcher1.getEvents());
        EventBusTest.assertEquals((String)"Shouldn't catch any more events when unregistered.", (Object)expectedEvents, catcher2.getEvents());
    }

    public void testRegisterThreadSafety() throws Exception {
        int i;
        CopyOnWriteArrayList catchers = Lists.newCopyOnWriteArrayList();
        ArrayList futures = Lists.newArrayList();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        int numberOfCatchers = 10000;
        for (i = 0; i < numberOfCatchers; ++i) {
            futures.add(executor.submit(new Registrator(this.bus, catchers)));
        }
        for (i = 0; i < numberOfCatchers; ++i) {
            ((Future)futures.get(i)).get();
        }
        EventBusTest.assertEquals((String)"Unexpected number of catchers in the list", (int)numberOfCatchers, (int)catchers.size());
        this.bus.post((Object)EVENT);
        ImmutableList expectedEvents = ImmutableList.of((Object)EVENT);
        for (StringCatcher catcher : catchers) {
            EventBusTest.assertEquals((String)"One of the registered catchers did not receive an event.", (Object)expectedEvents, catcher.getEvents());
        }
    }

    public void testRegistrationWithBridgeMethod() {
        final AtomicInteger calls = new AtomicInteger();
        this.bus.register((Object)new Callback<String>(){

            @Override
            @Subscribe
            public void call(String s) {
                calls.incrementAndGet();
            }
        });
        this.bus.post((Object)"hello");
        EventBusTest.assertEquals((int)1, (int)calls.get());
    }

    private <T> void assertContains(T element, Collection<T> collection) {
        String string = String.valueOf(String.valueOf(element));
        EventBusTest.assertTrue((String)new StringBuilder(24 + string.length()).append("Collection must contain ").append(string).toString(), (boolean)collection.contains(element));
    }

    private static interface Callback<T> {
        public void call(T var1);
    }

    private static class HierarchyFixture
    extends HierarchyFixtureParent {
        private HierarchyFixture() {
        }
    }

    private static class HierarchyFixtureParent
    implements HierarchyFixtureSubinterface {
        private HierarchyFixtureParent() {
        }
    }

    private static interface HierarchyFixtureSubinterface
    extends HierarchyFixtureInterface {
    }

    private static interface HierarchyFixtureInterface {
    }

    public static class GhostCatcher {
        private List<DeadEvent> events = Lists.newArrayList();

        @Subscribe
        public void ohNoesIHaveDied(DeadEvent event) {
            this.events.add(event);
        }

        public List<DeadEvent> getEvents() {
            return this.events;
        }
    }

    private static class Registrator
    implements Runnable {
        private final EventBus bus;
        private final List<StringCatcher> catchers;

        Registrator(EventBus bus, List<StringCatcher> catchers) {
            this.bus = bus;
            this.catchers = catchers;
        }

        @Override
        public void run() {
            StringCatcher catcher = new StringCatcher();
            this.bus.register((Object)catcher);
            this.catchers.add(catcher);
        }
    }

    private static final class RecordingSubscriberExceptionHandler
    implements SubscriberExceptionHandler {
        public SubscriberExceptionContext context;
        public Throwable exception;

        private RecordingSubscriberExceptionHandler() {
        }

        public void handleException(Throwable exception, SubscriberExceptionContext context) {
            this.exception = exception;
            this.context = context;
        }
    }
}

