/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html;

import com.google.common.annotations.GwtCompatible;
import com.google.common.html.HtmlEscapers;
import junit.framework.TestCase;

@GwtCompatible
public class HtmlEscapersTest
extends TestCase {
    public void testHtmlEscaper() throws Exception {
        HtmlEscapersTest.assertEquals((String)"xxx", (String)HtmlEscapers.htmlEscaper().escape("xxx"));
        HtmlEscapersTest.assertEquals((String)"&quot;test&quot;", (String)HtmlEscapers.htmlEscaper().escape("\"test\""));
        HtmlEscapersTest.assertEquals((String)"&#39;test&#39;", (String)HtmlEscapers.htmlEscaper().escape("'test'"));
        HtmlEscapersTest.assertEquals((String)"test &amp; test &amp; test", (String)HtmlEscapers.htmlEscaper().escape("test & test & test"));
        HtmlEscapersTest.assertEquals((String)"test &lt;&lt; 1", (String)HtmlEscapers.htmlEscaper().escape("test << 1"));
        HtmlEscapersTest.assertEquals((String)"test &gt;&gt; 1", (String)HtmlEscapers.htmlEscaper().escape("test >> 1"));
        HtmlEscapersTest.assertEquals((String)"&lt;tab&gt;", (String)HtmlEscapers.htmlEscaper().escape("<tab>"));
        HtmlEscapersTest.assertEquals((String)"foo&amp;bar", (String)HtmlEscapers.htmlEscaper().escape("foo&bar"));
        String s = "blah blah farhvergnugen";
        HtmlEscapersTest.assertSame((Object)s, (Object)HtmlEscapers.htmlEscaper().escape(s));
        HtmlEscapersTest.assertEquals((String)"&lt;p&gt;", (String)HtmlEscapers.htmlEscaper().escape("<p>"));
        HtmlEscapersTest.assertEquals((String)"a&quot;b&lt;c&gt;d&amp;", (String)HtmlEscapers.htmlEscaper().escape("a\"b<c>d&"));
        HtmlEscapersTest.assertEquals((String)"foo&amp;&amp;bar", (String)HtmlEscapers.htmlEscaper().escape("foo&&bar"));
        s = "!@#$%^*()_+=-/?\\|]}[{,.;:abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        HtmlEscapersTest.assertSame((Object)s, (Object)HtmlEscapers.htmlEscaper().escape(s));
    }
}

