/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSourceTester;
import com.google.common.io.RandomAmountInputStream;
import com.google.common.io.SourceSinkFactories;
import com.google.common.io.SourceSinkFactory;
import com.google.common.io.SourceSinkTester;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;

public class ByteSourceTester
extends SourceSinkTester<ByteSource, byte[], SourceSinkFactory.ByteSourceFactory> {
    private static final ImmutableList<Method> testMethods = ByteSourceTester.getTestMethods(ByteSourceTester.class);
    private ByteSource source;

    static TestSuite tests(String name, SourceSinkFactory.ByteSourceFactory factory, boolean testAsCharSource) {
        TestSuite suite = new TestSuite(name);
        for (Map.Entry entry : TEST_STRINGS.entrySet()) {
            if (testAsCharSource) {
                suite.addTest((Test)ByteSourceTester.suiteForString(factory, (String)entry.getValue(), name, (String)entry.getKey()));
                continue;
            }
            suite.addTest((Test)ByteSourceTester.suiteForBytes(factory, ((String)entry.getValue()).getBytes(Charsets.UTF_8), name, (String)entry.getKey(), true));
        }
        return suite;
    }

    private static TestSuite suiteForString(SourceSinkFactory.ByteSourceFactory factory, String string, String name, String desc) {
        TestSuite suite = ByteSourceTester.suiteForBytes(factory, string.getBytes(Charsets.UTF_8), name, desc, true);
        SourceSinkFactory.CharSourceFactory charSourceFactory = SourceSinkFactories.asCharSourceFactory(factory);
        suite.addTest((Test)CharSourceTester.suiteForString(charSourceFactory, string, String.valueOf(name).concat(".asCharSource[Charset]"), desc));
        return suite;
    }

    private static TestSuite suiteForBytes(SourceSinkFactory.ByteSourceFactory factory, byte[] bytes, String name, String desc, boolean slice) {
        String string = String.valueOf(String.valueOf(name));
        String string2 = String.valueOf(String.valueOf(desc));
        TestSuite suite = new TestSuite(new StringBuilder(3 + string.length() + string2.length()).append(string).append(" [").append(string2).append("]").toString());
        for (Method method : testMethods) {
            suite.addTest((Test)new ByteSourceTester(factory, bytes, name, desc, method));
        }
        if (slice && bytes.length > 0) {
            Random random = new Random();
            byte[] expected = factory.getExpected(bytes);
            int off = expected.length == 0 ? 0 : random.nextInt(expected.length);
            int len = expected.length == 0 ? 4 : random.nextInt(expected.length - off);
            SourceSinkFactory.ByteSourceFactory sliced = SourceSinkFactories.asSlicedByteSourceFactory(factory, off, len);
            suite.addTest((Test)ByteSourceTester.suiteForBytes(sliced, bytes, String.valueOf(name).concat(".slice[int, int]"), desc, false));
        }
        return suite;
    }

    public ByteSourceTester(SourceSinkFactory.ByteSourceFactory factory, byte[] bytes, String suiteName, String caseDesc, Method method) {
        super(factory, bytes, suiteName, caseDesc, method);
    }

    public void setUp() throws IOException {
        this.source = (ByteSource)((SourceSinkFactory.ByteSourceFactory)this.factory).createSource(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOpenStream() throws IOException {
        InputStream in = this.source.openStream();
        try {
            byte[] readBytes = ByteStreams.toByteArray((InputStream)in);
            this.assertExpectedBytes(readBytes);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOpenBufferedStream() throws IOException {
        InputStream in = this.source.openBufferedStream();
        try {
            byte[] readBytes = ByteStreams.toByteArray((InputStream)in);
            this.assertExpectedBytes(readBytes);
        }
        finally {
            in.close();
        }
    }

    public void testRead() throws IOException {
        byte[] readBytes = this.source.read();
        this.assertExpectedBytes(readBytes);
    }

    public void testCopyTo_outputStream() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.source.copyTo((OutputStream)out);
        this.assertExpectedBytes(out.toByteArray());
    }

    public void testCopyTo_byteSink() throws IOException {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.source.copyTo(new ByteSink(){

            public OutputStream openStream() throws IOException {
                return out;
            }
        });
        this.assertExpectedBytes(out.toByteArray());
    }

    public void testIsEmpty() throws IOException {
        ByteSourceTester.assertEquals((((byte[])this.expected).length == 0 ? 1 : 0) != 0, (boolean)this.source.isEmpty());
    }

    public void testSize() throws IOException {
        ByteSourceTester.assertEquals((long)((byte[])this.expected).length, (long)this.source.size());
    }

    public void testContentEquals() throws IOException {
        ByteSourceTester.assertTrue((boolean)this.source.contentEquals(new ByteSource(){

            public InputStream openStream() throws IOException {
                return new RandomAmountInputStream(new ByteArrayInputStream((byte[])ByteSourceTester.this.expected), new Random());
            }
        }));
    }

    public void testRead_usingByteProcessor() throws IOException {
        byte[] readBytes = (byte[])this.source.read((ByteProcessor)new ByteProcessor<byte[]>(){
            final ByteArrayOutputStream out = new ByteArrayOutputStream();

            public boolean processBytes(byte[] buf, int off, int len) throws IOException {
                this.out.write(buf, off, len);
                return true;
            }

            public byte[] getResult() {
                return this.out.toByteArray();
            }
        });
        this.assertExpectedBytes(readBytes);
    }

    public void testHash() throws IOException {
        HashCode expectedHash = Hashing.md5().hashBytes((byte[])this.expected);
        ByteSourceTester.assertEquals((Object)expectedHash, (Object)this.source.hash(Hashing.md5()));
    }

    public void testSlice_illegalArguments() {
        try {
            this.source.slice(-1L, 0L);
            String string = String.valueOf(String.valueOf(this.source));
            ByteSourceTester.fail((String)new StringBuilder(68 + string.length()).append("expected IllegalArgumentException for call to slice with offset -1: ").append(string).toString());
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.source.slice(0L, -1L);
            String expected = String.valueOf(String.valueOf(this.source));
            ByteSourceTester.fail((String)new StringBuilder(68 + expected.length()).append("expected IllegalArgumentException for call to slice with length -1: ").append(expected).toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertExpectedBytes(byte[] readBytes) {
        Assert.assertArrayEquals((byte[])((byte[])this.expected), (byte[])readBytes);
    }
}

