/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.collect.ImmutableList;
import com.google.common.io.IoTestCase;
import com.google.common.io.TestCharSink;
import com.google.common.io.TestCharSource;
import com.google.common.io.TestOption;
import com.google.common.io.TestReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.EnumSet;

public class CharSinkTest
extends IoTestCase {
    private static final String STRING = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1";
    private TestCharSink sink;

    public void setUp() {
        this.sink = new TestCharSink(new TestOption[0]);
    }

    public void testOpenBufferedStream() throws IOException {
        Writer writer = this.sink.openBufferedStream();
        CharSinkTest.assertTrue((boolean)this.sink.wasStreamOpened());
        CharSinkTest.assertFalse((boolean)this.sink.wasStreamClosed());
        writer.write(STRING);
        writer.close();
        CharSinkTest.assertTrue((boolean)this.sink.wasStreamClosed());
        CharSinkTest.assertEquals((String)STRING, (String)this.sink.getString());
    }

    public void testWrite_string() throws IOException {
        CharSinkTest.assertEquals((String)"", (String)this.sink.getString());
        this.sink.write(STRING);
        CharSinkTest.assertTrue((this.sink.wasStreamOpened() && this.sink.wasStreamClosed() ? 1 : 0) != 0);
        CharSinkTest.assertEquals((String)STRING, (String)this.sink.getString());
    }

    public void testWriteFrom_reader() throws IOException {
        StringReader reader = new StringReader(STRING);
        this.sink.writeFrom(reader);
        CharSinkTest.assertTrue((this.sink.wasStreamOpened() && this.sink.wasStreamClosed() ? 1 : 0) != 0);
        CharSinkTest.assertEquals((String)STRING, (String)this.sink.getString());
    }

    public void testWriteFromStream_doesNotCloseThatStream() throws IOException {
        TestReader in = new TestReader(new TestOption[0]);
        CharSinkTest.assertFalse((boolean)in.closed());
        this.sink.writeFrom(in);
        CharSinkTest.assertFalse((boolean)in.closed());
    }

    public void testWriteLines_withSpecificSeparator() throws IOException {
        this.sink.writeLines((Iterable)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz"), "\n");
        CharSinkTest.assertEquals((String)"foo\nbar\nbaz\n", (String)this.sink.getString());
    }

    public void testWriteLines_withDefaultSeparator() throws IOException {
        this.sink.writeLines((Iterable)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz"));
        String separator = System.getProperty("line.separator");
        String string = String.valueOf(String.valueOf(separator));
        String string2 = String.valueOf(String.valueOf(separator));
        String string3 = String.valueOf(String.valueOf(separator));
        CharSinkTest.assertEquals((String)new StringBuilder(9 + string.length() + string2.length() + string3.length()).append("foo").append(string).append("bar").append(string2).append("baz").append(string3).toString(), (String)this.sink.getString());
    }

    public void testClosesOnErrors_copyingFromCharSourceThatThrows() {
        for (TestOption option : EnumSet.of(TestOption.OPEN_THROWS, TestOption.READ_THROWS, TestOption.CLOSE_THROWS)) {
            TestCharSource failSource = new TestCharSource(STRING, option);
            TestCharSink okSink = new TestCharSink(new TestOption[0]);
            try {
                failSource.copyTo(okSink);
                CharSinkTest.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            String string = String.valueOf(String.valueOf((Object)option));
            CharSinkTest.assertTrue((String)new StringBuilder(56 + string.length()).append("stream not closed when copying from source with option: ").append(string).toString(), (!okSink.wasStreamOpened() || okSink.wasStreamClosed() ? 1 : 0) != 0);
        }
    }

    public void testClosesOnErrors_whenWriteThrows() {
        TestCharSink failSink = new TestCharSink(TestOption.WRITE_THROWS);
        try {
            new TestCharSource(STRING, new TestOption[0]).copyTo(failSink);
            CharSinkTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CharSinkTest.assertTrue((boolean)failSink.wasStreamClosed());
    }

    public void testClosesOnErrors_whenWritingFromReaderThatThrows() {
        TestCharSink okSink = new TestCharSink(new TestOption[0]);
        try {
            okSink.writeFrom(new TestReader(TestOption.READ_THROWS));
            CharSinkTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CharSinkTest.assertTrue((boolean)okSink.wasStreamClosed());
    }
}

